/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.model.classdisplay;

import edu.stanford.smi.protegex.owl.model.OWLAllValuesFrom;
import edu.stanford.smi.protegex.owl.model.OWLAnonymousClass;
import edu.stanford.smi.protegex.owl.model.OWLCardinality;
import edu.stanford.smi.protegex.owl.model.OWLComplementClass;
import edu.stanford.smi.protegex.owl.model.OWLEnumeratedClass;
import edu.stanford.smi.protegex.owl.model.OWLHasValue;
import edu.stanford.smi.protegex.owl.model.OWLIntersectionClass;
import edu.stanford.smi.protegex.owl.model.OWLMaxCardinality;
import edu.stanford.smi.protegex.owl.model.OWLMinCardinality;
import edu.stanford.smi.protegex.owl.model.OWLNAryLogicalClass;
import edu.stanford.smi.protegex.owl.model.OWLQuantifierRestriction;
import edu.stanford.smi.protegex.owl.model.OWLRestriction;
import edu.stanford.smi.protegex.owl.model.OWLSomeValuesFrom;
import edu.stanford.smi.protegex.owl.model.OWLUnionClass;
import edu.stanford.smi.protegex.owl.model.ProtegeNames;
import edu.stanford.smi.protegex.owl.model.RDFProperty;
import edu.stanford.smi.protegex.owl.model.RDFResource;
import edu.stanford.smi.protegex.owl.model.RDFSClass;
import edu.stanford.smi.protegex.owl.model.RDFSNamedClass;
import edu.stanford.smi.protegex.owl.model.classdisplay.OWLClassDisplay;
import java.util.Collection;
import java.util.Iterator;

public abstract class AbstractOWLClassDisplay
implements OWLClassDisplay {
    public String getDisplayText(RDFSClass rDFSClass) {
        if (rDFSClass instanceof RDFSNamedClass) {
            return rDFSClass.getBrowserText();
        }
        if (rDFSClass instanceof OWLRestriction) {
            return this.getCommentText(rDFSClass) + this.getDisplayTextOfOWLRestriction((OWLRestriction)rDFSClass);
        }
        if (rDFSClass instanceof OWLNAryLogicalClass) {
            return this.getCommentText(rDFSClass) + this.getDisplayTextOfOWLNAryLogicalClass((OWLNAryLogicalClass)rDFSClass);
        }
        if (rDFSClass instanceof OWLComplementClass) {
            return this.getCommentText(rDFSClass) + this.getDisplayTextOfOWLComplementClass((OWLComplementClass)rDFSClass);
        }
        if (rDFSClass instanceof OWLEnumeratedClass) {
            return this.getCommentText(rDFSClass) + this.getDisplayTextOfOWLEnumeratedClass((OWLEnumeratedClass)rDFSClass);
        }
        return null;
    }

    protected String getCommentText(RDFSClass rDFSClass) {
        RDFProperty rDFProperty;
        if (rDFSClass.isAnonymous() && (rDFProperty = rDFSClass.getOWLModel().getRDFProperty(ProtegeNames.Slot.IS_COMMENTED_OUT)) != null && rDFSClass.getPropertyValue(rDFProperty) != null) {
            return "// ";
        }
        return "";
    }

    public String getSymbol(OWLAnonymousClass oWLAnonymousClass) {
        if (oWLAnonymousClass instanceof OWLRestriction) {
            if (oWLAnonymousClass instanceof OWLSomeValuesFrom) {
                return this.getOWLSomeValuesFromSymbol();
            }
            if (oWLAnonymousClass instanceof OWLAllValuesFrom) {
                return this.getOWLAllValuesFromSymbol();
            }
            if (oWLAnonymousClass instanceof OWLHasValue) {
                return this.getOWLHasValueSymbol();
            }
            if (oWLAnonymousClass instanceof OWLCardinality) {
                return this.getOWLCardinalitySymbol();
            }
            if (oWLAnonymousClass instanceof OWLMaxCardinality) {
                return this.getOWLMaxCardinalitySymbol();
            }
            if (oWLAnonymousClass instanceof OWLMinCardinality) {
                return this.getOWLMinCardinalitySymbol();
            }
            throw new IllegalArgumentException("Unknown restriction type " + oWLAnonymousClass.getClass());
        }
        if (oWLAnonymousClass instanceof OWLIntersectionClass) {
            return this.getOWLIntersectionOfSymbol();
        }
        if (oWLAnonymousClass instanceof OWLUnionClass) {
            return this.getOWLUnionOfSymbol();
        }
        if (oWLAnonymousClass instanceof OWLComplementClass) {
            return this.getOWLComplementOfSymbol();
        }
        throw new IllegalArgumentException("Unexpected class type " + oWLAnonymousClass.getClass());
    }

    protected String getDisplayTextOfOWLComplementClass(OWLComplementClass oWLComplementClass) {
        String string = this.getOWLComplementOfSymbol();
        if (string.length() > 1) {
            return string + " " + this.getNestedDisplayText(oWLComplementClass.getComplement());
        }
        return string + this.getNestedDisplayText(oWLComplementClass.getComplement());
    }

    protected String getDisplayTextOfOWLEnumeratedClass(OWLEnumeratedClass oWLEnumeratedClass) {
        Collection collection = oWLEnumeratedClass.getOneOf();
        String string = "{";
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            RDFResource rDFResource = (RDFResource)iterator.next();
            string = string + rDFResource.getBrowserText();
            if (!iterator.hasNext()) continue;
            string = string + " ";
        }
        return string + "}";
    }

    protected String getDisplayTextOfOWLRestriction(OWLRestriction oWLRestriction) {
        RDFProperty rDFProperty = oWLRestriction.getOnProperty();
        return (rDFProperty != null ? rDFProperty.getBrowserText() : "?") + " " + this.getSymbol(oWLRestriction) + " " + this.getOWLRestrictionFillerText(oWLRestriction);
    }

    protected String getOWLRestrictionFillerText(OWLRestriction oWLRestriction) {
        if (oWLRestriction instanceof OWLQuantifierRestriction) {
            RDFResource rDFResource = ((OWLQuantifierRestriction)oWLRestriction).getFiller();
            if (rDFResource instanceof RDFSClass) {
                return this.getNestedDisplayText((RDFSClass)rDFResource);
            }
            return oWLRestriction.getFillerText();
        }
        return oWLRestriction.getFillerText();
    }

    protected String getDisplayTextOfOWLNAryLogicalClass(OWLNAryLogicalClass oWLNAryLogicalClass) {
        Collection<RDFSClass> collection = oWLNAryLogicalClass.getOperands();
        if (collection.size() == 0) {
            return "<empty " + oWLNAryLogicalClass.getClass() + ">";
        }
        String string = this.getSymbol(oWLNAryLogicalClass);
        String string2 = "";
        Iterator<RDFSClass> iterator = collection.iterator();
        while (iterator.hasNext()) {
            RDFSClass rDFSClass = iterator.next();
            string2 = string2 + this.getNestedDisplayText(rDFSClass);
            if (!iterator.hasNext()) continue;
            string2 = string2 + " " + string + " ";
        }
        return string2;
    }

    protected String getNestedDisplayText(RDFSClass rDFSClass) {
        if (rDFSClass instanceof RDFSNamedClass || rDFSClass instanceof OWLEnumeratedClass || rDFSClass instanceof OWLComplementClass) {
            return this.getDisplayText(rDFSClass);
        }
        return "(" + this.getDisplayText(rDFSClass) + ")";
    }
}

