/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.model;

import com.hp.hpl.jena.rdf.model.impl.Util;
import edu.stanford.smi.protege.util.URIUtilities;
import edu.stanford.smi.protegex.owl.model.NamespaceManager;
import edu.stanford.smi.protegex.owl.model.OWLModel;

public class NamespaceUtil {
    public static final String PREFIX_TO_NAME_SEPARATOR = ":";

    public static String getNameSpace(String string) {
        if (!URIUtilities.isAbsoluteURI((String)string)) {
            return null;
        }
        return string.substring(0, Util.splitNamespace((String)string));
    }

    public static String getLocalName(String string) {
        if (string == null) {
            return null;
        }
        if (!URIUtilities.isAbsoluteURI((String)string)) {
            return string;
        }
        return string.substring(Util.splitNamespace((String)string));
    }

    public static String getPrefixForResourceName(OWLModel oWLModel, String string) {
        String string2 = NamespaceUtil.getNameSpace(string);
        return oWLModel.getNamespaceManager().getPrefix(string2);
    }

    public static String getPrefixedName(OWLModel oWLModel, String string) {
        return NamespaceUtil.getPrefixedName(oWLModel.getNamespaceManager(), string);
    }

    public static String getPrefixedName(NamespaceManager namespaceManager, String string) {
        String string2 = NamespaceUtil.getNameSpace(string);
        if (string2 == null) {
            return string;
        }
        String string3 = NamespaceUtil.getLocalName(string);
        String string4 = namespaceManager.getPrefix(string2);
        if (string4 == null) {
            return string;
        }
        if (string4.equals("")) {
            return string3;
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(string4);
        stringBuffer.append(':');
        stringBuffer.append(string3);
        return stringBuffer.toString();
    }

    public static String getFullName(OWLModel oWLModel, String string) {
        int n = string.indexOf(PREFIX_TO_NAME_SEPARATOR);
        NamespaceManager namespaceManager = oWLModel.getNamespaceManager();
        if (n == -1) {
            String string2 = namespaceManager.getDefaultNamespace();
            if (string2 == null) {
                return string;
            }
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(string2);
            stringBuffer.append(string);
            return stringBuffer.toString();
        }
        if (n == 0) {
            return string;
        }
        String string3 = string.substring(0, n);
        String string4 = string.substring(n + 1);
        String string5 = namespaceManager.getNamespaceForPrefix(string3);
        if (string5 == null) {
            return null;
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(string5);
        stringBuffer.append(string4);
        return stringBuffer.toString();
    }
}

