/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.jena.parser;

import com.hp.hpl.jena.rdf.arp.ALiteral;
import com.hp.hpl.jena.rdf.arp.AResource;
import com.hp.hpl.jena.vocabulary.OWL;
import edu.stanford.smi.protege.model.Cls;
import edu.stanford.smi.protege.model.Instance;
import edu.stanford.smi.protege.util.Log;
import edu.stanford.smi.protegex.owl.jena.parser.AbstractStatefulTripleProcessor;
import edu.stanford.smi.protegex.owl.jena.parser.FrameCreatorUtility;
import edu.stanford.smi.protegex.owl.jena.parser.ParserUtil;
import edu.stanford.smi.protegex.owl.jena.parser.TriplePostProcessor;
import edu.stanford.smi.protegex.owl.jena.parser.TripleProcessor;
import edu.stanford.smi.protegex.owl.jena.parser.UndefTriple;
import edu.stanford.smi.protegex.owl.model.OWLModel;
import edu.stanford.smi.protegex.owl.model.RDFProperty;
import edu.stanford.smi.protegex.owl.model.RDFResource;
import edu.stanford.smi.protegex.owl.model.RDFSClass;
import edu.stanford.smi.protegex.owl.model.RDFSNamedClass;
import edu.stanford.smi.protegex.owl.model.impl.AbstractOWLModel;
import edu.stanford.smi.protegex.owl.model.triplestore.TripleStore;
import java.util.Collection;
import java.util.HashSet;
import java.util.logging.Level;

class TripleProcessorForUntypedResources
extends AbstractStatefulTripleProcessor {
    public TripleProcessorForUntypedResources(TripleProcessor tripleProcessor) {
        super(tripleProcessor);
    }

    public void processUndefTriples() {
        this.processRemainingUndefinedTriples();
    }

    protected void processRemainingUndefinedTriples() {
        HashSet<String> hashSet = new HashSet<String>();
        HashSet<String> hashSet2 = new HashSet<String>(this.processor.getGlobalParserCache().getUndefTriplesKeys());
        for (String string : hashSet2) {
            Collection<UndefTriple> collection = this.processor.getGlobalParserCache().getUndefTriples(string);
            Collection<UndefTriple> collection2 = collection.iterator();
            while (collection2.hasNext()) {
                UndefTriple undefTriple = collection2.next();
                Object object = undefTriple.getTripleObj();
                TripleStore tripleStore = undefTriple.getTripleStore();
                if (ParserUtil.getResourceName(undefTriple.getTriplePred()).equals(OWL.oneOf.getURI())) {
                    this.handleCreationOfOneOf(undefTriple, string);
                }
                boolean bl = false;
                if (object instanceof AResource) {
                    bl = this.processor.processTriple(undefTriple.getTripleSubj(), undefTriple.getTriplePred(), (AResource)undefTriple.getTripleObj(), tripleStore, true);
                } else if (object instanceof ALiteral) {
                    bl = this.processor.processTriple(undefTriple.getTripleSubj(), undefTriple.getTriplePred(), (ALiteral)undefTriple.getTripleObj(), tripleStore, true);
                }
                if (!bl) continue;
                collection2.remove();
            }
            collection2 = this.processor.getGlobalParserCache().getUndefTriples(string);
            if (!collection2.isEmpty()) continue;
            hashSet.add(string);
        }
        for (String string : hashSet) {
            this.processor.getGlobalParserCache().removeUndefTripleKey(string);
        }
    }

    private void handleCreationOfOneOf(UndefTriple undefTriple, String string) {
        AResource aResource = undefTriple.getTripleSubj();
        TripleStore tripleStore = undefTriple.getTripleStore();
        if (ParserUtil.getResourceName(aResource).equals(string)) {
            try {
                FrameCreatorUtility.createOWLEnumeratedCls(this.owlModel, ParserUtil.getResourceName(aResource), tripleStore);
            }
            catch (Exception exception) {
                Log.getLogger().log(Level.WARNING, "Error at creating enumeration class", exception);
            }
        }
    }

    public void createUntypedResources() {
        HashSet<String> hashSet = new HashSet<String>();
        for (String string : this.processor.getGlobalParserCache().getUndefTriplesKeys()) {
            Collection<UndefTriple> collection = this.processor.getGlobalParserCache().getUndefTriples(string);
            for (UndefTriple undefTriple : collection) {
                try {
                    String string2;
                    Object object;
                    String string3;
                    String string4 = ParserUtil.getResourceName(undefTriple.getTriplePred());
                    if (this.resolvUndefinedTriple(undefTriple, string4)) {
                        hashSet.add(string4);
                    }
                    if (this.resolvUndefinedTriple(undefTriple, string3 = ParserUtil.getResourceName(undefTriple.getTripleSubj()))) {
                        hashSet.add(string3);
                    }
                    if (!((object = undefTriple.getTripleObj()) instanceof AResource) || !this.resolvUndefinedTriple(undefTriple, string2 = ParserUtil.getResourceName((AResource)undefTriple.getTripleObj()))) continue;
                    hashSet.add(string2);
                }
                catch (Throwable throwable) {
                    TriplePostProcessor.log.log(Level.WARNING, "Could not process untyped resource from statement: (" + undefTriple.getTripleSubj() + ", " + undefTriple.getTriplePred() + ", " + undefTriple.getTripleObj() + ")", throwable);
                }
            }
        }
        for (String string : hashSet) {
            this.checkUndefinedResources(string);
        }
        this.processUndefTriples();
    }

    protected boolean resolvUndefinedTriple(UndefTriple undefTriple, String string) {
        if (this.owlModel.getRDFResource(string) == null) {
            RDFResource rDFResource = this.createUntypedObject(undefTriple, string);
            return rDFResource != null;
        }
        return false;
    }

    protected RDFResource createUntypedObject(UndefTriple undefTriple, String string) {
        AResource aResource = undefTriple.getTripleSubj();
        AResource aResource2 = undefTriple.getTriplePred();
        Object object = undefTriple.getTripleObj();
        RDFResource rDFResource = this.owlModel.getRDFResource(string);
        if (rDFResource != null) {
            return rDFResource;
        }
        if (string.equals(ParserUtil.getResourceName(aResource2))) {
            return this.handleUndefinedPredicate(undefTriple);
        }
        if (string.equals(ParserUtil.getResourceName(aResource))) {
            return this.handleUndefinedSubject(undefTriple);
        }
        if (string.equals(object.toString())) {
            return this.handleUndefinedObject(undefTriple);
        }
        return null;
    }

    protected RDFProperty handleUndefinedPredicate(UndefTriple undefTriple) {
        String string = ParserUtil.getResourceName(undefTriple.getTriplePred());
        Cls cls = null;
        Object object = undefTriple.getTripleObj();
        return TripleProcessorForUntypedResources.createUntypedPredicate(this.owlModel, string, cls);
    }

    protected RDFResource handleUndefinedSubject(UndefTriple undefTriple) {
        RDFSNamedClass rDFSNamedClass = ((AbstractOWLModel)this.owlModel).getRDFExternalClassClass();
        RDFProperty rDFProperty = this.owlModel.getRDFProperty(ParserUtil.getResourceName(undefTriple.getTriplePred()));
        if (rDFProperty == null) {
            rDFProperty = this.handleUndefinedPredicate(undefTriple);
        }
        String string = ParserUtil.getResourceName(undefTriple.getTripleSubj());
        if (rDFProperty.equals(this.owlModel.getSystemFrames().getRdfTypeProperty())) {
            Object object = undefTriple.getTripleObj();
            if (object instanceof AResource) {
                return this.createInstanceWithType(string, ParserUtil.getResourceName((AResource)object));
            }
            Log.getLogger().warning("Invalid triple: " + undefTriple);
            return TripleProcessorForUntypedResources.createUntypedResource(this.owlModel, string);
        }
        RDFSClass rDFSClass = (RDFSClass)rDFProperty.getPropertyValue(this.owlModel.getRDFSDomainProperty());
        if (rDFSClass == null) {
            return this.createUntypedClassOrResource(rDFProperty, string);
        }
        if (rDFSClass.equals(this.owlModel.getOWLThingClass())) {
            return this.createUntypedClassOrResource(rDFProperty, string);
        }
        if (rDFSClass.equals(((AbstractOWLModel)this.owlModel).getOWLClassMetaCls())) {
            return rDFSNamedClass.createInstance(string);
        }
        if (rDFSClass.isMetaclass()) {
            RDFResource rDFResource = rDFSClass.createInstance(string);
            if (rDFSClass.hasSuperclass(((AbstractOWLModel)this.owlModel).getOWLClassMetaCls())) {
                rDFResource.addDirectType(rDFSNamedClass);
            } else if (rDFSClass.hasSuperclass(this.owlModel.getRDFPropertyClass())) {
                rDFResource.addDirectType(((AbstractOWLModel)this.owlModel).getRDFExternalPropertyClass());
            }
            return rDFResource;
        }
        return this.owlModel.createRDFUntypedResource(string);
    }

    protected RDFResource handleUndefinedObject(UndefTriple undefTriple) {
        RDFSNamedClass rDFSNamedClass = ((AbstractOWLModel)this.owlModel).getRDFExternalClassClass();
        RDFProperty rDFProperty = this.owlModel.getRDFProperty(ParserUtil.getResourceName(undefTriple.getTriplePred()));
        if (rDFProperty == null) {
            rDFProperty = this.handleUndefinedPredicate(undefTriple);
        }
        String string = undefTriple.getTripleObj().toString();
        if (rDFProperty.equals(this.owlModel.getRDFTypeProperty())) {
            return rDFSNamedClass.createInstance(string);
        }
        if (rDFProperty.equals(this.owlModel.getSystemFrames().getRdfsSeeAlsoProperty())) {
            return this.owlModel.createRDFUntypedResource(string);
        }
        if (rDFProperty.equals(this.owlModel.getSystemFrames().getOwlVersionInfoProperty())) {
            return this.owlModel.createRDFUntypedResource(string);
        }
        RDFSClass rDFSClass = (RDFSClass)rDFProperty.getPropertyValue(this.owlModel.getRDFSRangeProperty());
        if (rDFSClass == null) {
            return this.createUntypedClassOrResource(rDFProperty, string);
        }
        if (rDFSClass.equals(this.owlModel.getOWLThingClass())) {
            return this.createUntypedClassOrResource(rDFProperty, string);
        }
        if (rDFSClass.equals(((AbstractOWLModel)this.owlModel).getOWLClassMetaCls())) {
            return rDFSNamedClass.createInstance(string);
        }
        if (rDFSClass.isMetaclass()) {
            RDFResource rDFResource = rDFSClass.createInstance(string);
            if (rDFSClass.hasSuperclass(((AbstractOWLModel)this.owlModel).getOWLClassMetaCls())) {
                rDFResource.addDirectType(rDFSNamedClass);
            } else if (rDFSClass.hasSuperclass(this.owlModel.getRDFPropertyClass())) {
                rDFResource.addDirectType(((AbstractOWLModel)this.owlModel).getRDFExternalPropertyClass());
            }
            return rDFResource;
        }
        return this.owlModel.createRDFUntypedResource(string);
    }

    protected RDFResource createUntypedClassOrResource(RDFProperty rDFProperty, String string) {
        if (rDFProperty.isSystem()) {
            if (rDFProperty.equals(this.owlModel.getSystemFrames().getRdfValueProperty())) {
                return this.owlModel.createRDFUntypedResource(string);
            }
            return TripleProcessorForUntypedResources.createUntypedClass(this.owlModel, string);
        }
        return this.owlModel.createRDFUntypedResource(string);
    }

    public static RDFProperty createUntypedPredicate(OWLModel oWLModel, String string, Cls cls) {
        RDFProperty rDFProperty = (RDFProperty)((AbstractOWLModel)oWLModel).getRDFExternalPropertyClass().createInstance(string);
        if (cls != null) {
            rDFProperty.addDirectType(cls);
        }
        return rDFProperty;
    }

    public static RDFResource createUntypedClass(OWLModel oWLModel, String string) {
        RDFSNamedClass rDFSNamedClass = ((AbstractOWLModel)oWLModel).getRDFExternalClassClass();
        return rDFSNamedClass.createInstance(string);
    }

    public static RDFResource createUntypedResource(OWLModel oWLModel, String string) {
        return oWLModel.createRDFUntypedResource(string);
    }

    private RDFResource createInstanceWithType(String string, String string2) {
        Instance instance;
        Cls cls = this.getCls(string2);
        if (cls == null) {
            cls = (Cls)TripleProcessorForUntypedResources.createUntypedClass(this.owlModel, string2);
        }
        if ((instance = (Instance)this.getFrame(string)) != null) {
            return (RDFResource)instance;
        }
        instance = cls.createDirectInstance(string);
        return (RDFResource)instance;
    }
}

