/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.jena.parser;

import com.hp.hpl.jena.rdf.arp.AResource;
import com.hp.hpl.jena.vocabulary.OWL;
import com.hp.hpl.jena.vocabulary.RDF;
import com.hp.hpl.jena.vocabulary.RDFS;
import edu.stanford.smi.protege.model.Cls;
import edu.stanford.smi.protege.model.Frame;
import edu.stanford.smi.protege.model.FrameID;
import edu.stanford.smi.protege.model.Instance;
import edu.stanford.smi.protege.model.Slot;
import edu.stanford.smi.protege.util.Log;
import edu.stanford.smi.protegex.owl.jena.parser.AbstractStatefulTripleProcessor;
import edu.stanford.smi.protegex.owl.jena.parser.FrameCreatorUtility;
import edu.stanford.smi.protegex.owl.jena.parser.LogicalClassCreatorUtility;
import edu.stanford.smi.protegex.owl.jena.parser.OWLFramesMapping;
import edu.stanford.smi.protegex.owl.jena.parser.OWLImportsCache;
import edu.stanford.smi.protegex.owl.jena.parser.ParserUtil;
import edu.stanford.smi.protegex.owl.jena.parser.ProtegeOWLParser;
import edu.stanford.smi.protegex.owl.jena.parser.TripleProcessor;
import edu.stanford.smi.protegex.owl.model.OWLEnumeratedClass;
import edu.stanford.smi.protegex.owl.model.OWLNamedClass;
import edu.stanford.smi.protegex.owl.model.RDFProperty;
import edu.stanford.smi.protegex.owl.model.RDFSClass;
import edu.stanford.smi.protegex.owl.model.RDFSNamedClass;
import edu.stanford.smi.protegex.owl.model.impl.AbstractOWLModel;
import edu.stanford.smi.protegex.owl.model.impl.DefaultRDFProperty;
import edu.stanford.smi.protegex.owl.model.triplestore.TripleStore;
import java.util.ArrayList;
import java.util.Collection;
import java.util.logging.Level;
import java.util.logging.Logger;

class TripleProcessorForResourceObjects
extends AbstractStatefulTripleProcessor {
    private static final transient Logger log = Log.getLogger(TripleProcessorForResourceObjects.class);
    private Collection<RDFSNamedClass> untypedMetaClasses = new ArrayList<RDFSNamedClass>();

    public TripleProcessorForResourceObjects(TripleProcessor tripleProcessor) {
        super(tripleProcessor);
        this.initUntypedMetaClasses();
    }

    protected void initUntypedMetaClasses() {
        this.untypedMetaClasses.add(((AbstractOWLModel)this.owlModel).getRDFExternalClassClass());
        this.untypedMetaClasses.add(((AbstractOWLModel)this.owlModel).getRDFExternalPropertyClass());
        this.untypedMetaClasses.add(((AbstractOWLModel)this.owlModel).getRDFExternalResourceClass());
    }

    public boolean processTriple(AResource aResource, AResource aResource2, AResource aResource3, TripleStore tripleStore, boolean bl) {
        return new InternalTripleProcessorForResourceObjects(aResource, aResource2, aResource3, tripleStore, bl).processTriple();
    }

    private class InternalTripleProcessorForResourceObjects {
        private AResource subj;
        private String subjName;
        private Frame subjFrame;
        private AResource pred;
        private String predName;
        private Slot predSlot;
        private AResource obj;
        private String objName;
        private Frame objFrame;
        private TripleStore tripleStore;
        private boolean alreadyInUndef;

        public InternalTripleProcessorForResourceObjects(AResource aResource, AResource aResource2, AResource aResource3, TripleStore tripleStore, boolean bl) {
            if (log.isLoggable(Level.FINER)) {
                log.finer("Process Triple " + aResource + " " + aResource2 + " " + aResource3);
            }
            this.subj = aResource;
            this.pred = aResource2;
            this.obj = aResource3;
            this.alreadyInUndef = bl;
            this.tripleStore = tripleStore;
            this.predName = ParserUtil.getResourceName(aResource2);
            this.predSlot = TripleProcessorForResourceObjects.this.getSlot(this.predName);
            this.subjName = ParserUtil.getResourceName(aResource);
            this.subjFrame = TripleProcessorForResourceObjects.this.getFrame(this.subjName);
            this.objName = ParserUtil.getResourceName(aResource3);
            this.objFrame = TripleProcessorForResourceObjects.this.getFrame(this.objName);
        }

        public boolean processTriple() {
            TripleStatus tripleStatus = this.handlePredUndefs();
            switch (tripleStatus) {
                case TRIPLE_PROCESSING_COMPLETE: {
                    return true;
                }
                case TRIPLE_HAS_UNDEF_NEEDS_POST_PROCESS: {
                    return false;
                }
            }
            tripleStatus = this.handleSetTypeAndCreation();
            switch (tripleStatus) {
                case TRIPLE_PROCESSING_COMPLETE: {
                    return true;
                }
                case TRIPLE_HAS_UNDEF_NEEDS_POST_PROCESS: {
                    return false;
                }
            }
            tripleStatus = this.handleSubjObjUndefs();
            switch (tripleStatus) {
                case TRIPLE_PROCESSING_COMPLETE: {
                    return true;
                }
                case TRIPLE_HAS_UNDEF_NEEDS_POST_PROCESS: {
                    return false;
                }
            }
            this.adjustJavaTypes();
            tripleStatus = this.handleEquivalentClassesOrProperties();
            switch (tripleStatus) {
                case TRIPLE_PROCESSING_COMPLETE: {
                    return true;
                }
                case TRIPLE_HAS_UNDEF_NEEDS_POST_PROCESS: {
                    return false;
                }
            }
            this.handleGeneralizedConceptInclusions();
            this.addTriple();
            return true;
        }

        private void adjustJavaTypes() {
            if (this.predName.equals(RDFS.subClassOf.getURI())) {
                this.subjFrame = TripleProcessorForResourceObjects.this.getCls(this.subjFrame);
                this.objFrame = TripleProcessorForResourceObjects.this.getCls(this.objFrame);
                return;
            }
            if (this.predName.equals(RDFS.subPropertyOf.getURI())) {
                this.subjFrame = TripleProcessorForResourceObjects.this.getSlot(this.subjFrame);
                this.objFrame = TripleProcessorForResourceObjects.this.getSlot(this.objFrame);
                return;
            }
            if (this.predName.equals(OWL.disjointWith.getURI())) {
                this.subjFrame = TripleProcessorForResourceObjects.this.getCls(this.subjFrame);
                this.objFrame = TripleProcessorForResourceObjects.this.getCls(this.objFrame);
                return;
            }
        }

        private TripleStatus handleSetTypeAndCreation() {
            TripleStatus tripleStatus = TripleStatus.TRIPLE_PROCESSING_SHOULD_CONTINUE;
            if (this.predName.equals(OWL.imports.getURI())) {
                OWLImportsCache.addOWLImport(this.subjName, this.objName);
            } else if (this.predName.equals(RDF.type.getURI())) {
                tripleStatus = this.handleSetType();
            } else if (this.predName.equals(RDF.first.getURI()) || this.predName.equals(RDF.rest.getURI())) {
                if (log.isLoggable(Level.FINE)) {
                    log.fine("Triple <" + this.subjName + ", " + this.predName + ", " + this.objName + "> signals RDFList creation");
                }
                this.createRDFList();
            } else if (OWLFramesMapping.getLogicalPredicatesNames().contains(this.predName)) {
                tripleStatus = this.handleCreateLogicalClass();
            } else if (OWLFramesMapping.getRestrictionPredicatesNames().contains(this.predName)) {
                this.subjFrame = TripleProcessorForResourceObjects.this.createRestriction(this.subjName, this.predName, this.tripleStore);
            } else if (this.predName.equals(OWL.oneOf.getURI())) {
                this.subjFrame = TripleProcessorForResourceObjects.this.getFrame(this.subjName);
                this.objFrame = TripleProcessorForResourceObjects.this.getFrame(this.objName);
                if (this.subjFrame != null && this.objFrame != null && this.subjFrame instanceof RDFSNamedClass) {
                    OWLEnumeratedClass oWLEnumeratedClass = FrameCreatorUtility.createOWLEnumeratedCls(TripleProcessorForResourceObjects.this.owlModel, TripleProcessorForResourceObjects.this.owlModel.getNextAnonymousResourceName(), this.tripleStore);
                    FrameCreatorUtility.addOwnSlotValue((Frame)oWLEnumeratedClass, TripleProcessorForResourceObjects.this.owlModel.getSystemFrames().getOwlOneOfProperty(), this.objFrame, this.tripleStore);
                    FrameCreatorUtility.createSubclassOf((Cls)this.subjFrame, oWLEnumeratedClass, this.tripleStore);
                    FrameCreatorUtility.createSubclassOf(oWLEnumeratedClass, (Cls)this.subjFrame, this.tripleStore);
                    FrameCreatorUtility.addOwnSlotValue(this.subjFrame, TripleProcessorForResourceObjects.this.owlModel.getSystemFrames().getOwlEquivalentClassProperty(), oWLEnumeratedClass, this.tripleStore);
                    tripleStatus = TripleStatus.TRIPLE_PROCESSING_COMPLETE;
                }
            }
            this.subjFrame = TripleProcessorForResourceObjects.this.getFrame(this.subjName);
            this.objFrame = TripleProcessorForResourceObjects.this.getFrame(this.objName);
            return tripleStatus;
        }

        private TripleStatus handleCreateLogicalClass() {
            Frame frame = this.subjFrame;
            boolean bl = false;
            if (!this.subj.isAnonymous()) {
                if (this.subjFrame == null) {
                    this.addUndefTriple(this.subjName);
                    return TripleStatus.TRIPLE_HAS_UNDEF_NEEDS_POST_PROCESS;
                }
                if (this.objFrame == null) {
                    this.addUndefTriple(this.objName);
                    return TripleStatus.TRIPLE_HAS_UNDEF_NEEDS_POST_PROCESS;
                }
                this.subjFrame = (Frame)TripleProcessorForResourceObjects.this.globalParserCache.getObjectToNamedLogicalClassSurrogate().get(this.objName);
                if (this.subjFrame != null) {
                    this.subjName = this.subjFrame.getName();
                    return TripleStatus.TRIPLE_PROCESSING_SHOULD_CONTINUE;
                }
                this.subjName = TripleProcessorForResourceObjects.this.owlModel.getNextAnonymousResourceName();
                bl = true;
            }
            this.subjFrame = this.createLogicalClass();
            if (bl) {
                this.subjFrame = TripleProcessorForResourceObjects.this.getCls(this.subjFrame);
                TripleProcessorForResourceObjects.this.globalParserCache.getObjectToNamedLogicalClassSurrogate().put(this.objName, (Cls)this.subjFrame);
                FrameCreatorUtility.addOwnSlotValue(frame, TripleProcessorForResourceObjects.this.owlModel.getOWLEquivalentClassProperty(), this.subjFrame, this.tripleStore);
                FrameCreatorUtility.createSubclassOf((Cls)this.subjFrame, TripleProcessorForResourceObjects.this.getCls(frame), this.tripleStore);
                FrameCreatorUtility.createSubclassOf(TripleProcessorForResourceObjects.this.getCls(frame), (Cls)this.subjFrame, this.tripleStore);
            }
            return TripleStatus.TRIPLE_PROCESSING_SHOULD_CONTINUE;
        }

        private TripleStatus handleSetType() {
            if (this.objName.equals(OWL.Restriction.getURI())) {
                return TripleStatus.TRIPLE_PROCESSING_COMPLETE;
            }
            if (this.subj.isAnonymous() && this.objName.equals(OWL.Class.getURI())) {
                return TripleStatus.TRIPLE_PROCESSING_COMPLETE;
            }
            if (this.objName.equals(OWL.Ontology.getURI())) {
                this.handleOntologyDeclaration();
            }
            if (this.objFrame == null) {
                this.addUndefTriple(this.objName);
                return TripleStatus.TRIPLE_HAS_UNDEF_NEEDS_POST_PROCESS;
            }
            boolean bl = this.subjFrame != null && !TripleProcessorForResourceObjects.this.getTypes(this.subjFrame).isEmpty();
            this.objFrame = TripleProcessorForResourceObjects.this.getCls(this.objFrame);
            this.subjFrame = this.createFrameWithType(this.subjName, (Cls)this.objFrame);
            if (!FrameCreatorUtility.hasRDFType(this.subjFrame, this.predSlot, (Cls)this.objFrame, this.tripleStore)) {
                FrameCreatorUtility.addOwnSlotValue(this.subjFrame, this.predSlot, this.objFrame, this.tripleStore);
            }
            if (bl && this.objFrame instanceof Cls) {
                if (log.isLoggable(Level.FINE)) {
                    log.fine("found an alternative type for " + this.subjFrame + " = " + this.objFrame);
                }
                TripleProcessorForResourceObjects.this.globalParserCache.getMultipleTypesInstanceCache().addType((Instance)this.subjFrame, (Cls)this.objFrame);
                return TripleStatus.TRIPLE_PROCESSING_COMPLETE;
            }
            return TripleStatus.TRIPLE_PROCESSING_SHOULD_CONTINUE;
        }

        private TripleStatus handlePredUndefs() {
            if (this.predSlot == null) {
                this.predSlot = new DefaultRDFProperty(TripleProcessorForResourceObjects.this.owlModel, new FrameID(this.predName));
                if (TripleProcessorForResourceObjects.this.isImporting(this.tripleStore)) {
                    this.predSlot.setIncluded(true);
                }
                TripleProcessorForResourceObjects.this.globalParserCache.getFramesWithWrongJavaType().add(this.predName);
            }
            return TripleStatus.TRIPLE_PROCESSING_SHOULD_CONTINUE;
        }

        private TripleStatus handleSubjObjUndefs() {
            if (this.subjFrame == null) {
                if (log.isLoggable(Level.FINE)) {
                    log.fine("\tDeferring triple because subject is not yet defined");
                }
                this.addUndefTriple(this.subjName);
                return TripleStatus.TRIPLE_HAS_UNDEF_NEEDS_POST_PROCESS;
            }
            if (this.objFrame == null) {
                this.addUndefTriple(this.objName);
                if (log.isLoggable(Level.FINE)) {
                    log.fine("+++ Add undef triple: " + this.subj + " " + this.pred + " " + this.obj + " undef:" + this.objName);
                }
                return TripleStatus.TRIPLE_HAS_UNDEF_NEEDS_POST_PROCESS;
            }
            return TripleStatus.TRIPLE_PROCESSING_SHOULD_CONTINUE;
        }

        private void handleOntologyDeclaration() {
            if (this.tripleStore.getName() == null) {
                this.tripleStore.setName(this.subjName);
                this.tripleStore.addIOAddress(this.subjName);
                if (!TripleProcessorForResourceObjects.this.isImporting(this.tripleStore)) {
                    ProtegeOWLParser.setTopOntologyName(this.subjName);
                }
            }
        }

        private TripleStatus handleEquivalentClassesOrProperties() {
            if (this.predName.equals(OWL.equivalentClass.getURI())) {
                FrameCreatorUtility.addOwnSlotValue(this.subjFrame, this.predSlot, this.objFrame, this.tripleStore);
                if (!FrameCreatorUtility.hasOwnSlotValue(this.objFrame, this.predSlot, this.subjFrame)) {
                    this.subjFrame = TripleProcessorForResourceObjects.this.getCls(this.subjFrame);
                    this.objFrame = TripleProcessorForResourceObjects.this.getCls(this.objFrame);
                    FrameCreatorUtility.createSubclassOf((Cls)this.subjFrame, (Cls)this.objFrame, this.tripleStore);
                    if (!this.subjFrame.equals(this.objFrame)) {
                        FrameCreatorUtility.createSubclassOf((Cls)this.objFrame, (Cls)this.subjFrame, this.tripleStore);
                    }
                }
                return TripleStatus.TRIPLE_PROCESSING_COMPLETE;
            }
            return TripleStatus.TRIPLE_PROCESSING_SHOULD_CONTINUE;
        }

        private void handleGeneralizedConceptInclusions() {
            if (this.subjFrame instanceof RDFSClass && ((RDFSClass)this.subjFrame).isAnonymous() && TripleProcessorForResourceObjects.this.globalParserCache.getPossibleGCIPredicates().contains(this.predSlot)) {
                OWLNamedClass oWLNamedClass = TripleProcessorForResourceObjects.this.owlModel.createOWLNamedClass(null);
                this.subjFrame = TripleProcessorForResourceObjects.this.getCls(this.subjFrame);
                FrameCreatorUtility.addOwnSlotValue((Frame)oWLNamedClass, TripleProcessorForResourceObjects.this.owlModel.getOWLEquivalentClassProperty(), this.subjFrame, this.tripleStore);
                FrameCreatorUtility.createSubclassOf((Cls)this.subjFrame, oWLNamedClass, this.tripleStore);
                FrameCreatorUtility.createSubclassOf(oWLNamedClass, (Cls)this.subjFrame, this.tripleStore);
                this.subjFrame = oWLNamedClass;
                TripleProcessorForResourceObjects.this.globalParserCache.addGciAxiom(oWLNamedClass);
            }
        }

        private void addTriple() {
            String string;
            if (this.predSlot.equals(TripleProcessorForResourceObjects.this.owlModel.getRDFTypeProperty())) {
                return;
            }
            FrameCreatorUtility.addOwnSlotValue(this.subjFrame, this.predSlot, this.objFrame, this.tripleStore);
            String string2 = OWLFramesMapping.getFramesSlotMapName(this.predName);
            if (string2 != null) {
                FrameCreatorUtility.addOwnSlotValue(this.subjFrame, TripleProcessorForResourceObjects.this.getSlot(string2), this.objFrame, this.tripleStore);
            }
            if ((string = OWLFramesMapping.getFramesInvSlotMapName(this.predName)) != null) {
                FrameCreatorUtility.addOwnSlotValue(this.objFrame, TripleProcessorForResourceObjects.this.getSlot(string), this.subjFrame, this.tripleStore);
            }
        }

        private void addUndefTriple(String string) {
            TripleProcessorForResourceObjects.this.processor.addUndefTriple(this.subj, this.pred, this.obj, string, this.alreadyInUndef, this.tripleStore);
        }

        private void createRDFList() {
            Frame frame;
            Frame frame2;
            FrameID frameID;
            Frame frame3 = TripleProcessorForResourceObjects.this.getFrame(this.subjName);
            if (frame3 == null) {
                frameID = new FrameID(this.subjName);
                frame2 = FrameCreatorUtility.createFrameWithType(TripleProcessorForResourceObjects.this.owlModel, frameID, TripleProcessorForResourceObjects.this.owlModel.getSystemFrames().getRdfListClass(), this.tripleStore);
                if (TripleProcessorForResourceObjects.this.isImporting(this.tripleStore)) {
                    frame2.setIncluded(true);
                }
                if (frame2 != null) {
                    TripleProcessorForResourceObjects.this.checkUndefinedResources(this.subjName);
                }
            }
            if (!this.predName.equals(RDF.rest.getURI())) {
                return;
            }
            frameID = TripleProcessorForResourceObjects.this.getFrame(this.objName);
            if (frameID == null && (frame = FrameCreatorUtility.createFrameWithType(TripleProcessorForResourceObjects.this.owlModel, (FrameID)(frame2 = new FrameID(this.objName)), TripleProcessorForResourceObjects.this.owlModel.getSystemFrames().getRdfListClass(), this.tripleStore)) != null) {
                TripleProcessorForResourceObjects.this.checkUndefinedResources(this.objName);
            }
        }

        private Frame createFrameWithType(String string, Cls cls) {
            Frame frame = TripleProcessorForResourceObjects.this.getFrame(string);
            if (frame != null) {
                return this.addTypeToInstance(string, (Instance)frame, cls);
            }
            FrameID frameID = new FrameID(string);
            frame = FrameCreatorUtility.createFrameWithType(TripleProcessorForResourceObjects.this.owlModel, frameID, cls, this.tripleStore);
            if (TripleProcessorForResourceObjects.this.isImporting(this.tripleStore)) {
                frame.setIncluded(true);
            }
            if (frame != null) {
                TripleProcessorForResourceObjects.this.checkUndefinedResources(string);
            }
            return frame;
        }

        private Frame addTypeToInstance(String string, Instance instance, Cls cls) {
            Collection<Cls> collection;
            if (!FrameCreatorUtility.hasOwnSlotValue((Frame)instance, TripleProcessorForResourceObjects.this.owlModel.getSystemFrames().getNameSlot(), string)) {
                FrameCreatorUtility.addOwnSlotValue((Frame)instance, TripleProcessorForResourceObjects.this.owlModel.getSystemFrames().getNameSlot(), string, this.tripleStore);
            }
            if ((collection = FrameCreatorUtility.getDirectTypes(instance)) != null && collection.contains(cls)) {
                return instance;
            }
            if (this.alreadyInUndef && collection != null) {
                collection = new ArrayList<Cls>(collection);
                collection.removeAll(TripleProcessorForResourceObjects.this.untypedMetaClasses);
            }
            if (collection == null || collection.isEmpty()) {
                FrameCreatorUtility.addInstanceType(instance, cls, this.tripleStore);
                TripleProcessorForResourceObjects.this.globalParserCache.getFramesWithWrongJavaType().add(string);
                return TripleProcessorForResourceObjects.this.getFrame(string);
            }
            if (this.alreadyInUndef) {
                FrameCreatorUtility.addInstanceType(instance, cls, this.tripleStore);
                TripleProcessorForResourceObjects.this.simpleFrameStore.swizzleInstance(instance);
            } else {
                TripleProcessorForResourceObjects.this.globalParserCache.getMultipleTypesInstanceCache().addType(instance, cls);
            }
            instance = (Instance)TripleProcessorForResourceObjects.this.getFrame(string);
            if (instance instanceof RDFProperty) {
                instance.setIncluded(TripleProcessorForResourceObjects.this.isImporting(this.tripleStore));
            }
            return instance;
        }

        private Frame createLogicalClass() {
            Frame frame = TripleProcessorForResourceObjects.this.getFrame(this.subjName);
            if (frame != null) {
                return frame;
            }
            FrameID frameID = new FrameID(this.subjName);
            frame = LogicalClassCreatorUtility.createLogicalClass(TripleProcessorForResourceObjects.this.owlModel, frameID, this.predName, this.tripleStore);
            if (frame != null) {
                TripleProcessorForResourceObjects.this.checkUndefinedResources(this.subjName);
            }
            if (TripleProcessorForResourceObjects.this.isImporting(this.tripleStore)) {
                frame.setIncluded(true);
            }
            return frame;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum TripleStatus {
        TRIPLE_PROCESSING_SHOULD_CONTINUE,
        TRIPLE_PROCESSING_COMPLETE,
        TRIPLE_HAS_UNDEF_NEEDS_POST_PROCESS;

    }
}

