/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.jena.parser;

import com.hp.hpl.jena.rdf.arp.ALiteral;
import com.hp.hpl.jena.rdf.arp.AResource;
import edu.stanford.smi.protege.model.Frame;
import edu.stanford.smi.protege.model.Slot;
import edu.stanford.smi.protege.util.Log;
import edu.stanford.smi.protegex.owl.jena.parser.AbstractStatefulTripleProcessor;
import edu.stanford.smi.protegex.owl.jena.parser.FrameCreatorUtility;
import edu.stanford.smi.protegex.owl.jena.parser.OWLFramesMapping;
import edu.stanford.smi.protegex.owl.jena.parser.ParserUtil;
import edu.stanford.smi.protegex.owl.jena.parser.TripleProcessor;
import edu.stanford.smi.protegex.owl.jena.parser.UndefTriple;
import edu.stanford.smi.protegex.owl.model.RDFProperty;
import edu.stanford.smi.protegex.owl.model.RDFResource;
import edu.stanford.smi.protegex.owl.model.RDFSDatatype;
import edu.stanford.smi.protegex.owl.model.RDFSLiteral;
import edu.stanford.smi.protegex.owl.model.impl.AbstractOWLModel;
import edu.stanford.smi.protegex.owl.model.impl.DefaultRDFSLiteral;
import edu.stanford.smi.protegex.owl.model.triplestore.TripleStore;
import java.util.logging.Level;
import java.util.logging.Logger;

class TripleProcessorForLiteralObjects
extends AbstractStatefulTripleProcessor {
    private static final transient Logger log = Log.getLogger(TripleProcessor.class);

    public TripleProcessorForLiteralObjects(TripleProcessor tripleProcessor) {
        super(tripleProcessor);
    }

    public boolean processTriple(AResource aResource, AResource aResource2, ALiteral aLiteral, TripleStore tripleStore, boolean bl) {
        String string;
        Slot slot;
        if (log.isLoggable(Level.FINER)) {
            log.finer("Processing triple with literal: " + aResource + " " + aResource2 + " " + aLiteral);
        }
        if ((slot = this.getSlot(string = ParserUtil.getResourceName(aResource2))) == null) {
            if (!bl) {
                this.globalParserCache.addUndefTriple(new UndefTriple(aResource, aResource2, aLiteral, tripleStore), string);
            }
            return false;
        }
        String string2 = ParserUtil.getResourceName(aResource);
        Frame frame = this.getFrame(string2);
        if (OWLFramesMapping.getRestrictionPredicatesNames().contains(string)) {
            frame = this.createRestriction(string2, string, tripleStore);
        }
        if ((frame = this.getFrame(string2)) == null) {
            if (!bl) {
                this.globalParserCache.addUndefTriple(new UndefTriple(aResource, aResource2, aLiteral, tripleStore), string2);
            }
            return false;
        }
        RDFSLiteral rDFSLiteral = this.createRDFSLiteral(aLiteral, (RDFProperty)slot);
        if (rDFSLiteral == null) {
            return false;
        }
        this.addTriple(frame, slot, rDFSLiteral, tripleStore);
        return true;
    }

    private void addTriple(Frame frame, Slot slot, RDFSLiteral rDFSLiteral, TripleStore tripleStore) {
        FrameCreatorUtility.addOwnSlotValue(frame, slot, AbstractOWLModel.convertRDFSLiteralToInternalFormat(rDFSLiteral), tripleStore);
    }

    private RDFSLiteral createRDFSLiteral(ALiteral aLiteral, RDFProperty rDFProperty) {
        if (aLiteral.getLang() != null && aLiteral.getLang().length() > 0) {
            return DefaultRDFSLiteral.create(this.owlModel, aLiteral.toString(), aLiteral.getLang());
        }
        if (aLiteral.getDatatypeURI() != null) {
            RDFSDatatype rDFSDatatype = this.owlModel.getRDFSDatatypeByURI(aLiteral.getDatatypeURI());
            if (rDFSDatatype == null) {
                return DefaultRDFSLiteral.create(this.owlModel, aLiteral.toString());
            }
            return DefaultRDFSLiteral.create(this.owlModel, aLiteral.toString(), rDFSDatatype);
        }
        RDFResource rDFResource = rDFProperty.getRange();
        if (rDFResource instanceof RDFSDatatype) {
            RDFSDatatype rDFSDatatype = this.owlModel.getRDFSDatatypeByURI(rDFResource.getURI());
            return DefaultRDFSLiteral.create(this.owlModel, aLiteral.toString(), rDFSDatatype);
        }
        return DefaultRDFSLiteral.create(this.owlModel, aLiteral.toString());
    }
}

