/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.jena.parser;

import com.hp.hpl.jena.rdf.arp.ALiteral;
import com.hp.hpl.jena.rdf.arp.AResource;
import edu.stanford.smi.protegex.owl.jena.parser.GlobalParserCache;
import edu.stanford.smi.protegex.owl.jena.parser.TriplePostProcessor;
import edu.stanford.smi.protegex.owl.jena.parser.TripleProcessorForLiteralObjects;
import edu.stanford.smi.protegex.owl.jena.parser.TripleProcessorForResourceObjects;
import edu.stanford.smi.protegex.owl.jena.parser.TripleProcessorForUntypedResources;
import edu.stanford.smi.protegex.owl.jena.parser.UndefTriple;
import edu.stanford.smi.protegex.owl.model.OWLModel;
import edu.stanford.smi.protegex.owl.model.impl.AbstractOWLModel;
import edu.stanford.smi.protegex.owl.model.triplestore.TripleStore;
import java.util.Collection;
import java.util.Iterator;

public class TripleProcessor {
    private OWLModel owlModel;
    private TripleProcessorForResourceObjects processorResourceObjs;
    private TripleProcessorForLiteralObjects processorLiteralObjs;
    private TripleProcessorForUntypedResources untypedProcessor;
    private TriplePostProcessor postProcessor;
    private GlobalParserCache globalParserCache;

    public TripleProcessor(OWLModel oWLModel) {
        this.owlModel = oWLModel;
        this.globalParserCache = ((AbstractOWLModel)oWLModel).getGlobalParserCache();
        this.processorResourceObjs = new TripleProcessorForResourceObjects(this);
        this.processorLiteralObjs = new TripleProcessorForLiteralObjects(this);
        this.untypedProcessor = new TripleProcessorForUntypedResources(this);
        this.postProcessor = new TriplePostProcessor(this);
    }

    public boolean processTriple(AResource aResource, AResource aResource2, AResource aResource3, TripleStore tripleStore, boolean bl) {
        return this.processorResourceObjs.processTriple(aResource, aResource2, aResource3, tripleStore, bl);
    }

    public boolean processTriple(AResource aResource, AResource aResource2, ALiteral aLiteral, TripleStore tripleStore, boolean bl) {
        return this.processorLiteralObjs.processTriple(aResource, aResource2, aLiteral, tripleStore, bl);
    }

    public OWLModel getOWLModel() {
        return this.owlModel;
    }

    public void addUndefTriple(AResource aResource, AResource aResource2, AResource aResource3, String string, boolean bl, TripleStore tripleStore) {
        if (!bl) {
            this.globalParserCache.addUndefTriple(new UndefTriple(aResource, aResource2, aResource3, tripleStore), string);
        }
    }

    protected void checkUndefinedResources(String string) {
        Collection<UndefTriple> collection = this.globalParserCache.getUndefTriples(string);
        Iterator<UndefTriple> iterator = collection.iterator();
        while (iterator.hasNext()) {
            UndefTriple undefTriple = iterator.next();
            Object object = undefTriple.getTripleObj();
            TripleStore tripleStore = undefTriple.getTripleStore();
            boolean bl = false;
            if (object instanceof AResource) {
                bl = this.processTriple(undefTriple.getTripleSubj(), undefTriple.getTriplePred(), (AResource)undefTriple.getTripleObj(), tripleStore, true);
            } else if (object instanceof ALiteral) {
                bl = this.processTriple(undefTriple.getTripleSubj(), undefTriple.getTriplePred(), (ALiteral)undefTriple.getTripleObj(), tripleStore, true);
            }
            if (!bl) continue;
            iterator.remove();
        }
        collection = this.globalParserCache.getUndefTriples(string);
        if (collection.isEmpty()) {
            this.globalParserCache.removeUndefTripleKey(string);
        }
    }

    public GlobalParserCache getGlobalParserCache() {
        return this.globalParserCache;
    }

    public void doPostProcessing() {
        this.processUndefTriples();
        this.postProcessor.doPostProcessing();
    }

    public void processUndefTriples() {
        this.untypedProcessor.processUndefTriples();
    }

    public void createUntypedResources() {
        this.untypedProcessor.createUntypedResources();
    }
}

