/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.jena.parser;

import edu.stanford.smi.protege.model.Cls;
import edu.stanford.smi.protege.model.Frame;
import edu.stanford.smi.protege.model.Instance;
import edu.stanford.smi.protege.model.Slot;
import edu.stanford.smi.protege.model.framestore.NarrowFrameStore;
import edu.stanford.smi.protege.util.ApplicationProperties;
import edu.stanford.smi.protege.util.ConsoleFormatter;
import edu.stanford.smi.protege.util.Log;
import edu.stanford.smi.protegex.owl.jena.parser.AbstractStatefulTripleProcessor;
import edu.stanford.smi.protegex.owl.jena.parser.FrameCreatorUtility;
import edu.stanford.smi.protegex.owl.jena.parser.MultipleTypesInstanceCache;
import edu.stanford.smi.protegex.owl.jena.parser.ParserUtil;
import edu.stanford.smi.protegex.owl.jena.parser.TriplePostProcessorLogFormatter;
import edu.stanford.smi.protegex.owl.jena.parser.TripleProcessor;
import edu.stanford.smi.protegex.owl.model.NamespaceManager;
import edu.stanford.smi.protegex.owl.model.OWLEnumeratedClass;
import edu.stanford.smi.protegex.owl.model.OWLIntersectionClass;
import edu.stanford.smi.protegex.owl.model.ProtegeNames;
import edu.stanford.smi.protegex.owl.model.RDFProperty;
import edu.stanford.smi.protegex.owl.model.RDFResource;
import edu.stanford.smi.protegex.owl.model.RDFSClass;
import edu.stanford.smi.protegex.owl.model.RDFSNamedClass;
import edu.stanford.smi.protegex.owl.model.impl.AbstractOWLModel;
import edu.stanford.smi.protegex.owl.model.triplestore.TripleStore;
import edu.stanford.smi.protegex.owl.model.triplestore.TripleStoreModel;
import edu.stanford.smi.protegex.owl.swrl.SWRLSystemFrames;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.logging.ConsoleHandler;
import java.util.logging.Formatter;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.protege.editor.owl.model.hierarchy.roots.Relation;
import org.protege.editor.owl.model.hierarchy.roots.TerminalElementFinder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class TriplePostProcessor
extends AbstractStatefulTripleProcessor {
    public static final transient Logger log = Log.getLogger(TriplePostProcessor.class);
    Collection<TripleStore> parsedTripleStores = new HashSet<TripleStore>();
    private Map<RDFResource, RDFSNamedClass> protegeSystemTypeMap = new HashMap<RDFResource, RDFSNamedClass>();

    static void initLogger() {
        Handler[] handlerArray;
        Log.makeInheritedLoggersLocal((Logger)log);
        for (Handler handler : handlerArray = log.getHandlers()) {
            if (!(handler.getFormatter() instanceof ConsoleFormatter)) continue;
            log.removeHandler(handler);
            ConsoleHandler consoleHandler = new ConsoleHandler();
            TriplePostProcessorLogFormatter triplePostProcessorLogFormatter = new TriplePostProcessorLogFormatter();
            consoleHandler.setFormatter((Formatter)((Object)triplePostProcessorLogFormatter));
            log.addHandler(consoleHandler);
        }
    }

    public TriplePostProcessor(TripleProcessor tripleProcessor) {
        super(tripleProcessor);
        SWRLSystemFrames sWRLSystemFrames = this.owlModel.getSystemFrames();
        this.protegeSystemTypeMap.put(sWRLSystemFrames.getDirectedBinaryRelationCls(), sWRLSystemFrames.getOwlNamedClassClass());
        this.protegeSystemTypeMap.put(sWRLSystemFrames.getPalConstraintCls(), sWRLSystemFrames.getOwlNamedClassClass());
        this.protegeSystemTypeMap.put(sWRLSystemFrames.getFromSlot(), sWRLSystemFrames.getOwlObjectPropertyClass());
        this.protegeSystemTypeMap.put(sWRLSystemFrames.getToSlot(), sWRLSystemFrames.getOwlObjectPropertyClass());
        this.protegeSystemTypeMap.put(sWRLSystemFrames.getSlotConstraintsSlot(), sWRLSystemFrames.getOwlObjectPropertyClass());
        this.protegeSystemTypeMap.put(sWRLSystemFrames.getPalStatementSlot(), sWRLSystemFrames.getOwlDatatypePropertyClass());
        this.protegeSystemTypeMap.put(sWRLSystemFrames.getPalDescriptionSlot(), sWRLSystemFrames.getOwlDatatypePropertyClass());
        this.protegeSystemTypeMap.put(sWRLSystemFrames.getPalNameSlot(), sWRLSystemFrames.getOwlDatatypePropertyClass());
        this.protegeSystemTypeMap.put(sWRLSystemFrames.getPalRangeSlot(), sWRLSystemFrames.getOwlDatatypePropertyClass());
    }

    @Override
    public void doPostProcessing() {
        this.parsedTripleStores = this.globalParserCache.getParsedTripleStores();
        if (this.parsedTripleStores.size() == 0) {
            return;
        }
        this.processor.processUndefTriples();
        this.reinitCaches();
        this.processFramesWithWrongJavaType();
        this.reinitCaches();
        this.processMetaclasses();
        this.reinitCaches();
        this.processSubclassesOfRdfList();
        this.reinitCaches();
        this.processInstancesWithMultipleTypes();
        this.reinitCaches();
        if (this.isCreateUntypedResourcesEnabled()) {
            this.processor.createUntypedResources();
            this.reinitCaches();
        }
        this.processInferredSuperclasses();
        this.reinitCaches();
        this.processOrphanClses();
        this.reinitCaches();
        this.processGeneralizedConceptInclusions();
        this.reinitCaches();
        this.processAbstractClasses();
        this.reinitCaches();
        this.processDomainAndRange();
        this.reinitCaches();
        this.processPossiblyTypedResources();
        this.reinitCaches();
        this.processProtegeOWLImport();
        this.reinitCaches();
    }

    private void processMetaclasses() {
        int n = this.owlModel.getSystemFrames().getRdfsNamedClassClass().getSubclassCount();
        log.info("Postprocess: Process metaclasses (" + n + " metaclasses) ... ");
        long l = System.currentTimeMillis();
        for (TripleStore tripleStore : this.parsedTripleStores) {
            this.processMetaclasses(tripleStore);
        }
        log.info(System.currentTimeMillis() - l + " ms\n");
    }

    private void processSubclassesOfRdfList() {
        log.info("Postprocess: Process subclasses of rdf:List (" + this.owlModel.getRDFListClass().getSubclassCount() + " classes) ... ");
        long l = System.currentTimeMillis();
        for (TripleStore tripleStore : this.parsedTripleStores) {
            this.processSubclassesOfRdfList(tripleStore);
        }
        log.info(System.currentTimeMillis() - l + " ms\n");
    }

    private void processInferredSuperclasses() {
        log.info("Postprocess: Add inferred superclasses ... ");
        long l = System.currentTimeMillis();
        for (TripleStore tripleStore : this.parsedTripleStores) {
            this.processInferredSuperclasses(tripleStore);
        }
        log.info(System.currentTimeMillis() - l + " ms\n");
    }

    private void processAbstractClasses() {
        log.info("Postprocess: Abstract classes... ");
        long l = System.currentTimeMillis();
        for (TripleStore tripleStore : this.parsedTripleStores) {
            this.processAbstractClasses(tripleStore);
        }
        log.info(System.currentTimeMillis() - l + " ms\n");
    }

    private void processDomainAndRange() {
        log.info("Postprocess: Domain and range of properties... ");
        long l = System.currentTimeMillis();
        for (TripleStore tripleStore : this.parsedTripleStores) {
            this.processDomainAndRange(tripleStore);
        }
        log.info(System.currentTimeMillis() - l + " ms\n");
    }

    private void reinitCaches() {
        this.owlModel.getFrameStoreManager().reinitialize();
    }

    private boolean isCreateUntypedResourcesEnabled() {
        return ApplicationProperties.getBooleanProperty((String)"protegeowl.parser.create.untyped.resources", (boolean)true);
    }

    private void processFramesWithWrongJavaType() {
        Set<String> set = this.globalParserCache.getFramesWithWrongJavaType();
        log.info("Postprocess: Process entities with incorrect Java type (" + set.size() + " entities) ... ");
        long l = System.currentTimeMillis();
        Iterator<String> iterator = set.iterator();
        while (iterator.hasNext()) {
            String string = iterator.next();
            try {
                Instance instance;
                if (log.isLoggable(Level.FINE)) {
                    log.fine("Fixing wrong Java type of: " + string);
                }
                if ((instance = (Instance)this.simpleFrameStore.getFrame(string)) != null) {
                    this.simpleFrameStore.swizzleInstance(instance);
                }
                iterator.remove();
            }
            catch (Exception exception) {
                log.log(Level.WARNING, "\nError at processing entity with incorrect Java type: " + string, exception);
            }
        }
        this.processWrongOneOfTypes();
        if (set.size() > 0) {
            log.warning("\n    Frames with wrong Java type: " + this.globalParserCache.getFramesWithWrongJavaType() + "\n");
        }
        log.info(System.currentTimeMillis() - l + " ms\n");
    }

    private void processWrongOneOfTypes() {
        for (TripleStore tripleStore : this.parsedTripleStores) {
            NarrowFrameStore narrowFrameStore = tripleStore.getNarrowFrameStore();
            Set set = narrowFrameStore.getFrames((Slot)this.owlModel.getSystemFrames().getRdfTypeProperty(), null, false, (Object)this.owlModel.getSystemFrames().getOwlDataRangeClass());
            for (Frame frame : set) {
                if (!(frame instanceof OWLEnumeratedClass)) continue;
                this.simpleFrameStore.swizzleInstance((Instance)frame);
            }
        }
    }

    private void processMetaclasses(TripleStore tripleStore) {
        this.processMetaclasses(this.owlModel.getRDFSNamedClassClass(), tripleStore);
        this.processMetaclasses(this.owlModel.getRDFPropertyClass(), tripleStore);
    }

    private void processMetaclasses(Cls cls, TripleStore tripleStore) {
        for (RDFSNamedClass rDFSNamedClass : cls.getSubclasses()) {
            if (rDFSNamedClass.isSystem()) continue;
            for (RDFResource rDFResource : tripleStore.getUserDefinedInstancesOf(rDFSNamedClass, RDFResource.class)) {
                Instance instance = rDFResource;
                ParserUtil.getSimpleFrameStore(this.owlModel).swizzleInstance(instance);
            }
        }
    }

    private void processSubclassesOfRdfList(TripleStore tripleStore) {
        this.processMetaclasses(this.owlModel.getRDFListClass(), tripleStore);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processOrphanClses() {
        HashSet<RDFSNamedClass> hashSet = new HashSet<RDFSNamedClass>();
        for (TripleStore tripleStore : this.parsedTripleStores) {
            hashSet.addAll(tripleStore.getUserDefinedClasses());
        }
        TerminalElementFinder terminalElementFinder = new TerminalElementFinder((Relation)new Relation<RDFSNamedClass>(){

            public Collection<RDFSNamedClass> getR(RDFSNamedClass rDFSNamedClass) {
                HashSet<RDFSNamedClass> hashSet = new HashSet<RDFSNamedClass>();
                for (Cls cls : rDFSNamedClass.getDirectSuperclasses()) {
                    if (!(cls instanceof RDFSNamedClass)) continue;
                    hashSet.add((RDFSNamedClass)cls);
                }
                return hashSet;
            }
        });
        hashSet.addAll(this.owlModel.getSystemFrames().getRdfExternalClassClass().getInstances());
        hashSet.remove(this.owlModel.getOWLThingClass());
        log.info("Postprocess: Process orphan classes (" + hashSet.size() + " classes) ... ");
        long l = System.currentTimeMillis();
        this.reinitCaches();
        HashSet hashSet2 = new HashSet();
        try {
            terminalElementFinder.appendTerminalElements(hashSet);
            hashSet2.addAll(terminalElementFinder.getTerminalElements());
        }
        catch (Exception exception) {
            log.log(Level.WARNING, "Error at computing orphan classes. Error message: " + exception.getMessage(), exception);
        }
        finally {
            terminalElementFinder.clear();
        }
        hashSet2.remove(this.owlModel.getOWLThingClass());
        this.reinitCaches();
        for (RDFSNamedClass rDFSNamedClass : hashSet2) {
            if (log.isLoggable(Level.FINE)) {
                log.fine("processClsesWithoutSupercls: No declared supercls: " + rDFSNamedClass + "\n");
            }
            try {
                TripleStore tripleStore = this.owlModel.getTripleStoreModel().getHomeTripleStore(rDFSNamedClass);
                FrameCreatorUtility.createSubclassOf(rDFSNamedClass, this.owlModel.getOWLThingClass(), tripleStore);
            }
            catch (Exception exception) {
                Log.getLogger().log(Level.WARNING, "Error at adding owl:Thing as a superclass of " + rDFSNamedClass, exception);
            }
        }
        log.info(System.currentTimeMillis() - l + " ms\n");
    }

    private void processInferredSuperclasses(TripleStore tripleStore) {
        Collection<RDFSNamedClass> collection = this.getNamedClassesWithEquivalentClasses(tripleStore);
        for (RDFSNamedClass rDFSNamedClass : collection) {
            try {
                RDFSNamedClass rDFSNamedClass2 = rDFSNamedClass;
                if (rDFSNamedClass2.isSystem()) continue;
                Collection<Cls> collection2 = this.getInferredSuperClasses(rDFSNamedClass2);
                for (Cls cls : collection2) {
                    if (FrameCreatorUtility.hasDirectSuperclass(rDFSNamedClass2, cls)) continue;
                    TripleStore tripleStore2 = this.owlModel.getTripleStoreModel().getHomeTripleStore(rDFSNamedClass2);
                    FrameCreatorUtility.createSubclassOf(rDFSNamedClass2, cls, tripleStore2);
                }
            }
            catch (Exception exception) {
                Log.getLogger().log(Level.WARNING, " Error at post processing " + rDFSNamedClass + "\n", exception);
            }
        }
    }

    private Collection<RDFSNamedClass> getNamedClassesWithEquivalentClasses(TripleStore tripleStore) {
        HashSet<RDFSNamedClass> hashSet = new HashSet<RDFSNamedClass>();
        NarrowFrameStore narrowFrameStore = tripleStore.getNarrowFrameStore();
        Set set = narrowFrameStore.getFramesWithAnyValue((Slot)this.owlModel.getOWLEquivalentClassProperty(), null, false);
        for (Frame frame : set) {
            if (!(frame instanceof RDFSNamedClass)) continue;
            hashSet.add((RDFSNamedClass)frame);
        }
        return hashSet;
    }

    private Collection<Cls> getInferredSuperClasses(RDFSNamedClass rDFSNamedClass) {
        ArrayList<Cls> arrayList = new ArrayList<Cls>();
        Collection collection = rDFSNamedClass.getEquivalentClasses();
        for (RDFSClass rDFSClass : collection) {
            try {
                if (rDFSClass instanceof RDFSNamedClass) {
                    arrayList.add(rDFSClass);
                    continue;
                }
                if (!(rDFSClass instanceof OWLIntersectionClass)) continue;
                Collection<RDFSClass> collection2 = ((OWLIntersectionClass)rDFSClass).getOperands();
                for (RDFSClass rDFSClass2 : collection2) {
                    if (!(rDFSClass2 instanceof RDFSNamedClass)) continue;
                    arrayList.add(rDFSClass2);
                }
            }
            catch (Exception exception) {
                Log.getLogger().log(Level.WARNING, "Errors at adding inferred superclasses to: " + rDFSClass, exception);
            }
        }
        return arrayList;
    }

    private void processInstancesWithMultipleTypes() {
        MultipleTypesInstanceCache multipleTypesInstanceCache = this.globalParserCache.getMultipleTypesInstanceCache();
        Set<Instance> set = multipleTypesInstanceCache.getInstancesWithMultipleTypes();
        log.info("Postprocess: Instances with multiple types (" + set.size() + " instances) ... ");
        long l = System.currentTimeMillis();
        for (Instance instance : set) {
            Set<Cls> set2 = multipleTypesInstanceCache.getTypesForInstanceAsSet(instance);
            this.adjustTypesOfInstance(instance, set2);
            if (!log.isLoggable(Level.FINE)) continue;
            log.fine("process instance with multiple types" + instance + ": " + set2 + "\n");
        }
        log.info(System.currentTimeMillis() - l + " ms\n");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void adjustTypesOfInstance(Instance instance, Set<Cls> set) {
        Collection<Cls> collection = FrameCreatorUtility.getDirectTypes(instance);
        set.removeAll(collection);
        String string = instance.getName();
        for (Cls cls : set) {
            instance = (Instance)this.simpleFrameStore.getFrame(string);
            TripleStoreModel tripleStoreModel = this.owlModel.getTripleStoreModel();
            TripleStore tripleStore = tripleStoreModel.getActiveTripleStore();
            try {
                TripleStore tripleStore2 = tripleStoreModel.getHomeTripleStore(instance, this.owlModel.getRDFTypeProperty(), cls);
                if (tripleStore2 != null) {
                    tripleStoreModel.setActiveTripleStore(tripleStore2);
                    FrameCreatorUtility.addInstanceType(instance, cls, tripleStore2);
                    this.simpleFrameStore.swizzleInstance(instance);
                    continue;
                }
                log.warning("Could not find home triple store of type triple for " + instance + "\n");
            }
            catch (Exception exception) {
                Log.getLogger().log(Level.WARNING, "Error at adjusting types of: " + instance, exception);
            }
            finally {
                tripleStoreModel.setActiveTripleStore(tripleStore);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processDomainAndRange(TripleStore tripleStore) {
        Iterator<RDFProperty> iterator = tripleStore.getUserDefinedProperties().iterator();
        while (iterator.hasNext()) {
            RDFProperty rDFProperty;
            RDFProperty rDFProperty2 = rDFProperty = iterator.next();
            TripleStoreModel tripleStoreModel = this.owlModel.getTripleStoreModel();
            TripleStore tripleStore2 = tripleStoreModel.getActiveTripleStore();
            try {
                TripleStore tripleStore3 = tripleStoreModel.getHomeTripleStore(rDFProperty2);
                tripleStoreModel.setActiveTripleStore(tripleStore3);
                this.owlModel.getFrameStoreManager().getDomainUpdateFrameStore().synchronizeRDFSDomainWithProtegeDomain(rDFProperty2);
                this.owlModel.getFrameStoreManager().getRangeUpdateFrameStore().synchronizeRDFSRangeWithProtegeAllowedValues(rDFProperty2);
            }
            catch (Exception exception) {
                Log.getLogger().log(Level.WARNING, "Errors at post-processing domain and range of: " + rDFProperty2, exception);
            }
            finally {
                tripleStoreModel.setActiveTripleStore(tripleStore2);
            }
        }
    }

    private void processGeneralizedConceptInclusions() {
        ArrayList<RDFSClass> arrayList = new ArrayList<RDFSClass>(this.globalParserCache.getGciAxioms());
        log.info("Postprocess: Generalized Concept Inclusion (" + arrayList.size() + " axioms) ... ");
        long l = System.currentTimeMillis();
        NamespaceManager namespaceManager = this.owlModel.getNamespaceManager();
        String string = namespaceManager.getDefaultNamespace();
        if (string == null && this.owlModel.getDefaultOWLOntology() != null && !(string = this.owlModel.getDefaultOWLOntology().getName()).endsWith("#")) {
            string = string + "#";
        }
        String string2 = string + "Axiom";
        int n = 0;
        if (string != null) {
            for (RDFSClass rDFSClass : arrayList) {
                try {
                    this.globalParserCache.removeGciAxiom(rDFSClass);
                    while (this.getFrame(string2 + n) != null) {
                        ++n;
                    }
                    rDFSClass.rename(string2 + n);
                }
                catch (Exception exception) {
                    Log.getLogger().log(Level.WARNING, "Error at post-processing GCI: " + rDFSClass, exception);
                }
            }
        }
        log.info(System.currentTimeMillis() - l + " ms\n");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processAbstractClasses(TripleStore tripleStore) {
        RDFProperty rDFProperty = this.owlModel.getRDFProperty(ProtegeNames.Slot.ABSTRACT);
        if (rDFProperty == null) {
            return;
        }
        Set set = tripleStore.getNarrowFrameStore().getFrames((Slot)rDFProperty, null, false, (Object)Boolean.TRUE);
        for (Object e : set) {
            if (!(e instanceof RDFSClass)) continue;
            TripleStoreModel tripleStoreModel = this.owlModel.getTripleStoreModel();
            TripleStore tripleStore2 = tripleStoreModel.getActiveTripleStore();
            try {
                TripleStore tripleStore3 = tripleStoreModel.getHomeTripleStore((RDFSClass)e);
                tripleStoreModel.setActiveTripleStore(tripleStore3);
                ((Cls)e).setAbstract(true);
            }
            catch (Exception exception) {
                Log.getLogger().log(Level.WARNING, "Error at post-processing abstract class: " + e, exception);
            }
            finally {
                tripleStoreModel.setActiveTripleStore(tripleStore2);
            }
        }
    }

    private void processPossiblyTypedResources() {
        RDFSNamedClass rDFSNamedClass = ((AbstractOWLModel)this.owlModel).getRDFExternalClassClass();
        RDFSNamedClass rDFSNamedClass2 = ((AbstractOWLModel)this.owlModel).getRDFExternalPropertyClass();
        RDFSNamedClass rDFSNamedClass3 = ((AbstractOWLModel)this.owlModel).getRDFExternalResourceClass();
        int n = rDFSNamedClass.getDirectInstanceCount() + rDFSNamedClass2.getDirectInstanceCount() + rDFSNamedClass3.getDirectInstanceCount();
        log.info("Postprocess: Possibly typed entities (" + n + " resources) ... ");
        long l = System.currentTimeMillis();
        this.processPossiblyTypedResources(rDFSNamedClass);
        this.processPossiblyTypedResources(rDFSNamedClass2);
        this.processPossiblyTypedResources(rDFSNamedClass3);
        log.info(System.currentTimeMillis() - l + " ms\n");
    }

    private void processPossiblyTypedResources(Cls cls) {
        for (Instance instance : cls.getDirectInstances()) {
            Instance instance2 = instance;
            if (instance2.getDirectTypes().size() <= 1) continue;
            instance2.removeDirectType(cls);
        }
    }

    private void processProtegeOWLImport() {
        TripleStoreModel tripleStoreModel = this.owlModel.getTripleStoreModel();
        TripleStore tripleStore = tripleStoreModel.getTripleStore(ProtegeNames.PROTEGE_OWL_ONTOLOGY);
        if (tripleStore == null) {
            return;
        }
        SWRLSystemFrames sWRLSystemFrames = this.owlModel.getSystemFrames();
        for (Map.Entry<RDFResource, RDFSNamedClass> entry : this.protegeSystemTypeMap.entrySet()) {
            try {
                RDFResource rDFResource = entry.getKey();
                RDFSNamedClass rDFSNamedClass = entry.getValue();
                FrameCreatorUtility.addInstanceType(rDFResource, rDFSNamedClass, tripleStore);
                FrameCreatorUtility.addOwnSlotValue((Frame)rDFResource, sWRLSystemFrames.getRdfTypeProperty(), rDFSNamedClass, tripleStore);
                FrameCreatorUtility.addOwnSlotValue((Frame)rDFResource, sWRLSystemFrames.getNameSlot(), rDFResource.getName(), tripleStore);
            }
            catch (Exception exception) {
                Log.getLogger().log(Level.WARNING, "Error at post processing: " + entry.getKey(), exception);
            }
        }
    }

    static {
        try {
            TriplePostProcessor.initLogger();
        }
        catch (Throwable throwable) {
            System.err.println("Could not initialize logger for TriplePostProcessor");
        }
    }
}

