/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.jena.parser;

import com.hp.hpl.jena.vocabulary.OWL;
import edu.stanford.smi.protege.model.Cls;
import edu.stanford.smi.protege.model.Frame;
import edu.stanford.smi.protege.model.FrameID;
import edu.stanford.smi.protege.model.Instance;
import edu.stanford.smi.protege.model.Slot;
import edu.stanford.smi.protegex.owl.jena.parser.FrameCreatorUtility;
import edu.stanford.smi.protegex.owl.model.OWLModel;
import edu.stanford.smi.protegex.owl.model.OWLNames;
import edu.stanford.smi.protegex.owl.model.impl.DefaultOWLAllValuesFrom;
import edu.stanford.smi.protegex.owl.model.impl.DefaultOWLCardinality;
import edu.stanford.smi.protegex.owl.model.impl.DefaultOWLHasValue;
import edu.stanford.smi.protegex.owl.model.impl.DefaultOWLMaxCardinality;
import edu.stanford.smi.protegex.owl.model.impl.DefaultOWLMinCardinality;
import edu.stanford.smi.protegex.owl.model.impl.DefaultOWLSomeValuesFrom;
import edu.stanford.smi.protegex.owl.model.triplestore.TripleStore;
import edu.stanford.smi.protegex.owl.swrl.SWRLSystemFrames;
import java.util.HashMap;

public class RestrictionCreatorUtility {
    private static final HashMap<String, String> restrictionURI2MetaclassName = new HashMap();
    private static final HashMap<String, String> filler2SlotName;

    public static Frame createRestriction(OWLModel oWLModel, FrameID frameID, String string, TripleStore tripleStore) {
        Object object = oWLModel.getFrame(frameID);
        SWRLSystemFrames sWRLSystemFrames = oWLModel.getSystemFrames();
        if (object != null) {
            return object;
        }
        if (string.equals(OWL.someValuesFrom.getURI())) {
            object = new DefaultOWLSomeValuesFrom(oWLModel, frameID);
        } else if (string.equals(OWL.allValuesFrom.getURI())) {
            object = new DefaultOWLAllValuesFrom(oWLModel, frameID);
        } else if (string.equals(OWL.hasValue.getURI())) {
            object = new DefaultOWLHasValue(oWLModel, frameID);
        } else if (string.equals(OWL.maxCardinality.getURI())) {
            object = new DefaultOWLMaxCardinality(oWLModel, frameID);
        } else if (string.equals(OWL.minCardinality.getURI())) {
            object = new DefaultOWLMinCardinality(oWLModel, frameID);
        } else if (string.equals(OWL.cardinality.getURI())) {
            object = new DefaultOWLCardinality(oWLModel, frameID);
        }
        object.assertFrameName();
        FrameCreatorUtility.addOwnSlotValue(object, sWRLSystemFrames.getRdfTypeProperty(), sWRLSystemFrames.getOwlRestrictionClass(), tripleStore);
        Cls cls = oWLModel.getCls(restrictionURI2MetaclassName.get(string));
        FrameCreatorUtility.addInstanceType((Instance)object, cls, tripleStore);
        return object;
    }

    public static boolean addRestrictionFiller(OWLModel oWLModel, Frame frame, Frame frame2, String string, TripleStore tripleStore) {
        if (frame == null || frame2 == null) {
            return false;
        }
        Slot slot = oWLModel.getSlot(filler2SlotName.get(string));
        if (slot == null) {
            return false;
        }
        FrameCreatorUtility.addOwnSlotValue(frame, slot, frame2, tripleStore);
        return true;
    }

    static {
        restrictionURI2MetaclassName.put(OWL.someValuesFrom.getURI(), OWLNames.Cls.SOME_VALUES_FROM_RESTRICTION);
        restrictionURI2MetaclassName.put(OWL.allValuesFrom.getURI(), OWLNames.Cls.ALL_VALUES_FROM_RESTRICTION);
        restrictionURI2MetaclassName.put(OWL.hasValue.getURI(), OWLNames.Cls.HAS_VALUE_RESTRICTION);
        restrictionURI2MetaclassName.put(OWL.maxCardinality.getURI(), OWLNames.Cls.MAX_CARDINALITY_RESTRICTION);
        restrictionURI2MetaclassName.put(OWL.minCardinality.getURI(), OWLNames.Cls.MIN_CARDINALITY_RESTRICTION);
        restrictionURI2MetaclassName.put(OWL.cardinality.getURI(), OWLNames.Cls.CARDINALITY_RESTRICTION);
        filler2SlotName = new HashMap();
        filler2SlotName.put(OWL.someValuesFrom.getURI(), OWLNames.Slot.SOME_VALUES_FROM);
        filler2SlotName.put(OWL.allValuesFrom.getURI(), OWLNames.Slot.ALL_VALUES_FROM);
        filler2SlotName.put(OWL.hasValue.getURI(), OWLNames.Slot.HAS_VALUE);
        filler2SlotName.put(OWL.maxCardinality.getURI(), OWLNames.Slot.MAX_CARDINALITY);
        filler2SlotName.put(OWL.minCardinality.getURI(), OWLNames.Slot.MIN_CARDINALITY);
        filler2SlotName.put(OWL.cardinality.getURI(), OWLNames.Slot.CARDINALITY);
    }
}

