/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.jena.parser;

import com.hp.hpl.jena.rdf.arp.ALiteral;
import com.hp.hpl.jena.rdf.arp.ARP;
import com.hp.hpl.jena.rdf.arp.ARPHandlers;
import com.hp.hpl.jena.rdf.arp.AResource;
import com.hp.hpl.jena.rdf.arp.NamespaceHandler;
import com.hp.hpl.jena.rdf.arp.StatementHandler;
import edu.stanford.smi.protege.exception.OntologyLoadException;
import edu.stanford.smi.protege.util.ApplicationProperties;
import edu.stanford.smi.protege.util.Log;
import edu.stanford.smi.protege.util.MessageError;
import edu.stanford.smi.protege.util.URIUtilities;
import edu.stanford.smi.protegex.owl.jena.JenaOWLModel;
import edu.stanford.smi.protegex.owl.jena.parser.OWLImportsCache;
import edu.stanford.smi.protegex.owl.jena.parser.ProtegeOWLParserException;
import edu.stanford.smi.protegex.owl.jena.parser.TripleProcessor;
import edu.stanford.smi.protegex.owl.model.NamespaceManager;
import edu.stanford.smi.protegex.owl.model.OWLModel;
import edu.stanford.smi.protegex.owl.model.RDFResource;
import edu.stanford.smi.protegex.owl.model.factory.AlreadyImportedException;
import edu.stanford.smi.protegex.owl.model.factory.FactoryUtils;
import edu.stanford.smi.protegex.owl.model.framestore.OWLFrameStoreManager;
import edu.stanford.smi.protegex.owl.model.impl.AbstractOWLModel;
import edu.stanford.smi.protegex.owl.model.triplestore.TripleStore;
import edu.stanford.smi.protegex.owl.model.triplestore.TripleStoreUtil;
import edu.stanford.smi.protegex.owl.repository.impl.AbstractStreamBasedRepositoryImpl;
import edu.stanford.smi.protegex.owl.repository.util.XMLBaseExtractor;
import edu.stanford.smi.protegex.owl.ui.widget.OWLUI;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.net.URLConnection;
import java.util.Collection;
import java.util.Set;
import java.util.TreeSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProtegeOWLParser {
    private static transient Logger log = Log.getLogger(ProtegeOWLParser.class);
    public static final String JENA_ERROR_LEVEL_PROPERTY = "jena.parser.error_level";
    public static final String CREATE_UNTYPED_RESOURCES = "protegeowl.parser.create.untyped.resources";
    public static final String PRINT_LOAD_TRIPLES_LOG = "protegeowl.parser.print.load.triples.log";
    public static final String PRINT_LOAD_TRIPLES_LOG_INCREMENT = "protegeowl.parser.print.load.triples.log.increment";
    private static String topOntologyName;
    private static String currentlyParsingOntologyLocation;
    private OWLModel owlModel;
    private boolean importing = false;
    private boolean isMergeImportMode = false;
    private int tripleCount = 0;
    private boolean printLoadTriplesLog = true;
    private int printLoadTriplesLogIncrement = 10000;
    private TripleProcessor tripleProcessor;

    public ProtegeOWLParser(OWLModel oWLModel) {
        topOntologyName = null;
        this.printLoadTriplesLog = ApplicationProperties.getBooleanProperty((String)PRINT_LOAD_TRIPLES_LOG, (boolean)true);
        this.printLoadTriplesLogIncrement = ApplicationProperties.getIntegerProperty((String)PRINT_LOAD_TRIPLES_LOG_INCREMENT, (int)10000);
        this.owlModel = oWLModel;
    }

    private ARPInvokation createARPInvokation(final InputStream inputStream, final String string) {
        ARPInvokation aRPInvokation = new ARPInvokation(){

            public void invokeARP(ARP aRP) throws Exception {
                ProtegeOWLParser.this.setErrorLevel(aRP);
                aRP.load(inputStream, string);
                inputStream.close();
            }
        };
        return aRPInvokation;
    }

    private ARPInvokation createARPInvokation(final Reader reader, final String string) {
        ARPInvokation aRPInvokation = new ARPInvokation(){

            public void invokeARP(ARP aRP) throws Exception {
                ProtegeOWLParser.this.setErrorLevel(aRP);
                aRP.load(reader, string);
                reader.close();
            }
        };
        return aRPInvokation;
    }

    protected ARP createARP(TripleStore tripleStore) {
        ARP aRP = new ARP();
        ARPHandlers aRPHandlers = aRP.getHandlers();
        aRPHandlers.setStatementHandler((StatementHandler)new ProtegeOWLStatementHandler(tripleStore));
        aRPHandlers.setErrorHandler((ErrorHandler)new ProtegeOWLErrorHandler());
        if (this.isMergingImportMode()) {
            aRPHandlers.setNamespaceHandler((NamespaceHandler)new ProtegeOWLMergingNamespaceHandler(tripleStore));
        } else {
            aRPHandlers.setNamespaceHandler((NamespaceHandler)new ProtegeOWLNamespaceHandler(tripleStore));
        }
        aRP.setHandlersWith(aRPHandlers);
        return aRP;
    }

    public void setErrorLevel(ARP aRP) {
        String string = ApplicationProperties.getApplicationOrSystemProperty((String)JENA_ERROR_LEVEL_PROPERTY, (String)"lax");
        if (string.equalsIgnoreCase("default")) {
            aRP.getOptions().setDefaultErrorMode();
        } else if (string.equalsIgnoreCase("lax")) {
            aRP.getOptions().setLaxErrorMode();
        } else if (string.equalsIgnoreCase("strict")) {
            aRP.getOptions().setStrictErrorMode();
        } else {
            aRP.getOptions().setLaxErrorMode();
        }
        aRP.getOptions().setErrorMode(105, 0);
    }

    public void run(URI uRI) throws OntologyLoadException {
        URL uRL;
        try {
            uRL = uRI.toURL();
        }
        catch (MalformedURLException malformedURLException) {
            throw new OntologyLoadException((Throwable)malformedURLException);
        }
        URI uRI2 = null;
        if (uRI != null) {
            try {
                uRI2 = XMLBaseExtractor.getXMLBase(uRI.toString());
            }
            catch (MalformedURLException malformedURLException) {
                throw new OntologyLoadException((Throwable)malformedURLException, "Malformed URL: " + uRI);
            }
            catch (IOException iOException) {
                throw new OntologyLoadException((Throwable)iOException);
            }
        }
        if (uRI2 == null) {
            uRI2 = uRI;
        }
        this.loadTriples(uRL.toString(), uRI2, this.createARPInvokation(ProtegeOWLParser.getInputStream(uRL), uRI2.toString()));
    }

    public void run(InputStream inputStream, String string) throws OntologyLoadException {
        this.loadTriples(null, URIUtilities.createURI((String)string), this.createARPInvokation(inputStream, string));
    }

    public void run(Reader reader, String string) throws OntologyLoadException {
        this.loadTriples(null, URIUtilities.createURI((String)string), this.createARPInvokation(reader, string));
    }

    public void loadTriples(String string, URI uRI, InputStream inputStream) throws OntologyLoadException {
        this.loadTriples(string, uRI, this.createARPInvokation(inputStream, string.toString()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadTriples(String string, URI uRI, ARPInvokation aRPInvokation) throws OntologyLoadException {
        TripleStore tripleStore = this.owlModel.getTripleStoreModel().getActiveTripleStore();
        ((AbstractOWLModel)this.owlModel).getGlobalParserCache().getParsedTripleStores().add(tripleStore);
        if (string != null) {
            tripleStore.addIOAddress(string.toString());
        }
        if (uRI != null) {
            tripleStore.addIOAddress(uRI.toString());
            tripleStore.setOriginalXMLBase(uRI.toString());
        }
        topOntologyName = string != null ? string : (uRI != null ? uRI.toString() : null);
        boolean bl = this.owlModel.setGenerateEventsEnabled(false);
        boolean bl2 = this.owlModel.isExpandShortNameInMethods();
        this.owlModel.setExpandShortNameInMethods(false);
        OWLFrameStoreManager oWLFrameStoreManager = this.owlModel.getFrameStoreManager();
        try {
            this.tripleProcessor = ((AbstractOWLModel)this.owlModel).getGlobalParserCache().getTripleProcessor();
            Log.getLogger().info("Loading triples for: " + string);
            ARP aRP = this.createARP(tripleStore);
            currentlyParsingOntologyLocation = string;
            long l = System.currentTimeMillis();
            try {
                aRPInvokation.invokeARP(aRP);
            }
            catch (ProtegeOWLParserException protegeOWLParserException) {
                throw protegeOWLParserException;
            }
            catch (Exception exception) {
                ProtegeOWLParserException protegeOWLParserException = new ProtegeOWLParserException(exception, exception.getMessage(), "");
                throw protegeOWLParserException;
            }
            long l2 = System.currentTimeMillis();
            currentlyParsingOntologyLocation = null;
            Log.getLogger().info("    Completed triple loading after " + (l2 - l) + " ms");
            this.tripleProcessor.getGlobalParserCache().dumpUndefTriples(Level.FINE);
            if (log.isLoggable(Level.FINE)) {
                log.fine("Start processing imports ...");
            }
            if (this.isMergingImportMode()) {
                this.processMergingImports(tripleStore, string);
            } else {
                this.processImports(tripleStore);
            }
            if (log.isLoggable(Level.FINE)) {
                log.fine("End processing imports");
            }
            this.handleNoOntologyDeclarationFound(tripleStore, string, uRI);
            if (!this.importing) {
                ProtegeOWLParser.doFinalPostProcessing(this.owlModel);
                if (this.isMergingImportMode()) {
                    this.doFinalPostProcessingMergingMode(this.owlModel);
                }
            }
        }
        catch (AlreadyImportedException alreadyImportedException) {
            Log.getLogger().warning("Broken import led to attempt to import the same ontology twice");
            this.owlModel.getTripleStoreModel().deleteTripleStore(tripleStore);
        }
        finally {
            this.owlModel.setGenerateEventsEnabled(bl);
            this.owlModel.setExpandShortNameInMethods(bl2);
        }
    }

    private void handleNoOntologyDeclarationFound(TripleStore tripleStore, String string, URI uRI) throws AlreadyImportedException {
        if (tripleStore.getName() == null) {
            String string2 = null;
            string2 = string != null ? string : (uRI != null ? uRI.toString() : FactoryUtils.generateOntologyURIBase());
            FactoryUtils.addOntologyToTripleStore(this.owlModel, tripleStore, string2);
        }
    }

    public static void doFinalPostProcessing(OWLModel oWLModel) throws OntologyLoadException {
        try {
            long l;
            TripleProcessor tripleProcessor = ((AbstractOWLModel)oWLModel).getGlobalParserCache().getTripleProcessor();
            tripleProcessor.doPostProcessing();
            if (oWLModel instanceof JenaOWLModel) {
                l = System.currentTimeMillis();
                ((JenaOWLModel)oWLModel).copyFacetValuesIntoNamedClses();
                ((JenaOWLModel)oWLModel).copyFacetValuesIntoProperties();
                log.info("Updating underlying frames model in " + (System.currentTimeMillis() - l) + " ms");
            }
            if (OWLUI.getSortClassTreeAfterLoadOption()) {
                l = System.currentTimeMillis();
                TripleStoreUtil.sortSubclasses(oWLModel);
                log.info("Sorting OWL class tree in " + (System.currentTimeMillis() - l) + " ms");
            }
        }
        catch (Exception exception) {
            throw new OntologyLoadException((Throwable)exception, " Errors at post processing ontology");
        }
    }

    private void doFinalPostProcessingMergingMode(OWLModel oWLModel) {
        Object object2;
        Collection collection = oWLModel.getOWLOntologies();
        collection.remove(oWLModel.getDefaultOWLOntology());
        for (Object object2 : collection) {
            object2.delete();
        }
        Set<String> set = OWLImportsCache.getAllOntologies();
        set.remove(oWLModel.getDefaultOWLOntology().getName());
        object2 = set.iterator();
        while (object2.hasNext()) {
            String string = (String)object2.next();
            RDFResource rDFResource = oWLModel.getRDFResource(string);
            if (rDFResource == null || !rDFResource.hasDirectType(oWLModel.getSystemFrames().getRdfExternalResourceClass())) continue;
            rDFResource.delete();
        }
    }

    public void setImporting(boolean bl) {
        this.importing = bl;
    }

    private void processImports(TripleStore tripleStore) throws OntologyLoadException {
        Set<String> set = OWLImportsCache.getOWLImportsURI(tripleStore.getName());
        for (String string : new TreeSet<String>(set)) {
            URI uRI = ((AbstractOWLModel)this.owlModel).loadImportedAssertions(URIUtilities.createURI((String)string));
            if (uRI != null) continue;
            ((AbstractOWLModel)this.owlModel).addParserError(new MessageError("Could not import ontology from " + string));
        }
    }

    private void processMergingImports(TripleStore tripleStore, String string) throws OntologyLoadException {
        if (!this.importing && topOntologyName != null) {
            string = topOntologyName;
        }
        if (string == null) {
            return;
        }
        Set<String> set = OWLImportsCache.getOWLImportsURI(string);
        for (String string2 : set) {
            if (OWLImportsCache.isImported(string2)) continue;
            URI uRI = URIUtilities.createURI((String)string2);
            URI uRI2 = null;
            try {
                uRI2 = this.getXMLBaseForMerge(uRI);
            }
            catch (OntologyLoadException ontologyLoadException) {
                Log.getLogger().warning("Could not load import from: " + uRI + " (Skipping this import)");
                ((AbstractOWLModel)this.owlModel).addParserError(new MessageError("Could not import ontology from " + uRI));
                continue;
            }
            ProtegeOWLParser protegeOWLParser = new ProtegeOWLParser(this.owlModel);
            protegeOWLParser.setMergingImportMode(this.isMergingImportMode());
            protegeOWLParser.setImporting(true);
            protegeOWLParser.loadTriples(string2, uRI2, this.getInputStreamForMerge(uRI));
        }
    }

    private InputStream getInputStreamForMerge(URI uRI) throws OntologyLoadException {
        AbstractStreamBasedRepositoryImpl abstractStreamBasedRepositoryImpl = (AbstractStreamBasedRepositoryImpl)this.owlModel.getRepositoryManager().getRepository(uRI);
        InputStream inputStream = null;
        try {
            inputStream = abstractStreamBasedRepositoryImpl == null ? ProtegeOWLParser.getInputStream(uRI.toURL()) : abstractStreamBasedRepositoryImpl.getInputStream(uRI);
        }
        catch (MalformedURLException malformedURLException) {
            throw new OntologyLoadException((Throwable)malformedURLException, "Malformed ontology name: " + uRI);
        }
        return inputStream;
    }

    private URI getXMLBaseForMerge(URI uRI) throws OntologyLoadException {
        URI uRI2 = uRI;
        try {
            URI uRI3 = XMLBaseExtractor.getXMLBase(this.getInputStreamForMerge(uRI));
            uRI2 = uRI3 != null ? uRI3 : uRI;
        }
        catch (Throwable throwable) {
            throw new OntologyLoadException(throwable);
        }
        return uRI2;
    }

    static void setTopOntologyName(String string) {
        topOntologyName = string;
    }

    static String getCurrentlyParsingOntologyLocation() {
        return currentlyParsingOntologyLocation;
    }

    public static Collection<MessageError> getParserErrors(OWLModel oWLModel) {
        return ((AbstractOWLModel)oWLModel).getParserErrors();
    }

    public static InputStream getInputStream(URL uRL) throws OntologyLoadException {
        try {
            if (uRL.getProtocol().equals("http")) {
                URLConnection uRLConnection = uRL.openConnection();
                uRLConnection.setConnectTimeout(ApplicationProperties.getUrlConnectTimeout() * 1000);
                uRLConnection.setReadTimeout(ApplicationProperties.getUrlConnectReadTimeout() * 1000);
                uRLConnection.setRequestProperty("Accept", "application/rdf+xml");
                uRLConnection.addRequestProperty("Accept", "text/xml");
                uRLConnection.addRequestProperty("Accept", "*/*");
                return uRLConnection.getInputStream();
            }
            return uRL.openStream();
        }
        catch (IOException iOException) {
            throw new OntologyLoadException((Throwable)iOException, "Could not get input stream for " + uRL);
        }
    }

    public boolean isMergingImportMode() {
        return this.isMergeImportMode;
    }

    public void setMergingImportMode(boolean bl) {
        this.isMergeImportMode = bl;
    }

    class ProtegeOWLMergingNamespaceHandler
    implements NamespaceHandler {
        TripleStore tripleStore;

        public ProtegeOWLMergingNamespaceHandler(TripleStore tripleStore) {
            this.tripleStore = tripleStore;
        }

        public void endPrefixMapping(String string) {
            NamespaceManager namespaceManager = this.tripleStore.getNamespaceManager();
            if (log.isLoggable(Level.FINE)) {
                log.fine("*** " + string + " -> " + namespaceManager.getNamespaceForPrefix(string));
            }
        }

        public void startPrefixMapping(String string, String string2) {
            NamespaceManager namespaceManager = this.tripleStore.getNamespaceManager();
            if (!namespaceManager.getPrefixes().contains(string)) {
                namespaceManager.setPrefix(string2, string);
            }
        }
    }

    class ProtegeOWLNamespaceHandler
    implements NamespaceHandler {
        TripleStore tripleStore;

        public ProtegeOWLNamespaceHandler(TripleStore tripleStore) {
            this.tripleStore = tripleStore;
        }

        public void endPrefixMapping(String string) {
            NamespaceManager namespaceManager = this.tripleStore.getNamespaceManager();
            if (log.isLoggable(Level.FINE)) {
                log.fine("*** " + string + " -> " + namespaceManager.getNamespaceForPrefix(string));
            }
        }

        public void startPrefixMapping(String string, String string2) {
            NamespaceManager namespaceManager = this.tripleStore.getNamespaceManager();
            namespaceManager.setPrefix(string2, string);
        }
    }

    class ProtegeOWLStatementHandler
    implements StatementHandler {
        TripleStore tripleStore;

        public ProtegeOWLStatementHandler(TripleStore tripleStore) {
            this.tripleStore = tripleStore;
        }

        public void statement(AResource aResource, AResource aResource2, AResource aResource3) {
            if (log.isLoggable(Level.FINE)) {
                log.fine("NewStatementHandler: " + aResource + "  " + aResource2 + "  " + aResource3);
            }
            ProtegeOWLParser.this.tripleCount++;
            this.printTriplesLoadLogMessage();
            try {
                ProtegeOWLParser.this.tripleProcessor.processTriple(aResource, aResource2, aResource3, this.tripleStore, false);
            }
            catch (Exception exception) {
                Log.getLogger().log(Level.SEVERE, "Error at parsing triple: " + aResource + " " + aResource2 + " " + aResource3, exception);
            }
        }

        public void statement(AResource aResource, AResource aResource2, ALiteral aLiteral) {
            if (log.isLoggable(Level.FINE)) {
                log.fine(aResource + "  " + aResource2 + "  " + aLiteral);
            }
            ProtegeOWLParser.this.tripleCount++;
            this.printTriplesLoadLogMessage();
            try {
                ProtegeOWLParser.this.tripleProcessor.processTriple(aResource, aResource2, aLiteral, this.tripleStore, false);
            }
            catch (Exception exception) {
                Log.getLogger().log(Level.SEVERE, "Error at parsing triple: " + aResource + " " + aResource2 + " " + aLiteral, exception);
            }
        }

        protected void printTriplesLoadLogMessage() {
            if (ProtegeOWLParser.this.printLoadTriplesLog && ProtegeOWLParser.this.tripleCount % ProtegeOWLParser.this.printLoadTriplesLogIncrement == 0) {
                Log.getLogger().info("    Loaded " + ProtegeOWLParser.this.tripleCount + " triples " + ProtegeOWLParser.this.tripleProcessor.getGlobalParserCache().getUndefTripleSize());
            }
        }
    }

    private class ProtegeOWLErrorHandler
    implements ErrorHandler {
        private ProtegeOWLErrorHandler() {
        }

        public void error(SAXParseException sAXParseException) throws SAXException {
            this.saveErrors(sAXParseException, MessageError.Severity.ERROR);
        }

        public void fatalError(SAXParseException sAXParseException) throws SAXException {
            this.saveErrors(sAXParseException, MessageError.Severity.FATAL);
        }

        public void warning(SAXParseException sAXParseException) throws SAXException {
            this.saveErrors(sAXParseException, MessageError.Severity.WARNING);
        }

        protected void saveErrors(SAXParseException sAXParseException, MessageError.Severity severity) {
            String string = (severity == MessageError.Severity.WARNING ? "A warning " : "An error ") + "occurred at parsing the OWL ontology ";
            string = string + "\n\n    " + topOntologyName + "\n\n";
            string = string + "    at line " + sAXParseException.getLineNumber() + " and column " + sAXParseException.getColumnNumber() + ".\n";
            string = string + "    Jena parse error message: " + sAXParseException.getMessage();
            Log.getLogger().log(severity == MessageError.Severity.WARNING ? Level.WARNING : Level.SEVERE, string, sAXParseException);
            ((AbstractOWLModel)ProtegeOWLParser.this.owlModel).addParserError(new MessageError((Throwable)sAXParseException, string, severity));
        }
    }

    public static interface ARPInvokation {
        public void invokeARP(ARP var1) throws Exception;
    }
}

