/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.jena.parser;

import edu.stanford.smi.protegex.owl.jena.parser.ProtegeOWLParser;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OWLImportsCache {
    public static HashMap<String, Set<String>> owlOntoloyToImportsMap = new HashMap();
    public static HashMap<String, String> owlOntologyLocToOntologName = new HashMap();

    public static Set<String> getOWLImportsURI(String string) {
        HashSet hashSet = owlOntoloyToImportsMap.get(string);
        return hashSet == null ? new HashSet() : hashSet;
    }

    public static void addOWLImport(String string, String string2) {
        OWLImportsCache.addImport(string, string2);
        String string3 = ProtegeOWLParser.getCurrentlyParsingOntologyLocation();
        if (string3 != null) {
            OWLImportsCache.addImport(string3, string2);
        }
    }

    private static void addImport(String string, String string2) {
        Set<String> set = OWLImportsCache.getOWLImportsURI(string);
        set.add(string2);
        owlOntoloyToImportsMap.put(string, set);
    }

    public static Set<String> getImportedOntologies() {
        HashSet<String> hashSet = new HashSet<String>();
        hashSet.addAll(owlOntologyLocToOntologName.keySet());
        hashSet.addAll(owlOntologyLocToOntologName.values());
        hashSet.addAll(owlOntoloyToImportsMap.keySet());
        return hashSet;
    }

    public static Set<String> getAllOntologies() {
        HashSet<String> hashSet = new HashSet<String>();
        hashSet.addAll(owlOntologyLocToOntologName.keySet());
        hashSet.addAll(owlOntologyLocToOntologName.values());
        hashSet.addAll(owlOntoloyToImportsMap.keySet());
        for (String string : owlOntoloyToImportsMap.keySet()) {
            hashSet.addAll((Collection<String>)owlOntoloyToImportsMap.get(string));
        }
        return hashSet;
    }

    public static boolean isImported(String string) {
        return owlOntologyLocToOntologName.keySet().contains(string) || owlOntologyLocToOntologName.values().contains(string) || owlOntoloyToImportsMap.keySet().contains(string);
    }

    public static String getOntologyName(String string) {
        return owlOntologyLocToOntologName.get(string);
    }

    public static void setOntologyName(String string, String string2) {
        owlOntologyLocToOntologName.put(string, string2);
    }

    public static void dispose() {
        owlOntologyLocToOntologName.clear();
        owlOntoloyToImportsMap.clear();
    }
}

