/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.jena.parser;

import com.hp.hpl.jena.vocabulary.OWL;
import edu.stanford.smi.protege.model.Cls;
import edu.stanford.smi.protege.model.Frame;
import edu.stanford.smi.protege.model.FrameID;
import edu.stanford.smi.protege.model.Instance;
import edu.stanford.smi.protege.model.Slot;
import edu.stanford.smi.protegex.owl.jena.parser.FrameCreatorUtility;
import edu.stanford.smi.protegex.owl.model.OWLModel;
import edu.stanford.smi.protegex.owl.model.OWLNames;
import edu.stanford.smi.protegex.owl.model.impl.DefaultOWLComplementClass;
import edu.stanford.smi.protegex.owl.model.impl.DefaultOWLIntersectionClass;
import edu.stanford.smi.protegex.owl.model.impl.DefaultOWLUnionClass;
import edu.stanford.smi.protegex.owl.model.triplestore.TripleStore;
import edu.stanford.smi.protegex.owl.swrl.SWRLSystemFrames;
import java.util.HashMap;

public class LogicalClassCreatorUtility {
    private static final HashMap<String, String> logicalClassURI2MetaclassName = new HashMap();
    private static final HashMap<String, String> filler2SlotName;

    public static Frame createLogicalClass(OWLModel oWLModel, FrameID frameID, String string, TripleStore tripleStore) {
        Object object = oWLModel.getFrame(frameID);
        SWRLSystemFrames sWRLSystemFrames = oWLModel.getSystemFrames();
        if (object != null) {
            return object;
        }
        if (string.equals(OWL.complementOf.getURI())) {
            object = new DefaultOWLComplementClass(oWLModel, frameID);
        } else if (string.equals(OWL.intersectionOf.getURI())) {
            object = new DefaultOWLIntersectionClass(oWLModel, frameID);
        } else if (string.equals(OWL.unionOf.getURI())) {
            object = new DefaultOWLUnionClass(oWLModel, frameID);
        }
        object.assertFrameName();
        FrameCreatorUtility.addOwnSlotValue(object, sWRLSystemFrames.getRdfTypeProperty(), sWRLSystemFrames.getOwlNamedClassClass(), tripleStore);
        Cls cls = oWLModel.getCls(logicalClassURI2MetaclassName.get(string));
        FrameCreatorUtility.addInstanceType((Instance)object, cls, tripleStore);
        return object;
    }

    public static boolean addLogicalFiller(OWLModel oWLModel, Frame frame, Frame frame2, String string, TripleStore tripleStore) {
        if (frame == null || frame2 == null) {
            return false;
        }
        Slot slot = oWLModel.getSlot(filler2SlotName.get(string));
        if (slot == null) {
            return false;
        }
        FrameCreatorUtility.addOwnSlotValue(frame, slot, frame2, tripleStore);
        return true;
    }

    static {
        logicalClassURI2MetaclassName.put(OWL.complementOf.getURI(), OWLNames.Cls.COMPLEMENT_CLASS);
        logicalClassURI2MetaclassName.put(OWL.intersectionOf.getURI(), OWLNames.Cls.INTERSECTION_CLASS);
        logicalClassURI2MetaclassName.put(OWL.unionOf.getURI(), OWLNames.Cls.UNION_CLASS);
        filler2SlotName = new HashMap();
        filler2SlotName.put(OWL.complementOf.getURI(), OWLNames.Slot.COMPLEMENT_OF);
        filler2SlotName.put(OWL.intersectionOf.getURI(), OWLNames.Slot.INTERSECTION_OF);
        filler2SlotName.put(OWL.unionOf.getURI(), OWLNames.Slot.UNION_OF);
    }
}

