/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.jena.parser;

import edu.stanford.smi.protege.model.Cls;
import edu.stanford.smi.protege.util.Disposable;
import edu.stanford.smi.protege.util.Log;
import edu.stanford.smi.protegex.owl.jena.parser.MultipleTypesInstanceCache;
import edu.stanford.smi.protegex.owl.jena.parser.TripleProcessor;
import edu.stanford.smi.protegex.owl.jena.parser.UndefTriple;
import edu.stanford.smi.protegex.owl.model.OWLModel;
import edu.stanford.smi.protegex.owl.model.RDFProperty;
import edu.stanford.smi.protegex.owl.model.RDFSClass;
import edu.stanford.smi.protegex.owl.model.triplestore.TripleStore;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GlobalParserCache
implements Disposable {
    transient Logger log = Log.getLogger(GlobalParserCache.class);
    private OWLModel owlModel;
    private HashMap<String, Collection<UndefTriple>> undefTriplesMap = new HashMap();
    private MultipleTypesInstanceCache multipleTypesInstanceCache = new MultipleTypesInstanceCache();
    private Set<String> framesWithWrongJavaType = new HashSet<String>();
    private Set<TripleStore> parsedTripleStores = new HashSet<TripleStore>();
    private Set<UndefTriple> oneOfTriples = new HashSet<UndefTriple>();
    private Collection<RDFProperty> possibleGCIPredicates = new ArrayList<RDFProperty>();
    private Collection<RDFSClass> gciAxioms = new ArrayList<RDFSClass>();
    private Map<String, Cls> objectToNamedLogicalClassSurrogate = new HashMap<String, Cls>();
    private TripleProcessor tripleProcessor;

    public GlobalParserCache(OWLModel oWLModel) {
        this.owlModel = oWLModel;
        this.initGCIPredicates();
    }

    public TripleProcessor getTripleProcessor() {
        if (this.tripleProcessor == null) {
            this.tripleProcessor = new TripleProcessor(this.owlModel);
        }
        return this.tripleProcessor;
    }

    public void addUndefTriple(UndefTriple undefTriple, String string) {
        if (this.log.isLoggable(Level.FINE)) {
            this.log.fine(" +++ Adding: " + undefTriple);
        }
        if (this.log.isLoggable(Level.FINE) && this.undefTriplesMap.keySet().size() % 1000 == 0) {
            this.log.fine(" Undef triples count: " + this.undefTriplesMap.keySet().size());
        }
        Collection<UndefTriple> collection = this.getUndefTriples(string);
        collection.add(undefTriple);
        this.undefTriplesMap.put(string, collection);
    }

    public Collection<UndefTriple> getUndefTriples(String string) {
        Collection<UndefTriple> collection = this.undefTriplesMap.get(string);
        if (collection == null) {
            return new ArrayList<UndefTriple>();
        }
        return collection;
    }

    public Set<String> getUndefTriplesKeys() {
        return this.undefTriplesMap.keySet();
    }

    public int getUndefTripleSize() {
        return this.undefTriplesMap.size();
    }

    public void removeUndefTriple(String string, UndefTriple undefTriple) {
        if (this.log.isLoggable(Level.FINE)) {
            this.log.fine(" --- Removing: " + undefTriple);
        }
        Collection<UndefTriple> collection = this.getUndefTriples(string);
        collection.remove(undefTriple);
        if (collection.isEmpty()) {
            this.undefTriplesMap.remove(string);
        } else {
            this.undefTriplesMap.put(string, collection);
        }
    }

    public void removeUndefTripleKey(String string) {
        this.undefTriplesMap.remove(string);
    }

    public void dumpUndefTriples(Level level) {
        if (!this.log.isLoggable(level)) {
            return;
        }
        this.log.log(level, "\n --------------- Begin undef triples dump ----------------");
        Iterator<String> iterator = this.undefTriplesMap.keySet().iterator();
        while (iterator.hasNext()) {
            String string;
            String string2 = string = iterator.next();
            Iterator<UndefTriple> iterator2 = this.undefTriplesMap.get(string2).iterator();
            while (iterator2.hasNext()) {
                UndefTriple undefTriple;
                UndefTriple undefTriple2 = undefTriple = iterator2.next();
                this.log.log(level, " * " + undefTriple2);
            }
        }
        this.log.log(level, " --------------- End undef triples dump ----------------\n");
    }

    public MultipleTypesInstanceCache getMultipleTypesInstanceCache() {
        return this.multipleTypesInstanceCache;
    }

    public Collection<RDFProperty> getPossibleGCIPredicates() {
        return this.possibleGCIPredicates;
    }

    public Collection<RDFSClass> getGciAxioms() {
        return Collections.unmodifiableCollection(this.gciAxioms);
    }

    public void addGciAxiom(RDFSClass rDFSClass) {
        this.gciAxioms.add(rDFSClass);
    }

    public void removeGciAxiom(RDFSClass rDFSClass) {
        this.gciAxioms.remove(rDFSClass);
    }

    public Map<String, Cls> getObjectToNamedLogicalClassSurrogate() {
        return this.objectToNamedLogicalClassSurrogate;
    }

    public Set<TripleStore> getParsedTripleStores() {
        return this.parsedTripleStores;
    }

    protected void initGCIPredicates() {
        this.possibleGCIPredicates.add(this.owlModel.getOWLDisjointWithProperty());
        this.possibleGCIPredicates.add(this.owlModel.getRDFSSubClassOfProperty());
        this.possibleGCIPredicates.add(this.owlModel.getOWLEquivalentClassProperty());
    }

    public Set<String> getFramesWithWrongJavaType() {
        return this.framesWithWrongJavaType;
    }

    public Set<UndefTriple> getOneOfTriples() {
        return this.oneOfTriples;
    }

    public void dispose() {
        this.multipleTypesInstanceCache.dispose();
        this.framesWithWrongJavaType.clear();
        this.parsedTripleStores.clear();
        this.oneOfTriples.clear();
        this.possibleGCIPredicates.clear();
        this.gciAxioms.clear();
        this.objectToNamedLogicalClassSurrogate.clear();
        this.undefTriplesMap.clear();
    }
}

