/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.jena.parser;

import com.hp.hpl.jena.vocabulary.OWL;
import com.hp.hpl.jena.vocabulary.RDF;
import com.hp.hpl.jena.vocabulary.RDFS;
import edu.stanford.smi.protege.model.Cls;
import edu.stanford.smi.protege.model.Frame;
import edu.stanford.smi.protege.model.FrameID;
import edu.stanford.smi.protege.model.Instance;
import edu.stanford.smi.protege.model.Slot;
import edu.stanford.smi.protege.model.framestore.NarrowFrameStore;
import edu.stanford.smi.protege.util.CollectionUtilities;
import edu.stanford.smi.protege.util.Log;
import edu.stanford.smi.protegex.owl.jena.parser.ParserUtil;
import edu.stanford.smi.protegex.owl.model.OWLEnumeratedClass;
import edu.stanford.smi.protegex.owl.model.OWLModel;
import edu.stanford.smi.protegex.owl.model.RDFSNamedClass;
import edu.stanford.smi.protegex.owl.model.impl.DefaultOWLAllDifferent;
import edu.stanford.smi.protegex.owl.model.impl.DefaultOWLDataRange;
import edu.stanford.smi.protegex.owl.model.impl.DefaultOWLDatatypeProperty;
import edu.stanford.smi.protegex.owl.model.impl.DefaultOWLEnumeratedClass;
import edu.stanford.smi.protegex.owl.model.impl.DefaultOWLIndividual;
import edu.stanford.smi.protegex.owl.model.impl.DefaultOWLNamedClass;
import edu.stanford.smi.protegex.owl.model.impl.DefaultOWLObjectProperty;
import edu.stanford.smi.protegex.owl.model.impl.DefaultOWLOntology;
import edu.stanford.smi.protegex.owl.model.impl.DefaultRDFList;
import edu.stanford.smi.protegex.owl.model.impl.DefaultRDFProperty;
import edu.stanford.smi.protegex.owl.model.impl.DefaultRDFSDatatype;
import edu.stanford.smi.protegex.owl.model.impl.DefaultRDFSNamedClass;
import edu.stanford.smi.protegex.owl.model.triplestore.TripleStore;
import edu.stanford.smi.protegex.owl.swrl.model.SWRLNames;
import edu.stanford.smi.protegex.owl.swrl.model.impl.DefaultSWRLAtomList;
import edu.stanford.smi.protegex.owl.swrl.model.impl.DefaultSWRLBuiltin;
import edu.stanford.smi.protegex.owl.swrl.model.impl.DefaultSWRLBuiltinAtom;
import edu.stanford.smi.protegex.owl.swrl.model.impl.DefaultSWRLClassAtom;
import edu.stanford.smi.protegex.owl.swrl.model.impl.DefaultSWRLDataRangeAtom;
import edu.stanford.smi.protegex.owl.swrl.model.impl.DefaultSWRLDatavaluedPropertyAtom;
import edu.stanford.smi.protegex.owl.swrl.model.impl.DefaultSWRLDifferentIndividualsAtom;
import edu.stanford.smi.protegex.owl.swrl.model.impl.DefaultSWRLImp;
import edu.stanford.smi.protegex.owl.swrl.model.impl.DefaultSWRLIndividualPropertyAtom;
import edu.stanford.smi.protegex.owl.swrl.model.impl.DefaultSWRLSameIndividualAtom;
import edu.stanford.smi.protegex.owl.swrl.model.impl.DefaultSWRLVariable;
import java.util.Collection;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FrameCreatorUtility {
    private static transient Logger log = Log.getLogger(FrameCreatorUtility.class);

    public static Frame createFrameWithType(OWLModel oWLModel, FrameID frameID, Cls cls, TripleStore tripleStore) {
        Object object = oWLModel.getFrame(frameID);
        if (object != null) {
            return object;
        }
        String string = cls.getName();
        if (string.equals(OWL.Ontology.getURI())) {
            object = new DefaultOWLOntology(oWLModel, frameID);
        } else if (string.equals(OWL.Class.getURI())) {
            object = new DefaultOWLNamedClass(oWLModel, frameID);
        } else if (string.equals(OWL.DeprecatedClass.getURI())) {
            object = new DefaultOWLNamedClass(oWLModel, frameID);
        } else if (string.equals(OWL.DatatypeProperty.getURI())) {
            object = new DefaultOWLDatatypeProperty(oWLModel, frameID);
        } else if (string.equals(OWL.ObjectProperty.getURI())) {
            object = new DefaultOWLObjectProperty(oWLModel, frameID);
        } else if (string.equals(OWL.TransitiveProperty.getURI())) {
            object = new DefaultOWLObjectProperty(oWLModel, frameID);
        } else if (string.equals(OWL.SymmetricProperty.getURI())) {
            object = new DefaultOWLObjectProperty(oWLModel, frameID);
        } else if (string.equals(OWL.AnnotationProperty.getURI())) {
            object = new DefaultRDFProperty(oWLModel, frameID);
        } else if (string.equals(OWL.InverseFunctionalProperty.getURI())) {
            object = new DefaultOWLObjectProperty(oWLModel, frameID);
        } else if (string.equals(OWL.FunctionalProperty.getURI())) {
            object = new DefaultRDFProperty(oWLModel, frameID);
            ((DefaultRDFProperty)object).setFunctional(true);
        } else {
            object = string.equals(OWL.AllDifferent.getURI()) ? new DefaultOWLAllDifferent(oWLModel, frameID) : (string.equals(OWL.DataRange.getURI()) ? new DefaultOWLDataRange(oWLModel, frameID) : (string.equals(RDF.Property.getURI()) ? new DefaultRDFProperty(oWLModel, frameID) : (string.equals(OWL.DeprecatedProperty.getURI()) ? new DefaultRDFProperty(oWLModel, frameID) : (string.equals(RDF.List.getURI()) ? new DefaultRDFList(oWLModel, frameID) : (string.equals(RDFS.Class.getURI()) ? new DefaultRDFSNamedClass(oWLModel, frameID) : (string.equals(RDFS.Datatype.getURI()) ? new DefaultRDFSDatatype(oWLModel, frameID) : (string.equals(SWRLNames.Cls.ATOM_LIST) ? new DefaultSWRLAtomList(oWLModel, frameID) : (string.equals(SWRLNames.Cls.BUILTIN_ATOM) ? new DefaultSWRLBuiltinAtom(oWLModel, frameID) : (string.equals(SWRLNames.Cls.BUILTIN) ? new DefaultSWRLBuiltin(oWLModel, frameID) : (string.equals(SWRLNames.Cls.CLASS_ATOM) ? new DefaultSWRLClassAtom(oWLModel, frameID) : (string.equals(SWRLNames.Cls.DATA_RANGE_ATOM) ? new DefaultSWRLDataRangeAtom(oWLModel, frameID) : (string.equals(SWRLNames.Cls.DATAVALUED_PROPERTY_ATOM) ? new DefaultSWRLDatavaluedPropertyAtom(oWLModel, frameID) : (string.equals(SWRLNames.Cls.DIFFERENT_INDIVIDUALS_ATOM) ? new DefaultSWRLDifferentIndividualsAtom(oWLModel, frameID) : (string.equals(SWRLNames.Cls.IMP) ? new DefaultSWRLImp(oWLModel, frameID) : (string.equals(SWRLNames.Cls.INDIVIDUAL_PROPERTY_ATOM) ? new DefaultSWRLIndividualPropertyAtom(oWLModel, frameID) : (string.equals(SWRLNames.Cls.SAME_INDIVIDUAL_ATOM) ? new DefaultSWRLSameIndividualAtom(oWLModel, frameID) : (string.equals(SWRLNames.Cls.VARIABLE) ? new DefaultSWRLVariable(oWLModel, frameID) : FrameCreatorUtility.createDefaultEntity(oWLModel, frameID, cls, tripleStore))))))))))))))))));
        }
        FrameCreatorUtility.assertFrameName(tripleStore, object);
        if (log.getLevel() == Level.FINE) {
            log.fine("Created frame: " + object);
        }
        if (!FrameCreatorUtility.hasDirectType((Instance)object, cls)) {
            if (log.getLevel() == Level.FINE) {
                log.fine("Adding direct type to " + object + " type: " + cls);
            }
            FrameCreatorUtility.addInstanceType((Instance)object, cls, tripleStore);
        }
        return object;
    }

    private static Frame createDefaultEntity(OWLModel oWLModel, FrameID frameID, Cls cls, TripleStore tripleStore) {
        if (cls.hasSuperclass((Cls)oWLModel.getRDFSNamedClassClass())) {
            return new DefaultOWLNamedClass(oWLModel, frameID);
        }
        if (cls.hasSuperclass((Cls)oWLModel.getRDFPropertyClass())) {
            return new DefaultRDFProperty(oWLModel, frameID);
        }
        return new DefaultOWLIndividual(oWLModel, frameID);
    }

    public static void assertFrameName(TripleStore tripleStore, Frame frame) {
        NarrowFrameStore narrowFrameStore = tripleStore.getNarrowFrameStore();
        narrowFrameStore.addValues(frame, frame.getKnowledgeBase().getSystemFrames().getNameSlot(), null, false, CollectionUtilities.createCollection((Object)frame.getName()));
    }

    public static boolean addInstanceType(Instance instance, Cls cls, TripleStore tripleStore) {
        if (instance == null || cls == null) {
            return false;
        }
        Slot slot = instance.getKnowledgeBase().getSystemFrames().getDirectTypesSlot();
        FrameCreatorUtility.addOwnSlotValue((Frame)instance, slot, cls, tripleStore);
        FrameCreatorUtility.addOwnSlotValue((Frame)cls, instance.getKnowledgeBase().getSystemFrames().getDirectInstancesSlot(), instance, tripleStore);
        return true;
    }

    public static boolean setInstanceType(Instance instance, Cls cls, TripleStore tripleStore) {
        if (instance == null || cls == null) {
            return false;
        }
        Slot slot = instance.getKnowledgeBase().getSystemFrames().getDirectTypesSlot();
        FrameCreatorUtility.setOwnSlotValue((Frame)instance, slot, (Frame)cls, tripleStore);
        FrameCreatorUtility.setOwnSlotValue((Frame)cls, instance.getKnowledgeBase().getSystemFrames().getDirectInstancesSlot(), (Frame)instance, tripleStore);
        return true;
    }

    public static boolean setOwnSlotValue(Frame frame, Slot slot, Frame frame2, TripleStore tripleStore) {
        if (frame == null || slot == null) {
            return false;
        }
        NarrowFrameStore narrowFrameStore = tripleStore.getNarrowFrameStore();
        narrowFrameStore.setValues(frame, slot, null, false, CollectionUtilities.createCollection((Object)frame2));
        return true;
    }

    public static boolean removeInstanceType(Instance instance, Cls cls) {
        Slot slot = instance.getKnowledgeBase().getSystemFrames().getDirectTypesSlot();
        ParserUtil.getSimpleFrameStore((Frame)instance).removeDirectOwnSlotValue((Frame)instance, slot, (Object)cls);
        ParserUtil.getSimpleFrameStore((Frame)cls).removeDirectOwnSlotValue((Frame)cls, instance.getKnowledgeBase().getSystemFrames().getDirectInstancesSlot(), (Object)instance);
        return true;
    }

    public static boolean hasDirectType(Instance instance, Cls cls) {
        return ParserUtil.getSimpleFrameStore((Frame)instance).getDirectTypes(instance).contains(cls);
    }

    public static boolean hasDirectSuperclass(Cls cls, Cls cls2) {
        return ParserUtil.getSimpleFrameStore((Frame)cls).getDirectSuperclasses(cls).contains(cls2);
    }

    public static boolean createSubclassOf(Cls cls, Cls cls2, TripleStore tripleStore) {
        if (cls == null || cls2 == null) {
            return false;
        }
        NarrowFrameStore narrowFrameStore = tripleStore.getNarrowFrameStore();
        narrowFrameStore.addValues((Frame)cls, cls.getKnowledgeBase().getSystemFrames().getDirectSuperclassesSlot(), null, false, CollectionUtilities.createCollection((Object)cls2));
        narrowFrameStore.addValues((Frame)cls2, cls.getKnowledgeBase().getSystemFrames().getDirectSubclassesSlot(), null, false, CollectionUtilities.createCollection((Object)cls));
        return true;
    }

    public static boolean createSubpropertyOf(Slot slot, Slot slot2, TripleStore tripleStore) {
        if (slot == null || slot2 == null) {
            return false;
        }
        NarrowFrameStore narrowFrameStore = tripleStore.getNarrowFrameStore();
        narrowFrameStore.addValues((Frame)slot, slot.getKnowledgeBase().getSystemFrames().getDirectSuperslotsSlot(), null, false, CollectionUtilities.createCollection((Object)slot2));
        narrowFrameStore.addValues((Frame)slot2, slot.getKnowledgeBase().getSystemFrames().getDirectSubclassesSlot(), null, false, CollectionUtilities.createCollection((Object)slot));
        return true;
    }

    public static boolean addOwnSlotValue(Frame frame, Slot slot, Object object, TripleStore tripleStore) {
        if (frame == null || slot == null) {
            return false;
        }
        NarrowFrameStore narrowFrameStore = tripleStore.getNarrowFrameStore();
        narrowFrameStore.addValues(frame, slot, null, false, CollectionUtilities.createCollection((Object)object));
        return true;
    }

    public static Collection<Cls> getDirectTypes(Instance instance) {
        return ParserUtil.getSimpleFrameStore((Frame)instance).getDirectTypes(instance);
    }

    public static boolean hasOwnSlotValue(Frame frame, Slot slot, Object object) {
        List list = ParserUtil.getSimpleFrameStore(frame).getDirectOwnSlotValues(frame, slot);
        return list.contains(object);
    }

    public static boolean hasRDFType(Frame frame, Slot slot, Cls cls, TripleStore tripleStore) {
        NarrowFrameStore narrowFrameStore = tripleStore.getNarrowFrameStore();
        return narrowFrameStore.getValues(frame, slot, null, false).contains(cls);
    }

    public static OWLEnumeratedClass createOWLEnumeratedCls(OWLModel oWLModel, String string, TripleStore tripleStore) {
        DefaultOWLEnumeratedClass defaultOWLEnumeratedClass = new DefaultOWLEnumeratedClass(oWLModel, new FrameID(string));
        FrameCreatorUtility.assertFrameName(tripleStore, (Frame)defaultOWLEnumeratedClass);
        RDFSNamedClass rDFSNamedClass = oWLModel.getSystemFrames().getOwlEnumeratedClassClass();
        FrameCreatorUtility.addInstanceType(defaultOWLEnumeratedClass, rDFSNamedClass, tripleStore);
        FrameCreatorUtility.addOwnSlotValue((Frame)defaultOWLEnumeratedClass, oWLModel.getRDFTypeProperty(), oWLModel.getOWLNamedClassClass(), tripleStore);
        return defaultOWLEnumeratedClass;
    }
}

