/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.jena.parser;

import edu.stanford.smi.protege.model.Cls;
import edu.stanford.smi.protege.model.Frame;
import edu.stanford.smi.protege.model.FrameID;
import edu.stanford.smi.protege.model.KnowledgeBase;
import edu.stanford.smi.protege.model.Slot;
import edu.stanford.smi.protege.model.framestore.MergingNarrowFrameStore;
import edu.stanford.smi.protege.model.framestore.SimpleFrameStore;
import edu.stanford.smi.protege.util.Log;
import edu.stanford.smi.protegex.owl.jena.parser.GlobalParserCache;
import edu.stanford.smi.protegex.owl.jena.parser.ParserUtil;
import edu.stanford.smi.protegex.owl.jena.parser.RestrictionCreatorUtility;
import edu.stanford.smi.protegex.owl.jena.parser.TripleProcessor;
import edu.stanford.smi.protegex.owl.model.OWLModel;
import edu.stanford.smi.protegex.owl.model.impl.DefaultOWLNamedClass;
import edu.stanford.smi.protegex.owl.model.impl.DefaultRDFProperty;
import edu.stanford.smi.protegex.owl.model.triplestore.TripleStore;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public abstract class AbstractStatefulTripleProcessor {
    private static final transient Logger log = Log.getLogger(AbstractStatefulTripleProcessor.class);
    protected TripleProcessor processor;
    protected OWLModel owlModel;
    protected GlobalParserCache globalParserCache;
    protected SimpleFrameStore simpleFrameStore;
    protected MergingNarrowFrameStore mnfs;

    public AbstractStatefulTripleProcessor(TripleProcessor tripleProcessor) {
        this.processor = tripleProcessor;
        this.owlModel = tripleProcessor.getOWLModel();
        this.globalParserCache = tripleProcessor.getGlobalParserCache();
        this.simpleFrameStore = ParserUtil.getSimpleFrameStore(this.owlModel);
        this.mnfs = MergingNarrowFrameStore.get((KnowledgeBase)this.owlModel);
    }

    protected Frame createRestriction(String string, String string2, TripleStore tripleStore) {
        Frame frame = this.getFrame(string);
        if (frame != null) {
            return frame;
        }
        FrameID frameID = new FrameID(string);
        frame = RestrictionCreatorUtility.createRestriction(this.owlModel, frameID, string2, tripleStore);
        if (frame != null) {
            this.checkUndefinedResources(string);
        }
        if (this.isImporting(tripleStore)) {
            frame.setIncluded(true);
        }
        return frame;
    }

    protected void checkUndefinedResources(String string) {
        this.processor.checkUndefinedResources(string);
    }

    public void doPostProcessing() {
    }

    public boolean isImporting(TripleStore tripleStore) {
        return !tripleStore.equals(this.owlModel.getTripleStoreModel().getTopTripleStore());
    }

    protected Frame getFrame(String string) {
        return this.simpleFrameStore.getFrame(string);
    }

    protected Cls getCls(String string) {
        return this.getCls(this.getFrame(string));
    }

    protected Cls getCls(Frame object) {
        if (object == null) {
            return (Cls)object;
        }
        if (object instanceof Cls) {
            return (Cls)object;
        }
        if (log.isLoggable(Level.FINE)) {
            log.warning("    Frame with wrong Java type: " + object.getName() + ". Expected: RDFSClass (or subclass), got: " + object.getClass().getName());
        }
        try {
            DefaultOWLNamedClass defaultOWLNamedClass = new DefaultOWLNamedClass(object.getKnowledgeBase(), new FrameID(object.getName()));
            this.swizzleFrame((Frame)object, (Frame)defaultOWLNamedClass);
            object = defaultOWLNamedClass;
        }
        catch (Exception exception) {
            log.log(Level.WARNING, "Error at changing Java type of: " + object + " to DefaultOWLNamedClass", exception);
        }
        this.globalParserCache.getFramesWithWrongJavaType().add(object.getName());
        return (Cls)object;
    }

    protected Slot getSlot(String string) {
        return this.getSlot(this.getFrame(string));
    }

    protected Slot getSlot(Frame object) {
        if (object == null) {
            return (Slot)object;
        }
        if (object instanceof Slot) {
            return (Slot)object;
        }
        if (log.isLoggable(Level.FINE)) {
            log.fine("    Frame with wrong Java type: " + object.getName() + ". Expected: RDFProperty (or subclass), got: " + object.getClass().getName());
        }
        try {
            DefaultRDFProperty defaultRDFProperty = new DefaultRDFProperty(object.getKnowledgeBase(), new FrameID(object.getName()));
            this.swizzleFrame((Frame)object, (Frame)defaultRDFProperty);
            object = defaultRDFProperty;
        }
        catch (Exception exception) {
            log.log(Level.WARNING, "Error at changing Java type of: " + object + " to DefaultRDFProperty", exception);
        }
        this.globalParserCache.getFramesWithWrongJavaType().add(object.getName());
        return (Slot)object;
    }

    protected Collection getTypes(Frame frame) {
        List list = this.simpleFrameStore.getDirectOwnSlotValues(frame, this.owlModel.getSystemFrames().getDirectTypesSlot());
        if (list == null) {
            return Collections.emptyList();
        }
        return list;
    }

    private void swizzleFrame(Frame frame, Frame frame2) {
        frame2.setIncluded(frame.isIncluded());
        frame2.setEditable(frame.isEditable());
        this.mnfs.replaceFrame(frame2);
        this.simpleFrameStore.reinitialize();
    }
}

