/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.jena.importer;

import edu.stanford.smi.protege.exception.OntologyLoadException;
import edu.stanford.smi.protege.model.KnowledgeBase;
import edu.stanford.smi.protege.model.Project;
import edu.stanford.smi.protege.plugin.ImportPlugin;
import edu.stanford.smi.protege.ui.ProjectManager;
import edu.stanford.smi.protege.util.Log;
import edu.stanford.smi.protege.util.WaitCursor;
import edu.stanford.smi.protegex.owl.jena.JenaFilePanel;
import edu.stanford.smi.protegex.owl.jena.JenaOWLModel;
import edu.stanford.smi.protegex.owl.jena.creator.OwlProjectFromUriCreator;
import edu.stanford.smi.protegex.owl.jena.importer.OWLImporter;
import edu.stanford.smi.protegex.owl.ui.ProtegeUI;
import java.awt.Component;
import java.io.File;
import java.net.URI;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;

public class JenaImportPlugin
implements ImportPlugin {
    private static transient Logger log = Log.getLogger(JenaImportPlugin.class);

    public void dispose() {
    }

    public String getName() {
        return "OWL File";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Project handleImportRequest() {
        Project project = null;
        JenaFilePanel jenaFilePanel = new JenaFilePanel();
        int n = ProtegeUI.getModalDialogFactory().showDialog(null, jenaFilePanel, "OWL File to Import", 11);
        if (n == 1) {
            String string = jenaFilePanel.getOWLFilePath();
            WaitCursor waitCursor = new WaitCursor((Component)ProjectManager.getProjectManager().getMainPanel());
            try {
                project = this.importProject(new File(string).toURI());
            }
            finally {
                waitCursor.hide();
            }
        }
        return project;
    }

    private Project importProject(URI uRI) {
        ArrayList<OntologyLoadException> arrayList = new ArrayList<OntologyLoadException>();
        OwlProjectFromUriCreator owlProjectFromUriCreator = new OwlProjectFromUriCreator();
        owlProjectFromUriCreator.setOntologyUri(uRI.toString());
        try {
            owlProjectFromUriCreator.create(arrayList);
        }
        catch (OntologyLoadException ontologyLoadException) {
            arrayList.add(ontologyLoadException);
        }
        JenaOWLModel jenaOWLModel = owlProjectFromUriCreator.getOwlModel();
        if (arrayList.isEmpty()) {
            Project project = Project.createNewProject(null, new ArrayList());
            KnowledgeBase knowledgeBase = project.getKnowledgeBase();
            new OWLImporter(jenaOWLModel, knowledgeBase);
            return project;
        }
        for (Object e : arrayList) {
            if (e instanceof Throwable) {
                log.log(Level.WARNING, "Exception caught", (Throwable)e);
                continue;
            }
            log.warning("Error found " + e);
        }
        return null;
    }
}

