/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.jena.export;

import com.hp.hpl.jena.ontology.OntModel;
import edu.stanford.smi.protege.exception.OntologyLoadException;
import edu.stanford.smi.protege.model.KnowledgeBase;
import edu.stanford.smi.protege.model.KnowledgeBaseFactory;
import edu.stanford.smi.protege.model.Project;
import edu.stanford.smi.protege.plugin.ExportPlugin;
import edu.stanford.smi.protege.ui.ProjectManager;
import edu.stanford.smi.protege.util.Log;
import edu.stanford.smi.protege.util.MessageError;
import edu.stanford.smi.protege.util.WaitCursor;
import edu.stanford.smi.protegex.owl.database.OWLDatabaseModel;
import edu.stanford.smi.protegex.owl.jena.JenaFilePanel;
import edu.stanford.smi.protegex.owl.jena.JenaKnowledgeBaseFactory;
import edu.stanford.smi.protegex.owl.jena.JenaOWLModel;
import edu.stanford.smi.protegex.owl.jena.creator.NewOwlProjectCreator;
import edu.stanford.smi.protegex.owl.jena.writersettings.JenaWriterSettings;
import edu.stanford.smi.protegex.owl.jena.writersettings.WriterSettings;
import edu.stanford.smi.protegex.owl.model.OWLModel;
import edu.stanford.smi.protegex.owl.storage.ProtegeSaver;
import edu.stanford.smi.protegex.owl.ui.ProtegeUI;
import edu.stanford.smi.protegex.owl.writer.rdfxml.rdfwriter.OWLModelAllTripleStoresWriter;
import edu.stanford.smi.protegex.owl.writer.rdfxml.util.ProtegeWriterSettings;
import edu.stanford.smi.protegex.owl.writer.xml.XMLWriterPreferences;
import java.awt.Component;
import java.io.File;
import java.net.URI;
import java.util.ArrayList;
import java.util.logging.Level;

public class JenaExportPlugin
implements ExportPlugin {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleExportRequest(Project project) {
        int n;
        JenaFilePanel jenaFilePanel = new JenaFilePanel();
        if (project.isMultiUserClient()) {
            jenaFilePanel.getUseNativeWriterCheckBox().setSelected(true);
            jenaFilePanel.getUseNativeWriterCheckBox().setEnabled(false);
        }
        if ((n = ProtegeUI.getModalDialogFactory().showDialog(ProtegeUI.getTopLevelContainer(project), jenaFilePanel, "OWL File to Export", 11)) == 1) {
            String string = jenaFilePanel.getOWLFilePath();
            WaitCursor waitCursor = new WaitCursor((Component)ProjectManager.getProjectManager().getMainPanel());
            try {
                this.exportProject(project.getKnowledgeBase(), string, jenaFilePanel.getUseNativeWriter());
            }
            catch (Exception exception) {
                Log.getLogger().log(Level.SEVERE, "Exception caught", exception);
                ProtegeUI.getModalDialogFactory().showErrorMessageDialog(jenaFilePanel, "Export failed. Please see console for details.\n" + exception);
            }
            finally {
                waitCursor.hide();
            }
        }
    }

    private void exportProject(KnowledgeBase knowledgeBase, String string, boolean bl) {
        Object object;
        ArrayList<MessageError> arrayList = new ArrayList<MessageError>();
        JenaKnowledgeBaseFactory jenaKnowledgeBaseFactory = new JenaKnowledgeBaseFactory();
        JenaOWLModel jenaOWLModel = null;
        URI uRI = new File(string).toURI();
        if (knowledgeBase instanceof OWLModel) {
            object = Project.createNewProject((KnowledgeBaseFactory)jenaKnowledgeBaseFactory, arrayList);
            jenaOWLModel = (JenaOWLModel)object.getKnowledgeBase();
            object.setProjectURI(uRI);
            OWLModel oWLModel = (OWLModel)knowledgeBase;
            WriterSettings writerSettings = oWLModel.getWriterSettings();
            oWLModel.setWriterSettings(bl ? new ProtegeWriterSettings(jenaOWLModel) : new JenaWriterSettings(jenaOWLModel));
            if (oWLModel instanceof JenaOWLModel) {
                ((JenaOWLModel)oWLModel).save(uRI, "RDF/XML-ABBREV", arrayList);
            } else if (oWLModel instanceof OWLDatabaseModel) {
                if (bl) {
                    ProtegeWriterSettings protegeWriterSettings = null;
                    if (writerSettings instanceof ProtegeWriterSettings) {
                        protegeWriterSettings = (ProtegeWriterSettings)writerSettings;
                    } else {
                        protegeWriterSettings = new ProtegeWriterSettings(jenaOWLModel);
                        protegeWriterSettings.setSortAlphabetically(true);
                    }
                    try {
                        boolean bl2 = protegeWriterSettings.getUseXMLEntities();
                        XMLWriterPreferences.getInstance().setUseNamespaceEntities(bl2);
                        OWLModelAllTripleStoresWriter oWLModelAllTripleStoresWriter = new OWLModelAllTripleStoresWriter(oWLModel, uRI, protegeWriterSettings.isSortAlphabetically());
                        oWLModelAllTripleStoresWriter.write();
                    }
                    catch (Exception exception) {
                        String string2 = "Failed to save file " + uRI;
                        Log.getLogger().log(Level.SEVERE, string2, exception);
                        arrayList.add(new MessageError((Throwable)exception, string2));
                    }
                } else {
                    OntModel ontModel = ((OWLDatabaseModel)oWLModel).getOntModel();
                    OWLDatabaseModel oWLDatabaseModel = (OWLDatabaseModel)oWLModel;
                    String string3 = oWLDatabaseModel.getTripleStoreModel().getActiveTripleStore().getOriginalXMLBase();
                    String string4 = oWLDatabaseModel.getNamespaceManager().getDefaultNamespace();
                    if (string3 == null && string4 != null && string4.endsWith("#")) {
                        string3 = string4.substring(0, string4.length() - 1);
                    }
                    try {
                        File file = new File(uRI);
                        JenaOWLModel.save(file, ontModel, "RDF/XML", string4, string3);
                    }
                    catch (Throwable throwable) {
                        Log.getLogger().log(Level.SEVERE, "Errors at exporting the OWL Database to OWL file", throwable);
                    }
                }
            }
            oWLModel.setWriterSettings(writerSettings);
        } else {
            object = new NewOwlProjectCreator();
            try {
                ((NewOwlProjectCreator)object).create(arrayList);
            }
            catch (OntologyLoadException ontologyLoadException) {
                Log.getLogger().log(Level.SEVERE, "Could not create new Jena OWL project", ontologyLoadException);
            }
            jenaOWLModel = ((NewOwlProjectCreator)object).getOwlModel();
            if (jenaOWLModel != null) {
                new ProtegeSaver(knowledgeBase, jenaOWLModel, bl).run();
                jenaOWLModel.save(uRI, "RDF/XML-ABBREV", arrayList);
            }
        }
        if (arrayList.size() == 0) {
            ProtegeUI.getModalDialogFactory().showMessageDialog(jenaOWLModel, "Project has been exported to:\n" + string);
        } else {
            ProtegeUI.getModalDialogFactory().showErrorMessageDialog(jenaOWLModel, "Export failed.\nPlease see console and logs for more details.");
        }
        if (jenaOWLModel != null) {
            try {
                jenaOWLModel.getProject().dispose();
            }
            catch (Exception exception) {
                Log.getLogger().log(Level.WARNING, "Errors at disposing temporary exported OWL model", exception);
            }
        }
    }

    public String getName() {
        return "OWL";
    }

    public void dispose() {
    }
}

