/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.jena.creator;

import edu.stanford.smi.protege.exception.OntologyLoadException;
import edu.stanford.smi.protege.model.KnowledgeBaseFactory;
import edu.stanford.smi.protege.model.Project;
import edu.stanford.smi.protege.util.ApplicationProperties;
import edu.stanford.smi.protege.util.FileUtilities;
import edu.stanford.smi.protege.util.Log;
import edu.stanford.smi.protege.util.PropertyList;
import edu.stanford.smi.protegex.owl.jena.JenaKnowledgeBaseFactory;
import edu.stanford.smi.protegex.owl.jena.JenaOWLModel;
import edu.stanford.smi.protegex.owl.model.factory.AbstractOwlProjectCreator;
import edu.stanford.smi.protegex.owl.model.factory.FactoryUtils;
import edu.stanford.smi.protegex.owl.repository.Repository;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OwlProjectFromUriCreator
extends AbstractOwlProjectCreator {
    private static String MERGE_MODE_PROP = "protege.owl.parser.convert.file.merge.mode";
    private boolean isMergeImportMode = ApplicationProperties.getBooleanProperty((String)MERGE_MODE_PROP, (boolean)false);
    private String ontologyUri;
    private String lang = "RDF/XML-ABBREV";
    private Project project;
    private List<Repository> repositories = new ArrayList<Repository>();

    public OwlProjectFromUriCreator() {
        this(new JenaKnowledgeBaseFactory());
    }

    public OwlProjectFromUriCreator(JenaKnowledgeBaseFactory jenaKnowledgeBaseFactory) {
        super(jenaKnowledgeBaseFactory);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void create(Collection collection) throws OntologyLoadException {
        boolean bl = JenaKnowledgeBaseFactory.isMergingImportMode();
        try {
            JenaKnowledgeBaseFactory.setMergingImportMode(this.isMergeImportMode);
            this.project = Project.createBuildProject((KnowledgeBaseFactory)this.factory, (Collection)collection);
            this.initializeSources(this.project.getSources());
            URI uRI = this.getBuildProjectURI();
            if (uRI != null) {
                this.project.setProjectURI(uRI);
            }
            this.project.createDomainKnowledgeBase((KnowledgeBaseFactory)this.factory, collection, true);
            FactoryUtils.adjustBrowserTextBasedOnPreferences(this.getOwlModel());
        }
        finally {
            JenaKnowledgeBaseFactory.setMergingImportMode(bl);
        }
    }

    @Override
    public JenaOWLModel getOwlModel() {
        if (this.project != null) {
            return (JenaOWLModel)this.project.getKnowledgeBase();
        }
        return null;
    }

    @Override
    public Project getProject() {
        return this.project;
    }

    protected void initializeSources(PropertyList propertyList) {
        JenaKnowledgeBaseFactory.setOWLFileName(propertyList, this.ontologyUri);
        JenaKnowledgeBaseFactory.setOWLFileLanguage(propertyList, this.lang);
        for (Repository repository : this.repositories) {
            JenaKnowledgeBaseFactory.addRepository(repository);
        }
        this.addViewSettings(propertyList);
    }

    protected URI getBuildProjectURI() {
        int n;
        if (this.ontologyUri != null && this.ontologyUri.startsWith("file:") && (n = this.ontologyUri.lastIndexOf(46)) > 0) {
            String string = FileUtilities.replaceExtension((String)this.ontologyUri, (String)".pprj");
            try {
                return new URI(string);
            }
            catch (Exception exception) {
                Log.emptyCatchBlock((Throwable)exception);
            }
        }
        return null;
    }

    public void setOntologyUri(String string) {
        this.ontologyUri = string;
    }

    public void setLang(String string) {
        this.lang = string;
    }

    @Override
    public JenaKnowledgeBaseFactory getFactory() {
        return (JenaKnowledgeBaseFactory)super.getFactory();
    }

    public void addRepository(Repository repository) {
        this.repositories.add(repository);
    }

    public void clearRepositories() {
        this.repositories.clear();
    }

    @Override
    public Collection<Repository> getRepositories() {
        return Collections.unmodifiableCollection(this.repositories);
    }

    public boolean isMergeImportMode() {
        return this.isMergeImportMode;
    }

    public void setMergeImportMode(boolean bl) {
        this.isMergeImportMode = bl;
    }
}

