/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.jena.creator;

import edu.stanford.smi.protege.exception.OntologyLoadException;
import edu.stanford.smi.protege.model.KnowledgeBaseFactory;
import edu.stanford.smi.protege.model.Project;
import edu.stanford.smi.protegex.owl.jena.JenaKnowledgeBaseFactory;
import edu.stanford.smi.protegex.owl.jena.JenaOWLModel;
import edu.stanford.smi.protegex.owl.jena.parser.ProtegeOWLParser;
import edu.stanford.smi.protegex.owl.model.factory.AbstractOwlProjectCreator;
import edu.stanford.smi.protegex.owl.repository.Repository;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OwlProjectFromStreamCreator
extends AbstractOwlProjectCreator {
    private InputStream stream;
    private String xmlBase;
    private List<Repository> repositories = new ArrayList<Repository>();
    private Project project;
    private JenaOWLModel owlModel;

    public OwlProjectFromStreamCreator() {
        this(new JenaKnowledgeBaseFactory());
    }

    public OwlProjectFromStreamCreator(JenaKnowledgeBaseFactory jenaKnowledgeBaseFactory) {
        super(jenaKnowledgeBaseFactory);
    }

    @Override
    public void create(Collection collection) throws OntologyLoadException {
        this.project = Project.createNewProject((KnowledgeBaseFactory)this.factory, (Collection)collection);
        this.owlModel = (JenaOWLModel)this.project.getKnowledgeBase();
        this.insertRepositoriesIntoOwlModel(this.owlModel);
        ProtegeOWLParser protegeOWLParser = new ProtegeOWLParser(this.owlModel);
        try {
            protegeOWLParser.run(this.stream, this.xmlBase);
        }
        catch (OntologyLoadException ontologyLoadException) {
            collection.add(ontologyLoadException);
        }
    }

    @Override
    public JenaOWLModel getOwlModel() {
        return this.owlModel;
    }

    @Override
    public Project getProject() {
        return this.project;
    }

    public void setStream(InputStream inputStream) {
        this.stream = inputStream;
    }

    public void setXmlBase(String string) {
        this.xmlBase = string;
    }

    public void addRepository(Repository repository) {
        this.repositories.add(repository);
    }

    public void clearRepositories() {
        this.repositories.clear();
    }

    public List<Repository> getRepositories() {
        return Collections.unmodifiableList(this.repositories);
    }
}

