/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.jena.creator;

import edu.stanford.smi.protege.exception.OntologyLoadException;
import edu.stanford.smi.protege.model.KnowledgeBaseFactory;
import edu.stanford.smi.protege.model.Project;
import edu.stanford.smi.protegex.owl.jena.JenaKnowledgeBaseFactory;
import edu.stanford.smi.protegex.owl.jena.JenaOWLModel;
import edu.stanford.smi.protegex.owl.model.factory.AbstractOwlProjectCreator;
import edu.stanford.smi.protegex.owl.model.factory.AlreadyImportedException;
import edu.stanford.smi.protegex.owl.model.factory.FactoryUtils;
import java.util.Collection;

public class NewOwlProjectCreator
extends AbstractOwlProjectCreator {
    private String ontologyName;
    private Project project;
    private JenaOWLModel owlModel;

    public NewOwlProjectCreator() {
        this(new JenaKnowledgeBaseFactory());
    }

    public NewOwlProjectCreator(JenaKnowledgeBaseFactory jenaKnowledgeBaseFactory) {
        super(jenaKnowledgeBaseFactory);
    }

    public void create(Collection collection) throws OntologyLoadException {
        this.project = Project.createNewProject((KnowledgeBaseFactory)this.factory, (Collection)collection);
        this.owlModel = (JenaOWLModel)this.project.getKnowledgeBase();
        if (this.ontologyName == null) {
            this.ontologyName = FactoryUtils.generateOntologyURIBase();
        }
        try {
            FactoryUtils.addOntologyToTripleStore(this.owlModel, this.owlModel.getTripleStoreModel().getActiveTripleStore(), this.ontologyName);
        }
        catch (AlreadyImportedException alreadyImportedException) {
            throw new RuntimeException("This shouldn't happen", alreadyImportedException);
        }
        this.addViewSettings(this.project.getSources());
    }

    public JenaOWLModel getOwlModel() {
        return this.owlModel;
    }

    public Project getProject() {
        return this.project;
    }

    public void setOntologyName(String string) {
        this.ontologyName = string;
    }
}

