/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.jena;

import edu.stanford.smi.protege.exception.AmalgamatedLoadException;
import edu.stanford.smi.protege.exception.OntologyLoadException;
import edu.stanford.smi.protege.model.KnowledgeBaseFactory;
import edu.stanford.smi.protege.model.Project;
import edu.stanford.smi.protege.plugin.AbstractCreateProjectPlugin;
import edu.stanford.smi.protege.plugin.CreateProjectWizard;
import edu.stanford.smi.protege.util.Log;
import edu.stanford.smi.protege.util.Wizard;
import edu.stanford.smi.protege.util.WizardPage;
import edu.stanford.smi.protegex.owl.jena.JenaKnowledgeBaseFactory;
import edu.stanford.smi.protegex.owl.jena.OWLFilesPlugin;
import edu.stanford.smi.protegex.owl.jena.creator.NewOwlProjectCreator;
import edu.stanford.smi.protegex.owl.jena.creator.OwlProjectFromUriCreator;
import edu.stanford.smi.protegex.owl.ui.cls.SwitchClassDefinitionResourceDisplayPlugin;
import edu.stanford.smi.protegex.owl.ui.jena.OWLFilesWizardPage;
import edu.stanford.smi.protegex.owl.ui.metadatatab.OntologyURIWizardPage;
import edu.stanford.smi.protegex.owl.ui.profiles.ProfileSelectionWizardPage;
import java.util.ArrayList;
import java.util.logging.Logger;

public class OWLFilesCreateProjectPlugin
extends AbstractCreateProjectPlugin
implements OWLFilesPlugin {
    private static transient Logger log = Log.getLogger(OWLFilesCreateProjectPlugin.class);
    private Class defaultClassView;
    private String ontologyName;
    private String fileURI;
    private String lang;
    private String profileURI;

    public OWLFilesCreateProjectPlugin() {
        super("OWL Files");
        JenaKnowledgeBaseFactory.useStandalone = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Project buildNewProject(KnowledgeBaseFactory knowledgeBaseFactory) {
        ArrayList<OntologyLoadException> arrayList = new ArrayList<OntologyLoadException>();
        OwlProjectFromUriCreator owlProjectFromUriCreator = new OwlProjectFromUriCreator((JenaKnowledgeBaseFactory)knowledgeBaseFactory);
        owlProjectFromUriCreator.setOntologyUri(this.fileURI);
        owlProjectFromUriCreator.setLang(this.lang);
        owlProjectFromUriCreator.setDefaultClassView(this.defaultClassView);
        owlProjectFromUriCreator.setProfileURI(this.profileURI);
        try {
            owlProjectFromUriCreator.create(arrayList);
        }
        catch (OntologyLoadException ontologyLoadException) {
            arrayList.add(ontologyLoadException);
        }
        finally {
            this.handleErrors(arrayList);
        }
        return owlProjectFromUriCreator.getProject();
    }

    public boolean canCreateProject(KnowledgeBaseFactory knowledgeBaseFactory, boolean bl) {
        return knowledgeBaseFactory instanceof JenaKnowledgeBaseFactory;
    }

    public WizardPage createCreateProjectWizardPage(CreateProjectWizard createProjectWizard, boolean bl) {
        ProfileSelectionWizardPage.isBuild = bl;
        if (bl) {
            return new OWLFilesWizardPage((Wizard)createProjectWizard, this);
        }
        return new OntologyURIWizardPage((Wizard)createProjectWizard, this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Project createNewProject(KnowledgeBaseFactory knowledgeBaseFactory) {
        ArrayList<OntologyLoadException> arrayList = new ArrayList<OntologyLoadException>();
        NewOwlProjectCreator newOwlProjectCreator = new NewOwlProjectCreator((JenaKnowledgeBaseFactory)knowledgeBaseFactory);
        newOwlProjectCreator.setOntologyName(this.ontologyName);
        newOwlProjectCreator.setDefaultClassView(this.defaultClassView);
        newOwlProjectCreator.setProfileURI(this.profileURI);
        try {
            newOwlProjectCreator.create(arrayList);
        }
        catch (AmalgamatedLoadException amalgamatedLoadException) {
            arrayList.addAll(amalgamatedLoadException.getErrorList());
        }
        catch (OntologyLoadException ontologyLoadException) {
            arrayList.add(ontologyLoadException);
        }
        finally {
            this.handleErrors(arrayList);
        }
        return newOwlProjectCreator.getProject();
    }

    public void setFile(String string) {
        this.fileURI = string;
    }

    public void setLanguage(String string) {
        this.lang = string;
    }

    public void setDefaultClassView(Class clazz) {
        this.defaultClassView = clazz;
        SwitchClassDefinitionResourceDisplayPlugin.setDefaultClassesView(clazz.getName());
    }

    public void setOntologyName(String string) {
        this.ontologyName = string;
    }

    public void setProfile(String string) {
        this.profileURI = string;
    }

    public void addImport(String string, String string2) {
    }
}

