/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.jena;

import com.hp.hpl.jena.ontology.OntModel;
import com.hp.hpl.jena.ontology.OntModelSpec;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.rdf.model.RDFWriter;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.reasoner.Reasoner;
import com.hp.hpl.jena.reasoner.ReasonerRegistry;
import com.hp.hpl.jena.reasoner.dig.DIGReasoner;
import com.hp.hpl.jena.vocabulary.ReasonerVocabulary;
import edu.stanford.smi.protege.exception.OntologyLoadException;
import edu.stanford.smi.protege.model.Instance;
import edu.stanford.smi.protege.model.KnowledgeBaseFactory;
import edu.stanford.smi.protege.util.Log;
import edu.stanford.smi.protege.util.MessageError;
import edu.stanford.smi.protege.util.SystemUtilities;
import edu.stanford.smi.protegex.owl.jena.Jena;
import edu.stanford.smi.protegex.owl.jena.OntModelProvider;
import edu.stanford.smi.protegex.owl.jena.creator.JenaCreator;
import edu.stanford.smi.protegex.owl.jena.parser.ProtegeOWLParser;
import edu.stanford.smi.protegex.owl.jena.protege2jena.Protege2Jena;
import edu.stanford.smi.protegex.owl.jena.writersettings.JenaWriterSettings;
import edu.stanford.smi.protegex.owl.model.OWLOntology;
import edu.stanford.smi.protegex.owl.model.RDFList;
import edu.stanford.smi.protegex.owl.model.RDFNames;
import edu.stanford.smi.protegex.owl.model.RDFResource;
import edu.stanford.smi.protegex.owl.model.impl.AbstractOWLModel;
import edu.stanford.smi.protegex.owl.model.triplestore.TripleStoreModel;
import edu.stanford.smi.protegex.owl.resource.OWLText;
import edu.stanford.smi.protegex.owl.ui.widget.ModalProgressBarManager;
import edu.stanford.smi.protegex.owl.writer.rdfxml.rdfwriter.OWLModelAllTripleStoresWriter;
import edu.stanford.smi.protegex.owl.writer.rdfxml.util.ProtegeWriterSettings;
import edu.stanford.smi.protegex.owl.writer.xml.XMLWriterPreferences;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.io.Reader;
import java.io.Writer;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.Charset;
import java.util.Collection;
import java.util.Set;
import java.util.logging.Level;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JenaOWLModel
extends AbstractOWLModel
implements OntModelProvider {
    public static final String COPYRIGHT = "<!-- Created with Protege (with OWL Plugin " + OWLText.getVersion() + ", Build " + OWLText.getBuildNumber() + ")  http://protege.stanford.edu -->";
    public static boolean inUI = false;
    public static final String TEMPLATE_FILE_NAME = "plugins/owl/template.owl";
    public static final String DEFAULT_PREFIX = "default";
    public static final String WRITER_SETTINGS_PROPERTY = JenaOWLModel.class.getName() + ".writer";
    public static final String WRITER_PROTEGE = "protege";

    protected JenaOWLModel(KnowledgeBaseFactory knowledgeBaseFactory) {
        super(knowledgeBaseFactory);
        TripleStoreModel tripleStoreModel = this.getTripleStoreModel();
        tripleStoreModel.setTopTripleStore(tripleStoreModel.getActiveTripleStore());
    }

    private void closeRDFLists() {
        for (Instance instance : this.getCls(RDFNames.Cls.LIST).getInstances()) {
            RDFList rDFList;
            Instance instance2 = instance;
            if (!(instance2 instanceof RDFList) || !instance2.isEditable() || (rDFList = (RDFList)instance2).getRest() != null) continue;
            rDFList.setRest(this.getRDFNil());
        }
    }

    public RDFResource getRDFResource(Resource resource) {
        String string = resource.getURI();
        String string2 = this.getResourceNameForURI(string);
        if (string2 != null) {
            return (RDFResource)this.getFrame(string2);
        }
        return null;
    }

    @Override
    public OntModel getOntModel() {
        return Protege2Jena.createOntModel(this);
    }

    @Override
    public OntModel getOWLDLOntModel() {
        JenaCreator jenaCreator = new JenaCreator(this, true, null, inUI ? new ModalProgressBarManager("Preparing Ontology") : null);
        return jenaCreator.createOntModelWithoutOWLFullModel();
    }

    public String getOWLFilePath() {
        return this.getOWLProject().getSettingsMap().getString("owl_file_name");
    }

    @Override
    public int getOWLSpecies() {
        OntModel ontModel = Protege2Jena.createOntModel(this);
        return Jena.getOWLSpecies(ontModel);
    }

    @Override
    public OntModel getReasonerOntModel(String string) {
        Model model = ModelFactory.createDefaultModel();
        Resource resource = model.createResource("http://foo.de#foo");
        model.add(resource, ReasonerVocabulary.EXT_REASONER_URL, string);
        DIGReasoner dIGReasoner = (DIGReasoner)ReasonerRegistry.theRegistry().create("http://jena.hpl.hp.com/2003/DIGReasoner", resource);
        OntModelSpec ontModelSpec = new OntModelSpec(OntModelSpec.OWL_DL_MEM);
        ontModelSpec.setReasoner((Reasoner)dIGReasoner);
        return Jena.cloneOntModel(this.getOntModel(), ontModelSpec);
    }

    public void save(URI uRI) throws Exception {
        Protege2Jena.saveAll(this, uRI, "RDF/XML-ABBREV");
    }

    public void save(URI uRI, String string, Collection collection) {
        if (this.getWriterSettings() instanceof JenaWriterSettings) {
            try {
                Protege2Jena.saveAll(this, uRI, string);
            }
            catch (Exception exception) {
                String string2 = "Failed to save file " + uRI + " using Protege2Jena.";
                Log.getLogger().log(Level.SEVERE, string2, exception);
                collection.add(new MessageError((Throwable)exception, string2));
            }
        } else if (this.getWriterSettings() instanceof ProtegeWriterSettings) {
            ProtegeWriterSettings protegeWriterSettings = (ProtegeWriterSettings)this.getWriterSettings();
            try {
                boolean bl = protegeWriterSettings.getUseXMLEntities();
                XMLWriterPreferences.getInstance().setUseNamespaceEntities(bl);
                OWLModelAllTripleStoresWriter oWLModelAllTripleStoresWriter = new OWLModelAllTripleStoresWriter(this, uRI, protegeWriterSettings.isSortAlphabetically());
                oWLModelAllTripleStoresWriter.write();
            }
            catch (Exception exception) {
                String string3 = "Failed to save file " + uRI;
                Log.getLogger().log(Level.SEVERE, string3, exception);
                collection.add(new MessageError((Throwable)exception, string3));
            }
        }
    }

    @Deprecated
    public void save(OutputStream outputStream, String string, Collection collection) {
        this.closeRDFLists();
        this.save(outputStream, string, collection, this.getOntModel());
    }

    public void save(URI uRI, String string, Collection collection, OntModel ontModel) {
        try {
            File file = new File(uRI);
            String string2 = this.getNamespaceManager().getDefaultNamespace();
            JenaOWLModel.save(file, ontModel, string, string2);
        }
        catch (Throwable throwable) {
            String string3 = "Failed to save file " + uRI;
            Log.getLogger().log(Level.SEVERE, string3, throwable);
            collection.add(new MessageError((Throwable)new Exception(throwable), string3));
        }
    }

    @Deprecated
    public static void save(File file, OntModel ontModel, String string, String string2) throws IOException {
        JenaOWLModel.save(file, ontModel, string, string2, string2);
    }

    public static void save(File file, OntModel ontModel, String string, String string2, String string3) throws IOException {
        FileOutputStream fileOutputStream = new FileOutputStream(file);
        JenaOWLModel.save(fileOutputStream, ontModel, string, string2, string3);
    }

    @Deprecated
    public void save(OutputStream outputStream, String string, Collection collection, OntModel ontModel) {
        try {
            String string2 = this.getNamespaceManager().getDefaultNamespace();
            JenaOWLModel.save(outputStream, ontModel, string, string2, string2);
        }
        catch (Throwable throwable) {
            String string3 = "Failed to save file to output stream";
            Log.getLogger().log(Level.SEVERE, string3, throwable);
            collection.add(new MessageError((Throwable)new Exception(throwable), string3));
        }
    }

    private static void save(OutputStream outputStream, OntModel ontModel, String string, String string2, String string3) throws IOException {
        JenaOWLModel.saveModel(outputStream, ontModel.getBaseModel(), string, string2, string3);
    }

    @Deprecated
    public static void saveModel(OutputStream outputStream, Model model, String string, String string2) throws IOException {
        JenaOWLModel.saveModel(outputStream, model, string, string2, string2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void saveModel(OutputStream outputStream, Model model, String string, String string2, String string3) throws IOException {
        PrintStream printStream = new PrintStream(outputStream);
        RDFWriter rDFWriter = model.getWriter(string);
        Jena.prepareWriter(rDFWriter, string, string2, string3);
        boolean bl = Jena.isXMLLanguage(string);
        if (bl) {
            String string4 = SystemUtilities.getFileEncoding();
            Set<String> set = Charset.availableCharsets().keySet();
            if (!set.contains(string4)) {
                string4 = "UTF-8";
            }
            rDFWriter.write(model, (Writer)new OutputStreamWriter((OutputStream)printStream, string4), string2);
        } else {
            model.removeNsPrefix("");
            model.setNsPrefix(DEFAULT_PREFIX, string2);
            try {
                rDFWriter.write(model, (OutputStream)printStream, string2);
            }
            finally {
                model.removeNsPrefix(DEFAULT_PREFIX);
                model.setNsPrefix("", string2);
            }
        }
        if (bl) {
            printStream.println();
            printStream.println(COPYRIGHT);
        }
        outputStream.close();
    }

    public void setProjectFileName(String string) {
        try {
            URI uRI = new URI(string);
            this.getOWLProject().getSettingsMap().setString("owl_file_language", "RDF/XML-ABBREV");
            this.getOWLProject().getSettingsMap().setString("owl_file_name", uRI.toString());
        }
        catch (URISyntaxException uRISyntaxException) {
            Log.getLogger().log(Level.SEVERE, "Exception caught", uRISyntaxException);
        }
    }

    @Deprecated
    public void load(URI uRI, String string) throws OntologyLoadException {
        this.ensureDefaultOntologyDeleted();
        ProtegeOWLParser protegeOWLParser = new ProtegeOWLParser(this);
        protegeOWLParser.run(uRI);
    }

    @Deprecated
    public void load(InputStream inputStream, String string) throws OntologyLoadException {
        this.ensureDefaultOntologyDeleted();
        ProtegeOWLParser protegeOWLParser = new ProtegeOWLParser(this);
        protegeOWLParser.run(inputStream, null);
    }

    @Deprecated
    public void load(Reader reader, String string) throws OntologyLoadException {
        this.ensureDefaultOntologyDeleted();
        ProtegeOWLParser protegeOWLParser = new ProtegeOWLParser(this);
        protegeOWLParser.run(reader, null);
    }

    @Deprecated
    public void load(URI uRI, String string, Collection<MessageError> collection) {
        try {
            this.load(uRI, string);
        }
        catch (Throwable throwable) {
            Log.getLogger().log(Level.SEVERE, "Error at loading file " + uRI, throwable);
            Collection<MessageError> collection2 = this.getParserErrors();
            if (collection2 != null && collection2.size() > 0) {
                collection.addAll(collection2);
            }
            this.addParserError(new MessageError(throwable));
            String string2 = "Errors at loading OWL file from " + uRI + "\n";
            string2 = string2 + "\nPlease consider running the file through an RDF or OWL validation service such as:";
            string2 = string2 + "\n  - RDF Validator: http://www.w3.org/RDF/Validator";
            string2 = string2 + "\n  - OWL Validator: http://phoebus.cs.man.ac.uk:9999/OWL/Validator";
            if (this.getNamespaceManager().getPrefix("http://protege.stanford.edu/system#") != null || this.getNamespaceManager().getPrefix("http://protege.stanford.edu/kb#") != null) {
                string2 = string2 + "\nThis file seems to have been created with the frame-based Protege RDF Backend. " + "Please try to use the RDF Backend of Protege to open this file and then export it to OWL " + "using Export to Format...";
            }
            collection.add(new MessageError(string2));
        }
        Collection<MessageError> collection3 = this.getParserErrors();
        if (collection3 != null && collection3.size() > 0) {
            collection.addAll(collection3);
        }
    }

    private void ensureDefaultOntologyDeleted() {
        OWLOntology oWLOntology = this.getDefaultOWLOntology();
        if (oWLOntology != null) {
            oWLOntology.delete();
        }
        this.getTripleStoreModel().getActiveTripleStore().setName(null);
        this.resetOntologyCache();
    }
}

