/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.jena;

import com.hp.hpl.jena.datatypes.xsd.XSDDatatype;
import com.hp.hpl.jena.graph.Graph;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.ontology.AllValuesFromRestriction;
import com.hp.hpl.jena.ontology.AnnotationProperty;
import com.hp.hpl.jena.ontology.CardinalityRestriction;
import com.hp.hpl.jena.ontology.ComplementClass;
import com.hp.hpl.jena.ontology.DatatypeProperty;
import com.hp.hpl.jena.ontology.EnumeratedClass;
import com.hp.hpl.jena.ontology.FunctionalProperty;
import com.hp.hpl.jena.ontology.HasValueRestriction;
import com.hp.hpl.jena.ontology.Individual;
import com.hp.hpl.jena.ontology.IntersectionClass;
import com.hp.hpl.jena.ontology.MaxCardinalityRestriction;
import com.hp.hpl.jena.ontology.MinCardinalityRestriction;
import com.hp.hpl.jena.ontology.ObjectProperty;
import com.hp.hpl.jena.ontology.OntClass;
import com.hp.hpl.jena.ontology.OntModel;
import com.hp.hpl.jena.ontology.OntProperty;
import com.hp.hpl.jena.ontology.OntResource;
import com.hp.hpl.jena.ontology.Ontology;
import com.hp.hpl.jena.ontology.Restriction;
import com.hp.hpl.jena.ontology.SomeValuesFromRestriction;
import com.hp.hpl.jena.ontology.SymmetricProperty;
import com.hp.hpl.jena.ontology.TransitiveProperty;
import com.hp.hpl.jena.ontology.UnionClass;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.NodeIterator;
import com.hp.hpl.jena.rdf.model.Property;
import com.hp.hpl.jena.rdf.model.RDFList;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.rdf.model.Statement;
import com.hp.hpl.jena.rdf.model.StmtIterator;
import com.hp.hpl.jena.util.ResourceUtils;
import com.hp.hpl.jena.util.iterator.ExtendedIterator;
import com.hp.hpl.jena.util.iterator.Filter;
import com.hp.hpl.jena.vocabulary.OWL;
import com.hp.hpl.jena.vocabulary.RDF;
import com.hp.hpl.jena.vocabulary.RDFS;
import edu.stanford.smi.protege.util.Log;
import edu.stanford.smi.protege.util.MessageError;
import edu.stanford.smi.protegex.owl.jena.Jena;
import edu.stanford.smi.protegex.owl.model.NamespaceManager;
import edu.stanford.smi.protegex.owl.model.ProtegeNames;
import edu.stanford.smi.protegex.owl.model.impl.AbstractOWLModel;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

public class JenaNormalizer {
    private static final transient Logger log = Log.getLogger(JenaNormalizer.class);
    private OntModel ontModel;
    private Model owlFullModel;

    public JenaNormalizer(OntModel ontModel, Model model, NamespaceManager namespaceManager) {
        this.owlFullModel = model;
        this.ontModel = ontModel;
        Jena.ensureOWLFullModelIsLastModel(ontModel, model);
        String string = namespaceManager.getDefaultNamespace();
        JenaNormalizer.standardizePrefixes(ontModel);
        this.alignPrefixes(ontModel, namespaceManager);
        this.createPrefixesForImports(ontModel, namespaceManager);
        this.mergeOntologies();
        this.ensureAnnotationPropertiesHaveRange();
        if (model != null) {
            this.ensureDeprecatedClassesAreOntClasses(model);
            this.ensureDeprecatedPropertiesAreOntProperties(model);
            this.ensureFunctionalPropertiesAreOntProperties(model);
            this.ensureSymmetricPropertiesAreOntProperties(model);
            this.ensureTransitivePropertiesAreOntProperties(model);
        }
        this.convertCyclicPropertyInheritance();
        this.assignNamesToAnonymousTopLevelClasses(ontModel, string);
        this.convertNamedClassExpressions();
        if (model != null) {
            JenaNormalizer.assignRDFTypesToMetaclassInstances(ontModel, model);
            this.ensureSuperclassesAreRDFSClasses(model);
            this.ensureSuperPropertiesAreRDFProperties(model);
        }
        this.removeRedundantDomains((Iterator)ontModel.listDatatypeProperties());
        this.removeRedundantDomains((Iterator)ontModel.listObjectProperties());
        this.convertMultipleDomainsIntoIntersection(ontModel);
        this.convertMultipleRangesIntoIntersection(ontModel);
    }

    private void createPrefixesForImports(OntModel ontModel, NamespaceManager namespaceManager) {
        String string = ontModel.getNsPrefixURI("");
        ExtendedIterator extendedIterator = ontModel.listOntologies();
        while (extendedIterator.hasNext()) {
            Ontology ontology = (Ontology)extendedIterator.next();
            ExtendedIterator extendedIterator2 = ontology.listImports();
            while (extendedIterator2.hasNext()) {
                String string2;
                Resource resource = (Resource)extendedIterator2.next();
                String string3 = resource.getURI();
                if (!string3.endsWith("/") && !string3.endsWith("#")) {
                    string3 = string3 + "#";
                }
                if (string.equals(string3) || ontModel.getOntology(resource.getURI()) == null || (string2 = ontModel.getNsURIPrefix(string3)) != null && string2.length() != 0) continue;
                String string4 = this.createImportURI(ontModel);
                ontology.getModel().setNsPrefix(string4, string3);
                namespaceManager.setPrefix(string3, string4);
            }
        }
    }

    private String createImportURI(OntModel ontModel) {
        String string = null;
        String string2 = "import";
        int n = 1;
        while (ontModel.getNsPrefixURI(string = string2 + n++) != null) {
        }
        return string;
    }

    private void alignPrefixes(OntModel ontModel, NamespaceManager namespaceManager) {
        List list = ontModel.getSubGraphs();
        for (Graph graph : list) {
            Map map = graph.getPrefixMapping().getNsPrefixMap();
            for (String string : map.keySet()) {
                String string2;
                String string3;
                if (string.length() <= 0 || string.equals(string3 = ontModel.getNsURIPrefix(string2 = (String)map.get(string)))) continue;
                if (log.isLoggable(Level.FINE)) {
                    log.fine("Prefix mismatch " + string + " aligned to " + string3 + " for namespace " + string2);
                }
                graph.getPrefixMapping().removeNsPrefix(string);
                graph.getPrefixMapping().setNsPrefix(string3, string2);
                namespaceManager.setPrefix(string2, string3);
                namespaceManager.removePrefix(string);
            }
        }
    }

    private void ensureDeprecatedClassesAreOntClasses(Model model) {
        for (Resource resource : Jena.set((Iterator)this.ontModel.listSubjectsWithProperty(RDF.type, (RDFNode)OWL.DeprecatedClass))) {
            if (resource.canAs(OntClass.class)) continue;
            this.ontModel.add(resource, RDF.type, (RDFNode)RDFS.Class);
            if (!log.isLoggable(Level.FINE)) continue;
            log.fine("+ Made deprecated class " + resource + " an RDFS class");
        }
    }

    private void ensureDeprecatedPropertiesAreOntProperties(Model model) {
        for (Resource resource : Jena.set((Iterator)this.ontModel.listSubjectsWithProperty(RDF.type, (RDFNode)OWL.DeprecatedProperty))) {
            if (resource.canAs(OntProperty.class)) continue;
            this.ontModel.add(resource, RDF.type, (RDFNode)RDF.Property);
            if (!log.isLoggable(Level.FINE)) continue;
            log.fine("+ Made deprecated property " + resource + " an RDF property");
        }
    }

    private void ensureFunctionalPropertiesAreOntProperties(Model model) {
        for (FunctionalProperty functionalProperty : Jena.set((Iterator)this.ontModel.listFunctionalProperties())) {
            if (this.hasValidPropertyType((Property)functionalProperty)) continue;
            this.ontModel.add((Resource)functionalProperty, RDF.type, (RDFNode)RDF.Property);
            if (!log.isLoggable(Level.FINE)) continue;
            log.fine("+ Made functional property " + functionalProperty + " an RDF property");
        }
    }

    private boolean hasValidPropertyType(Property property) {
        StmtIterator stmtIterator = property.listProperties(RDF.type);
        while (stmtIterator.hasNext()) {
            Statement statement = stmtIterator.nextStatement();
            Resource resource = (Resource)statement.getObject();
            if (!resource.equals(OWL.ObjectProperty) && !resource.equals(OWL.DatatypeProperty) && !resource.equals(RDF.Property) && resource.getURI().startsWith("http://www.w3.org/2002/07/owl#")) continue;
            return true;
        }
        return false;
    }

    private void ensureSuperclassesAreRDFSClasses(Model model) {
        NodeIterator nodeIterator = this.ontModel.listObjectsOfProperty(RDFS.subClassOf);
        while (nodeIterator.hasNext()) {
            RDFNode rDFNode = (RDFNode)nodeIterator.next();
            if (Jena.canAsOntClass(rDFNode) || !rDFNode.canAs(Resource.class)) continue;
            model.add((Resource)rDFNode.as(Resource.class), RDF.type, (RDFNode)RDFS.Class);
            if (!log.isLoggable(Level.FINE)) continue;
            log.fine("+ Made non-imported superclass " + rDFNode + " an " + RDFS.Class);
        }
    }

    private void ensureSuperPropertiesAreRDFProperties(Model model) {
        NodeIterator nodeIterator = this.ontModel.listObjectsOfProperty(RDFS.subPropertyOf);
        while (nodeIterator.hasNext()) {
            RDFNode rDFNode = (RDFNode)nodeIterator.next();
            if (rDFNode.canAs(OntProperty.class) || !rDFNode.canAs(Resource.class)) continue;
            model.add((Resource)rDFNode.as(Resource.class), RDF.type, (RDFNode)RDF.Property);
            if (!log.isLoggable(Level.FINE)) continue;
            log.fine("+ Made non-imported superclass " + rDFNode + " an " + RDF.Property);
        }
    }

    private void ensureSymmetricPropertiesAreOntProperties(Model model) {
        for (SymmetricProperty symmetricProperty : Jena.set((Iterator)this.ontModel.listSymmetricProperties())) {
            if (this.hasValidPropertyType((Property)symmetricProperty)) continue;
            this.ontModel.add((Resource)symmetricProperty, RDF.type, (RDFNode)OWL.ObjectProperty);
            if (!log.isLoggable(Level.FINE)) continue;
            log.fine("+ Made symmetric property " + symmetricProperty + " an object property");
        }
    }

    private void ensureTransitivePropertiesAreOntProperties(Model model) {
        for (TransitiveProperty transitiveProperty : Jena.set((Iterator)this.ontModel.listTransitiveProperties())) {
            if (this.hasValidPropertyType((Property)transitiveProperty)) continue;
            this.ontModel.add((Resource)transitiveProperty, RDF.type, (RDFNode)OWL.ObjectProperty);
            if (!log.isLoggable(Level.FINE)) continue;
            log.fine("+ Made transitive property " + transitiveProperty + " an object property");
        }
    }

    private void assignNamesToAnonymousTopLevelClasses(OntModel ontModel, String string) {
        boolean bl = true;
        for (OntClass ontClass : Jena.set(JenaNormalizer.listAnonTopLevelClasses(ontModel))) {
            String string2 = AbstractOWLModel.getNextAnonymousResourceNameStatic();
            ResourceUtils.renameResource((Resource)ontClass, (String)string2);
            if (!log.isLoggable(Level.FINE)) continue;
            log.fine("* Assigned name " + string2 + " to anonymous top-level class " + ontClass);
        }
    }

    public static void assignRDFTypesToMetaclassInstances(OntModel ontModel, Model model) {
        int n = 0;
        boolean bl = false;
        do {
            Set set = Jena.set((Iterator)ontModel.listIndividuals());
            bl = false;
            for (Individual individual : set) {
                if (++n % 100 == 0 && log.isLoggable(Level.FINE)) {
                    log.fine("- Assigning RDF types to individual " + n + " of " + set.size());
                }
                if (Jena.canAsOntClass((RDFNode)individual)) {
                    bl = JenaNormalizer.ensureRDFType((OntResource)individual, OWL.Class, model) || bl;
                    continue;
                }
                if (Jena.canAsObjectProperty((RDFNode)individual)) {
                    bl = JenaNormalizer.ensureRDFType((OntResource)individual, OWL.ObjectProperty, model) || bl;
                    continue;
                }
                if (!Jena.canAsDatatypeProperty((RDFNode)individual)) continue;
                bl = JenaNormalizer.ensureRDFType((OntResource)individual, OWL.DatatypeProperty, model) || bl;
            }
        } while (bl);
    }

    private void convertCyclicPropertyInheritance() {
        ArrayList arrayList = new ArrayList();
        this.convertCyclicPropertyInheritance(this.ontModel.listDatatypeProperties(), arrayList);
        this.convertCyclicPropertyInheritance(this.ontModel.listObjectProperties(), arrayList);
        if (arrayList.size() > 0) {
            for (Object e : arrayList) {
                System.err.println("[JenaNormalizer] " + e);
            }
        }
    }

    private void convertCyclicPropertyInheritance(ExtendedIterator extendedIterator, List list) {
        while (extendedIterator.hasNext()) {
            OntProperty ontProperty = (OntProperty)extendedIterator.next();
            try {
                this.convertCyclicPropertyInheritance(ontProperty, ontProperty, new HashSet(), list);
            }
            catch (Throwable throwable) {
                log.warning("Can't convertCyclicPropertyInheritance for " + ontProperty.getLocalName());
            }
        }
    }

    private void convertCyclicPropertyInheritance(OntProperty ontProperty, OntProperty ontProperty2, Set set, Collection collection) {
        set.add(ontProperty2);
        ExtendedIterator extendedIterator = ontProperty2.listSuperProperties(true);
        while (extendedIterator.hasNext()) {
            Object object;
            OntProperty ontProperty3 = (OntProperty)extendedIterator.next();
            if (set.contains(ontProperty3)) {
                object = "Error: Property " + ontProperty2 + " has a cyclic superproperty relation with " + ontProperty3 + " - please use owl:equivalentProperty instead!";
                Log.getLogger().warning((String)object);
                collection.add(new MessageError((String)object));
                continue;
            }
            object = new HashSet(set);
            this.convertCyclicPropertyInheritance(ontProperty, ontProperty3, (Set)object, collection);
        }
    }

    private void convertMultipleDomainsIntoIntersection(OntModel ontModel) {
        this.convertMultipleDomainsIntoIntersection((Iterator)ontModel.listDatatypeProperties());
        this.convertMultipleDomainsIntoIntersection((Iterator)ontModel.listObjectProperties());
    }

    private void convertMultipleDomainsIntoIntersection(Iterator iterator) {
        while (iterator.hasNext()) {
            OntProperty ontProperty = (OntProperty)iterator.next();
            Set set = Jena.set((Iterator)ontProperty.listDomain());
            if (set.size() <= 1) continue;
            if (log.isLoggable(Level.FINE)) {
                log.fine("* Converted multiple domains for " + ontProperty.getLocalName() + " into an intersection class");
            }
            RDFList rDFList = this.ontModel.createList(set.iterator());
            IntersectionClass intersectionClass = this.ontModel.createIntersectionClass(null, rDFList);
            ontProperty.setDomain((Resource)intersectionClass);
        }
    }

    private void convertMultipleRangesIntoIntersection(OntModel ontModel) {
        this.convertMultipleRangesIntoIntersection((Iterator)ontModel.listObjectProperties());
    }

    private void convertMultipleRangesIntoIntersection(Iterator iterator) {
        while (iterator.hasNext()) {
            OntProperty ontProperty = (OntProperty)iterator.next();
            Set set = Jena.set((Iterator)ontProperty.listRange());
            if (set.size() <= 1) continue;
            RDFList rDFList = this.ontModel.createList(set.iterator());
            IntersectionClass intersectionClass = this.ontModel.createIntersectionClass(null, rDFList);
            ontProperty.setRange((Resource)intersectionClass);
            if (!log.isLoggable(Level.FINE)) continue;
            log.fine("* Converted multiple ranges for " + ontProperty.getLocalName() + " into an intersection class");
        }
    }

    private void convertNamedClassExpressions() {
        Set set = Jena.set((Iterator)this.ontModel.listNamedClasses());
        for (OntClass ontClass : set) {
            if (Jena.isSystemResource((Resource)ontClass)) continue;
            ComplementClass complementClass = null;
            if (ontClass.isComplementClass()) {
                complementClass = this.createComplementClass(ontClass.asComplementClass());
            } else if (ontClass.isEnumeratedClass()) {
                complementClass = this.createEnumeratedClass(ontClass);
            } else if (ontClass.isIntersectionClass()) {
                complementClass = this.createIntersectionClass(ontClass.asIntersectionClass());
            } else if (ontClass.isUnionClass()) {
                complementClass = this.createUnionClass(ontClass.asUnionClass());
            } else if (ontClass.isRestriction()) {
                complementClass = this.createRestriction(ontClass.asRestriction());
            }
            if (complementClass == null) continue;
            if (Jena.isImportedResource(this.ontModel, this.owlFullModel, (OntResource)ontClass)) {
                Graph graph = Jena.getHomeGraph(this.ontModel, (OntResource)ontClass);
                graph.add(new Triple(ontClass.asNode(), OWL.equivalentClass.asNode(), complementClass.asNode()));
                for (Statement statement : Jena.set((Iterator)complementClass.listProperties())) {
                    this.ontModel.remove(statement);
                    Node node = statement.getSubject().asNode();
                    Node node2 = statement.getPredicate().asNode();
                    Node node3 = statement.getObject() == null ? null : statement.getObject().asNode();
                    Triple triple = new Triple(node, node2, node3);
                    graph.add(triple);
                    if (!log.isLoggable(Level.FINE)) continue;
                    log.fine("  * Moved triple into imported graph: " + triple);
                }
                continue;
            }
            ontClass.addEquivalentClass((Resource)complementClass);
        }
    }

    private AllValuesFromRestriction createAllValuesFromRestriction(AllValuesFromRestriction allValuesFromRestriction) {
        if (log.isLoggable(Level.FINE)) {
            log.fine("+ Adding anonymous AllValuesFromRestriction for " + allValuesFromRestriction);
        }
        AllValuesFromRestriction allValuesFromRestriction2 = this.ontModel.createAllValuesFromRestriction(null, (Property)allValuesFromRestriction.getOnProperty(), allValuesFromRestriction.getAllValuesFrom());
        allValuesFromRestriction.removeAll(this.ontModel.getProfile().ALL_VALUES_FROM());
        allValuesFromRestriction.removeAll(this.ontModel.getProfile().ON_PROPERTY());
        return allValuesFromRestriction2;
    }

    private CardinalityRestriction createCardinalityRestriction(CardinalityRestriction cardinalityRestriction) {
        if (log.isLoggable(Level.FINE)) {
            log.fine("+ Adding anonymous OWLCardinalityBase for " + cardinalityRestriction);
        }
        CardinalityRestriction cardinalityRestriction2 = this.ontModel.createCardinalityRestriction(null, (Property)cardinalityRestriction.getOnProperty(), cardinalityRestriction.getCardinality());
        cardinalityRestriction.removeAll(this.ontModel.getProfile().CARDINALITY());
        cardinalityRestriction.removeAll(this.ontModel.getProfile().ON_PROPERTY());
        return cardinalityRestriction2;
    }

    private ComplementClass createComplementClass(ComplementClass complementClass) {
        if (log.isLoggable(Level.FINE)) {
            log.fine("+ Adding anonymous ComplementClass for " + complementClass);
        }
        OntClass ontClass = complementClass.getOperand();
        complementClass.removeAll(this.ontModel.getProfile().COMPLEMENT_OF());
        return this.ontModel.createComplementClass(null, (Resource)ontClass);
    }

    private EnumeratedClass createEnumeratedClass(OntClass ontClass) {
        if (log.isLoggable(Level.FINE)) {
            log.fine("+ Adding anonymous EnumeratedClass for " + ontClass);
        }
        Property property = this.ontModel.getProperty(OWL.oneOf.getURI());
        Statement statement = ontClass.getProperty(property);
        RDFList rDFList = (RDFList)statement.getObject().as(RDFList.class);
        this.ontModel.remove(statement);
        return this.ontModel.createEnumeratedClass(null, rDFList);
    }

    private HasValueRestriction createHasValueRestriction(HasValueRestriction hasValueRestriction) {
        if (log.isLoggable(Level.FINE)) {
            log.fine("+ Adding anonymous HasValueRestriction for " + hasValueRestriction);
        }
        HasValueRestriction hasValueRestriction2 = this.ontModel.createHasValueRestriction(null, (Property)hasValueRestriction.getOnProperty(), hasValueRestriction.getHasValue());
        hasValueRestriction.removeAll(this.ontModel.getProfile().HAS_VALUE());
        hasValueRestriction.removeAll(this.ontModel.getProfile().ON_PROPERTY());
        return hasValueRestriction2;
    }

    private IntersectionClass createIntersectionClass(IntersectionClass intersectionClass) {
        if (log.isLoggable(Level.FINE)) {
            log.fine("+ Adding anonymous IntersectionClass for " + intersectionClass);
        }
        RDFList rDFList = intersectionClass.getOperands();
        IntersectionClass intersectionClass2 = this.ontModel.createIntersectionClass(null, rDFList);
        intersectionClass.removeAll(this.ontModel.getProfile().INTERSECTION_OF());
        return intersectionClass2;
    }

    private MaxCardinalityRestriction createMaxCardinalityRestriction(MaxCardinalityRestriction maxCardinalityRestriction) {
        if (log.isLoggable(Level.FINE)) {
            log.fine("+ Adding anonymous MaxCardinalityRestriction for " + maxCardinalityRestriction);
        }
        MaxCardinalityRestriction maxCardinalityRestriction2 = this.ontModel.createMaxCardinalityRestriction(null, (Property)maxCardinalityRestriction.getOnProperty(), maxCardinalityRestriction.getMaxCardinality());
        maxCardinalityRestriction.removeAll(this.ontModel.getProfile().CARDINALITY());
        maxCardinalityRestriction.removeAll(this.ontModel.getProfile().ON_PROPERTY());
        return maxCardinalityRestriction2;
    }

    private MinCardinalityRestriction createMinCardinalityRestriction(MinCardinalityRestriction minCardinalityRestriction) {
        if (log.isLoggable(Level.FINE)) {
            log.fine("+ Adding anonymous MinCardinalityRestriction for " + minCardinalityRestriction);
        }
        MinCardinalityRestriction minCardinalityRestriction2 = this.ontModel.createMinCardinalityRestriction(null, (Property)minCardinalityRestriction.getOnProperty(), minCardinalityRestriction.getMinCardinality());
        minCardinalityRestriction.removeAll(this.ontModel.getProfile().CARDINALITY());
        minCardinalityRestriction.removeAll(this.ontModel.getProfile().ON_PROPERTY());
        return minCardinalityRestriction2;
    }

    private Restriction createRestriction(Restriction restriction) {
        if (restriction.isAllValuesFromRestriction()) {
            return this.createAllValuesFromRestriction(restriction.asAllValuesFromRestriction());
        }
        if (restriction.isSomeValuesFromRestriction()) {
            return this.createSomeValuesFromRestriction(restriction.asSomeValuesFromRestriction());
        }
        if (restriction.isHasValueRestriction()) {
            return this.createHasValueRestriction(restriction.asHasValueRestriction());
        }
        if (restriction.isMaxCardinalityRestriction()) {
            return this.createMaxCardinalityRestriction(restriction.asMaxCardinalityRestriction());
        }
        if (restriction.isMinCardinalityRestriction()) {
            return this.createMinCardinalityRestriction(restriction.asMinCardinalityRestriction());
        }
        if (restriction.isCardinalityRestriction()) {
            return this.createCardinalityRestriction(restriction.asCardinalityRestriction());
        }
        return null;
    }

    private SomeValuesFromRestriction createSomeValuesFromRestriction(SomeValuesFromRestriction someValuesFromRestriction) {
        if (log.isLoggable(Level.FINE)) {
            log.fine("+ Adding anonymous SomeValuesFromRestriction for " + someValuesFromRestriction);
        }
        SomeValuesFromRestriction someValuesFromRestriction2 = this.ontModel.createSomeValuesFromRestriction(null, (Property)someValuesFromRestriction.getOnProperty(), someValuesFromRestriction.getSomeValuesFrom());
        someValuesFromRestriction.removeAll(this.ontModel.getProfile().SOME_VALUES_FROM());
        someValuesFromRestriction.removeAll(this.ontModel.getProfile().ON_PROPERTY());
        return someValuesFromRestriction2;
    }

    private UnionClass createUnionClass(UnionClass unionClass) {
        if (log.isLoggable(Level.FINE)) {
            log.fine("+ Adding anonymous UnionClass for " + unionClass);
        }
        RDFList rDFList = unionClass.getOperands();
        unionClass.removeAll(this.ontModel.getProfile().UNION_OF());
        return this.ontModel.createUnionClass(null, rDFList);
    }

    private void ensureAnnotationPropertiesHaveRange() {
        for (AnnotationProperty annotationProperty : Jena.set((Iterator)this.ontModel.listAnnotationProperties())) {
            String string;
            if (annotationProperty.canAs(DatatypeProperty.class) || annotationProperty.canAs(ObjectProperty.class) || (string = annotationProperty.getNameSpace()).equals("http://www.w3.org/2002/07/owl#") || string.equals(RDFS.getURI())) continue;
            Graph graph = this.ontModel.getGraph();
            if (Jena.isImportedResource(this.ontModel, this.owlFullModel, (OntResource)annotationProperty)) {
                graph = this.getHomeGraph((OntResource)annotationProperty);
            }
            graph.add(new Triple(annotationProperty.asNode(), RDF.type.asNode(), OWL.DatatypeProperty.asNode()));
            XSDDatatype xSDDatatype = XSDDatatype.XSDstring;
            if (annotationProperty.getURI().equals(ProtegeNames.PROTEGE_OWL_NAMESPACE + "readOnly")) {
                xSDDatatype = XSDDatatype.XSDboolean;
            }
            graph.add(new Triple(annotationProperty.asNode(), RDFS.range.asNode(), this.ontModel.getResource(xSDDatatype.getURI()).asNode()));
            if (!log.isLoggable(Level.FINE)) continue;
            log.fine("Made annotationProperty " + annotationProperty.getURI() + " a datatype property with range " + xSDDatatype);
        }
    }

    private static boolean ensureRDFType(OntResource ontResource, Resource resource, Model model) {
        if (!ontResource.hasRDFType(resource)) {
            model.add((Resource)ontResource, RDF.type, (RDFNode)resource);
            if (log.isLoggable(Level.FINE)) {
                log.fine("+ Added " + resource + " to rdf:types of " + ontResource + " in OWL Full model");
            }
            return true;
        }
        return false;
    }

    private Graph getHomeGraph(OntResource ontResource) {
        Property property = RDF.type;
        Resource resource = ontResource.getRDFType();
        for (Graph graph : this.ontModel.getSubGraphs()) {
            if (!graph.contains(ontResource.asNode(), property.asNode(), resource.asNode())) continue;
            return graph;
        }
        return null;
    }

    public static Iterator listAnonTopLevelClasses(OntModel ontModel) {
        final Set set = Jena.set((Iterator)ontModel.listObjects());
        return ontModel.listClasses().filterDrop(new Filter(){

            public boolean accept(Object object) {
                OntClass ontClass = (OntClass)object;
                return !ontClass.isAnon() || set.contains(ontClass);
            }
        });
    }

    private void mergeOntologies() {
        ExtendedIterator extendedIterator = this.ontModel.listOntologies();
        while (extendedIterator.hasNext()) {
            Ontology ontology = (Ontology)extendedIterator.next();
            if (ontology.getURI() != null) continue;
            System.err.println("Warning: Ontology without URI detected: The correct syntax is <owl:Ontology rdf:about=\"\"> and there should be a default namespace");
        }
    }

    private void removeRedundantDomains(Iterator iterator) {
        while (iterator.hasNext()) {
            OntProperty ontProperty = (OntProperty)iterator.next();
            Set set = Jena.set((Iterator)ontProperty.listDomain());
            if (!set.contains(OWL.Thing)) continue;
            ontProperty.removeAll(RDFS.domain);
            if (!log.isLoggable(Level.FINE)) continue;
            log.fine("- Removed redundant domain from property " + ontProperty);
        }
    }

    private static Resource setResourceNamespace(Resource resource, String string) {
        String string2 = string + "#";
        if (!Jena.isSystemResource(resource) && !string2.equals(resource.getNameSpace())) {
            String string3 = resource.getLocalName();
            if (!AbstractOWLModel.isValidOWLFrameName(null, string3)) {
                string3 = "_" + string3;
            }
            String string4 = (Jena.isNamespaceWithSeparator(string) ? string : string2) + string3;
            if (log.isLoggable(Level.FINE)) {
                log.fine("* Namespacing " + resource.getURI() + " to " + string4);
            }
            return ResourceUtils.renameResource((Resource)resource, (String)string4);
        }
        return null;
    }

    public static void standardizePrefixes(OntModel ontModel) {
        ontModel.setNsPrefix("owl", "http://www.w3.org/2002/07/owl#");
    }

    public static void unifyNamespace(OntModel ontModel, String string, String string2) {
        if (!string.equals(string2)) {
            JenaNormalizer.unifyNamespaceOfOntologies(ontModel, string, string2);
            JenaNormalizer.unifyNamespaceOfProperties(ontModel, string, string2);
            JenaNormalizer.unifyNamespaceOfNamedClasses(ontModel, string, string2);
            JenaNormalizer.unifyNamespaceOfIndividuals(ontModel, string, string2);
        }
    }

    private static void unifyNamespaceOfIndividuals(OntModel ontModel, String string, String string2) {
        Set set = Jena.set((Iterator)ontModel.listIndividuals());
        JenaNormalizer.unifyNamespaceOfResources(set.iterator(), string, string2);
        JenaNormalizer.unifyNamespaceOfResources((Iterator)ontModel.listObjects(), string, string2);
    }

    private static void unifyNamespaceOfResources(Iterator iterator, String string, String string2) {
        while (iterator.hasNext()) {
            Individual individual;
            String string3;
            Object e = iterator.next();
            if (!(e instanceof Resource) || !((Resource)e).canAs(Individual.class) || (string3 = (individual = (Individual)((Resource)e).as(Individual.class)).getNameSpace()) == null || string != null && !string3.equals(string)) continue;
            JenaNormalizer.setResourceNamespace((Resource)individual, string2);
        }
    }

    private static void unifyNamespaceOfNamedClasses(OntModel ontModel, String string, String string2) {
        Set set = Jena.set((Iterator)ontModel.listNamedClasses());
        for (OntClass ontClass : set) {
            if (string != null && !ontClass.getNameSpace().equals(string)) continue;
            JenaNormalizer.setResourceNamespace((Resource)ontClass, string2);
        }
    }

    private static void unifyNamespaceOfOntologies(OntModel ontModel, String string, String string2) {
        Set set = Jena.set((Iterator)ontModel.listOntologies());
        for (Ontology ontology : set) {
            String string3;
            String string4 = ontology.getURI();
            if (string4 == null || !(string3 = Jena.isNamespaceWithSeparator(string4) ? string4 : string4 + "#").equals(string)) continue;
            String string5 = string2;
            if (string5.endsWith("#")) {
                string5 = string2.substring(0, string2.length() - 1);
            }
            if (log.isLoggable(Level.FINE)) {
                log.fine("* Renaming ontology " + ontology.getURI() + " into namespace " + string5);
            }
            ResourceUtils.renameResource((Resource)ontology, (String)string5);
        }
    }

    private static void unifyNamespaceOfProperties(OntModel ontModel, String string, String string2) {
        Set set = Jena.set((Iterator)ontModel.listDatatypeProperties());
        Jena.set(set, (Iterator)ontModel.listObjectProperties());
        Jena.set(set, (Iterator)ontModel.listAnnotationProperties());
        for (Property property : set) {
            Resource resource;
            if (string != null && !property.getNameSpace().equals(string) || (resource = JenaNormalizer.setResourceNamespace((Resource)property, string2)) == null) continue;
            Property property2 = (Property)resource.as(Property.class);
            Set set2 = Jena.set((Iterator)ontModel.listStatements(null, property, (RDFNode)null));
            for (Statement statement : set2) {
                statement.remove();
                ontModel.add(statement.getSubject(), property2, statement.getObject());
                if (!log.isLoggable(Level.FINE)) continue;
                log.fine("* Changed statement (" + statement.getSubject() + ", " + property2 + ", " + statement.getObject());
            }
        }
    }
}

