/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.jena;

import com.hp.hpl.jena.ontology.OntModel;
import edu.stanford.smi.protege.exception.OntologyLoadException;
import edu.stanford.smi.protege.model.KnowledgeBase;
import edu.stanford.smi.protege.model.KnowledgeBaseFactory;
import edu.stanford.smi.protege.model.KnowledgeBaseSourcesEditor;
import edu.stanford.smi.protege.model.Project;
import edu.stanford.smi.protege.ui.ProjectManager;
import edu.stanford.smi.protege.util.ApplicationProperties;
import edu.stanford.smi.protege.util.Log;
import edu.stanford.smi.protege.util.MessageError;
import edu.stanford.smi.protege.util.PropertyList;
import edu.stanford.smi.protege.util.URIUtilities;
import edu.stanford.smi.protegex.owl.database.OWLDatabaseModel;
import edu.stanford.smi.protegex.owl.jena.JenaKnowledgeBaseSourcesEditor;
import edu.stanford.smi.protegex.owl.jena.JenaOWLModel;
import edu.stanford.smi.protegex.owl.jena.parser.ProtegeOWLParser;
import edu.stanford.smi.protegex.owl.model.OWLModel;
import edu.stanford.smi.protegex.owl.model.factory.AlreadyImportedException;
import edu.stanford.smi.protegex.owl.model.factory.FactoryUtils;
import edu.stanford.smi.protegex.owl.repository.Repository;
import edu.stanford.smi.protegex.owl.repository.RepositoryManager;
import edu.stanford.smi.protegex.owl.repository.util.RepositoryFileManager;
import edu.stanford.smi.protegex.owl.storage.OWLKnowledgeBaseFactory;
import edu.stanford.smi.protegex.owl.storage.ProtegeSaver;
import edu.stanford.smi.protegex.owl.ui.menu.OWLBackwardsCompatibilityProjectFixups;
import edu.stanford.smi.protegex.owl.ui.resourceselection.ResourceSelectionAction;
import edu.stanford.smi.protegex.owl.writer.rdfxml.rdfwriter.OWLModelAllTripleStoresWriter;
import edu.stanford.smi.protegex.owl.writer.rdfxml.util.ProtegeWriterSettings;
import edu.stanford.smi.protegex.owl.writer.xml.XMLWriterPreferences;
import java.io.File;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JenaKnowledgeBaseFactory
implements OWLKnowledgeBaseFactory {
    private static final transient Logger log = Log.getLogger(JenaKnowledgeBaseFactory.class);
    public static final String JENA_SYNCHRONIZED = JenaKnowledgeBaseFactory.class.getName() + ".synchronized";
    public static final String OWL_FILE_URI_PROPERTY = "owl_file_name";
    public static final String OWL_FILE_LANGUAGE_PROPERTY = "owl_file_language";
    public static final String[] fileLanguages = new String[]{"RDF/XML-ABBREV", "RDF/XML", "N-TRIPLE", "N3", "TURTLE"};
    static final String[] extensions = new String[]{"owl", "rdf-xml.owl", "ntriple.owl", "n3.owl", "turtle.owl"};
    private static boolean isMergingImportMode = false;
    public static boolean useStandalone = true;
    private static List<Repository> repositories = new ArrayList<Repository>();

    public static void addRepository(Repository repository) {
        repositories.add(repository);
    }

    public static void clearRepositories() {
        repositories.clear();
    }

    public static Collection<Repository> getRepositories() {
        return Collections.unmodifiableCollection(repositories);
    }

    public KnowledgeBase createKnowledgeBase(Collection collection) {
        boolean bl = ProjectManager.getProjectManager().getMainPanel() != null;
        useStandalone = !bl;
        ResourceSelectionAction.setActivated(true);
        JenaOWLModel jenaOWLModel = new JenaOWLModel(this);
        jenaOWLModel.getRepositoryManager().addDefaultRepositories();
        return jenaOWLModel;
    }

    public KnowledgeBaseSourcesEditor createKnowledgeBaseSourcesEditor(String string, PropertyList propertyList) {
        if (string != null && string.startsWith("http://")) {
            int n = string.lastIndexOf(47);
            string = new File(string.substring(n + 1)).toURI().toString();
        }
        return new JenaKnowledgeBaseSourcesEditor(string, propertyList);
    }

    protected URI getFileURI(PropertyList propertyList, Project project) {
        try {
            String string = JenaKnowledgeBaseFactory.getOWLFilePath(propertyList);
            if (string.startsWith("http://")) {
                return new URI(string);
            }
            URI uRI = project.getProjectURI();
            if (uRI == null) {
                return new URI(string);
            }
            URI uRI2 = project.getProjectDirectoryURI();
            URI uRI3 = URIUtilities.relativize((URI)uRI2, (URI)new URI(string));
            URI uRI4 = uRI.resolve(uRI3);
            return uRI4;
        }
        catch (Exception exception) {
            Log.getLogger().log(Level.SEVERE, "Exception caught", exception);
            return null;
        }
    }

    public static String getExtension(String string) {
        for (int i = 0; i < fileLanguages.length; ++i) {
            String string2 = fileLanguages[i];
            if (!string2.equals(string)) continue;
            return extensions[i];
        }
        return null;
    }

    protected static String getOWLFileLanguage(PropertyList propertyList) {
        String string = propertyList.getString(OWL_FILE_LANGUAGE_PROPERTY);
        return string == null ? fileLanguages[0] : string;
    }

    public static String getOWLFilePath(PropertyList propertyList) {
        return propertyList.getString(OWL_FILE_URI_PROPERTY);
    }

    public String getDescription() {
        return "OWL / RDF Files";
    }

    public String getProjectFilePath() {
        return useStandalone ? "OWL-min.pprj" : "OWL.pprj";
    }

    public void includeKnowledgeBase(KnowledgeBase knowledgeBase, PropertyList propertyList, Collection collection) {
        this.loadKnowledgeBase(knowledgeBase, propertyList, collection);
    }

    public boolean isComplete(PropertyList propertyList) {
        return true;
    }

    public void loadKnowledgeBase(KnowledgeBase knowledgeBase, PropertyList propertyList, Collection collection) {
        String string = JenaKnowledgeBaseFactory.getOWLFileLanguage(propertyList);
        if (knowledgeBase instanceof JenaOWLModel) {
            Collection<MessageError> collection2;
            JenaOWLModel jenaOWLModel = (JenaOWLModel)knowledgeBase;
            URI uRI = this.getFileURI(propertyList, jenaOWLModel.getProject());
            JenaKnowledgeBaseFactory.setOWLFileName(propertyList, uRI.toString());
            RepositoryFileManager.loadProjectRepositories(jenaOWLModel);
            RepositoryManager repositoryManager = jenaOWLModel.getRepositoryManager();
            for (Repository repository : repositories) {
                repositoryManager.addProjectRepository(repository);
            }
            repositories.clear();
            try {
                collection2 = new ProtegeOWLParser(jenaOWLModel);
                ((ProtegeOWLParser)((Object)collection2)).setMergingImportMode(JenaKnowledgeBaseFactory.isMergingImportMode());
                ((ProtegeOWLParser)((Object)collection2)).run(uRI);
            }
            catch (OntologyLoadException ontologyLoadException) {
                this.handleException(ontologyLoadException, jenaOWLModel, uRI, collection);
            }
            collection2 = jenaOWLModel.getParserErrors();
            if (collection2 != null && collection2.size() > 0) {
                collection.addAll(collection2);
            }
        } else {
            String string2 = "This plugin can currently only load OWL files into OWL projects";
            collection.add(new MessageError(string2));
            Log.getLogger().severe(string2);
        }
    }

    protected void handleException(Throwable throwable, JenaOWLModel jenaOWLModel, URI uRI, Collection<MessageError> collection) {
        Log.getLogger().log(Level.SEVERE, "Error at loading file " + uRI, throwable);
        Collection<MessageError> collection2 = jenaOWLModel.getParserErrors();
        if (collection2 != null && collection2.size() > 0) {
            collection.addAll(collection2);
        }
        collection.add(new MessageError(throwable));
        String string = "Errors at loading OWL file from " + uRI + "\n";
        string = string + "\nPlease consider running the file through an RDF or OWL validation service such as:";
        string = string + "\n  - RDF Validator: http://www.w3.org/RDF/Validator";
        string = string + "\n  - OWL Validator: http://phoebus.cs.man.ac.uk:9999/OWL/Validator";
        if (jenaOWLModel.getNamespaceManager().getPrefix("http://protege.stanford.edu/system#") != null || jenaOWLModel.getNamespaceManager().getPrefix("http://protege.stanford.edu/kb#") != null) {
            string = string + "\nThis file seems to have been created with the frame-based Protege RDF Backend. " + "Please try to use the RDF Backend of Protege to open this file and then export it to OWL " + "using Export to Format...";
        }
        collection.add(new MessageError(string));
    }

    public void saveKnowledgeBase(KnowledgeBase knowledgeBase, PropertyList propertyList, Collection collection) {
        String string = JenaKnowledgeBaseFactory.getOWLFileLanguage(propertyList);
        if (knowledgeBase instanceof JenaOWLModel) {
            JenaOWLModel jenaOWLModel = (JenaOWLModel)knowledgeBase;
            OWLBackwardsCompatibilityProjectFixups.insertVersionData(propertyList);
            URI uRI = this.getFileURI(propertyList, jenaOWLModel.getProject());
            jenaOWLModel.save(uRI, string, collection);
            this.makeOWLFileNameRelativeIfPossible(jenaOWLModel.getProject());
            ApplicationProperties.addProjectToMRUList((URI)jenaOWLModel.getProject().getProjectURI());
        } else {
            boolean bl;
            Project project = Project.createNewProject((KnowledgeBaseFactory)this, (Collection)collection);
            project.setProjectURI(knowledgeBase.getProject().getProjectURI());
            JenaOWLModel jenaOWLModel = (JenaOWLModel)project.getKnowledgeBase();
            boolean bl2 = bl = knowledgeBase instanceof OWLModel && ((OWLModel)knowledgeBase).getWriterSettings() instanceof ProtegeWriterSettings;
            if (knowledgeBase instanceof OWLDatabaseModel && !bl) {
                OntModel ontModel = ((OWLDatabaseModel)knowledgeBase).getOntModel();
                URI uRI = this.getFileURI(propertyList, jenaOWLModel.getProject());
                jenaOWLModel.save(uRI, string, collection, ontModel);
                ontModel.close();
            } else if (bl) {
                URI uRI = this.getFileURI(propertyList, jenaOWLModel.getProject());
                ProtegeWriterSettings protegeWriterSettings = (ProtegeWriterSettings)((OWLModel)knowledgeBase).getWriterSettings();
                try {
                    boolean bl3 = protegeWriterSettings.getUseXMLEntities();
                    XMLWriterPreferences.getInstance().setUseNamespaceEntities(bl3);
                    OWLModelAllTripleStoresWriter oWLModelAllTripleStoresWriter = new OWLModelAllTripleStoresWriter((OWLModel)knowledgeBase, uRI, protegeWriterSettings.isSortAlphabetically());
                    oWLModelAllTripleStoresWriter.write();
                }
                catch (Exception exception) {
                    String string2 = "Failed to save file " + uRI;
                    Log.getLogger().log(Level.SEVERE, string2, exception);
                    collection.add(new MessageError((Throwable)exception, string2));
                }
            } else {
                try {
                    FactoryUtils.addOntologyToTripleStore(jenaOWLModel, jenaOWLModel.getTripleStoreModel().getTopTripleStore(), FactoryUtils.generateOntologyURIBase());
                }
                catch (AlreadyImportedException alreadyImportedException) {
                    log.log(Level.WARNING, "Unexpected Exception - Could not set default ontology", alreadyImportedException);
                }
                new ProtegeSaver(knowledgeBase, jenaOWLModel, bl).run();
                URI uRI = this.getFileURI(propertyList, jenaOWLModel.getProject());
                jenaOWLModel.save(uRI, string, collection);
            }
        }
    }

    protected void makeOWLFileNameRelativeIfPossible(Project project) {
        String string = JenaKnowledgeBaseFactory.getOWLFilePath(project.getSources());
        URI uRI = project.getProjectDirectoryURI();
        if (uRI != null && uRI.toString().startsWith("file:")) {
            try {
                URI uRI2 = new URI(string);
                File file = new File(uRI2);
                if (file.isAbsolute()) {
                    File file2 = new File(uRI);
                    File file3 = file.getParentFile();
                    if (file3.toString().equals(file2.toString())) {
                        String string2 = file.getName();
                        JenaKnowledgeBaseFactory.setOWLFileName(project.getSources(), string2);
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static void setOWLFileLanguage(PropertyList propertyList, String string) {
        propertyList.setString(OWL_FILE_LANGUAGE_PROPERTY, string);
    }

    public static void setOWLFileName(PropertyList propertyList, String string) {
        if (string.indexOf(".") < 0) {
            string = string + ".owl";
        }
        propertyList.setString(OWL_FILE_URI_PROPERTY, string);
    }

    public static String getOWLFileName(PropertyList propertyList) {
        return propertyList.getString(OWL_FILE_URI_PROPERTY);
    }

    public static boolean isMergingImportMode() {
        return isMergingImportMode;
    }

    public static void setMergingImportMode(boolean bl) {
        isMergingImportMode = bl;
    }
}

