/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.jena;

import edu.stanford.smi.protege.model.Project;
import edu.stanford.smi.protege.plugin.CreateProjectFromFilePlugin;
import edu.stanford.smi.protege.util.FileUtilities;
import edu.stanford.smi.protege.util.Log;
import edu.stanford.smi.protege.util.MessageError;
import edu.stanford.smi.protege.util.URIUtilities;
import edu.stanford.smi.protegex.owl.jena.JenaKnowledgeBaseFactory;
import edu.stanford.smi.protegex.owl.jena.creator.OwlProjectFromUriCreator;
import java.io.File;
import java.net.URI;
import java.util.Collection;
import java.util.logging.Level;

public class CreateOWLProjectFromFilePlugin
implements CreateProjectFromFilePlugin {
    public Project createProject(File file, Collection collection) {
        OwlProjectFromUriCreator owlProjectFromUriCreator = new OwlProjectFromUriCreator();
        try {
            JenaKnowledgeBaseFactory.useStandalone = false;
            owlProjectFromUriCreator.setOntologyUri(URIUtilities.createURI((String)file.getPath()).toString());
            owlProjectFromUriCreator.create(collection);
        }
        catch (Exception exception) {
            collection.add(new MessageError((Throwable)exception, "Ontology content might be incomplete or corrupted.\nSee console or log for the full stack trace."));
            Log.getLogger().log(Level.SEVERE, "Error loading file with the CreateOWLProjectFromFilePlugin", exception);
        }
        return owlProjectFromUriCreator.getProject();
    }

    public String[] getSuffixes() {
        return new String[]{"owl"};
    }

    public String getDescription() {
        return "OWL Files";
    }

    protected URI getBuildProjectURI(File file) {
        String string = FileUtilities.replaceExtension((String)file.getAbsolutePath(), (String)".pprj");
        try {
            File file2 = new File(string);
            if (file2.exists()) {
                return URIUtilities.createURI((String)string);
            }
        }
        catch (Exception exception) {
            Log.emptyCatchBlock((Throwable)exception);
        }
        return null;
    }
}

