/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.javacode;

import edu.stanford.smi.protegex.owl.javacode.RDFSClassCode;
import edu.stanford.smi.protegex.owl.model.RDFProperty;

public class RDFPropertyCode
implements Comparable {
    private RDFProperty property;
    private boolean usePrefix;

    public RDFPropertyCode(RDFProperty rDFProperty, boolean bl) {
        this.property = rDFProperty;
        this.usePrefix = bl;
    }

    public int compareTo(Object object) {
        if (object instanceof RDFPropertyCode) {
            RDFPropertyCode rDFPropertyCode = (RDFPropertyCode)object;
            return this.getJavaName().compareTo(rDFPropertyCode.getJavaName());
        }
        return 0;
    }

    public String getJavaName() {
        String string = this.property.getNamespacePrefix();
        if (this.usePrefix && string != null && !string.equals("")) {
            string = string.toUpperCase() + "_";
            return RDFSClassCode.getValidJavaName(string + this.property.getLocalName());
        }
        return RDFSClassCode.getValidJavaName(this.property.getLocalName());
    }

    public RDFProperty getRDFProperty() {
        return this.property;
    }

    public String getUpperCaseJavaName() {
        String string = this.getJavaName();
        if (string.length() > 1) {
            return Character.toUpperCase(string.charAt(0)) + string.substring(1);
        }
        return string.toUpperCase();
    }
}

