/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.javacode;

import edu.stanford.smi.protege.model.Cls;
import edu.stanford.smi.protege.model.FrameID;
import edu.stanford.smi.protegex.owl.model.OWLModel;
import edu.stanford.smi.protegex.owl.model.RDFResource;
import edu.stanford.smi.protegex.owl.model.RDFSNamedClass;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProtegeJavaMapping {
    private static Map<String, Entry> protegeMap = new HashMap<String, Entry>();
    private static Map<Class, Entry> interfaceMap = new HashMap<Class, Entry>();
    private static Map<Class, Entry> implementationMap = new HashMap<Class, Entry>();

    public static void add(String string, Class<? extends RDFResource> clazz, Class<? extends RDFResource> clazz2) {
        Entry entry = new Entry(string, clazz, clazz2);
        protegeMap.put(string, entry);
        interfaceMap.put(clazz, entry);
        implementationMap.put(clazz2, entry);
    }

    public static <X> X create(OWLModel oWLModel, Class<? extends X> clazz, String string) {
        RDFSNamedClass rDFSNamedClass;
        Entry entry = interfaceMap.get(clazz);
        if (entry == null) {
            return null;
        }
        if (string == null) {
            string = oWLModel.getNextAnonymousResourceName();
        }
        if ((rDFSNamedClass = oWLModel.getRDFSNamedClass(entry.getProtegeClass())) == null) {
            return null;
        }
        rDFSNamedClass.createInstance(string);
        return (X)ProtegeJavaMapping.constructImplementation(oWLModel, entry.getJavaImplementation(), new FrameID(string));
    }

    public static boolean canAs(RDFResource rDFResource, Class<? extends RDFResource> clazz) {
        if (clazz.isAssignableFrom(rDFResource.getClass())) {
            return true;
        }
        return ProtegeJavaMapping.getJavaImplementation(rDFResource, clazz) != null;
    }

    public static <X extends RDFResource> X as(RDFResource rDFResource, Class<? extends X> clazz) {
        OWLModel oWLModel = rDFResource.getOWLModel();
        if (clazz.isAssignableFrom(rDFResource.getClass())) {
            return (X)((RDFResource)clazz.cast(rDFResource));
        }
        Class<? extends X> clazz2 = ProtegeJavaMapping.getJavaImplementation(rDFResource, clazz);
        return (X)((RDFResource)ProtegeJavaMapping.constructImplementation(oWLModel, clazz2, rDFResource.getFrameID()));
    }

    private static <X> X constructImplementation(OWLModel oWLModel, Class<? extends X> clazz, FrameID frameID) {
        try {
            Constructor<X> constructor = clazz.getConstructor(OWLModel.class, FrameID.class);
            return constructor.newInstance(oWLModel, frameID);
        }
        catch (Throwable throwable) {
            ClassCastException classCastException = new ClassCastException("Resource " + frameID.getName() + " could not be cast to type " + clazz);
            classCastException.initCause(throwable);
            throw classCastException;
        }
    }

    private static <X> Class<? extends X> getJavaImplementation(RDFResource rDFResource, Class<? extends X> clazz) {
        Object object;
        Object object2;
        RDFSNamedClass rDFSNamedClass;
        Collection collection = rDFResource.getProtegeTypes();
        ArrayList arrayList = new ArrayList();
        arrayList.addAll(collection);
        for (Object e : collection) {
            if (!(e instanceof RDFSNamedClass)) continue;
            rDFSNamedClass = (RDFSNamedClass)e;
            object2 = rDFSNamedClass.getSuperclasses(true);
            object = object2.iterator();
            while (object.hasNext()) {
                Object e2 = object.next();
                if (arrayList.contains(e2)) continue;
                arrayList.add(e2);
            }
        }
        for (Object e : arrayList) {
            if (!(e instanceof Cls) || (object2 = protegeMap.get((rDFSNamedClass = (Cls)e).getName())) == null || !clazz.isAssignableFrom((Class<?>)(object = ((Entry)object2).getJavaImplementation()))) continue;
            return ((Class)object).asSubclass(clazz);
        }
        return null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class Entry {
        private String protegeClass;
        private Class<? extends RDFResource> javaInterface;
        private Class<? extends RDFResource> javaImplementation;

        public Entry(String string, Class<? extends RDFResource> clazz, Class<? extends RDFResource> clazz2) {
            this.protegeClass = string;
            this.javaInterface = clazz;
            this.javaImplementation = clazz2;
        }

        public String getProtegeClass() {
            return this.protegeClass;
        }

        public Class<? extends RDFResource> getJavaInterface() {
            return this.javaInterface;
        }

        public Class<? extends RDFResource> getJavaImplementation() {
            return this.javaImplementation;
        }
    }
}

