/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.javacode;

import edu.stanford.smi.protegex.owl.javacode.EditableJavaCodeGeneratorOptions;
import edu.stanford.smi.protegex.owl.model.OWLModel;
import edu.stanford.smi.protegex.owl.model.project.OWLProject;
import java.io.File;

public class ProjectBasedJavaCodeGeneratorOptions
implements EditableJavaCodeGeneratorOptions {
    public static final String ABSTRACT_MODE = "JavaCodeAbstract";
    public static final String FACTORY_CLASS_NAME = "JavaCodeFactoryClassName";
    public static final String FILE_NAME = "JavaCodeFileName";
    public static final String PACKAGE = "JavaCodePackage";
    public static final String SET_MODE = "JavaCodeSet";
    public static final String PREFIX_MODE = "JavaCodeUsePrefix";
    private OWLProject project;

    public ProjectBasedJavaCodeGeneratorOptions(OWLModel oWLModel) {
        this.project = oWLModel.getOWLProject();
    }

    public boolean getAbstractMode() {
        Boolean bl = this.project.getSettingsMap().getBoolean(ABSTRACT_MODE);
        if (bl != null) {
            return bl;
        }
        return false;
    }

    public String getFactoryClassName() {
        String string = this.project.getSettingsMap().getString(FACTORY_CLASS_NAME);
        if (string == null) {
            return "MyFactory";
        }
        return string;
    }

    public File getOutputFolder() {
        String string = this.project.getSettingsMap().getString(FILE_NAME);
        if (string == null) {
            return new File("");
        }
        return new File(string);
    }

    public String getPackage() {
        return this.project.getSettingsMap().getString(PACKAGE);
    }

    public boolean getSetMode() {
        Boolean bl = this.project.getSettingsMap().getBoolean(SET_MODE);
        if (bl != null) {
            return bl;
        }
        return false;
    }

    public boolean getPrefixMode() {
        Boolean bl = this.project.getSettingsMap().getBoolean(PREFIX_MODE);
        if (bl != null) {
            return bl;
        }
        return false;
    }

    public void setAbstractMode(boolean bl) {
        this.project.getSettingsMap().setBoolean(ABSTRACT_MODE, bl);
    }

    public void setOutputFolder(File file) {
        if (file == null) {
            this.project.getSettingsMap().remove(FILE_NAME);
        } else {
            this.project.getSettingsMap().setString(FILE_NAME, file.getAbsolutePath());
        }
    }

    public void setFactoryClassName(String string) {
        if (string == null || string.length() == 0) {
            this.project.getSettingsMap().remove(FACTORY_CLASS_NAME);
        } else {
            this.project.getSettingsMap().setString(FACTORY_CLASS_NAME, string);
        }
    }

    public void setPackage(String string) {
        if (string == null || string.length() == 0) {
            this.project.getSettingsMap().remove(PACKAGE);
        } else {
            this.project.getSettingsMap().setString(PACKAGE, string);
        }
    }

    public void setSetMode(boolean bl) {
        this.project.getSettingsMap().setBoolean(SET_MODE, bl);
    }

    public void setPrefixMode(boolean bl) {
        this.project.getSettingsMap().setBoolean(PREFIX_MODE, bl);
    }
}

