/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.javacode;

import edu.stanford.smi.protege.resource.Icons;
import edu.stanford.smi.protege.util.Log;
import edu.stanford.smi.protegex.owl.javacode.JavaCodeGenerator;
import edu.stanford.smi.protegex.owl.javacode.JavaCodeGeneratorPanel;
import edu.stanford.smi.protegex.owl.javacode.ProjectBasedJavaCodeGeneratorOptions;
import edu.stanford.smi.protegex.owl.model.OWLModel;
import edu.stanford.smi.protegex.owl.model.RDFResource;
import edu.stanford.smi.protegex.owl.model.RDFSNamedClass;
import edu.stanford.smi.protegex.owl.ui.ProtegeUI;
import edu.stanford.smi.protegex.owl.ui.actions.ResourceAction;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.logging.Level;
import javax.swing.JTree;

public class JavaCodeGeneratorResourceAction
extends ResourceAction {
    private static final long serialVersionUID = -3545349747404645380L;

    public JavaCodeGeneratorResourceAction() {
        super("Generate Protege-OWL Java Code for class...", Icons.getBlankIcon(), "Extract/");
    }

    public void actionPerformed(ActionEvent actionEvent) {
        OWLModel oWLModel = this.getOWLModel();
        ProjectBasedJavaCodeGeneratorOptions projectBasedJavaCodeGeneratorOptions = new ProjectBasedJavaCodeGeneratorOptions(oWLModel);
        JavaCodeGeneratorPanel javaCodeGeneratorPanel = new JavaCodeGeneratorPanel(projectBasedJavaCodeGeneratorOptions);
        if (ProtegeUI.getModalDialogFactory().showDialog(ProtegeUI.getTopLevelContainer(oWLModel.getProject()), javaCodeGeneratorPanel, (String)this.getValue("Name"), 11) == 1) {
            javaCodeGeneratorPanel.ok();
            JavaCodeGenerator javaCodeGenerator = new JavaCodeGenerator(oWLModel, projectBasedJavaCodeGeneratorOptions);
            try {
                RDFSNamedClass rDFSNamedClass = (RDFSNamedClass)this.getResource();
                javaCodeGenerator.createInterface(rDFSNamedClass);
                javaCodeGenerator.createImplementation(rDFSNamedClass);
                javaCodeGenerator.createFactoryClass();
                ProtegeUI.getModalDialogFactory().showMessageDialog(oWLModel, "Java code successfully generated for " + rDFSNamedClass.getLocalName() + ".");
            }
            catch (Exception exception) {
                Log.getLogger().log(Level.SEVERE, "Exception caught", exception);
                ProtegeUI.getModalDialogFactory().showErrorMessageDialog(oWLModel, "Could not create Java code:\n" + exception);
            }
        }
    }

    public boolean isSuitable(Component component, RDFResource rDFResource) {
        return rDFResource instanceof RDFSNamedClass && !rDFResource.isSystem() && component instanceof JTree;
    }
}

