/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.javacode;

import edu.stanford.smi.protege.resource.Icons;
import edu.stanford.smi.protege.util.LabeledComponent;
import edu.stanford.smi.protegex.owl.javacode.EditableJavaCodeGeneratorOptions;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.io.File;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JCheckBox;
import javax.swing.JFileChooser;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class JavaCodeGeneratorPanel
extends JPanel {
    private static final long serialVersionUID = 3706024179518110486L;
    private JCheckBox abstractCheckBox;
    private JTextField factoryClassNameTextField;
    private JFileChooser fileChooser = new JFileChooser(".");
    private EditableJavaCodeGeneratorOptions options;
    private JTextField packageTextField;
    private JTextField rootFolderTextField;
    private JCheckBox setCheckBox;
    private JCheckBox prefixCheckBox;

    public JavaCodeGeneratorPanel(EditableJavaCodeGeneratorOptions editableJavaCodeGeneratorOptions) {
        this.options = editableJavaCodeGeneratorOptions;
        this.packageTextField = new JTextField();
        if (editableJavaCodeGeneratorOptions.getPackage() != null) {
            this.packageTextField.setText(editableJavaCodeGeneratorOptions.getPackage());
        }
        this.rootFolderTextField = new JTextField();
        if (editableJavaCodeGeneratorOptions.getOutputFolder() != null) {
            this.rootFolderTextField.setText(editableJavaCodeGeneratorOptions.getOutputFolder().getAbsolutePath());
        }
        this.fileChooser.setDialogTitle("Select output folder");
        this.fileChooser.setFileSelectionMode(1);
        this.factoryClassNameTextField = new JTextField();
        if (editableJavaCodeGeneratorOptions.getFactoryClassName() != null) {
            this.factoryClassNameTextField.setText(editableJavaCodeGeneratorOptions.getFactoryClassName());
        }
        this.abstractCheckBox = new JCheckBox("Create abstract base files (e.g., Person_)");
        this.abstractCheckBox.setSelected(editableJavaCodeGeneratorOptions.getAbstractMode());
        this.setCheckBox = new JCheckBox("Return Set instead of Collection");
        this.setCheckBox.setSelected(editableJavaCodeGeneratorOptions.getSetMode());
        this.prefixCheckBox = new JCheckBox("Include prefixes in generated Java names");
        this.prefixCheckBox.setSelected(editableJavaCodeGeneratorOptions.getPrefixMode());
        this.setLayout(new BoxLayout(this, 1));
        LabeledComponent labeledComponent = new LabeledComponent("Root output folder", (Component)this.rootFolderTextField);
        labeledComponent.addHeaderButton((Action)new AbstractAction("Select folder...", Icons.getAddIcon()){
            private static final long serialVersionUID = 2754013804198315963L;

            public void actionPerformed(ActionEvent actionEvent) {
                JavaCodeGeneratorPanel.this.selectFolder();
            }
        });
        this.add((Component)labeledComponent);
        this.add(Box.createVerticalStrut(8));
        this.add((Component)new LabeledComponent("Java package", (Component)this.packageTextField));
        this.add(Box.createVerticalStrut(8));
        this.add((Component)new LabeledComponent("Factory class name", (Component)this.factoryClassNameTextField));
        this.add(Box.createVerticalStrut(8));
        this.add(this.createCheckBoxPanel(this.abstractCheckBox));
        this.add(Box.createVerticalStrut(8));
        this.add(this.createCheckBoxPanel(this.setCheckBox));
        this.add(Box.createVerticalStrut(8));
        this.add(this.createCheckBoxPanel(this.prefixCheckBox));
        this.add(Box.createVerticalStrut(8));
    }

    private JPanel createCheckBoxPanel(Component component) {
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.add("West", component);
        jPanel.add("Center", new JPanel());
        jPanel.setPreferredSize(new Dimension(300, 24));
        return jPanel;
    }

    public void ok() {
        File file = null;
        String string = this.rootFolderTextField.getText().trim();
        if (string.length() > 0) {
            file = new File(string);
        }
        this.options.setOutputFolder(file);
        this.options.setAbstractMode(this.abstractCheckBox.isSelected());
        this.options.setSetMode(this.setCheckBox.isSelected());
        this.options.setPrefixMode(this.prefixCheckBox.isSelected());
        this.options.setFactoryClassName(this.factoryClassNameTextField.getText());
        String string2 = this.packageTextField.getText().trim();
        this.options.setPackage(string2.length() > 0 ? string2 : null);
    }

    private void selectFolder() {
        if (this.fileChooser.showDialog(this, "Select") == 0) {
            File file = this.fileChooser.getSelectedFile();
            this.rootFolderTextField.setText(file.toString());
        }
    }
}

