/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.javacode;

import edu.stanford.smi.protege.util.Log;
import edu.stanford.smi.protegex.owl.javacode.JavaCodeGenerator;
import edu.stanford.smi.protegex.owl.javacode.JavaCodeGeneratorPanel;
import edu.stanford.smi.protegex.owl.javacode.ProjectBasedJavaCodeGeneratorOptions;
import edu.stanford.smi.protegex.owl.model.OWLModel;
import edu.stanford.smi.protegex.owl.ui.ProtegeUI;
import edu.stanford.smi.protegex.owl.ui.actions.AbstractOWLModelAction;
import java.util.logging.Level;

public class JavaCodeGeneratorAction
extends AbstractOWLModelAction {
    public static final String GROUP = "1_Java_Code";

    public String getMenubarPath() {
        return "Code/1_Java_Code";
    }

    public String getName() {
        return "Generate Protege-OWL Java Code...";
    }

    public void run(OWLModel oWLModel) {
        ProjectBasedJavaCodeGeneratorOptions projectBasedJavaCodeGeneratorOptions = new ProjectBasedJavaCodeGeneratorOptions(oWLModel);
        JavaCodeGeneratorPanel javaCodeGeneratorPanel = new JavaCodeGeneratorPanel(projectBasedJavaCodeGeneratorOptions);
        if (ProtegeUI.getModalDialogFactory().showDialog(ProtegeUI.getTopLevelContainer(oWLModel.getProject()), javaCodeGeneratorPanel, this.getName(), 11) == 1) {
            javaCodeGeneratorPanel.ok();
            JavaCodeGenerator javaCodeGenerator = new JavaCodeGenerator(oWLModel, projectBasedJavaCodeGeneratorOptions);
            try {
                javaCodeGenerator.createAll();
                ProtegeUI.getModalDialogFactory().showMessageDialog(oWLModel, "Java code successfully generated.");
            }
            catch (Exception exception) {
                Log.getLogger().log(Level.SEVERE, "Exception caught", exception);
                ProtegeUI.getModalDialogFactory().showErrorMessageDialog(oWLModel, "Could not create Java code:\n" + exception);
            }
        }
    }
}

