/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.javacode;

import edu.stanford.smi.protegex.owl.javacode.JavaCodeGeneratorOptions;
import edu.stanford.smi.protegex.owl.javacode.RDFPropertyAtClassCode;
import edu.stanford.smi.protegex.owl.javacode.RDFPropertyCode;
import edu.stanford.smi.protegex.owl.javacode.RDFSClassCode;
import edu.stanford.smi.protegex.owl.model.OWLModel;
import edu.stanford.smi.protegex.owl.model.OWLNamedClass;
import edu.stanford.smi.protegex.owl.model.RDFProperty;
import edu.stanford.smi.protegex.owl.model.RDFSClass;
import edu.stanford.smi.protegex.owl.model.RDFSNamedClass;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class JavaCodeGenerator {
    private OWLModel owlModel;
    private JavaCodeGeneratorOptions options;
    private static Map<Class, Class> primitiveTypesMap = new HashMap<Class, Class>();
    private static final boolean TRANSITIVE = true;
    private static final boolean ALL_PROPERTIES = true;
    private static final boolean ONLY_LOCAL_PROPERTIES = false;

    public JavaCodeGenerator(OWLModel oWLModel, JavaCodeGeneratorOptions javaCodeGeneratorOptions) {
        String string;
        this.owlModel = oWLModel;
        this.options = javaCodeGeneratorOptions;
        File file = javaCodeGeneratorOptions.getOutputFolder();
        if (file != null && !file.exists()) {
            file.mkdirs();
        }
        if ((string = javaCodeGeneratorOptions.getPackage()) != null) {
            string = string.replace('.', '/');
            File file2 = file == null ? new File(string) : new File(file, string);
            file2.mkdirs();
            File file3 = new File(file2, "impl");
            file3.mkdirs();
        } else {
            File file4 = file == null ? new File("impl") : new File(file, "impl");
            file4.mkdirs();
        }
    }

    public void createAll() throws IOException {
        for (RDFSNamedClass rDFSNamedClass : this.owlModel.getUserDefinedRDFSNamedClasses()) {
            if (rDFSNamedClass.getNamespace().equals("http://www.w3.org/2003/11/swrl#")) continue;
            this.createInterface(rDFSNamedClass);
            this.createImplementation(rDFSNamedClass);
        }
        this.createFactoryClass();
    }

    public void createFactoryClass() throws IOException {
        String string = this.options.getFactoryClassName();
        if (string != null && string.length() > 0) {
            File file = this.getInterfaceFile(string);
            FileWriter fileWriter = new FileWriter(file);
            PrintWriter printWriter = new PrintWriter(fileWriter);
            this.printFactoryClass(printWriter);
            fileWriter.close();
        }
    }

    private void printFactoryClass(PrintWriter printWriter) {
        String string;
        Object object;
        this.printInterfacePackageStatement(printWriter);
        printWriter.println();
        if (this.options.getPackage() != null) {
            printWriter.println("import " + this.options.getPackage() + ".impl.*;");
        } else {
            printWriter.println("import impl;");
        }
        printWriter.println();
        printWriter.println("import edu.stanford.smi.protege.model.FrameID;");
        printWriter.println("import edu.stanford.smi.protegex.owl.model.*;");
        printWriter.println("import edu.stanford.smi.protegex.owl.model.impl.OWLUtil;");
        printWriter.println("import edu.stanford.smi.protegex.owl.javacode.ProtegeJavaMapping;");
        printWriter.println();
        printWriter.println("import java.util.*;");
        printWriter.println();
        printWriter.println("/**");
        printWriter.println(" * Generated by Protege-OWL  (http://protege.stanford.edu/plugins/owl).");
        printWriter.println(" *");
        printWriter.println(" * @version generated on " + new Date());
        printWriter.println(" */");
        printWriter.println("public class " + this.options.getFactoryClassName() + " {");
        printWriter.println();
        printWriter.println("    private OWLModel owlModel;");
        printWriter.println();
        printWriter.println("    static {");
        for (Object object2 : this.owlModel.getUserDefinedRDFSNamedClasses()) {
            object = (RDFSNamedClass)object2;
            printWriter.println("        ProtegeJavaMapping.add(\"" + object.getName() + "\", " + this.getInterfaceName((RDFSNamedClass)object) + ".class, " + this.getImplementationName((RDFSNamedClass)object) + ".class);");
        }
        printWriter.println("    }");
        printWriter.println();
        printWriter.println("    public " + this.options.getFactoryClassName() + "(OWLModel owlModel) {");
        printWriter.println("        this.owlModel = owlModel;");
        printWriter.println("    }");
        printWriter.println();
        printWriter.println("    public <X> X create(Class<? extends X> javaInterface, String name) {");
        printWriter.println("        return ProtegeJavaMapping.create(owlModel, javaInterface, name);");
        printWriter.println("    }");
        for (Object object2 : this.owlModel.getUserDefinedRDFSNamedClasses()) {
            if (object2.getNamespace().equals("http://www.w3.org/2003/11/swrl#")) continue;
            object = this.getInterfaceName((RDFSNamedClass)object2);
            string = this.getImplementationName((RDFSNamedClass)object2);
            printWriter.println();
            printWriter.println();
            printWriter.println("    public RDFSNamedClass get" + (String)object + "Class() {");
            printWriter.println("        final String uri = \"" + object2.getURI() + "\";");
            printWriter.println("        final String name = owlModel.getResourceNameForURI(uri);");
            printWriter.println("        return owlModel.getRDFSNamedClass(name);");
            printWriter.println("    }");
            printWriter.println();
            printWriter.println("    public " + (String)object + " create" + (String)object + "(String name) {");
            printWriter.println("        final RDFSNamedClass cls = get" + (String)object + "Class();");
            printWriter.println("        if (name == null) {");
            printWriter.println("            name = owlModel.getNextAnonymousResourceName();");
            printWriter.println("        }");
            printWriter.println("        return  new " + string + "(owlModel, cls.createInstance(name).getFrameID());");
            printWriter.println("    }");
            printWriter.println();
            printWriter.println("    public " + (String)object + " get" + (String)object + "(String name) {");
            printWriter.println("        RDFResource res = owlModel.getRDFResource(OWLUtil.getInternalFullName(owlModel, name));");
            printWriter.println("        if (res == null) {return null;}");
            printWriter.println("        if (res instanceof " + (String)object + ") {");
            printWriter.println("            return (" + (String)object + ") res;");
            printWriter.println("        } else if (res.hasProtegeType(get" + (String)object + "Class())) {");
            printWriter.println("            return new " + string + "(owlModel, res.getFrameID());");
            printWriter.println("        }");
            printWriter.println("        return null;");
            printWriter.println("    }");
            String string2 = this.options.getSetMode() ? "Set" : "Collection";
            String string3 = this.options.getSetMode() ? "HashSet" : "ArrayList";
            printWriter.println();
            printWriter.println("    public " + string2 + "<" + (String)object + "> getAll" + (String)object + "Instances() {");
            printWriter.println("        return getAll" + (String)object + "Instances(false);");
            printWriter.println("    }");
            printWriter.println();
            printWriter.println("    public " + string2 + "<" + (String)object + "> getAll" + (String)object + "Instances(boolean transitive) {");
            printWriter.println("        " + string2 + "<" + (String)object + "> result = new " + string3 + "<" + (String)object + ">();");
            printWriter.println("        final RDFSNamedClass cls = get" + (String)object + "Class();");
            printWriter.println("        RDFResource owlIndividual;");
            printWriter.println("        for (Iterator it = cls.getInstances(transitive).iterator();it.hasNext();) {");
            printWriter.println("            owlIndividual = (RDFResource) it.next();");
            printWriter.println("            result.add(new " + string + "(owlModel, owlIndividual.getFrameID()));");
            printWriter.println("        }");
            printWriter.println("        return result;");
            printWriter.println("    }");
        }
        for (Object object2 : this.owlModel.getUserDefinedRDFProperties()) {
            if (object2.getNamespace().equals("http://www.w3.org/2003/11/swrl#")) continue;
            object = new RDFPropertyCode((RDFProperty)object2, this.options.getPrefixMode());
            string = ((RDFPropertyCode)object).getUpperCaseJavaName();
            printWriter.println();
            printWriter.println();
            printWriter.println("    public RDFProperty get" + string + "Property() {");
            printWriter.println("        final String uri = \"" + object2.getURI() + "\";");
            printWriter.println("        final String name = owlModel.getResourceNameForURI(uri);");
            printWriter.println("        return owlModel.getRDFProperty(name);");
            printWriter.println("    }");
        }
        printWriter.println("}");
    }

    public void createImplementation(RDFSNamedClass rDFSNamedClass) throws IOException {
        File file = this.getImplementationFile(rDFSNamedClass);
        FileWriter fileWriter = new FileWriter(file);
        PrintWriter printWriter = new PrintWriter(fileWriter);
        this.printImplementationCode(printWriter, rDFSNamedClass);
        fileWriter.close();
        if (this.options.getAbstractMode()) {
            this.createUserImplementation(rDFSNamedClass);
        }
    }

    public void createUserImplementation(RDFSNamedClass rDFSNamedClass) throws IOException {
        String string = this.getImplementationName(rDFSNamedClass);
        File file = this.getImplementationFile(string);
        if (!file.exists()) {
            FileWriter fileWriter = new FileWriter(file);
            PrintWriter printWriter = new PrintWriter(fileWriter);
            this.printUserImplementationCode(printWriter, rDFSNamedClass);
            fileWriter.close();
        }
    }

    public void printImplementationCode(PrintWriter printWriter, RDFSNamedClass rDFSNamedClass) {
        boolean bl;
        RDFSClassCode rDFSClassCode = new RDFSClassCode(rDFSNamedClass, this.options.getPrefixMode());
        boolean bl2 = bl = this.hasMultipleSuperclasses(rDFSNamedClass);
        if (this.options.getPackage() != null) {
            printWriter.println("package " + this.options.getPackage() + ".impl;");
        } else {
            printWriter.println("package impl;");
        }
        printWriter.println();
        printWriter.println("import edu.stanford.smi.protege.model.FrameID;");
        printWriter.println("import edu.stanford.smi.protegex.owl.model.*;");
        printWriter.println("import edu.stanford.smi.protegex.owl.model.impl.*;");
        printWriter.println("import edu.stanford.smi.protegex.owl.javacode.AbstractCodeGeneratorIndividual;");
        this.perhapsAddImportJavaUtil(rDFSClassCode, printWriter, bl);
        String string = this.options.getPackage();
        if (string != null) {
            printWriter.println("import " + string + "." + this.getInterfaceNamePossiblyAbstract(rDFSNamedClass) + ";");
            printWriter.println("import " + string + ".*;");
            printWriter.println();
        }
        printWriter.println("/**");
        printWriter.println(" * Generated by Protege-OWL  (http://protege.stanford.edu/plugins/owl).");
        printWriter.println(" * Source OWL Class: " + rDFSNamedClass.getURI());
        printWriter.println(" *");
        printWriter.println(" * @version generated on " + new Date());
        printWriter.println(" */");
        String string2 = this.getImplementationNamePossiblyAbstract(rDFSNamedClass);
        printWriter.println("public class " + string2 + this.getImplementationExtendsCode(rDFSNamedClass));
        printWriter.println("         implements " + this.getInterfaceNamePossiblyAbstract(rDFSNamedClass) + " {");
        this.printConstructors(printWriter, string2);
        Iterator iterator = rDFSClassCode.getPropertyCodes(bl).iterator();
        while (iterator.hasNext()) {
            printWriter.println();
            printWriter.println();
            RDFPropertyAtClassCode rDFPropertyAtClassCode = (RDFPropertyAtClassCode)iterator.next();
            this.printImplementationPropertyCode(printWriter, rDFPropertyAtClassCode);
        }
        printWriter.println("}");
    }

    public void printUserImplementationCode(PrintWriter printWriter, RDFSNamedClass rDFSNamedClass) {
        if (this.options.getPackage() != null) {
            printWriter.println("package " + this.options.getPackage() + ".impl;");
        } else {
            printWriter.println("package impl;");
        }
        printWriter.println();
        printWriter.println("import edu.stanford.smi.protege.model.FrameID;");
        printWriter.println("import edu.stanford.smi.protegex.owl.model.*;");
        printWriter.println("import edu.stanford.smi.protegex.owl.model.impl.*;");
        printWriter.println("import edu.stanford.smi.protegex.owl.javacode.AbstractCodeGeneratorIndividual;");
        String string = this.options.getPackage();
        if (string != null) {
            printWriter.println("import " + string + ".*;");
            printWriter.println();
        }
        String string2 = this.getImplementationName(rDFSNamedClass);
        printWriter.println("public class " + string2 + " extends " + this.getImplementationNamePossiblyAbstract(rDFSNamedClass));
        printWriter.println("         implements " + this.getInterfaceName(rDFSNamedClass) + " {");
        this.printConstructors(printWriter, string2);
        printWriter.println("}");
    }

    private void printConstructors(PrintWriter printWriter, String string) {
        printWriter.println();
        printWriter.println("    public " + string + "(OWLModel owlModel, FrameID id) {");
        printWriter.println("        super(owlModel, id);");
        printWriter.println("    }");
        printWriter.println();
        printWriter.println();
        printWriter.println("    public " + string + "() {");
        printWriter.println("    }");
    }

    private String getImplementationExtendsCode(RDFSNamedClass rDFSNamedClass) {
        String string = " extends ";
        String string2 = this.getBaseImplementation(rDFSNamedClass);
        if (string2 == null) {
            return string + "AbstractCodeGeneratorIndividual";
        }
        return string + string2;
    }

    public void createInterface(RDFSNamedClass rDFSNamedClass) throws IOException {
        File file = this.getInterfaceFile(rDFSNamedClass);
        FileWriter fileWriter = new FileWriter(file);
        PrintWriter printWriter = new PrintWriter(fileWriter);
        this.printInterfaceCode(printWriter, rDFSNamedClass);
        fileWriter.close();
        if (this.options.getAbstractMode()) {
            this.createUserInterface(rDFSNamedClass);
        }
    }

    private void createUserInterface(RDFSNamedClass rDFSNamedClass) throws IOException {
        String string = this.getInterfaceName(rDFSNamedClass);
        File file = this.getInterfaceFile(string);
        if (!file.exists()) {
            FileWriter fileWriter = new FileWriter(file);
            PrintWriter printWriter = new PrintWriter(fileWriter);
            this.printUserInterfaceCode(printWriter, rDFSNamedClass);
            fileWriter.close();
        }
    }

    public void printInterfaceCode(PrintWriter printWriter, RDFSNamedClass rDFSNamedClass) {
        RDFSClassCode rDFSClassCode = new RDFSClassCode(rDFSNamedClass, this.options.getPrefixMode());
        this.printInterfacePackageStatement(printWriter);
        printWriter.println("import edu.stanford.smi.protegex.owl.model.*;");
        printWriter.println();
        this.perhapsAddImportJavaUtil(rDFSClassCode, printWriter, false);
        printWriter.println("/**");
        printWriter.println(" * Generated by Protege-OWL  (http://protege.stanford.edu/plugins/owl).");
        printWriter.println(" * Source OWL Class: " + rDFSNamedClass.getURI());
        printWriter.println(" *");
        printWriter.println(" * @version generated on " + new Date());
        printWriter.println(" */");
        printWriter.println("public interface " + this.getInterfaceNamePossiblyAbstract(rDFSNamedClass) + this.getInterfaceExtendsCode(rDFSNamedClass) + " {");
        Iterator iterator = rDFSClassCode.getPropertyCodes(false).iterator();
        while (iterator.hasNext()) {
            RDFPropertyAtClassCode rDFPropertyAtClassCode = (RDFPropertyAtClassCode)iterator.next();
            this.createInterfacePropertyCode(printWriter, rDFPropertyAtClassCode);
            if (!iterator.hasNext()) continue;
            printWriter.println();
        }
        printWriter.println("}");
    }

    private void printInterfacePackageStatement(PrintWriter printWriter) {
        if (this.options.getPackage() != null) {
            printWriter.println("package " + this.options.getPackage() + ";");
            printWriter.println();
        }
    }

    public void printUserInterfaceCode(PrintWriter printWriter, RDFSNamedClass rDFSNamedClass) {
        this.printInterfacePackageStatement(printWriter);
        printWriter.println("public interface " + this.getInterfaceName(rDFSNamedClass) + " extends " + this.getInterfaceNamePossiblyAbstract(rDFSNamedClass) + " {");
        printWriter.println("}");
    }

    private String getInterfaceExtendsCode(RDFSNamedClass rDFSNamedClass) {
        String string = " extends ";
        String string2 = this.getBaseInterface(rDFSNamedClass);
        if (string2 == null) {
            return string + "RDFIndividual";
        }
        return string + string2;
    }

    public void printImplementationPropertyCode(PrintWriter printWriter, RDFPropertyAtClassCode rDFPropertyAtClassCode) {
        String string;
        String string2;
        RDFProperty rDFProperty = rDFPropertyAtClassCode.getRDFProperty();
        String string3 = rDFPropertyAtClassCode.getUpperCaseJavaName();
        String string4 = this.getJavaTypeName(rDFPropertyAtClassCode);
        String string5 = rDFPropertyAtClassCode.getJavaType();
        boolean bl = rDFPropertyAtClassCode.isMultiple();
        String string6 = "get" + string3 + "Property()";
        printWriter.println();
        printWriter.println("    // Property " + rDFProperty.getURI());
        printWriter.println();
        printWriter.println("    public " + string4 + " get" + string3 + "() {");
        if (bl) {
            if (this.options.getSetMode()) {
                if (rDFPropertyAtClassCode.isCustomType()) {
                    printWriter.println("        return new HashSet(getPropertyValuesAs(" + string6 + ", " + string5 + ".class));");
                } else {
                    printWriter.println("        return new HashSet(getPropertyValues(" + string6 + "));");
                }
            } else if (rDFPropertyAtClassCode.isCustomType()) {
                printWriter.println("        return getPropertyValuesAs(" + string6 + ", " + string5 + ".class);");
            } else {
                printWriter.println("        return getPropertyValues(" + string6 + ");");
            }
        } else if (rDFPropertyAtClassCode.isPrimitive()) {
            string2 = "" + Character.toUpperCase(string4.charAt(0)) + string4.substring(1);
            printWriter.println("        return getPropertyValueLiteral(" + string6 + ").get" + string2 + "();");
        } else if (rDFPropertyAtClassCode.isCustomType()) {
            printWriter.println("        return (" + string4 + ") getPropertyValueAs(" + string6 + ", " + string5 + ".class);");
        } else {
            printWriter.println("        return (" + string4 + ") getPropertyValue(" + string6 + ");");
        }
        printWriter.println("    }");
        printWriter.println();
        printWriter.println();
        printWriter.println("    public RDFProperty get" + string3 + "Property() {");
        printWriter.println("        final String uri = \"" + rDFProperty.getURI() + "\";");
        printWriter.println("        final String name = getOWLModel().getResourceNameForURI(uri);");
        printWriter.println("        return getOWLModel().getRDFProperty(name);");
        printWriter.println("    }");
        printWriter.println();
        printWriter.println();
        printWriter.println("    public boolean has" + string3 + "() {");
        printWriter.println("        return getPropertyValueCount(" + string6 + ") > 0;");
        printWriter.println("    }");
        string2 = "new" + string3;
        if (bl) {
            printWriter.println();
            printWriter.println();
            printWriter.println("    public Iterator list" + string3 + "() {");
            if (rDFPropertyAtClassCode.isCustomType()) {
                printWriter.println("        return listPropertyValuesAs(" + string6 + ", " + string5 + ".class);");
            } else {
                printWriter.println("        return listPropertyValues(" + string6 + ");");
            }
            printWriter.println("    }");
            printWriter.println();
            printWriter.println();
            printWriter.println("    public void add" + string3 + "(" + string5 + " " + string2 + ") {");
            printWriter.println("        addPropertyValue(" + string6 + ", " + string2 + ");");
            printWriter.println("    }");
            printWriter.println();
            printWriter.println();
            string = "old" + string3;
            printWriter.println("    public void remove" + string3 + "(" + string5 + " " + string + ") {");
            printWriter.println("        removePropertyValue(" + string6 + ", " + string + ");");
            printWriter.println("    }");
        }
        printWriter.println();
        printWriter.println();
        printWriter.println("    public void set" + string3 + "(" + string4 + " " + string2 + ") {");
        if (bl) {
            printWriter.println("        setPropertyValues(" + string6 + ", " + string2 + ");");
        } else if (rDFPropertyAtClassCode.isPrimitive()) {
            string = null;
            string = "int".equals(string4) ? "java.lang.Integer" : ("boolean".equals(string4) ? "java.lang.Boolean" : "java.lang.Float");
            printWriter.println("        setPropertyValue(" + string6 + ", new " + string + "(" + string2 + "));");
        } else {
            printWriter.println("        setPropertyValue(" + string6 + ", " + string2 + ");");
        }
        printWriter.println("    }");
    }

    public void createInterfacePropertyCode(PrintWriter printWriter, RDFPropertyAtClassCode rDFPropertyAtClassCode) {
        RDFProperty rDFProperty = rDFPropertyAtClassCode.getRDFProperty();
        String string = rDFPropertyAtClassCode.getUpperCaseJavaName();
        String string2 = this.getJavaTypeName(rDFPropertyAtClassCode);
        printWriter.println();
        printWriter.println("    // Property " + rDFProperty.getURI());
        printWriter.println();
        printWriter.println("    " + string2 + " get" + string + "();");
        printWriter.println();
        printWriter.println("    RDFProperty get" + string + "Property();");
        printWriter.println();
        printWriter.println("    boolean has" + string + "();");
        if (rDFPropertyAtClassCode.isMultiple()) {
            String string3 = rDFPropertyAtClassCode.getJavaType();
            printWriter.println();
            printWriter.println("    Iterator list" + string + "();");
            printWriter.println();
            printWriter.println("    void add" + string + "(" + string3 + " new" + string + ");");
            printWriter.println();
            printWriter.println("    void remove" + string + "(" + string3 + " old" + string + ");");
        }
        printWriter.println();
        printWriter.println("    void set" + string + "(" + string2 + " new" + string + ");");
    }

    private String getJavaTypeName(RDFPropertyAtClassCode rDFPropertyAtClassCode) {
        if (rDFPropertyAtClassCode.isMultiple()) {
            return this.options.getSetMode() ? "Set" : "Collection";
        }
        return rDFPropertyAtClassCode.getJavaType();
    }

    public String getBaseImplementation(RDFSNamedClass rDFSNamedClass) {
        String string = "";
        for (RDFSClass rDFSClass : rDFSNamedClass.getSuperclasses(false)) {
            String string2 = this.getSystemJavaClass(rDFSClass);
            if (string2 != null) {
                return "Default" + string2;
            }
            if (!(rDFSClass instanceof RDFSNamedClass) || this.owlModel.getOWLThingClass().equals(rDFSClass)) continue;
            if (string.equals("")) {
                string = this.getImplementationName((RDFSNamedClass)rDFSClass);
                continue;
            }
            return null;
        }
        if (string.equals("")) {
            return null;
        }
        return string;
    }

    public String getBaseInterface(RDFSNamedClass rDFSNamedClass) {
        String string = "";
        for (RDFSClass rDFSClass : rDFSNamedClass.getSuperclasses(false)) {
            String string2 = this.getSystemJavaClass(rDFSClass);
            if (string2 != null) {
                return string2;
            }
            if (!(rDFSClass instanceof RDFSNamedClass) || this.owlModel.getOWLThingClass().equals(rDFSClass)) continue;
            string = string + (string.equals("") ? "" : ", ") + this.getInterfaceName((RDFSNamedClass)rDFSClass);
        }
        if (string.equals("")) {
            return rDFSNamedClass.getProtegeType() instanceof OWLNamedClass ? "OWLIndividual" : "RDFIndividual";
        }
        return string;
    }

    public File getImplementationFile(RDFSNamedClass rDFSNamedClass) {
        String string = this.getImplementationNamePossiblyAbstract(rDFSNamedClass);
        return this.getImplementationFile(string);
    }

    private File getImplementationFile(String string) {
        String string2 = this.options.getPackage();
        string2 = string2 != null ? string2.replace('.', '/') + "/" : "";
        return new File(this.options.getOutputFolder(), string2 + "impl/" + string + ".java");
    }

    public String getImplementationName(RDFSNamedClass rDFSNamedClass) {
        return "Default" + this.getInterfaceName(rDFSNamedClass);
    }

    public String getImplementationNamePossiblyAbstract(RDFSNamedClass rDFSNamedClass) {
        return "Default" + this.getInterfaceNamePossiblyAbstract(rDFSNamedClass);
    }

    public File getInterfaceFile(RDFSNamedClass rDFSNamedClass) {
        String string = this.getInterfaceNamePossiblyAbstract(rDFSNamedClass);
        return this.getInterfaceFile(string);
    }

    private File getInterfaceFile(String string) {
        String string2 = this.options.getPackage();
        string2 = string2 != null ? string2.replace('.', '/') + "/" : "";
        return new File(this.options.getOutputFolder(), string2 + string + ".java");
    }

    public String getInterfaceNamePossiblyAbstract(RDFSNamedClass rDFSNamedClass) {
        String string = new RDFSClassCode(rDFSNamedClass, this.options.getPrefixMode()).getJavaName();
        if (this.options.getAbstractMode()) {
            string = string + "_";
        }
        return string;
    }

    public String getInterfaceName(RDFSNamedClass rDFSNamedClass) {
        return new RDFSClassCode(rDFSNamedClass, this.options.getPrefixMode()).getJavaName();
    }

    private String getSystemJavaClass(RDFSClass rDFSClass) {
        if (rDFSClass.equals(this.owlModel.getOWLObjectPropertyClass())) {
            return "OWLObjectProperty";
        }
        if (rDFSClass.equals(this.owlModel.getOWLDatatypePropertyClass())) {
            return "OWLDatatypeProperty";
        }
        if (rDFSClass.equals(this.owlModel.getRDFPropertyClass())) {
            return "RDFProperty";
        }
        if (rDFSClass.equals(this.owlModel.getOWLNamedClassClass())) {
            return "OWLNamedClass";
        }
        if (rDFSClass.equals(this.owlModel.getRDFSNamedClassClass())) {
            return "RDFSNamedClass";
        }
        return null;
    }

    public static String getValidJavaName(String string) {
        for (int i = 1; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (Character.isJavaIdentifierPart(c)) continue;
            string = string.replace(c, '_');
        }
        return string;
    }

    private void perhapsAddImportJavaUtil(RDFSClassCode rDFSClassCode, PrintWriter printWriter, boolean bl) {
        for (RDFPropertyAtClassCode rDFPropertyAtClassCode : rDFSClassCode.getPropertyCodes(bl)) {
            if (!rDFPropertyAtClassCode.isMultiple()) continue;
            printWriter.println("import java.util.*;");
            printWriter.println();
            return;
        }
    }

    public boolean hasMultipleSuperclasses(RDFSNamedClass rDFSNamedClass) {
        boolean bl = false;
        for (RDFSClass rDFSClass : rDFSNamedClass.getSuperclasses(false)) {
            String string = this.getSystemJavaClass(rDFSClass);
            if (string != null) {
                return false;
            }
            if (!(rDFSClass instanceof RDFSNamedClass) || this.owlModel.getOWLThingClass().equals(rDFSClass)) continue;
            if (!bl) {
                bl = true;
                continue;
            }
            return true;
        }
        return false;
    }

    static {
        primitiveTypesMap.put(Integer.class, Integer.TYPE);
        primitiveTypesMap.put(Float.class, Float.TYPE);
        primitiveTypesMap.put(Boolean.class, Boolean.TYPE);
    }
}

