/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.inference.reasoner;

import edu.stanford.smi.protege.event.ProjectAdapter;
import edu.stanford.smi.protege.event.ProjectEvent;
import edu.stanford.smi.protege.event.ProjectListener;
import edu.stanford.smi.protege.util.Log;
import edu.stanford.smi.protegex.owl.inference.protegeowl.log.ReasonerLogRecordFactory;
import edu.stanford.smi.protegex.owl.inference.protegeowl.log.ReasonerLogger;
import edu.stanford.smi.protegex.owl.inference.protegeowl.task.ReasonerTask;
import edu.stanford.smi.protegex.owl.inference.protegeowl.task.ReasonerTaskAdapter;
import edu.stanford.smi.protegex.owl.inference.protegeowl.task.ReasonerTaskEvent;
import edu.stanford.smi.protegex.owl.inference.protegeowl.task.ReasonerTaskListener;
import edu.stanford.smi.protegex.owl.inference.protegeowl.task.protegereasoner.ClassifyTaxonomyTask;
import edu.stanford.smi.protegex.owl.inference.protegeowl.task.protegereasoner.SynchronizeReasonerTask;
import edu.stanford.smi.protegex.owl.inference.protegeowl.task.protegereasoner.UpdateInconsistentClassesTask;
import edu.stanford.smi.protegex.owl.inference.protegeowl.task.protegereasoner.UpdateInferredHierarchyTask;
import edu.stanford.smi.protegex.owl.inference.protegeowl.task.protegereasoner.UpdateInferredTypesTask;
import edu.stanford.smi.protegex.owl.inference.reasoner.ProtegeReasoner;
import edu.stanford.smi.protegex.owl.inference.reasoner.exception.ProtegeReasonerException;
import edu.stanford.smi.protegex.owl.inference.util.TimeDifference;
import edu.stanford.smi.protegex.owl.model.OWLClass;
import edu.stanford.smi.protegex.owl.model.OWLDatatypeProperty;
import edu.stanford.smi.protegex.owl.model.OWLIndividual;
import edu.stanford.smi.protegex.owl.model.OWLModel;
import edu.stanford.smi.protegex.owl.model.OWLObjectProperty;
import edu.stanford.smi.protegex.owl.model.OWLProperty;
import edu.stanford.smi.protegex.owl.model.RDFProperty;
import edu.stanford.smi.protegex.owl.model.RDFResource;
import edu.stanford.smi.protegex.owl.model.RDFSClass;
import edu.stanford.smi.protegex.owl.model.event.ClassAdapter;
import edu.stanford.smi.protegex.owl.model.event.ClassListener;
import edu.stanford.smi.protegex.owl.model.event.ModelAdapter;
import edu.stanford.smi.protegex.owl.model.event.ModelListener;
import edu.stanford.smi.protegex.owl.model.event.PropertyAdapter;
import edu.stanford.smi.protegex.owl.model.event.PropertyListener;
import edu.stanford.smi.protegex.owl.model.event.PropertyValueAdapter;
import edu.stanford.smi.protegex.owl.model.event.PropertyValueListener;
import edu.stanford.smi.protegex.owl.model.event.ResourceAdapter;
import edu.stanford.smi.protegex.owl.model.event.ResourceListener;
import java.util.Collection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractProtegeReasoner
implements ProtegeReasoner {
    protected OWLModel owlModel;
    protected ReasonerTaskListener reasonerTaskListener;
    protected boolean synchronizeReasoner = true;
    protected boolean autoSynchReasoner = true;
    protected ModelListener modelListener;
    protected ResourceListener resourceAdapter;
    protected PropertyListener propertyListener;
    protected ClassListener classListener;
    protected PropertyValueListener propertyValueListener;
    protected ProjectListener projectListener = this.getProjectListener();

    protected AbstractProtegeReasoner() {
        this.resourceAdapter = this.getResourceListener();
        this.propertyListener = this.getPropertyListener();
        this.classListener = this.getClassListener();
        this.propertyValueListener = this.getPropertyValueListener();
        this.modelListener = this.getModelListener();
    }

    @Override
    public void setReasonerTaskListener(ReasonerTaskListener reasonerTaskListener) {
        this.reasonerTaskListener = reasonerTaskListener;
    }

    @Override
    public ReasonerTaskListener getReasonerTaskListener() {
        return this.reasonerTaskListener;
    }

    @Override
    public void setOWLModel(OWLModel oWLModel) {
        if (this.owlModel != null) {
            this.removeListeners();
            try {
                this.reset();
            }
            catch (Throwable throwable) {
                Log.getLogger().warning("Error at releasing old knowledgebase " + oWLModel + " from reasoner. " + "Error message: " + throwable.getMessage());
            }
        }
        this.owlModel = oWLModel;
        this.forceReasonerReSynchronization();
        this.addListeners();
    }

    public void dispose() {
        this.removeListeners();
    }

    @Override
    public void initialize() {
    }

    @Override
    public void rebind() {
        this.reset();
        this.setOWLModel(this.owlModel);
    }

    @Override
    public void classifyTaxonomy() throws ProtegeReasonerException {
        ClassifyTaxonomyTask classifyTaxonomyTask = new ClassifyTaxonomyTask(this);
        this.performTask(classifyTaxonomyTask);
    }

    @Override
    public void computeInferredHierarchy() throws ProtegeReasonerException {
        UpdateInferredHierarchyTask updateInferredHierarchyTask = new UpdateInferredHierarchyTask(this);
        this.performTask(updateInferredHierarchyTask);
    }

    @Override
    public void computeInconsistentConcepts() throws ProtegeReasonerException {
        UpdateInconsistentClassesTask updateInconsistentClassesTask = new UpdateInconsistentClassesTask(this);
        this.performTask(updateInconsistentClassesTask);
    }

    @Override
    public void computeInferredIndividualTypes() throws ProtegeReasonerException {
        UpdateInferredTypesTask updateInferredTypesTask = new UpdateInferredTypesTask(this);
        this.performTask(updateInferredTypesTask);
    }

    @Override
    public void computeEquivalentConcepts() throws ProtegeReasonerException {
        throw new ProtegeReasonerException("Operation not supported by this reasoner");
    }

    @Override
    public Collection<OWLClass> getEquivalentClasses(OWLClass oWLClass) throws ProtegeReasonerException {
        throw new ProtegeReasonerException("Operation not supported by this reasoner");
    }

    @Override
    public Collection<OWLClass> getAncestorClasses(OWLClass oWLClass) throws ProtegeReasonerException {
        throw new ProtegeReasonerException("Operation not supported by this reasoner");
    }

    @Override
    public Collection<OWLClass> getDescendantClasses(OWLClass oWLClass) throws ProtegeReasonerException {
        throw new ProtegeReasonerException("Operation not supported by this reasoner");
    }

    @Override
    public Collection<OWLClass> getIndividualTypes(OWLIndividual oWLIndividual) throws ProtegeReasonerException {
        throw new ProtegeReasonerException("Operation not supported by this reasoner");
    }

    @Override
    public Collection<OWLClass> getIndividualDirectTypes(OWLIndividual oWLIndividual) throws ProtegeReasonerException {
        throw new ProtegeReasonerException("Operation not supported by this reasoner");
    }

    @Override
    public Collection<OWLIndividual> getIndividualsBelongingToClass(OWLClass oWLClass) throws ProtegeReasonerException {
        throw new ProtegeReasonerException("Operation not supported by this reasoner");
    }

    @Override
    public OWLModel getOWLModel() {
        return this.owlModel;
    }

    @Override
    public Collection<OWLIndividual> getRelatedIndividuals(OWLIndividual oWLIndividual, OWLObjectProperty oWLObjectProperty) throws ProtegeReasonerException {
        throw new ProtegeReasonerException("Operation not supported by this reasoner");
    }

    @Override
    public Collection getRelatedValues(OWLIndividual oWLIndividual, OWLDatatypeProperty oWLDatatypeProperty) throws ProtegeReasonerException {
        throw new ProtegeReasonerException("Operation not supported by this reasoner");
    }

    @Override
    public Collection<OWLClass> getSubclasses(OWLClass oWLClass) throws ProtegeReasonerException {
        throw new ProtegeReasonerException("Operation not supported by this reasoner");
    }

    public int getSubsumptionRelationship(OWLClass oWLClass, OWLClass oWLClass2) throws ProtegeReasonerException {
        throw new ProtegeReasonerException("Operation not supported by this reasoner");
    }

    @Override
    public Collection<OWLClass> getSuperclasses(OWLClass oWLClass) throws ProtegeReasonerException {
        throw new ProtegeReasonerException("Operation not supported by this reasoner");
    }

    public Collection<OWLClass> getSuperclassesOfIntersection(OWLClass[] oWLClassArray) throws ProtegeReasonerException {
        throw new ProtegeReasonerException("Operation not supported by this reasoner");
    }

    @Override
    public Collection<OWLProperty> getSubProperties(OWLProperty oWLProperty) throws ProtegeReasonerException {
        throw new ProtegeReasonerException("Operation not supported by this reasoner");
    }

    @Override
    public Collection<OWLProperty> getSuperProperties(OWLProperty oWLProperty) throws ProtegeReasonerException {
        throw new ProtegeReasonerException("Operation not supported by this reasoner");
    }

    @Override
    public Collection<OWLProperty> getAncestorProperties(OWLProperty oWLProperty) throws ProtegeReasonerException {
        throw new ProtegeReasonerException("Operation not supported by this reasoner");
    }

    @Override
    public Collection<OWLProperty> getDescendantProperties(OWLProperty oWLProperty) throws ProtegeReasonerException {
        throw new ProtegeReasonerException("Operation not supported by this reasoner");
    }

    @Override
    public boolean isDisjointTo(OWLClass oWLClass, OWLClass oWLClass2) throws ProtegeReasonerException {
        throw new ProtegeReasonerException("Operation not supported by this reasoner");
    }

    @Override
    public boolean isIntersectionSatisfiable(OWLClass[] oWLClassArray) throws ProtegeReasonerException {
        throw new ProtegeReasonerException("Operation not supported by this reasoner");
    }

    @Override
    public boolean isSatisfiable(OWLClass oWLClass) throws ProtegeReasonerException {
        throw new ProtegeReasonerException("Operation not supported by this reasoner");
    }

    @Override
    public boolean isSubsumedBy(OWLClass oWLClass, OWLClass oWLClass2) throws ProtegeReasonerException {
        throw new ProtegeReasonerException("Operation not supported by this reasoner");
    }

    public void performTask(ReasonerTask reasonerTask) throws ProtegeReasonerException {
        this.performTask(reasonerTask, this.reasonerTaskListener);
    }

    public void performTask(ReasonerTask reasonerTask, ReasonerTaskListener reasonerTaskListener) throws ProtegeReasonerException {
        TimeDifference timeDifference = new TimeDifference();
        timeDifference.markStart();
        final ReasonerTaskListener reasonerTaskListener2 = reasonerTaskListener;
        ReasonerTaskAdapter reasonerTaskAdapter = reasonerTaskListener != null ? new ReasonerTaskAdapter(){

            public void addedToTask(ReasonerTaskEvent reasonerTaskEvent) {
                reasonerTaskListener2.addedToTask(reasonerTaskEvent);
            }

            public void progressChanged(ReasonerTaskEvent reasonerTaskEvent) {
                reasonerTaskListener2.progressChanged(reasonerTaskEvent);
            }

            public void progressIndeterminateChanged(ReasonerTaskEvent reasonerTaskEvent) {
                reasonerTaskListener2.progressIndeterminateChanged(reasonerTaskEvent);
            }

            public void descriptionChanged(ReasonerTaskEvent reasonerTaskEvent) {
                reasonerTaskListener2.descriptionChanged(reasonerTaskEvent);
            }

            public void messageChanged(ReasonerTaskEvent reasonerTaskEvent) {
                reasonerTaskListener2.messageChanged(reasonerTaskEvent);
            }

            public void taskFailed(ReasonerTaskEvent reasonerTaskEvent) {
                reasonerTaskListener2.taskFailed(reasonerTaskEvent);
            }
        } : new ReasonerTaskAdapter();
        this.synchronizeReasoner(reasonerTaskAdapter);
        if (reasonerTaskListener != null) {
            reasonerTask.addTaskListener(reasonerTaskListener);
        }
        try {
            reasonerTask.run();
        }
        catch (ProtegeReasonerException protegeReasonerException) {
            this.reset();
            this.synchronizeReasoner = true;
            ReasonerLogger.getInstance().postLogRecord(ReasonerLogRecordFactory.getInstance().createErrorMessageLogRecord(protegeReasonerException.getMessage(), null));
            reasonerTask.setRequestAbort();
            throw protegeReasonerException;
        }
        finally {
            if (reasonerTaskListener != null) {
                reasonerTask.removeTaskListener(reasonerTaskListener);
            }
        }
        timeDifference.markEnd();
        ReasonerLogger.getInstance().postLogRecord(ReasonerLogRecordFactory.getInstance().createInformationMessageLogRecord("Total time: " + timeDifference, null));
    }

    protected void removeListeners() {
        if (this.owlModel == null) {
            return;
        }
        this.owlModel.removeModelListener(this.modelListener);
        this.owlModel.removeResourceListener(this.resourceAdapter);
        this.owlModel.removePropertyListener(this.propertyListener);
        this.owlModel.removeClassListener(this.classListener);
        this.owlModel.removePropertyValueListener(this.propertyValueListener);
        this.owlModel.getProject().removeProjectListener(this.projectListener);
    }

    protected void addListeners() {
        if (this.owlModel == null) {
            return;
        }
        this.owlModel.getProject().addProjectListener(this.projectListener);
        this.owlModel.addModelListener(this.modelListener);
        this.owlModel.addResourceListener(this.resourceAdapter);
        this.owlModel.addPropertyListener(this.propertyListener);
        this.owlModel.addClassListener(this.classListener);
        this.owlModel.addPropertyValueListener(this.propertyValueListener);
    }

    protected ClassListener getClassListener() {
        this.classListener = new ClassAdapter(){

            public void addedToUnionDomainOf(RDFSClass rDFSClass, RDFProperty rDFProperty) {
                AbstractProtegeReasoner.this.reactToKnowledgeBaseChange();
            }

            public void instanceAdded(RDFSClass rDFSClass, RDFResource rDFResource) {
                AbstractProtegeReasoner.this.reactToKnowledgeBaseChange();
            }

            public void instanceRemoved(RDFSClass rDFSClass, RDFResource rDFResource) {
                AbstractProtegeReasoner.this.reactToKnowledgeBaseChange();
            }

            public void removedFromUnionDomainOf(RDFSClass rDFSClass, RDFProperty rDFProperty) {
                AbstractProtegeReasoner.this.reactToKnowledgeBaseChange();
            }

            public void subclassAdded(RDFSClass rDFSClass, RDFSClass rDFSClass2) {
                AbstractProtegeReasoner.this.reactToKnowledgeBaseChange();
            }

            public void subclassRemoved(RDFSClass rDFSClass, RDFSClass rDFSClass2) {
                AbstractProtegeReasoner.this.reactToKnowledgeBaseChange();
            }

            public void superclassAdded(RDFSClass rDFSClass, RDFSClass rDFSClass2) {
                AbstractProtegeReasoner.this.reactToKnowledgeBaseChange();
            }

            public void superclassRemoved(RDFSClass rDFSClass, RDFSClass rDFSClass2) {
                AbstractProtegeReasoner.this.reactToKnowledgeBaseChange();
            }
        };
        return this.classListener;
    }

    protected PropertyListener getPropertyListener() {
        this.propertyListener = new PropertyAdapter(){

            public void subpropertyAdded(RDFProperty rDFProperty, RDFProperty rDFProperty2) {
                AbstractProtegeReasoner.this.reactToKnowledgeBaseChange();
            }

            public void subpropertyRemoved(RDFProperty rDFProperty, RDFProperty rDFProperty2) {
                AbstractProtegeReasoner.this.reactToKnowledgeBaseChange();
            }

            public void superpropertyAdded(RDFProperty rDFProperty, RDFProperty rDFProperty2) {
                AbstractProtegeReasoner.this.reactToKnowledgeBaseChange();
            }

            public void superpropertyRemoved(RDFProperty rDFProperty, RDFProperty rDFProperty2) {
                AbstractProtegeReasoner.this.reactToKnowledgeBaseChange();
            }

            public void unionDomainClassAdded(RDFProperty rDFProperty, RDFSClass rDFSClass) {
                AbstractProtegeReasoner.this.reactToKnowledgeBaseChange();
            }

            public void unionDomainClassRemoved(RDFProperty rDFProperty, RDFSClass rDFSClass) {
                AbstractProtegeReasoner.this.reactToKnowledgeBaseChange();
            }
        };
        return this.propertyListener;
    }

    protected PropertyValueListener getPropertyValueListener() {
        this.propertyValueListener = new PropertyValueAdapter(){

            public void nameChanged(RDFResource rDFResource, String string) {
                AbstractProtegeReasoner.this.reactToKnowledgeBaseChange();
            }

            public void propertyValueChanged(RDFResource rDFResource, RDFProperty rDFProperty, Collection collection) {
                AbstractProtegeReasoner.this.reactToKnowledgeBaseChange();
            }
        };
        return this.propertyValueListener;
    }

    protected ResourceListener getResourceListener() {
        this.resourceAdapter = new ResourceAdapter(){

            public void typeAdded(RDFResource rDFResource, RDFSClass rDFSClass) {
                AbstractProtegeReasoner.this.reactToKnowledgeBaseChange();
            }

            public void typeRemoved(RDFResource rDFResource, RDFSClass rDFSClass) {
                AbstractProtegeReasoner.this.reactToKnowledgeBaseChange();
            }
        };
        return this.resourceAdapter;
    }

    protected ModelListener getModelListener() {
        this.modelListener = new ModelAdapter(){

            public void classCreated(RDFSClass rDFSClass) {
                AbstractProtegeReasoner.this.reactToKnowledgeBaseChange();
            }

            public void classDeleted(RDFSClass rDFSClass) {
                AbstractProtegeReasoner.this.reactToKnowledgeBaseChange();
            }

            public void propertyCreated(RDFProperty rDFProperty) {
                AbstractProtegeReasoner.this.reactToKnowledgeBaseChange();
            }

            public void propertyDeleted(RDFProperty rDFProperty) {
                AbstractProtegeReasoner.this.reactToKnowledgeBaseChange();
            }

            public void individualCreated(RDFResource rDFResource) {
                AbstractProtegeReasoner.this.reactToKnowledgeBaseChange();
            }

            public void individualDeleted(RDFResource rDFResource) {
                AbstractProtegeReasoner.this.reactToKnowledgeBaseChange();
            }

            public void resourceReplaced(RDFResource rDFResource, RDFResource rDFResource2, String string) {
                AbstractProtegeReasoner.this.reactToKnowledgeBaseChange();
            }
        };
        return this.modelListener;
    }

    protected ProjectListener getProjectListener() {
        this.projectListener = new ProjectAdapter(){

            public void projectClosed(ProjectEvent projectEvent) {
                if (AbstractProtegeReasoner.this.owlModel != null) {
                    AbstractProtegeReasoner.this.removeListeners();
                    AbstractProtegeReasoner.this.owlModel = null;
                }
            }
        };
        return this.projectListener;
    }

    protected void synchronizeReasoner(ReasonerTaskListener reasonerTaskListener) throws ProtegeReasonerException {
        if (this.synchronizeReasoner) {
            SynchronizeReasonerTask synchronizeReasonerTask = new SynchronizeReasonerTask(this);
            if (reasonerTaskListener != null) {
                synchronizeReasonerTask.addTaskListener(reasonerTaskListener);
            }
            synchronizeReasonerTask.run();
            if (reasonerTaskListener != null) {
                synchronizeReasonerTask.removeTaskListener(reasonerTaskListener);
            }
            this.synchronizeReasoner = false;
        }
    }

    protected void reactToKnowledgeBaseChange() {
        if (this.autoSynchReasoner) {
            this.forceReasonerReSynchronization();
        }
    }

    @Override
    public void forceReasonerReSynchronization() {
        this.synchronizeReasoner = true;
    }

    @Override
    public void setAutoSynchronizationEnabled(boolean bl) {
        this.autoSynchReasoner = bl;
    }

    @Override
    public boolean isAutoSynchronizationEnabled() {
        return this.autoSynchReasoner;
    }
}

