/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.inference.protegeowl.task.protegereasoner;

import edu.stanford.smi.protege.model.Frame;
import edu.stanford.smi.protege.util.ApplicationProperties;
import edu.stanford.smi.protege.util.Log;
import edu.stanford.smi.protegex.owl.inference.protegeowl.log.ReasonerLogRecord;
import edu.stanford.smi.protegex.owl.inference.protegeowl.log.ReasonerLogRecordFactory;
import edu.stanford.smi.protegex.owl.inference.protegeowl.task.protegereasoner.AbstractReasonerTask;
import edu.stanford.smi.protegex.owl.inference.reasoner.ProtegeReasoner;
import edu.stanford.smi.protegex.owl.inference.reasoner.exception.ProtegeReasonerException;
import edu.stanford.smi.protegex.owl.inference.util.ReasonerUtil;
import edu.stanford.smi.protegex.owl.inference.util.TimeDifference;
import edu.stanford.smi.protegex.owl.model.OWLClass;
import edu.stanford.smi.protegex.owl.model.OWLIndividual;
import edu.stanford.smi.protegex.owl.model.OWLModel;
import edu.stanford.smi.protegex.owl.model.ProtegeNames;
import edu.stanford.smi.protegex.owl.model.RDFProperty;
import edu.stanford.smi.protegex.owl.model.impl.AbstractOWLModel;
import java.util.Collection;
import java.util.Collections;
import java.util.logging.Level;
import java.util.logging.Logger;

public class UpdateInferredTypesTask
extends AbstractReasonerTask {
    private static final transient Logger log = Log.getLogger(UpdateInferredTypesTask.class);
    private static final String DISPLAY_DIRECT_TYPES_ONLY = "reasoner.ui.display.direct.types.only";
    private ProtegeReasoner protegeReasoner;
    private boolean isDisplayDirectTypesOnly = false;

    public UpdateInferredTypesTask(ProtegeReasoner protegeReasoner) {
        super(protegeReasoner);
        this.protegeReasoner = protegeReasoner;
        this.isDisplayDirectTypesOnly = this.isDisplayDirectTypesOnly();
    }

    public int getTaskSize() {
        return ReasonerUtil.getInstance().getIndividuals(this.protegeReasoner.getOWLModel()).size();
    }

    public void run() throws ProtegeReasonerException {
        OWLModel oWLModel = this.protegeReasoner.getOWLModel();
        ReasonerLogRecordFactory reasonerLogRecordFactory = ReasonerLogRecordFactory.getInstance();
        ReasonerLogRecord reasonerLogRecord = reasonerLogRecordFactory.createInformationMessageLogRecord("Computing inferred types", null);
        this.postLogRecord(reasonerLogRecord);
        this.setDescription("Computing inferred types");
        this.setMessage("Querying reasoner and updating Protege-OWL...");
        TimeDifference timeDifference = new TimeDifference();
        timeDifference.markStart();
        boolean bl = oWLModel.setGenerateEventsEnabled(false);
        try {
            oWLModel.beginTransaction("Compute and update inferred types");
            RDFProperty rDFProperty = oWLModel.getRDFProperty(ProtegeNames.Slot.INFERRED_TYPE);
            RDFProperty rDFProperty2 = ((AbstractOWLModel)oWLModel).getProtegeClassificationStatusProperty();
            Collection collection = ReasonerUtil.getInstance().getIndividuals(oWLModel);
            for (OWLIndividual oWLIndividual : collection) {
                Collection<OWLClass> collection2;
                if (log.isLoggable(Level.FINE)) {
                    log.fine("Computing Inteffed types for individual: " + oWLIndividual);
                }
                Collection<OWLClass> collection3 = collection2 = this.isDisplayDirectTypesOnly ? this.protegeReasoner.getIndividualDirectTypes(oWLIndividual) : this.protegeReasoner.getIndividualTypes(oWLIndividual);
                if (collection2.size() == 0) {
                    collection2.add(oWLIndividual.getOWLModel().getOWLThingClass());
                }
                Collection collection4 = oWLIndividual.getProtegeTypes();
                oWLModel.setOwnSlotValues((Frame)oWLIndividual, rDFProperty, collection2);
                if (!collection2.containsAll(collection4) && !collection4.containsAll(collection2)) {
                    oWLModel.setOwnSlotValues((Frame)oWLIndividual, rDFProperty2, Collections.singleton(new Integer(3)));
                } else {
                    oWLModel.setOwnSlotValues((Frame)oWLIndividual, rDFProperty2, Collections.singleton(new Integer(1)));
                }
                this.setProgress(this.getProgress() + 1);
                this.doAbortCheck();
            }
            oWLModel.commitTransaction();
        }
        catch (ProtegeReasonerException protegeReasonerException) {
            oWLModel.rollbackTransaction();
            throw protegeReasonerException;
        }
        catch (Exception exception) {
            oWLModel.rollbackTransaction();
            RuntimeException runtimeException = new RuntimeException();
            runtimeException.initCause(exception);
            throw runtimeException;
        }
        finally {
            oWLModel.setGenerateEventsEnabled(bl);
        }
        timeDifference.markEnd();
        this.postLogRecord(ReasonerLogRecordFactory.getInstance().createInformationMessageLogRecord("Time to update Protege-OWL = " + timeDifference, reasonerLogRecord));
        this.setTaskCompleted();
    }

    private boolean isDisplayDirectTypesOnly() {
        return ApplicationProperties.getBooleanProperty((String)DISPLAY_DIRECT_TYPES_ONLY, (boolean)false);
    }
}

