/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.inference.protegeowl.task.protegereasoner;

import edu.stanford.smi.protege.util.Log;
import edu.stanford.smi.protegex.owl.inference.protegeowl.log.ReasonerLogRecord;
import edu.stanford.smi.protegex.owl.inference.protegeowl.log.ReasonerLogRecordFactory;
import edu.stanford.smi.protegex.owl.inference.protegeowl.task.protegereasoner.AbstractReasonerTask;
import edu.stanford.smi.protegex.owl.inference.reasoner.ProtegeReasoner;
import edu.stanford.smi.protegex.owl.inference.reasoner.exception.ProtegeReasonerException;
import edu.stanford.smi.protegex.owl.inference.util.ReasonerUtil;
import edu.stanford.smi.protegex.owl.inference.util.TimeDifference;
import edu.stanford.smi.protegex.owl.model.OWLModel;
import edu.stanford.smi.protegex.owl.model.OWLNamedClass;
import java.util.Collection;
import java.util.logging.Level;

public class UpdateInconsistentClassesTask
extends AbstractReasonerTask {
    private ProtegeReasoner protegeReasoner;

    public UpdateInconsistentClassesTask(ProtegeReasoner protegeReasoner) {
        super(protegeReasoner);
        this.protegeReasoner = protegeReasoner;
    }

    public int getTaskSize() {
        return ReasonerUtil.getInstance().getNamedClses(this.protegeReasoner.getOWLModel()).size();
    }

    public void run() throws ProtegeReasonerException {
        OWLModel oWLModel = this.protegeReasoner.getOWLModel();
        ReasonerLogRecord reasonerLogRecord = ReasonerLogRecordFactory.getInstance().createInformationMessageLogRecord("Check concept consistency", null);
        this.postLogRecord(reasonerLogRecord);
        this.setProgress(0);
        TimeDifference timeDifference = new TimeDifference();
        this.setDescription("Computing inconsistent concepts");
        this.setMessage("Querying reasoner for inconsistent concepts and updating Protege-OWL...");
        ReasonerLogRecord reasonerLogRecord2 = null;
        timeDifference.markStart();
        boolean bl = oWLModel.setGenerateEventsEnabled(false);
        try {
            oWLModel.beginTransaction("Compute and mark inconsistent classes");
            OWLNamedClass oWLNamedClass = oWLModel.getOWLNothing();
            Collection collection = ReasonerUtil.getInstance().getNamedClses(oWLModel);
            for (OWLNamedClass oWLNamedClass2 : collection) {
                this.doAbortCheck();
                boolean bl2 = this.protegeReasoner.isSatisfiable(oWLNamedClass2);
                if (bl2) {
                    oWLNamedClass2.setClassificationStatus(1);
                    oWLNamedClass2.removeInferredSuperclass(oWLNamedClass);
                } else {
                    if (reasonerLogRecord2 == null) {
                        reasonerLogRecord2 = ReasonerLogRecordFactory.getInstance().createInformationMessageLogRecord("Inconsistent concepts", reasonerLogRecord);
                        this.postLogRecord(reasonerLogRecord2);
                    }
                    this.postLogRecord(ReasonerLogRecordFactory.getInstance().createConceptConsistencyLogRecord(oWLNamedClass2, false, reasonerLogRecord2));
                    oWLNamedClass2.setClassificationStatus(2);
                    Collection collection2 = oWLNamedClass2.getInferredSuperclasses();
                    if (!collection2.contains(oWLNamedClass)) {
                        oWLNamedClass2.addInferredSuperclass(oWLNamedClass);
                    }
                }
                this.setProgress(this.getProgress() + 1);
            }
            timeDifference.markEnd();
            this.postLogRecord(ReasonerLogRecordFactory.getInstance().createInformationMessageLogRecord("Time to update Protege-OWL = " + timeDifference, reasonerLogRecord));
            this.setTaskCompleted();
            oWLModel.commitTransaction();
        }
        catch (ProtegeReasonerException protegeReasonerException) {
            oWLModel.rollbackTransaction();
            throw protegeReasonerException;
        }
        catch (Exception exception) {
            Log.getLogger().log(Level.WARNING, "Exception in transaction. Rollback. Exception: " + exception.getMessage(), exception);
            oWLModel.rollbackTransaction();
            RuntimeException runtimeException = new RuntimeException();
            runtimeException.initCause(exception);
            throw runtimeException;
        }
        oWLModel.setGenerateEventsEnabled(bl);
    }
}

