/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.inference.protegeowl.task.protegereasoner;

import edu.stanford.smi.protege.util.Log;
import edu.stanford.smi.protegex.owl.inference.protegeowl.log.ReasonerLogRecord;
import edu.stanford.smi.protegex.owl.inference.protegeowl.log.ReasonerLogRecordFactory;
import edu.stanford.smi.protegex.owl.inference.protegeowl.task.protegereasoner.AbstractReasonerTask;
import edu.stanford.smi.protegex.owl.inference.reasoner.ProtegeReasoner;
import edu.stanford.smi.protegex.owl.inference.reasoner.exception.ProtegeReasonerException;
import edu.stanford.smi.protegex.owl.inference.util.ReasonerUtil;
import edu.stanford.smi.protegex.owl.inference.util.TimeDifference;
import edu.stanford.smi.protegex.owl.model.OWLClass;
import edu.stanford.smi.protegex.owl.model.OWLModel;
import edu.stanford.smi.protegex.owl.model.OWLNamedClass;
import java.util.Collection;

public class UpdateEquivalentClassesTask
extends AbstractReasonerTask {
    private ProtegeReasoner protegeReasoner;

    public UpdateEquivalentClassesTask(ProtegeReasoner protegeReasoner) {
        super(protegeReasoner);
        this.protegeReasoner = protegeReasoner;
    }

    public int getTaskSize() {
        return ReasonerUtil.getInstance().getNamedClses(this.protegeReasoner.getOWLModel()).size();
    }

    public void run() throws ProtegeReasonerException {
        OWLModel oWLModel = this.protegeReasoner.getOWLModel();
        ReasonerLogRecord reasonerLogRecord = ReasonerLogRecordFactory.getInstance().createInformationMessageLogRecord("Compute equivalent classes", null);
        this.doAbortCheck();
        this.postLogRecord(reasonerLogRecord);
        TimeDifference timeDifference = new TimeDifference();
        this.setProgress(0);
        this.setDescription("Computing equivalent classes");
        this.setMessage("Querying reasoner and updating Protege-OWL...");
        timeDifference.markStart();
        boolean bl = oWLModel.setGenerateEventsEnabled(false);
        try {
            oWLModel.beginTransaction("Compute and update equivalent classes");
            Collection collection = ReasonerUtil.getInstance().getNamedClses(oWLModel);
            for (OWLNamedClass oWLNamedClass : collection) {
                this.doAbortCheck();
                if (oWLNamedClass.isConsistent()) {
                    Collection<OWLClass> collection2 = this.protegeReasoner.getEquivalentClasses(oWLNamedClass);
                    for (OWLClass oWLClass : collection2) {
                        OWLNamedClass oWLNamedClass2;
                        if (!oWLClass.isVisible() || !(oWLClass instanceof OWLNamedClass) || (oWLNamedClass2 = (OWLNamedClass)oWLClass).equals(oWLNamedClass)) continue;
                        if (!oWLNamedClass.getInferredSuperclasses().contains(oWLNamedClass2)) {
                            oWLNamedClass.addInferredSuperclass(oWLNamedClass2);
                        }
                        if (!oWLNamedClass2.getInferredSuperclasses().contains(oWLNamedClass)) {
                            oWLNamedClass2.addInferredSuperclass(oWLNamedClass);
                        }
                        oWLNamedClass.setClassificationStatus(3);
                    }
                }
                this.setProgress(this.getProgress() + 1);
            }
            oWLModel.commitTransaction();
        }
        catch (ProtegeReasonerException protegeReasonerException) {
            oWLModel.rollbackTransaction();
            throw protegeReasonerException;
        }
        catch (Exception exception) {
            oWLModel.rollbackTransaction();
            Log.getLogger().warning("Exception in transaction. Rollback. Exception: " + exception.getMessage());
            RuntimeException runtimeException = new RuntimeException();
            runtimeException.initCause(exception);
            throw runtimeException;
        }
        oWLModel.setGenerateEventsEnabled(bl);
        timeDifference.markEnd();
        this.postLogRecord(ReasonerLogRecordFactory.getInstance().createInformationMessageLogRecord("Time to update Protege-OWL = " + timeDifference, reasonerLogRecord));
        this.setTaskCompleted();
    }
}

