/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.inference.protegeowl.task.protegereasoner;

import edu.stanford.smi.protege.util.Log;
import edu.stanford.smi.protegex.owl.inference.dig.exception.DIGReasonerException;
import edu.stanford.smi.protegex.owl.inference.protegeowl.task.protegereasoner.AbstractReasonerTask;
import edu.stanford.smi.protegex.owl.inference.reasoner.ProtegeReasoner;
import edu.stanford.smi.protegex.owl.model.OWLModel;
import edu.stanford.smi.protegex.owl.model.impl.OWLUtil;

public class ResetInferredHierarchyTask
extends AbstractReasonerTask {
    private ProtegeReasoner protegeReasoner;

    public ResetInferredHierarchyTask(ProtegeReasoner protegeReasoner) {
        super(protegeReasoner);
        this.protegeReasoner = protegeReasoner;
    }

    public int getTaskSize() {
        return 1;
    }

    public void run() throws DIGReasonerException {
        this.setDescription("Resetting inferred hierarchy");
        this.setMessage("Clearing...");
        this.setProgressIndeterminate(true);
        OWLModel oWLModel = this.protegeReasoner.getOWLModel();
        boolean bl = oWLModel.setGenerateEventsEnabled(false);
        try {
            oWLModel.beginTransaction("Reset inferred hierarchy");
            OWLUtil.resetComputedSuperclasses(oWLModel);
            oWLModel.commitTransaction();
        }
        catch (Exception exception) {
            oWLModel.rollbackTransaction();
            Log.getLogger().warning("Exception in transaction. Rollback. Exception: " + exception.getMessage());
            RuntimeException runtimeException = new RuntimeException();
            runtimeException.initCause(exception);
            throw runtimeException;
        }
        oWLModel.setGenerateEventsEnabled(bl);
        this.setProgressIndeterminate(false);
        this.setTaskCompleted();
        this.setProgress(1);
    }
}

