/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.inference.protegeowl.task.protegereasoner;

import edu.stanford.smi.protegex.owl.inference.protegeowl.log.ReasonerLogRecord;
import edu.stanford.smi.protegex.owl.inference.protegeowl.log.ReasonerLogRecordFactory;
import edu.stanford.smi.protegex.owl.inference.protegeowl.task.protegereasoner.AbstractReasonerTask;
import edu.stanford.smi.protegex.owl.inference.protegeowl.task.protegereasoner.CollectionResultReasonerTask;
import edu.stanford.smi.protegex.owl.inference.reasoner.ProtegeReasoner;
import edu.stanford.smi.protegex.owl.inference.reasoner.exception.ProtegeReasonerException;
import edu.stanford.smi.protegex.owl.model.OWLIndividual;
import edu.stanford.smi.protegex.owl.model.RDFSClass;
import java.util.Collection;
import java.util.HashSet;

public class GetIndividualInferredTypesTask
extends AbstractReasonerTask
implements CollectionResultReasonerTask {
    private OWLIndividual individual;
    private ProtegeReasoner protegeReasoner;
    private HashSet types;

    public GetIndividualInferredTypesTask(OWLIndividual oWLIndividual, ProtegeReasoner protegeReasoner) {
        super(protegeReasoner);
        this.individual = oWLIndividual;
        this.protegeReasoner = protegeReasoner;
        this.types = new HashSet();
    }

    public int getTaskSize() {
        return 1;
    }

    public void run() throws ProtegeReasonerException {
        ReasonerLogRecordFactory reasonerLogRecordFactory = ReasonerLogRecordFactory.getInstance();
        this.setDescription("Getting types for individual");
        this.setProgress(0);
        this.setMessage("Building reasoner query...");
        this.setMessage("Querying reasoner...");
        ReasonerLogRecord reasonerLogRecord = reasonerLogRecordFactory.createInformationMessageLogRecord("Inferred types for: " + this.individual.getBrowserText(), null);
        this.postLogRecord(reasonerLogRecord);
        this.types.addAll(this.protegeReasoner.getIndividualTypes(this.individual));
        for (RDFSClass rDFSClass : this.types) {
            this.postLogRecord(reasonerLogRecordFactory.createOWLInstanceLogRecord(rDFSClass, reasonerLogRecord));
        }
        this.setMessage("Finished");
        this.setTaskCompleted();
    }

    public Collection getResult() {
        return this.types;
    }
}

