/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.inference.protegeowl.task.protegereasoner;

import edu.stanford.smi.protegex.owl.inference.protegeowl.log.ReasonerLogRecord;
import edu.stanford.smi.protegex.owl.inference.protegeowl.log.ReasonerLogRecordFactory;
import edu.stanford.smi.protegex.owl.inference.protegeowl.task.protegereasoner.AbstractReasonerTask;
import edu.stanford.smi.protegex.owl.inference.protegeowl.task.protegereasoner.BooleanResultReasonerTask;
import edu.stanford.smi.protegex.owl.inference.reasoner.ProtegeReasoner;
import edu.stanford.smi.protegex.owl.inference.reasoner.exception.ProtegeReasonerException;
import edu.stanford.smi.protegex.owl.inference.util.TimeDifference;
import edu.stanford.smi.protegex.owl.model.OWLClass;

public class GetConceptSatisfiableTask
extends AbstractReasonerTask
implements BooleanResultReasonerTask {
    private OWLClass aClass;
    private ProtegeReasoner protegeReasoner;
    private boolean satisfiable;

    public GetConceptSatisfiableTask(OWLClass oWLClass, ProtegeReasoner protegeReasoner) {
        super(protegeReasoner);
        this.aClass = oWLClass;
        this.protegeReasoner = protegeReasoner;
        this.satisfiable = true;
    }

    public int getTaskSize() {
        return 1;
    }

    public void run() throws ProtegeReasonerException {
        ReasonerLogRecordFactory reasonerLogRecordFactory = ReasonerLogRecordFactory.getInstance();
        ReasonerLogRecord reasonerLogRecord = reasonerLogRecordFactory.createInformationMessageLogRecord("Checking consistency of " + this.aClass.getBrowserText(), null);
        this.postLogRecord(reasonerLogRecord);
        this.setDescription("Computing consistency");
        this.setMessage("Querying reasoner...");
        TimeDifference timeDifference = new TimeDifference();
        timeDifference.markStart();
        this.satisfiable = this.protegeReasoner.isSatisfiable(this.aClass);
        timeDifference.markEnd();
        this.postLogRecord(reasonerLogRecordFactory.createInformationMessageLogRecord("Time to query reasoner = " + timeDifference, reasonerLogRecord));
        this.postLogRecord(reasonerLogRecordFactory.createConceptConsistencyLogRecord(this.aClass, this.satisfiable, reasonerLogRecord));
        this.setProgress(1);
        this.setMessage("Finished");
        this.setTaskCompleted();
    }

    public boolean getResult() {
        return this.satisfiable;
    }
}

