/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.inference.protegeowl.task.digreasoner;

import edu.stanford.smi.protege.util.Log;
import edu.stanford.smi.protegex.owl.inference.dig.exception.DIGReasonerException;
import edu.stanford.smi.protegex.owl.inference.dig.translator.DIGQueryResponse;
import edu.stanford.smi.protegex.owl.inference.protegeowl.ProtegeOWLReasoner;
import edu.stanford.smi.protegex.owl.inference.protegeowl.log.ReasonerLogRecord;
import edu.stanford.smi.protegex.owl.inference.protegeowl.log.ReasonerLogRecordFactory;
import edu.stanford.smi.protegex.owl.inference.protegeowl.task.digreasoner.AbstractReasonerTask;
import edu.stanford.smi.protegex.owl.inference.util.ReasonerUtil;
import edu.stanford.smi.protegex.owl.inference.util.TimeDifference;
import edu.stanford.smi.protegex.owl.model.OWLModel;
import edu.stanford.smi.protegex.owl.model.OWLNamedClass;
import edu.stanford.smi.protegex.owl.model.RDFSClass;
import java.util.Collection;
import java.util.Iterator;
import org.w3c.dom.Document;

public class UpdateInferredHierarchyTask
extends AbstractReasonerTask {
    private ProtegeOWLReasoner protegeOWLReasoner;

    public UpdateInferredHierarchyTask(ProtegeOWLReasoner protegeOWLReasoner) {
        super(protegeOWLReasoner);
        this.protegeOWLReasoner = protegeOWLReasoner;
    }

    public int getTaskSize() {
        return ReasonerUtil.getInstance().getNamedClses(this.protegeOWLReasoner.getKnowledgeBase()).size();
    }

    public void run() throws DIGReasonerException {
        Object object2;
        OWLModel oWLModel = this.protegeOWLReasoner.getKnowledgeBase();
        ReasonerLogRecord reasonerLogRecord = ReasonerLogRecordFactory.getInstance().createInformationMessageLogRecord("Compute inferred hierarchy", null);
        this.doAbortCheck();
        this.postLogRecord(reasonerLogRecord);
        this.setProgress(0);
        this.setDescription("Computing inferred hierarchy");
        this.setMessage("Building inferred hierarchy reasoner query...");
        TimeDifference timeDifference = new TimeDifference();
        timeDifference.markStart();
        Document document = this.getTranslator().createAsksDocument(this.protegeOWLReasoner.getReasonerKnowledgeBaseURI());
        Collection collection = ReasonerUtil.getInstance().getNamedClses(oWLModel);
        for (Object object2 : collection) {
            this.getTranslator().createDirectSuperConceptsQuery(document, object2.getName(), (RDFSClass)object2);
        }
        timeDifference.markEnd();
        this.postLogRecord(ReasonerLogRecordFactory.getInstance().createInformationMessageLogRecord("Time to build query = " + timeDifference, reasonerLogRecord));
        this.doAbortCheck();
        this.setMessage("Querying reasoner...");
        timeDifference.markStart();
        object2 = this.protegeOWLReasoner.getDIGReasoner().performRequest(document);
        timeDifference.markEnd();
        this.postLogRecord(ReasonerLogRecordFactory.getInstance().createInformationMessageLogRecord("Time to query reasoner = " + timeDifference, reasonerLogRecord));
        this.doAbortCheck();
        this.setMessage("Updating Protege-OWL...");
        timeDifference.markStart();
        boolean bl = oWLModel.setGenerateEventsEnabled(false);
        try {
            oWLModel.beginTransaction("Compute and update inferred class hierarchy");
            Iterator iterator = this.getTranslator().getDIGQueryResponseIterator(oWLModel, (Document)object2);
            while (iterator.hasNext()) {
                this.doAbortCheck();
                DIGQueryResponse dIGQueryResponse = (DIGQueryResponse)iterator.next();
                String string = dIGQueryResponse.getID();
                OWLNamedClass oWLNamedClass = oWLModel.getOWLNamedClass(string);
                if (oWLNamedClass != null) {
                    Object object3;
                    if (oWLNamedClass.isConsistent()) {
                        object3 = dIGQueryResponse.getConcepts();
                        Object object4 = object3.iterator();
                        while (object4.hasNext()) {
                            RDFSClass rDFSClass = (RDFSClass)object4.next();
                            if (!rDFSClass.isVisible()) continue;
                            oWLNamedClass.addInferredSuperclass(rDFSClass);
                        }
                        object4 = oWLNamedClass.getNamedSuperclasses();
                        if (!object4.containsAll((Collection<?>)object3) || !object3.containsAll((Collection<?>)object4)) {
                            oWLNamedClass.setClassificationStatus(3);
                        } else {
                            oWLNamedClass.setClassificationStatus(1);
                        }
                    } else {
                        object3 = oWLNamedClass.getNamedSuperclasses().iterator();
                        while (object3.hasNext()) {
                            oWLNamedClass.addInferredSuperclass((RDFSClass)object3.next());
                        }
                    }
                }
                this.setProgress(this.getProgress() + 1);
            }
            oWLModel.commitTransaction();
        }
        catch (DIGReasonerException dIGReasonerException) {
            oWLModel.rollbackTransaction();
            throw dIGReasonerException;
        }
        catch (Exception exception) {
            oWLModel.rollbackTransaction();
            Log.getLogger().warning("Exception in transaction. Rollback. Exception: " + exception.getMessage());
            RuntimeException runtimeException = new RuntimeException();
            runtimeException.initCause(exception);
            throw runtimeException;
        }
        oWLModel.setGenerateEventsEnabled(bl);
        timeDifference.markEnd();
        this.postLogRecord(ReasonerLogRecordFactory.getInstance().createInformationMessageLogRecord("Time to update Protege-OWL = " + timeDifference, reasonerLogRecord));
        this.setTaskCompleted();
    }
}

