/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.inference.protegeowl.task.digreasoner;

import edu.stanford.smi.protegex.owl.inference.dig.exception.DIGReasonerException;
import edu.stanford.smi.protegex.owl.inference.protegeowl.ProtegeOWLReasoner;
import edu.stanford.smi.protegex.owl.inference.protegeowl.log.ReasonerLogRecord;
import edu.stanford.smi.protegex.owl.inference.protegeowl.log.ReasonerLogRecordFactory;
import edu.stanford.smi.protegex.owl.inference.protegeowl.task.digreasoner.AbstractReasonerTask;
import edu.stanford.smi.protegex.owl.inference.util.TimeDifference;
import edu.stanford.smi.protegex.owl.model.OWLModel;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class SynchronizeReasonerTask
extends AbstractReasonerTask {
    private ProtegeOWLReasoner protegeOWLReasoner;

    public SynchronizeReasonerTask(ProtegeOWLReasoner protegeOWLReasoner) {
        super(protegeOWLReasoner);
        this.protegeOWLReasoner = protegeOWLReasoner;
    }

    public int getTaskSize() {
        return 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() throws DIGReasonerException {
        TimeDifference timeDifference = new TimeDifference();
        this.setDescription("Synchronizing reasoner");
        this.setMessage("Synchronizing reasoner...");
        ReasonerLogRecordFactory reasonerLogRecordFactory = ReasonerLogRecordFactory.getInstance();
        ReasonerLogRecord reasonerLogRecord = reasonerLogRecordFactory.createInformationMessageLogRecord("Synchronize reasoner", null);
        this.postLogRecord(reasonerLogRecord);
        timeDifference.markStart();
        this.setProgressIndeterminate(true);
        this.doAbortCheck();
        this.setMessage("Updating reasoner...");
        OWLModel oWLModel = this.protegeOWLReasoner.getKnowledgeBase();
        boolean bl = oWLModel.setGenerateEventsEnabled(false);
        try {
            this.clearKnowledgeBase(reasonerLogRecord);
            this.doAbortCheck();
            this.transmitToReasoner(reasonerLogRecord);
        }
        catch (Exception exception) {
        }
        finally {
            oWLModel.setGenerateEventsEnabled(bl);
        }
        this.doAbortCheck();
        this.setProgressIndeterminate(false);
        timeDifference.markEnd();
        this.postLogRecord(ReasonerLogRecordFactory.getInstance().createInformationMessageLogRecord("Time to synchronize = " + timeDifference, reasonerLogRecord));
        this.setMessage("Reasoner synchronized");
        this.setProgress(1);
        this.setTaskCompleted();
    }

    protected void clearKnowledgeBase(ReasonerLogRecord reasonerLogRecord) throws DIGReasonerException {
        TimeDifference timeDifference = new TimeDifference();
        timeDifference.markStart();
        this.setMessage("Clearing knowledge base...");
        this.protegeOWLReasoner.getDIGReasoner().clearKnowledgeBase(this.protegeOWLReasoner.getReasonerKnowledgeBaseURI());
        timeDifference.markEnd();
        this.postLogRecord(ReasonerLogRecordFactory.getInstance().createInformationMessageLogRecord("Time to clear knowledgebase = " + timeDifference, reasonerLogRecord));
    }

    protected void transmitToReasoner(ReasonerLogRecord reasonerLogRecord) throws DIGReasonerException {
        TimeDifference timeDifference = new TimeDifference();
        this.setMessage("Generating DIG representation...");
        timeDifference.markStart();
        Document document = this.getTranslator().createTellsDocument(this.protegeOWLReasoner.getReasonerKnowledgeBaseURI());
        this.getTranslator().translateToDIG(this.protegeOWLReasoner.getKnowledgeBase(), document, (Node)document.getDocumentElement());
        timeDifference.markEnd();
        this.postLogRecord(ReasonerLogRecordFactory.getInstance().createInformationMessageLogRecord("Time for DIG conversion = " + timeDifference, reasonerLogRecord));
        this.doAbortCheck();
        this.setMessage("Updating reasoner");
        timeDifference.markStart();
        this.protegeOWLReasoner.getDIGReasoner().performRequest(document);
        timeDifference.markEnd();
        this.postLogRecord(ReasonerLogRecordFactory.getInstance().createInformationMessageLogRecord("Time to update reasoner = " + timeDifference, reasonerLogRecord));
    }
}

