/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.inference.protegeowl.task.digreasoner;

import edu.stanford.smi.protegex.owl.inference.dig.exception.DIGReasonerException;
import edu.stanford.smi.protegex.owl.inference.dig.translator.DIGQueryResponse;
import edu.stanford.smi.protegex.owl.inference.protegeowl.ProtegeOWLReasoner;
import edu.stanford.smi.protegex.owl.inference.protegeowl.log.ReasonerLogRecord;
import edu.stanford.smi.protegex.owl.inference.protegeowl.log.ReasonerLogRecordFactory;
import edu.stanford.smi.protegex.owl.inference.protegeowl.task.digreasoner.AbstractReasonerTask;
import edu.stanford.smi.protegex.owl.inference.protegeowl.task.digreasoner.CollectionResultReasonerTask;
import edu.stanford.smi.protegex.owl.model.OWLClass;
import edu.stanford.smi.protegex.owl.model.RDFResource;
import edu.stanford.smi.protegex.owl.model.RDFSClass;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import org.w3c.dom.Document;

public abstract class AbstractSingleConceptWithConceptCollectionResultTask
extends AbstractReasonerTask
implements CollectionResultReasonerTask {
    private OWLClass aClass;
    private ProtegeOWLReasoner protegeOWLReasoner;
    private HashSet parents;
    private String taskDesciption;

    public AbstractSingleConceptWithConceptCollectionResultTask(String string, OWLClass oWLClass, ProtegeOWLReasoner protegeOWLReasoner) {
        super(protegeOWLReasoner);
        this.taskDesciption = string;
        this.aClass = oWLClass;
        this.protegeOWLReasoner = protegeOWLReasoner;
        this.parents = new HashSet();
    }

    public int getTaskSize() {
        return 1;
    }

    public void run() throws DIGReasonerException {
        Object object;
        this.setDescription(this.taskDesciption);
        this.setMessage("Building reasoner query...");
        this.setProgress(0);
        this.doAbortCheck();
        Document document = this.getTranslator().createAsksDocument(this.protegeOWLReasoner.getReasonerKnowledgeBaseURI());
        this.createQuery(document);
        this.setMessage("Querying reasoner...");
        Document document2 = this.protegeOWLReasoner.getDIGReasoner().performRequest(document);
        this.doAbortCheck();
        Iterator iterator = this.getTranslator().getDIGQueryResponseIterator(this.protegeOWLReasoner.getKnowledgeBase(), document2);
        while (iterator.hasNext()) {
            object = (DIGQueryResponse)iterator.next();
            this.parents.addAll(object.getConcepts());
        }
        object = ReasonerLogRecordFactory.getInstance();
        ReasonerLogRecord reasonerLogRecord = ((ReasonerLogRecordFactory)object).createInformationMessageLogRecord("Concepts", null);
        this.postLogRecord(reasonerLogRecord);
        iterator = this.parents.iterator();
        while (iterator.hasNext()) {
            this.postLogRecord(((ReasonerLogRecordFactory)object).createOWLInstanceLogRecord((RDFResource)iterator.next(), reasonerLogRecord));
        }
        this.setProgress(1);
        this.doAbortCheck();
        this.setTaskCompleted();
    }

    public Collection getResult() {
        return this.parents;
    }

    public abstract void createQuery(Document var1) throws DIGReasonerException;

    protected RDFSClass getCls() {
        return this.aClass;
    }

    protected ProtegeOWLReasoner getProtegeOWLReasoner() {
        return this.protegeOWLReasoner;
    }
}

