/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.inference.protegeowl;

import edu.stanford.smi.protegex.owl.inference.protegeowl.ReasonerManager;
import edu.stanford.smi.protegex.owl.inference.protegeowl.ReasonerPluginManager;
import edu.stanford.smi.protegex.owl.model.OWLModel;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import javax.swing.ButtonGroup;
import javax.swing.JMenu;
import javax.swing.JRadioButtonMenuItem;

public class ReasonerPluginMenuManager {
    public static final String NONE_REASONER = "None";

    public static void fillReasoningMenu(OWLModel oWLModel, JMenu jMenu) {
        Map<String, String> map = ReasonerPluginManager.getSuitableReasonerMap(oWLModel);
        if (map.size() == 0) {
            return;
        }
        ArrayList<String> arrayList = new ArrayList<String>(map.keySet());
        Collections.sort(arrayList);
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(ReasonerPluginMenuManager.addMenuItem(oWLModel, jMenu, NONE_REASONER, null));
        for (String string : arrayList) {
            buttonGroup.add(ReasonerPluginMenuManager.addMenuItem(oWLModel, jMenu, string, map.get(string)));
        }
    }

    private static JRadioButtonMenuItem addMenuItem(final OWLModel oWLModel, JMenu jMenu, String string, final String string2) {
        final JRadioButtonMenuItem jRadioButtonMenuItem = new JRadioButtonMenuItem(string);
        String string3 = ReasonerManager.getInstance().getDefaultReasonerClassName();
        if (string3.equals(string2)) {
            ReasonerManager.getInstance().setProtegeReasonerClass(oWLModel, string2);
            jRadioButtonMenuItem.setSelected(true);
        }
        jRadioButtonMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (jRadioButtonMenuItem.isSelected()) {
                    ReasonerManager.getInstance().setDefaultReasonerClass(string2);
                    ReasonerManager.getInstance().setProtegeReasonerClass(oWLModel, string2);
                }
            }
        });
        jMenu.add(jRadioButtonMenuItem);
        return jRadioButtonMenuItem;
    }
}

