/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.inference.protegeowl;

import edu.stanford.smi.protege.model.Project;
import edu.stanford.smi.protege.plugin.PluginUtilities;
import edu.stanford.smi.protege.util.Log;
import edu.stanford.smi.protegex.owl.inference.reasoner.ProtegeReasoner;
import edu.stanford.smi.protegex.owl.model.OWLModel;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReasonerPluginManager {
    private static final String REASONER_PLUGIN = "ReasonerPlugin";
    private static final String IS_SUITABLE_METHOD_NAME = "isSuitable";
    private static final Class<?>[] IS_SUITABLE_METHOD_ARGS = new Class[]{Project.class, Collection.class};
    private static final String METHOD_NAME = "getReasonerName";
    private static final Class<?>[] METHOD_ARG_CLASSES = new Class[0];

    public static Collection<Class> getAvailableReasonerPluginClasses() {
        return PluginUtilities.getClassesWithAttribute((String)REASONER_PLUGIN, (String)"True");
    }

    public static Collection<Class<? extends ProtegeReasoner>> getSuitableReasonerPluginClasses(Project project) {
        Collection<Class> collection = ReasonerPluginManager.getAvailableReasonerPluginClasses();
        ArrayList<Class<? extends ProtegeReasoner>> arrayList = new ArrayList<Class<? extends ProtegeReasoner>>();
        for (Class clazz : collection) {
            if (!ReasonerPluginManager.isSuitable(project, clazz)) continue;
            arrayList.add(clazz);
        }
        return arrayList;
    }

    private static boolean isSuitable(Project project, Class<? extends ProtegeReasoner> clazz) {
        boolean bl;
        try {
            ArrayList arrayList = new ArrayList();
            Method method = clazz.getMethod(IS_SUITABLE_METHOD_NAME, IS_SUITABLE_METHOD_ARGS);
            Boolean bl2 = (Boolean)method.invoke(clazz, project, arrayList);
            bl = bl2;
        }
        catch (NoSuchMethodException noSuchMethodException) {
            bl = true;
        }
        catch (Exception exception) {
            bl = false;
            Log.getLogger().warning(exception.getMessage());
        }
        return bl;
    }

    public static ProtegeReasoner getReasonerPluginInstance(OWLModel oWLModel, Class<? extends ProtegeReasoner> clazz) {
        ProtegeReasoner protegeReasoner = ReasonerPluginManager.getReasonerPluginInstance(clazz);
        if (protegeReasoner != null) {
            protegeReasoner.setOWLModel(oWLModel);
        }
        return protegeReasoner;
    }

    public static ProtegeReasoner getReasonerPluginInstance(Class<? extends ProtegeReasoner> clazz) {
        ProtegeReasoner protegeReasoner = null;
        try {
            protegeReasoner = clazz.newInstance();
        }
        catch (Exception exception) {
            Log.getLogger().log(Level.WARNING, "Could not create plugin for " + clazz, exception);
        }
        return protegeReasoner;
    }

    public static ProtegeReasoner getReasonerPluginInstance(String string) {
        Class<? extends ProtegeReasoner> clazz = ReasonerPluginManager.getReasonerJavaClass(string);
        if (clazz == null) {
            Log.getLogger().warning("Cannot find reasoner java class " + string);
            return null;
        }
        return ReasonerPluginManager.getReasonerPluginInstance(clazz);
    }

    public static ProtegeReasoner getReasonerPluginInstance(OWLModel oWLModel, String string) {
        Class<? extends ProtegeReasoner> clazz = ReasonerPluginManager.getReasonerJavaClass(string);
        if (clazz == null) {
            Log.getLogger().warning("Cannot find reasoner java class " + string);
            return null;
        }
        return ReasonerPluginManager.getReasonerPluginInstance(oWLModel, clazz);
    }

    public static Class<? extends ProtegeReasoner> getReasonerJavaClass(String string) {
        return PluginUtilities.forName((String)string, (boolean)true);
    }

    public static Collection<String> getSuitableReasonerNames(OWLModel oWLModel) {
        ArrayList<String> arrayList = new ArrayList<String>(ReasonerPluginManager.getSuitableReasonerMap(oWLModel).keySet());
        Collections.sort(arrayList);
        return arrayList;
    }

    public static Map<String, String> getSuitableReasonerMap(OWLModel oWLModel) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        for (Class<? extends ProtegeReasoner> clazz : ReasonerPluginManager.getSuitableReasonerPluginClasses(oWLModel.getProject())) {
            hashMap.put(ReasonerPluginManager.getReasonerName(clazz), clazz.getName());
        }
        return hashMap;
    }

    public static String getReasonerName(Class<? extends ProtegeReasoner> clazz) {
        String string = null;
        try {
            Method method = clazz.getMethod(METHOD_NAME, METHOD_ARG_CLASSES);
            string = (String)method.invoke(null, new Object[0]);
        }
        catch (Exception exception) {
            Log.getLogger().warning("Could not find reasoner name for: " + clazz.getName());
            string = clazz.getSimpleName();
        }
        return string;
    }
}

