/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.inference.protegeowl;

import edu.stanford.smi.protege.event.ProjectAdapter;
import edu.stanford.smi.protege.event.ProjectEvent;
import edu.stanford.smi.protege.event.ProjectListener;
import edu.stanford.smi.protege.util.Log;
import edu.stanford.smi.protegex.owl.inference.dig.exception.DIGError;
import edu.stanford.smi.protegex.owl.inference.dig.exception.DIGReasonerException;
import edu.stanford.smi.protegex.owl.inference.dig.reasoner.DIGReasoner;
import edu.stanford.smi.protegex.owl.inference.dig.reasoner.DIGReasonerIdentity;
import edu.stanford.smi.protegex.owl.inference.dig.reasoner.DefaultDIGReasoner;
import edu.stanford.smi.protegex.owl.inference.dig.reasoner.logger.DIGLogger;
import edu.stanford.smi.protegex.owl.inference.dig.reasoner.logger.DIGLoggerListener;
import edu.stanford.smi.protegex.owl.inference.protegeowl.ProtegeOWLReasoner;
import edu.stanford.smi.protegex.owl.inference.protegeowl.log.ErrorMessageLogRecord;
import edu.stanford.smi.protegex.owl.inference.protegeowl.log.ReasonerLogRecordFactory;
import edu.stanford.smi.protegex.owl.inference.protegeowl.log.ReasonerLogger;
import edu.stanford.smi.protegex.owl.inference.protegeowl.task.ReasonerTask;
import edu.stanford.smi.protegex.owl.inference.protegeowl.task.ReasonerTaskAdapter;
import edu.stanford.smi.protegex.owl.inference.protegeowl.task.ReasonerTaskEvent;
import edu.stanford.smi.protegex.owl.inference.protegeowl.task.ReasonerTaskListener;
import edu.stanford.smi.protegex.owl.inference.protegeowl.task.digreasoner.ClassifyTaxonomyTask;
import edu.stanford.smi.protegex.owl.inference.protegeowl.task.digreasoner.GetAncestorConceptsTask;
import edu.stanford.smi.protegex.owl.inference.protegeowl.task.digreasoner.GetConceptIntersectionSuperclassesTask;
import edu.stanford.smi.protegex.owl.inference.protegeowl.task.digreasoner.GetConceptSatisfiableTask;
import edu.stanford.smi.protegex.owl.inference.protegeowl.task.digreasoner.GetDescendantConceptsTask;
import edu.stanford.smi.protegex.owl.inference.protegeowl.task.digreasoner.GetEquivalentConceptsTask;
import edu.stanford.smi.protegex.owl.inference.protegeowl.task.digreasoner.GetIndividualInferredTypesTask;
import edu.stanford.smi.protegex.owl.inference.protegeowl.task.digreasoner.GetIndividualsBelongingToConceptTask;
import edu.stanford.smi.protegex.owl.inference.protegeowl.task.digreasoner.GetSubConceptsTask;
import edu.stanford.smi.protegex.owl.inference.protegeowl.task.digreasoner.GetSubsumptionRelationshipTask;
import edu.stanford.smi.protegex.owl.inference.protegeowl.task.digreasoner.GetSuperConceptsTask;
import edu.stanford.smi.protegex.owl.inference.protegeowl.task.digreasoner.IsConceptIntersectionSatisfiableTask;
import edu.stanford.smi.protegex.owl.inference.protegeowl.task.digreasoner.IsDisjointToTask;
import edu.stanford.smi.protegex.owl.inference.protegeowl.task.digreasoner.IsSubsumedByTask;
import edu.stanford.smi.protegex.owl.inference.protegeowl.task.digreasoner.SynchronizeReasonerTask;
import edu.stanford.smi.protegex.owl.inference.protegeowl.task.digreasoner.UpdateEquivalentClassesTask;
import edu.stanford.smi.protegex.owl.inference.protegeowl.task.digreasoner.UpdateInconsistentClassesTask;
import edu.stanford.smi.protegex.owl.inference.protegeowl.task.digreasoner.UpdateInferredHierarchyTask;
import edu.stanford.smi.protegex.owl.inference.protegeowl.task.digreasoner.UpdateInferredTypesTask;
import edu.stanford.smi.protegex.owl.inference.reasoner.exception.ProtegeReasonerException;
import edu.stanford.smi.protegex.owl.inference.util.TimeDifference;
import edu.stanford.smi.protegex.owl.model.OWLClass;
import edu.stanford.smi.protegex.owl.model.OWLIndividual;
import edu.stanford.smi.protegex.owl.model.OWLModel;
import edu.stanford.smi.protegex.owl.model.OWLNamedClass;
import edu.stanford.smi.protegex.owl.model.RDFProperty;
import edu.stanford.smi.protegex.owl.model.RDFResource;
import edu.stanford.smi.protegex.owl.model.RDFSClass;
import edu.stanford.smi.protegex.owl.model.event.ClassAdapter;
import edu.stanford.smi.protegex.owl.model.event.ClassListener;
import edu.stanford.smi.protegex.owl.model.event.ModelAdapter;
import edu.stanford.smi.protegex.owl.model.event.ModelListener;
import edu.stanford.smi.protegex.owl.model.event.PropertyAdapter;
import edu.stanford.smi.protegex.owl.model.event.PropertyListener;
import edu.stanford.smi.protegex.owl.model.event.PropertyValueAdapter;
import edu.stanford.smi.protegex.owl.model.event.PropertyValueListener;
import edu.stanford.smi.protegex.owl.model.event.ResourceAdapter;
import java.util.Collection;
import java.util.logging.Level;
import java.util.logging.Logger;

public class DefaultProtegeOWLReasoner
implements ProtegeOWLReasoner {
    private static transient Logger log = Log.getLogger(DefaultProtegeOWLReasoner.class);
    private DIGReasoner reasoner;
    private OWLModel model;
    private boolean synchronizeReasoner = true;
    private boolean autoSynchReasoner = true;
    private String kbURI;
    private ProjectListener projectListener = new ProjectAdapter(){

        public void projectClosed(ProjectEvent projectEvent) {
            if (DefaultProtegeOWLReasoner.this.kbURI != null) {
                try {
                    DefaultProtegeOWLReasoner.this.reasoner.releaseKnowledgeBase(DefaultProtegeOWLReasoner.this.kbURI);
                    DefaultProtegeOWLReasoner.this.kbURI = null;
                    DefaultProtegeOWLReasoner.this.removeListeners();
                    DefaultProtegeOWLReasoner.this.model.getProject().removeProjectListener(DefaultProtegeOWLReasoner.this.projectListener);
                    DefaultProtegeOWLReasoner.this.model = null;
                }
                catch (DIGReasonerException dIGReasonerException) {
                    Log.getLogger().log(Level.SEVERE, "Exception caught", dIGReasonerException);
                }
            }
        }
    };
    private ModelListener modelListener = new ModelAdapter(){

        public void classCreated(RDFSClass rDFSClass) {
            DefaultProtegeOWLReasoner.this.reactToKnowledgeBaseChange();
        }

        public void classDeleted(RDFSClass rDFSClass) {
            DefaultProtegeOWLReasoner.this.reactToKnowledgeBaseChange();
        }

        public void propertyCreated(RDFProperty rDFProperty) {
            DefaultProtegeOWLReasoner.this.reactToKnowledgeBaseChange();
        }

        public void propertyDeleted(RDFProperty rDFProperty) {
            DefaultProtegeOWLReasoner.this.reactToKnowledgeBaseChange();
        }

        public void individualCreated(RDFResource rDFResource) {
            DefaultProtegeOWLReasoner.this.reactToKnowledgeBaseChange();
        }

        public void individualDeleted(RDFResource rDFResource) {
            DefaultProtegeOWLReasoner.this.reactToKnowledgeBaseChange();
        }

        public void resourceReplaced(RDFResource rDFResource, RDFResource rDFResource2, String string) {
            DefaultProtegeOWLReasoner.this.reactToKnowledgeBaseChange();
        }
    };
    private ResourceAdapter resourceAdapter = new ResourceAdapter(){

        public void typeAdded(RDFResource rDFResource, RDFSClass rDFSClass) {
            DefaultProtegeOWLReasoner.this.reactToKnowledgeBaseChange();
        }

        public void typeRemoved(RDFResource rDFResource, RDFSClass rDFSClass) {
            DefaultProtegeOWLReasoner.this.reactToKnowledgeBaseChange();
        }
    };
    private PropertyListener propertyListener = new PropertyAdapter(){

        public void subpropertyAdded(RDFProperty rDFProperty, RDFProperty rDFProperty2) {
            DefaultProtegeOWLReasoner.this.reactToKnowledgeBaseChange();
        }

        public void subpropertyRemoved(RDFProperty rDFProperty, RDFProperty rDFProperty2) {
            DefaultProtegeOWLReasoner.this.reactToKnowledgeBaseChange();
        }

        public void superpropertyAdded(RDFProperty rDFProperty, RDFProperty rDFProperty2) {
            DefaultProtegeOWLReasoner.this.reactToKnowledgeBaseChange();
        }

        public void superpropertyRemoved(RDFProperty rDFProperty, RDFProperty rDFProperty2) {
            DefaultProtegeOWLReasoner.this.reactToKnowledgeBaseChange();
        }

        public void unionDomainClassAdded(RDFProperty rDFProperty, RDFSClass rDFSClass) {
            DefaultProtegeOWLReasoner.this.reactToKnowledgeBaseChange();
        }

        public void unionDomainClassRemoved(RDFProperty rDFProperty, RDFSClass rDFSClass) {
            DefaultProtegeOWLReasoner.this.reactToKnowledgeBaseChange();
        }
    };
    private ClassListener classListener = new ClassAdapter(){

        public void addedToUnionDomainOf(RDFSClass rDFSClass, RDFProperty rDFProperty) {
            DefaultProtegeOWLReasoner.this.reactToKnowledgeBaseChange();
        }

        public void instanceAdded(RDFSClass rDFSClass, RDFResource rDFResource) {
            DefaultProtegeOWLReasoner.this.reactToKnowledgeBaseChange();
        }

        public void instanceRemoved(RDFSClass rDFSClass, RDFResource rDFResource) {
            DefaultProtegeOWLReasoner.this.reactToKnowledgeBaseChange();
        }

        public void removedFromUnionDomainOf(RDFSClass rDFSClass, RDFProperty rDFProperty) {
            DefaultProtegeOWLReasoner.this.reactToKnowledgeBaseChange();
        }

        public void subclassAdded(RDFSClass rDFSClass, RDFSClass rDFSClass2) {
            DefaultProtegeOWLReasoner.this.reactToKnowledgeBaseChange();
        }

        public void subclassRemoved(RDFSClass rDFSClass, RDFSClass rDFSClass2) {
            DefaultProtegeOWLReasoner.this.reactToKnowledgeBaseChange();
        }

        public void superclassAdded(RDFSClass rDFSClass, RDFSClass rDFSClass2) {
            DefaultProtegeOWLReasoner.this.reactToKnowledgeBaseChange();
        }

        public void superclassRemoved(RDFSClass rDFSClass, RDFSClass rDFSClass2) {
            DefaultProtegeOWLReasoner.this.reactToKnowledgeBaseChange();
        }
    };
    private PropertyValueListener propertyValueListener = new PropertyValueAdapter(){

        public void nameChanged(RDFResource rDFResource, String string) {
            DefaultProtegeOWLReasoner.this.reactToKnowledgeBaseChange();
        }

        public void propertyValueChanged(RDFResource rDFResource, RDFProperty rDFProperty, Collection collection) {
            DefaultProtegeOWLReasoner.this.reactToKnowledgeBaseChange();
        }
    };
    private DIGLoggerListener digLoggerListener = new DIGLoggerListener(){

        public void errorLogged(DIGError dIGError) {
            OWLNamedClass oWLNamedClass = DefaultProtegeOWLReasoner.this.model.getOWLNamedClass(dIGError.getID());
            ReasonerLogger.getInstance().postLogRecord(new ErrorMessageLogRecord(oWLNamedClass, dIGError.getMessage(), null));
        }
    };

    public DefaultProtegeOWLReasoner(OWLModel oWLModel) {
        this.reasoner = new DefaultDIGReasoner();
        DIGLogger.getInstance(this.reasoner).addListener(this.digLoggerListener);
        this.setKnowledgeBase(oWLModel);
        oWLModel.getProject().addProjectListener(this.projectListener);
    }

    public DIGReasoner getDIGReasoner() {
        return this.reasoner;
    }

    protected void setKnowledgeBase(OWLModel oWLModel) {
        if (this.model != null) {
            this.removeListeners();
        }
        this.model = oWLModel;
        this.forceReasonerReSynchronization();
        this.addListeners();
    }

    private void removeListeners() {
        this.model.removeModelListener(this.modelListener);
        this.model.removeResourceListener(this.resourceAdapter);
        this.model.removePropertyListener(this.propertyListener);
        this.model.removeClassListener(this.classListener);
        this.model.removePropertyValueListener(this.propertyValueListener);
    }

    private void addListeners() {
        this.model.addModelListener(this.modelListener);
        this.model.addResourceListener(this.resourceAdapter);
        this.model.addPropertyListener(this.propertyListener);
        this.model.addClassListener(this.classListener);
        this.model.addPropertyValueListener(this.propertyValueListener);
    }

    public void setURL(String string) {
        try {
            if (!this.reasoner.getReasonerURL().equals(string)) {
                if (this.kbURI != null) {
                    this.reasoner.releaseKnowledgeBase(this.kbURI);
                    this.kbURI = null;
                    this.forceReasonerReSynchronization();
                }
                this.reasoner.setReasonerURL(string);
            }
        }
        catch (DIGReasonerException dIGReasonerException) {
            Log.getLogger().log(Level.SEVERE, "Exception caught", dIGReasonerException);
        }
    }

    public String getURL() {
        return this.reasoner.getReasonerURL();
    }

    public boolean isConnected() {
        try {
            this.reasoner.getIdentity();
            return true;
        }
        catch (DIGReasonerException dIGReasonerException) {
            return false;
        }
    }

    private void reactToKnowledgeBaseChange() {
        if (this.autoSynchReasoner) {
            this.forceReasonerReSynchronization();
        }
    }

    public void forceReasonerReSynchronization() {
        this.synchronizeReasoner = true;
    }

    public void setAutoSynchronizationEnabled(boolean bl) {
        this.autoSynchReasoner = bl;
    }

    public boolean isAutoSynchronizationEnabled() {
        return this.autoSynchReasoner;
    }

    public String getReasonerKnowledgeBaseURI() {
        return this.kbURI;
    }

    protected void synchronizeReasoner(ReasonerTaskListener reasonerTaskListener) throws DIGReasonerException {
        if (this.synchronizeReasoner || this.kbURI == null) {
            SynchronizeReasonerTask synchronizeReasonerTask = new SynchronizeReasonerTask(this);
            if (reasonerTaskListener != null) {
                synchronizeReasonerTask.addTaskListener(reasonerTaskListener);
            }
            if (this.kbURI == null) {
                this.kbURI = this.reasoner.createKnowledgeBase();
            }
            synchronizeReasonerTask.run();
            if (reasonerTaskListener != null) {
                synchronizeReasonerTask.removeTaskListener(reasonerTaskListener);
            }
            this.synchronizeReasoner = false;
        }
    }

    public DIGReasonerIdentity getIdentity() {
        DIGReasonerIdentity dIGReasonerIdentity;
        block2: {
            dIGReasonerIdentity = null;
            try {
                dIGReasonerIdentity = this.reasoner.getIdentity();
            }
            catch (DIGReasonerException dIGReasonerException) {
                Log.getLogger().severe(dIGReasonerException.getMessage());
                if (!log.isLoggable(Level.FINE)) break block2;
                log.log(Level.FINE, "Exception caught", dIGReasonerException);
            }
        }
        return dIGReasonerIdentity;
    }

    public OWLModel getKnowledgeBase() {
        return this.model;
    }

    public void classifyTaxonomy(ReasonerTaskListener reasonerTaskListener) throws DIGReasonerException {
        ClassifyTaxonomyTask classifyTaxonomyTask = new ClassifyTaxonomyTask(this);
        this.performTask(classifyTaxonomyTask, reasonerTaskListener);
    }

    public void computeInferredHierarchy(ReasonerTaskListener reasonerTaskListener) throws DIGReasonerException {
        UpdateInferredHierarchyTask updateInferredHierarchyTask = new UpdateInferredHierarchyTask(this);
        this.performTask(updateInferredHierarchyTask, reasonerTaskListener);
    }

    public void computeEquivalentConcepts(ReasonerTaskListener reasonerTaskListener) throws DIGReasonerException {
        UpdateEquivalentClassesTask updateEquivalentClassesTask = new UpdateEquivalentClassesTask(this);
        this.performTask(updateEquivalentClassesTask, reasonerTaskListener);
    }

    public void computeInconsistentConcepts(ReasonerTaskListener reasonerTaskListener) throws DIGReasonerException {
        UpdateInconsistentClassesTask updateInconsistentClassesTask = new UpdateInconsistentClassesTask(this);
        this.performTask(updateInconsistentClassesTask, reasonerTaskListener);
    }

    public void computeInferredIndividualTypes(ReasonerTaskListener reasonerTaskListener) throws DIGReasonerException {
        UpdateInferredTypesTask updateInferredTypesTask = new UpdateInferredTypesTask(this);
        this.performTask(updateInferredTypesTask, reasonerTaskListener);
    }

    public boolean isSatisfiable(OWLClass oWLClass, ReasonerTaskListener reasonerTaskListener) throws DIGReasonerException {
        GetConceptSatisfiableTask getConceptSatisfiableTask = new GetConceptSatisfiableTask(oWLClass, this);
        this.performTask(getConceptSatisfiableTask, reasonerTaskListener);
        return getConceptSatisfiableTask.getResult();
    }

    public boolean isIntersectionSatisfiable(OWLClass[] oWLClassArray, ReasonerTaskListener reasonerTaskListener) throws DIGReasonerException {
        IsConceptIntersectionSatisfiableTask isConceptIntersectionSatisfiableTask = new IsConceptIntersectionSatisfiableTask(oWLClassArray, this);
        this.performTask(isConceptIntersectionSatisfiableTask, reasonerTaskListener);
        return isConceptIntersectionSatisfiableTask.getResult();
    }

    public boolean isSubsumedBy(OWLClass oWLClass, OWLClass oWLClass2, ReasonerTaskListener reasonerTaskListener) throws DIGReasonerException {
        IsSubsumedByTask isSubsumedByTask = new IsSubsumedByTask(this, oWLClass, oWLClass2);
        this.performTask(isSubsumedByTask, reasonerTaskListener);
        return isSubsumedByTask.getResult();
    }

    public boolean isDisjointTo(OWLClass oWLClass, OWLClass oWLClass2, ReasonerTaskListener reasonerTaskListener) throws DIGReasonerException {
        IsDisjointToTask isDisjointToTask = new IsDisjointToTask(this, oWLClass, oWLClass2);
        this.performTask(isDisjointToTask, reasonerTaskListener);
        return isDisjointToTask.getResult();
    }

    public int getSubsumptionRelationship(OWLClass oWLClass, OWLClass oWLClass2, ReasonerTaskListener reasonerTaskListener) throws DIGReasonerException {
        GetSubsumptionRelationshipTask getSubsumptionRelationshipTask = new GetSubsumptionRelationshipTask(this, oWLClass, oWLClass2);
        this.performTask(getSubsumptionRelationshipTask, reasonerTaskListener);
        return getSubsumptionRelationshipTask.getResult();
    }

    public Collection getSuperclasses(OWLClass oWLClass, ReasonerTaskListener reasonerTaskListener) throws DIGReasonerException {
        GetSuperConceptsTask getSuperConceptsTask = new GetSuperConceptsTask(oWLClass, this);
        this.performTask(getSuperConceptsTask, reasonerTaskListener);
        return getSuperConceptsTask.getResult();
    }

    public Collection getSuperclassesOfIntersection(OWLClass[] oWLClassArray, ReasonerTaskListener reasonerTaskListener) throws DIGReasonerException {
        GetConceptIntersectionSuperclassesTask getConceptIntersectionSuperclassesTask = new GetConceptIntersectionSuperclassesTask(oWLClassArray, this);
        this.performTask(getConceptIntersectionSuperclassesTask, reasonerTaskListener);
        return getConceptIntersectionSuperclassesTask.getResult();
    }

    public Collection getSubclasses(OWLClass oWLClass, ReasonerTaskListener reasonerTaskListener) throws DIGReasonerException {
        GetSubConceptsTask getSubConceptsTask = new GetSubConceptsTask(oWLClass, this);
        this.performTask(getSubConceptsTask, reasonerTaskListener);
        return getSubConceptsTask.getResult();
    }

    public Collection getAncestorClasses(OWLClass oWLClass, ReasonerTaskListener reasonerTaskListener) throws DIGReasonerException {
        GetAncestorConceptsTask getAncestorConceptsTask = new GetAncestorConceptsTask(oWLClass, this);
        this.performTask(getAncestorConceptsTask, reasonerTaskListener);
        return getAncestorConceptsTask.getResult();
    }

    public Collection getDescendantClasses(OWLClass oWLClass, ReasonerTaskListener reasonerTaskListener) throws DIGReasonerException {
        GetDescendantConceptsTask getDescendantConceptsTask = new GetDescendantConceptsTask(oWLClass, this);
        this.performTask(getDescendantConceptsTask, reasonerTaskListener);
        return getDescendantConceptsTask.getResult();
    }

    public Collection getEquivalentClasses(OWLClass oWLClass, ReasonerTaskListener reasonerTaskListener) throws DIGReasonerException {
        GetEquivalentConceptsTask getEquivalentConceptsTask = new GetEquivalentConceptsTask(oWLClass, this);
        this.performTask(getEquivalentConceptsTask, reasonerTaskListener);
        return getEquivalentConceptsTask.getResult();
    }

    public Collection getIndividualsBelongingToClass(OWLClass oWLClass, ReasonerTaskListener reasonerTaskListener) throws DIGReasonerException {
        GetIndividualsBelongingToConceptTask getIndividualsBelongingToConceptTask = new GetIndividualsBelongingToConceptTask(oWLClass, this);
        this.performTask(getIndividualsBelongingToConceptTask, reasonerTaskListener);
        return getIndividualsBelongingToConceptTask.getResult();
    }

    public Collection getIndividualTypes(OWLIndividual oWLIndividual, ReasonerTaskListener reasonerTaskListener) throws DIGReasonerException {
        GetIndividualInferredTypesTask getIndividualInferredTypesTask = new GetIndividualInferredTypesTask(oWLIndividual, this);
        this.performTask(getIndividualInferredTypesTask, reasonerTaskListener);
        return getIndividualInferredTypesTask.getResult();
    }

    public void performTask(ReasonerTask reasonerTask, ReasonerTaskListener reasonerTaskListener) throws DIGReasonerException {
        TimeDifference timeDifference = new TimeDifference();
        timeDifference.markStart();
        final ReasonerTaskListener reasonerTaskListener2 = reasonerTaskListener;
        ReasonerTaskAdapter reasonerTaskAdapter = reasonerTaskListener != null ? new ReasonerTaskAdapter(){

            public void addedToTask(ReasonerTaskEvent reasonerTaskEvent) {
                reasonerTaskListener2.addedToTask(reasonerTaskEvent);
            }

            public void progressChanged(ReasonerTaskEvent reasonerTaskEvent) {
                reasonerTaskListener2.progressChanged(reasonerTaskEvent);
            }

            public void progressIndeterminateChanged(ReasonerTaskEvent reasonerTaskEvent) {
                reasonerTaskListener2.progressIndeterminateChanged(reasonerTaskEvent);
            }

            public void descriptionChanged(ReasonerTaskEvent reasonerTaskEvent) {
                reasonerTaskListener2.descriptionChanged(reasonerTaskEvent);
            }

            public void messageChanged(ReasonerTaskEvent reasonerTaskEvent) {
                reasonerTaskListener2.messageChanged(reasonerTaskEvent);
            }

            public void taskFailed(ReasonerTaskEvent reasonerTaskEvent) {
                reasonerTaskListener2.taskFailed(reasonerTaskEvent);
            }
        } : new ReasonerTaskAdapter();
        this.synchronizeReasoner(reasonerTaskAdapter);
        if (reasonerTaskListener != null) {
            reasonerTask.addTaskListener(reasonerTaskListener);
        }
        try {
            reasonerTask.run();
        }
        catch (ProtegeReasonerException protegeReasonerException) {
            String string = this.kbURI;
            this.kbURI = null;
            this.reasoner.releaseKnowledgeBase(string);
            this.synchronizeReasoner = true;
            throw new DIGReasonerException(protegeReasonerException.getMessage(), protegeReasonerException);
        }
        finally {
            if (reasonerTaskListener != null) {
                reasonerTask.removeTaskListener(reasonerTaskListener);
            }
        }
        timeDifference.markEnd();
        ReasonerLogger.getInstance().postLogRecord(ReasonerLogRecordFactory.getInstance().createInformationMessageLogRecord("Total time: " + timeDifference, null));
    }
}

