/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.inference.dig.translator;

import edu.stanford.smi.protege.model.Slot;
import edu.stanford.smi.protegex.owl.inference.dig.exception.DIGReasonerException;
import edu.stanford.smi.protegex.owl.inference.dig.reasoner.DIGReasonerIdentity;
import edu.stanford.smi.protegex.owl.inference.dig.translator.DIGDataTypes;
import edu.stanford.smi.protegex.owl.inference.dig.translator.DIGRenderer;
import edu.stanford.smi.protegex.owl.inference.dig.translator.DIGTranslatorPreferences;
import edu.stanford.smi.protegex.owl.inference.protegeowl.log.ReasonerLogRecord;
import edu.stanford.smi.protegex.owl.inference.protegeowl.log.ReasonerLogRecordFactory;
import edu.stanford.smi.protegex.owl.inference.protegeowl.log.ReasonerLogger;
import edu.stanford.smi.protegex.owl.inference.util.ReasonerPreferences;
import edu.stanford.smi.protegex.owl.inference.util.ReasonerUtil;
import edu.stanford.smi.protegex.owl.model.OWLAllDifferent;
import edu.stanford.smi.protegex.owl.model.OWLAllValuesFrom;
import edu.stanford.smi.protegex.owl.model.OWLCardinality;
import edu.stanford.smi.protegex.owl.model.OWLCardinalityBase;
import edu.stanford.smi.protegex.owl.model.OWLClass;
import edu.stanford.smi.protegex.owl.model.OWLComplementClass;
import edu.stanford.smi.protegex.owl.model.OWLDataRange;
import edu.stanford.smi.protegex.owl.model.OWLDatatypeProperty;
import edu.stanford.smi.protegex.owl.model.OWLEnumeratedClass;
import edu.stanford.smi.protegex.owl.model.OWLHasValue;
import edu.stanford.smi.protegex.owl.model.OWLIndividual;
import edu.stanford.smi.protegex.owl.model.OWLIntersectionClass;
import edu.stanford.smi.protegex.owl.model.OWLLogicalClass;
import edu.stanford.smi.protegex.owl.model.OWLMaxCardinality;
import edu.stanford.smi.protegex.owl.model.OWLMinCardinality;
import edu.stanford.smi.protegex.owl.model.OWLModel;
import edu.stanford.smi.protegex.owl.model.OWLNAryLogicalClass;
import edu.stanford.smi.protegex.owl.model.OWLNamedClass;
import edu.stanford.smi.protegex.owl.model.OWLNames;
import edu.stanford.smi.protegex.owl.model.OWLObjectProperty;
import edu.stanford.smi.protegex.owl.model.OWLProperty;
import edu.stanford.smi.protegex.owl.model.OWLQuantifierRestriction;
import edu.stanford.smi.protegex.owl.model.OWLSomeValuesFrom;
import edu.stanford.smi.protegex.owl.model.OWLUnionClass;
import edu.stanford.smi.protegex.owl.model.RDFIndividual;
import edu.stanford.smi.protegex.owl.model.RDFList;
import edu.stanford.smi.protegex.owl.model.RDFProperty;
import edu.stanford.smi.protegex.owl.model.RDFResource;
import edu.stanford.smi.protegex.owl.model.RDFSClass;
import edu.stanford.smi.protegex.owl.model.RDFSDatatype;
import edu.stanford.smi.protegex.owl.model.RDFSLiteral;
import edu.stanford.smi.protegex.owl.model.util.ClassCommenter;
import edu.stanford.smi.protegex.owl.swrl.model.SWRLFactory;
import edu.stanford.smi.protegex.owl.swrl.model.factory.SWRLJavaFactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.Text;

public class DefaultDIGRenderer
implements DIGRenderer {
    private HashSet slotsToIgnore = new HashSet();
    private HashSet clsesToIgnore = new HashSet();
    private DIGReasonerIdentity reasonerIdentity = null;
    private SWRLFactory swrlFactory;

    public void setReasonerIdentity(DIGReasonerIdentity dIGReasonerIdentity) {
        this.reasonerIdentity = dIGReasonerIdentity;
    }

    protected boolean renderAppropriateCls(RDFSClass rDFSClass, Document document, Node node) throws DIGReasonerException {
        boolean bl = false;
        if (rDFSClass instanceof OWLNamedClass) {
            bl = this.render((OWLNamedClass)rDFSClass, document, node);
        } else if (rDFSClass instanceof OWLSomeValuesFrom) {
            bl = this.render((OWLSomeValuesFrom)rDFSClass, document, node);
        } else if (rDFSClass instanceof OWLAllValuesFrom) {
            bl = this.render((OWLAllValuesFrom)rDFSClass, document, node);
        } else if (rDFSClass instanceof OWLHasValue) {
            bl = this.render((OWLHasValue)rDFSClass, document, node);
        } else if (rDFSClass instanceof OWLMinCardinality) {
            bl = this.render((OWLMinCardinality)rDFSClass, document, node);
        } else if (rDFSClass instanceof OWLMaxCardinality) {
            bl = this.render((OWLMaxCardinality)rDFSClass, document, node);
        } else if (rDFSClass instanceof OWLCardinality) {
            bl = this.render((OWLCardinality)rDFSClass, document, node);
        } else if (rDFSClass instanceof OWLIntersectionClass) {
            bl = this.render((OWLIntersectionClass)rDFSClass, document, node);
        } else if (rDFSClass instanceof OWLUnionClass) {
            bl = this.render((OWLUnionClass)rDFSClass, document, node);
        } else if (rDFSClass instanceof OWLComplementClass) {
            bl = this.render((OWLComplementClass)rDFSClass, document, node);
        } else if (rDFSClass instanceof OWLEnumeratedClass) {
            bl = this.render((OWLEnumeratedClass)rDFSClass, document, node);
        } else {
            this.logErrorOrWarning(rDFSClass, "Don't know how to render the type: " + rDFSClass.getClass().getName(), "Ignoring this type and attempting to continue.");
        }
        return bl;
    }

    protected boolean renderAppropriateSlot(Slot slot, Document document, Node node) throws DIGReasonerException {
        boolean bl = true;
        if (slot instanceof OWLObjectProperty) {
            bl = this.render((OWLObjectProperty)slot, document, node);
        } else if (slot instanceof OWLDatatypeProperty) {
            bl = this.render((OWLDatatypeProperty)slot, document, node);
        }
        return bl;
    }

    public void render(OWLModel oWLModel, Document document, Node node) throws DIGReasonerException {
        this.clsesToIgnore.removeAll(this.clsesToIgnore);
        this.slotsToIgnore.removeAll(this.slotsToIgnore);
        this.updateIgnoredCollections(oWLModel);
        this.renderClasses(oWLModel, document, node);
        this.renderProperties(oWLModel, document, node);
        this.renderIndividuals(oWLModel, document, node);
        Collection collection = oWLModel.getOWLAllDifferents();
        if (!collection.isEmpty()) {
            Iterator iterator = collection.iterator();
            while (iterator.hasNext()) {
                Element element = document.createElement("alldifferent");
                OWLAllDifferent oWLAllDifferent = (OWLAllDifferent)iterator.next();
                if (this.isSupportedTellElement("alldifferent")) {
                    for (RDFIndividual rDFIndividual : oWLAllDifferent.getDistinctMembers()) {
                        this.render(rDFIndividual, document, (Node)element);
                    }
                } else {
                    this.renderFakedDifferentFrom(oWLAllDifferent.getDistinctMembers(), document, node);
                }
                if (element.getChildNodes().getLength() <= 0) continue;
                node.appendChild(element);
            }
        }
    }

    protected void renderFakedDifferentFrom(Collection collection, Document document, Node node) throws DIGReasonerException {
        if (this.isSupportedTellElement("disjoint")) {
            Element element = document.createElement("disjoint");
            for (RDFIndividual rDFIndividual : collection) {
                Element element2 = document.createElement("iset");
                this.render(rDFIndividual, document, (Node)element2);
                element.appendChild(element2);
            }
            node.appendChild(element);
        }
    }

    protected void renderClasses(OWLModel oWLModel, Document document, Node node) throws DIGReasonerException {
        Collection collection = ReasonerUtil.getInstance().getNamedClses(oWLModel);
        collection.removeAll(this.clsesToIgnore);
        for (OWLNamedClass oWLNamedClass : collection) {
            Element element = document.createElement("defconcept");
            element.setAttribute("name", oWLNamedClass.getName());
            node.appendChild(element);
            this.renderAxioms(oWLNamedClass, document, node);
        }
    }

    protected void renderProperties(OWLModel oWLModel, Document document, Node node) throws DIGReasonerException {
        Collection<RDFProperty> collection = ReasonerUtil.getInstance().getProperties(oWLModel);
        collection.removeAll(this.slotsToIgnore);
        for (OWLProperty oWLProperty : collection) {
            if (oWLProperty.isAnnotationProperty()) continue;
            Element element = oWLProperty instanceof OWLObjectProperty ? document.createElement("defrole") : document.createElement("defattribute");
            element.setAttribute("name", oWLProperty.getName());
            node.appendChild(element);
            this.renderAxioms(oWLProperty, document, node);
        }
    }

    protected void renderIndividuals(OWLModel oWLModel, Document document, Node node) throws DIGReasonerException {
        Collection collection = ReasonerUtil.getInstance().getIndividuals(oWLModel);
        for (OWLIndividual oWLIndividual : collection) {
            if (this.isSWRLResource(oWLIndividual)) continue;
            Element element = document.createElement("defindividual");
            element.setAttribute("name", oWLIndividual.getName());
            node.appendChild(element);
            this.renderAxioms(oWLIndividual, document, node);
        }
    }

    public boolean render(OWLNamedClass oWLNamedClass, Document document, Node node) {
        boolean bl = true;
        if (!this.clsesToIgnore.contains(oWLNamedClass)) {
            Element element;
            OWLModel oWLModel = oWLNamedClass.getOWLModel();
            if (oWLNamedClass.equals(oWLModel.getOWLThingClass())) {
                element = document.createElement("top");
            } else if (oWLNamedClass.equals(oWLModel.getOWLNothing())) {
                element = document.createElement("bottom");
            } else {
                String string = oWLNamedClass.getName();
                element = document.createElement("catom");
                element.setAttribute("name", string);
            }
            node.appendChild(element);
        } else {
            bl = false;
        }
        return bl;
    }

    public boolean render(OWLSomeValuesFrom oWLSomeValuesFrom, Document document, Node node) throws DIGReasonerException {
        boolean bl = true;
        bl = this.isSupportedLanguageElement("some");
        if (bl) {
            bl = this.render((OWLQuantifierRestriction)oWLSomeValuesFrom, document, node);
        } else {
            this.logErrorOrWarning(oWLSomeValuesFrom, "Existential (some values from) restrictions are not\nsupported by this reasoner.", "Ignoring restriction and attempting to continue.");
        }
        return bl;
    }

    public boolean render(OWLAllValuesFrom oWLAllValuesFrom, Document document, Node node) throws DIGReasonerException {
        boolean bl = true;
        bl = this.isSupportedLanguageElement("all");
        if (bl) {
            bl = this.render((OWLQuantifierRestriction)oWLAllValuesFrom, document, node);
        } else {
            this.logErrorOrWarning(oWLAllValuesFrom, "Universal (all values from) restrictions are not\nsupported by this reasoner.", "Ignoring restriction and attempting to continue.");
        }
        return bl;
    }

    protected boolean render(OWLQuantifierRestriction oWLQuantifierRestriction, Document document, Node node) throws DIGReasonerException {
        boolean bl = true;
        bl = oWLQuantifierRestriction.getFiller() instanceof RDFSClass ? this.renderQuantifierObjectRestriction(oWLQuantifierRestriction, document, node) : this.renderQuantifierDataRestriction(oWLQuantifierRestriction, document, node);
        return bl;
    }

    public boolean renderQuantifierObjectRestriction(OWLQuantifierRestriction oWLQuantifierRestriction, Document document, Node node) throws DIGReasonerException {
        boolean bl = true;
        String string = oWLQuantifierRestriction instanceof OWLSomeValuesFrom ? "some" : "all";
        Element element = document.createElement(string);
        if (this.renderAppropriateSlot(oWLQuantifierRestriction.getOnProperty(), document, element)) {
            bl = this.renderAppropriateCls((RDFSClass)oWLQuantifierRestriction.getFiller(), document, element);
        }
        if (bl) {
            node.appendChild(element);
        }
        return bl;
    }

    public boolean renderQuantifierDataRestriction(OWLQuantifierRestriction oWLQuantifierRestriction, Document document, Node node) throws DIGReasonerException {
        boolean bl = true;
        Element element = null;
        RDFResource rDFResource = oWLQuantifierRestriction.getFiller();
        if (rDFResource instanceof OWLDataRange) {
            OWLDataRange oWLDataRange = (OWLDataRange)rDFResource;
            RDFList rDFList = oWLDataRange.getOneOf();
            List list = rDFList == null ? Collections.EMPTY_LIST : rDFList.getValues();
            element = document.createElement("or");
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                RDFSLiteral rDFSLiteral = oWLQuantifierRestriction.getOWLModel().asRDFSLiteral(iterator.next());
                DIGDataTypes dIGDataTypes = DIGDataTypes.getInstance(oWLQuantifierRestriction.getOWLModel());
                if (dIGDataTypes.isSupported(rDFSLiteral)) {
                    String string = dIGDataTypes.getConcreteDomainExpressionTagName(rDFSLiteral);
                    String string2 = dIGDataTypes.getDataTypeRendering(rDFSLiteral);
                    Element element2 = document.createElement(string);
                    element2.setAttribute("val", string2);
                    bl = this.renderAppropriateSlot(oWLQuantifierRestriction.getOnProperty(), document, element2);
                    if (!bl) continue;
                    element.appendChild(element2);
                    continue;
                }
                bl = false;
                this.logErrorOrWarning(oWLQuantifierRestriction, "The enumerated datatypes filler contains an unsupported\ndatatype (" + rDFSLiteral + ").", "Ignoring this restriction and attempting to continue.");
                break;
            }
        } else {
            this.logErrorOrWarning(oWLQuantifierRestriction, "The current version of the DIG interface does not support\nquantifier restrictions on datatype properties.", "Ignoring this restriction and attempting to continue.");
            bl = false;
        }
        if (bl) {
            node.appendChild(element);
        }
        return bl;
    }

    public boolean render(OWLHasValue oWLHasValue, Document document, Node node) throws DIGReasonerException {
        boolean bl = true;
        Element element = null;
        OWLProperty oWLProperty = (OWLProperty)oWLHasValue.getOnProperty();
        if (oWLProperty.isObjectProperty()) {
            if (oWLHasValue.getHasValue() instanceof RDFIndividual) {
                if (this.isSupportedLanguageElement("some")) {
                    element = document.createElement("some");
                    bl = this.renderAppropriateSlot(oWLHasValue.getOnProperty(), document, element);
                    if (bl) {
                        if (this.isSupportedLanguageElement("iset")) {
                            Element element2 = document.createElement("iset");
                            bl = this.render((RDFIndividual)oWLHasValue.getHasValue(), document, (Node)element2);
                            if (bl) {
                                element.appendChild(element2);
                            }
                        } else {
                            this.logErrorOrWarning(oWLHasValue, "Has value restrictions are not supported by this reasoner.\n(Indirectly caused by no support for individual enumerations).", "Ignoring this restriction and attempting to continue.");
                            bl = false;
                        }
                    }
                } else {
                    this.logErrorOrWarning(oWLHasValue, "Has value restrictions are not supported by this reasoner.\n(Indirectly caused by no support for existential restrictions).", "Ignoring this restriction and attempting to continue.");
                    bl = false;
                }
            } else {
                bl = false;
                this.logErrorOrWarning(oWLHasValue, "The ontology is in OWL-FULL.\nThis is because the filler for a hasValue object property\nrestriction is not an individual.", "Ignoring restriction and attempting to continue.");
            }
        } else {
            bl = false;
            this.logErrorOrWarning(oWLHasValue, "DIG 1.1 (The language used to communicate with the reasoner)\ndoes not support hasValue restrictions on datatype properties\n", "Ignoring restriction and attempting to continue.");
        }
        if (bl) {
            node.appendChild(element);
        }
        return bl;
    }

    public boolean render(OWLMinCardinality oWLMinCardinality, Document document, Node node) throws DIGReasonerException {
        boolean bl = true;
        if (this.isSupportedLanguageElement("atleast")) {
            bl = this.render(oWLMinCardinality, document, node, "atleast");
        } else {
            bl = false;
            this.logErrorOrWarning(oWLMinCardinality, "Minimum cardinality restrictions are not supported by this reasoner.", "Ignoring this restriction and attempting to continue.");
        }
        return bl;
    }

    public boolean render(OWLMaxCardinality oWLMaxCardinality, Document document, Node node) throws DIGReasonerException {
        boolean bl = true;
        if (this.isSupportedLanguageElement("atmost")) {
            bl = this.render(oWLMaxCardinality, document, node, "atmost");
        } else {
            bl = false;
            this.logErrorOrWarning(oWLMaxCardinality, "Maximum cardinality restrictions are not supported by this reasoner.", "Ignoring this restriction and attempting to continue.");
        }
        return bl;
    }

    public boolean render(OWLCardinality oWLCardinality, Document document, Node node) throws DIGReasonerException {
        boolean bl = true;
        if (this.isSupportedLanguageElement("and")) {
            Element element = document.createElement("and");
            if (this.isSupportedLanguageElement("atleast")) {
                bl = this.render(oWLCardinality, document, (Node)element, "atleast");
            } else {
                bl = false;
                this.logErrorOrWarning(oWLCardinality, "Cardinality restrictions are not supported by this reasoner.\n(Indirectly caused by lack of support for max cardinality restrictions).", "Ignoring this restriction and attempting to continue.");
            }
            if (bl) {
                if (this.isSupportedLanguageElement("atmost")) {
                    bl = this.render(oWLCardinality, document, (Node)element, "atmost");
                } else {
                    bl = false;
                    this.logErrorOrWarning(oWLCardinality, "Cardinality restrictions are not supported by this reasoner.\n(Indirectly caused by lack of support for min cardinality restrictions).", "Ignoring this restriction and attempting to continue.");
                }
            }
            if (bl) {
                node.appendChild(element);
            }
        } else {
            bl = false;
            this.logErrorOrWarning(oWLCardinality, "Cardinality restrictions are not supported by this reasoner.\n(Indirectly causedby lack of support for intersection classes.)", "Ignoring this restriction and attepting to continue.");
        }
        return bl;
    }

    protected boolean render(OWLCardinalityBase oWLCardinalityBase, Document document, Node node, String string) throws DIGReasonerException {
        Object object;
        boolean bl = true;
        if (!(oWLCardinalityBase.getOnProperty() instanceof OWLProperty)) {
            this.logErrorOrWarning(oWLCardinalityBase, "The property " + oWLCardinalityBase.getOnProperty().getBrowserText() + " on the restriction\n" + oWLCardinalityBase.getBrowserText() + " is not an OWLProperty.\n", "Ignoring this restriction and attempting to continue.");
            bl = false;
            return bl;
        }
        OWLProperty oWLProperty = (OWLProperty)oWLCardinalityBase.getOnProperty();
        if (oWLProperty.isObjectProperty()) {
            if (((OWLObjectProperty)oWLProperty).isTransitive()) {
                bl = false;
                this.logErrorOrWarning(oWLCardinalityBase, "The property " + oWLProperty.getBrowserText() + " is transitive.\n" + "OWL-DL does not allow transitive properties to be used\n" + "is cardinality restrictions.", "Ignoring this restriction and attempting to continue.");
            } else {
                object = oWLProperty.getInverseProperty();
                if (object != null && ((OWLObjectProperty)object).isTransitive()) {
                    bl = false;
                    this.logErrorOrWarning(oWLCardinalityBase, "The inverse property of " + oWLProperty.getBrowserText() + " (" + object.getBrowserText() + ")\n" + "is transitive. OWL-DL does not allow transitive properties, or\n" + "properties whose inverse property is transitive to be used in\n" + "cardinality restrictions.", "Ignoring this restriction and attempting to continue.");
                }
            }
        } else {
            bl = false;
            this.logErrorOrWarning(oWLCardinalityBase, "Not able to convert datatype property cardinality restrictions\nto DIG (the langauge used to communicate with the reasoner).", "Ignoring this restriction and attempting to continue.");
        }
        if (bl) {
            object = null;
            object = document.createElement(string);
            object.setAttribute("num", Integer.toString(oWLCardinalityBase.getCardinality()));
            bl = this.renderAppropriateSlot(oWLCardinalityBase.getOnProperty(), document, (Node)object);
            if (bl) {
                this.renderAppropriateCls(oWLCardinalityBase.getQualifier(), document, (Node)object);
            }
            if (bl) {
                node.appendChild((Node)object);
            }
        }
        return bl;
    }

    public boolean render(OWLUnionClass oWLUnionClass, Document document, Node node) throws DIGReasonerException {
        boolean bl = true;
        if (this.isSupportedLanguageElement("or")) {
            bl = this.render(oWLUnionClass, document, node, "or");
        } else {
            bl = false;
            this.logErrorOrWarning(oWLUnionClass, "Union classes (disjunctions) are not supported by this reasoner.", "Ignoring this class and attemptng to continue.");
        }
        return bl;
    }

    public boolean render(OWLComplementClass oWLComplementClass, Document document, Node node) throws DIGReasonerException {
        boolean bl = true;
        if (this.isSupportedLanguageElement("not")) {
            bl = this.render(oWLComplementClass, document, node, "not");
        } else {
            bl = false;
            this.logErrorOrWarning(oWLComplementClass, "Complement classes are not supported by this reasoner.", "Ignoring this class and attemptng to continue.");
        }
        return bl;
    }

    public boolean render(OWLIntersectionClass oWLIntersectionClass, Document document, Node node) throws DIGReasonerException {
        boolean bl = true;
        if (this.isSupportedLanguageElement("and")) {
            bl = this.render(oWLIntersectionClass, document, node, "and");
        } else {
            bl = false;
            this.logErrorOrWarning(oWLIntersectionClass, "Intersection classes (conjunctions) are not supported by this reasoner.", "Ignoring this class and attemptng to continue.");
        }
        return bl;
    }

    protected boolean render(OWLLogicalClass oWLLogicalClass, Document document, Node node, String string) throws DIGReasonerException {
        boolean bl = true;
        Element element = null;
        element = document.createElement(string);
        Collection<RDFSClass> collection = null;
        collection = oWLLogicalClass instanceof OWLNAryLogicalClass ? ((OWLNAryLogicalClass)oWLLogicalClass).getOperands() : Collections.singleton(((OWLComplementClass)oWLLogicalClass).getComplement());
        for (RDFResource rDFResource : collection) {
            if (rDFResource instanceof RDFSClass) {
                bl = this.renderAppropriateCls((RDFSClass)rDFResource, document, element);
                if (bl) continue;
                break;
            }
            this.logErrorOrWarning(oWLLogicalClass, "Intersection, Union and Complement classes may only\ncontain operands that are OWL Classes.", "Ignoring class and attempting to continue.");
            bl = false;
            break;
        }
        if (bl) {
            node.appendChild(element);
        }
        return bl;
    }

    public boolean render(OWLEnumeratedClass oWLEnumeratedClass, Document document, Node node) throws DIGReasonerException {
        boolean bl = true;
        if (this.isSupportedLanguageElement("iset")) {
            Element element = document.createElement("iset");
            Collection collection = oWLEnumeratedClass.getOneOf();
            for (Object e : collection) {
                if (e instanceof RDFIndividual) {
                    bl = this.render((RDFIndividual)e, document, (Node)element);
                    if (bl) continue;
                    break;
                }
                this.logErrorOrWarning(oWLEnumeratedClass, "The ontology is in OWL-Full.\nEnumerated classes can only be made up of enumerations\nof individuals.", "Ignoring enumerated class.");
                bl = false;
                break;
            }
            if (bl) {
                node.appendChild(element);
            }
        } else {
            bl = false;
            this.logErrorOrWarning(oWLEnumeratedClass, "Enumeration classes are not supported by this reasoner.", "Ignoring this class and attempting to continue.");
        }
        return bl;
    }

    public boolean render(OWLObjectProperty oWLObjectProperty, Document document, Node node) {
        boolean bl = true;
        Element element = null;
        if (!this.slotsToIgnore.contains(oWLObjectProperty)) {
            element = document.createElement("ratom");
            element.setAttribute("name", oWLObjectProperty.getName());
            node.appendChild(element);
        } else {
            bl = false;
        }
        return bl;
    }

    public boolean render(OWLDatatypeProperty oWLDatatypeProperty, Document document, Node node) throws DIGReasonerException {
        boolean bl = true;
        if (this.isSupportedLanguageElement("attribute")) {
            if (!this.slotsToIgnore.contains(oWLDatatypeProperty)) {
                Element element = document.createElement("attribute");
                element.setAttribute("name", oWLDatatypeProperty.getName());
                node.appendChild(element);
            } else {
                bl = false;
            }
        } else {
            bl = false;
            this.logErrorOrWarning(oWLDatatypeProperty, "Datatype properties are not supported by this reasoner.", "Ignoring property and attempting to continue.");
        }
        return bl;
    }

    public boolean render(RDFIndividual rDFIndividual, Document document, Node node) throws DIGReasonerException {
        if (this.isSWRLResource(rDFIndividual)) {
            return false;
        }
        boolean bl = true;
        Element element = document.createElement("individual");
        element.setAttribute("name", rDFIndividual.getName());
        node.appendChild(element);
        return bl;
    }

    public void renderAxioms(OWLNamedClass oWLNamedClass, Document document, Node node) throws DIGReasonerException {
        Object object;
        Object object2;
        Object object3;
        Collection collection;
        boolean bl = true;
        boolean bl2 = DIGTranslatorPreferences.getInstance().isIgnoreNecessaryConditionsOnDefinedClasses();
        if (!(oWLNamedClass.isDefinedClass() && bl2)) {
            Object object42;
            collection = oWLNamedClass.getPureSuperclasses();
            for (Object object42 : collection) {
                if (object42.equals(object42.getOWLModel().getOWLThingClass()) || ((ClassCommenter)(object3 = new ClassCommenter(oWLNamedClass.getOWLModel()))).isCommentedOut((RDFSClass)object42) || !(bl = this.render(oWLNamedClass, document, (Node)(object2 = document.createElement("impliesc")))) || !(bl = this.renderAppropriateCls((RDFSClass)object42, document, (Node)object2))) continue;
                node.appendChild((Node)object2);
            }
            object42 = oWLNamedClass.getDisjointClasses();
            object3 = object42.iterator();
            while (object3.hasNext()) {
                Element element;
                object2 = (RDFSClass)object3.next();
                if (object2.getEquivalentClasses().size() > 0 && bl2 || ((ClassCommenter)(object = new ClassCommenter(oWLNamedClass.getOWLModel()))).isCommentedOut((RDFSClass)object2) || !(bl = this.render(oWLNamedClass, document, (Node)(element = document.createElement("disjoint"))))) continue;
                bl = this.renderAppropriateCls((RDFSClass)object2, document, element);
                bl = true;
                if (!true) continue;
                node.appendChild(element);
            }
        }
        collection = oWLNamedClass.getEquivalentClasses();
        for (Object object42 : collection) {
            object3 = new ClassCommenter(oWLNamedClass.getOWLModel());
            if (((ClassCommenter)object3).isCommentedOut((RDFSClass)object42) || !(bl = this.render(oWLNamedClass, document, (Node)(object2 = document.createElement("equalc"))))) continue;
            if (!(object42 instanceof OWLIntersectionClass)) {
                object = document.createElement("and");
                bl = this.renderAppropriateCls((RDFSClass)object42, document, (Node)object);
                object2.appendChild((Node)object);
            } else {
                bl = this.renderAppropriateCls((RDFSClass)object42, document, (Node)object2);
            }
            bl = true;
            if (!true) continue;
            node.appendChild((Node)object2);
        }
    }

    public void renderAxioms(OWLProperty oWLProperty, Document document, Node node) throws DIGReasonerException {
        this.renderSuperSlots(oWLProperty, document, node);
        this.renderEquivalentSlots(oWLProperty, document, node);
        this.renderSlotDomain(oWLProperty, document, node);
        this.renderSlotRange(oWLProperty, document, node);
        this.renderInverseSlot(oWLProperty, document, node);
        if (oWLProperty.isObjectProperty()) {
            this.renderTransitiveSlot(oWLProperty, document, node);
            if (oWLProperty.isInverseFunctional()) {
                this.renderInverseFunctionalSlot(oWLProperty, document, node);
            }
            if (((OWLObjectProperty)oWLProperty).isSymmetric()) {
                this.renderSymmetricSlot(oWLProperty, document, node);
            }
        }
        if (oWLProperty.isFunctional()) {
            this.renderFunctionalSlot(oWLProperty, document, node);
        }
    }

    protected void renderSuperSlots(OWLProperty oWLProperty, Document document, Node node) throws DIGReasonerException {
        Collection collection = oWLProperty.getSuperproperties(false);
        for (Slot slot : collection) {
            Element element = document.createElement("impliesr");
            boolean bl = this.renderAppropriateSlot(oWLProperty, document, element);
            if (!bl || !(bl = this.renderAppropriateSlot(slot, document, element))) continue;
            node.appendChild(element);
        }
    }

    protected void renderEquivalentSlots(OWLProperty oWLProperty, Document document, Node node) throws DIGReasonerException {
        Collection collection = oWLProperty.getEquivalentProperties();
        for (Slot slot : collection) {
            Element element = document.createElement("equalr");
            boolean bl = this.renderAppropriateSlot(oWLProperty, document, element);
            if (!bl || !(bl = this.renderAppropriateSlot(slot, document, element))) continue;
            node.appendChild(element);
        }
    }

    protected void renderSlotDomain(OWLProperty oWLProperty, Document document, Node node) throws DIGReasonerException {
        Collection collection = oWLProperty.getDomains(false);
        Iterator iterator = collection.iterator();
        Element element = document.createElement("domain");
        OWLNamedClass oWLNamedClass = oWLProperty.getOWLModel().getOWLThingClass();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            if (!(e instanceof OWLClass) || oWLNamedClass.equals(e) || !this.renderAppropriateSlot(oWLProperty, document, element)) continue;
            node.appendChild(element);
            this.renderAppropriateCls((OWLClass)e, document, element);
        }
    }

    protected void renderSlotRange(OWLProperty oWLProperty, Document document, Node node) throws DIGReasonerException {
        if (oWLProperty.isObjectProperty()) {
            Collection collection = oWLProperty.getUnionRangeClasses();
            Iterator iterator = collection.iterator();
            Element element = document.createElement("or");
            Element element2 = document.createElement("range");
            while (iterator.hasNext()) {
                Object e = iterator.next();
                if (!(e instanceof RDFSClass)) continue;
                this.renderAppropriateCls((RDFSClass)e, document, element);
            }
            if (element.getChildNodes().getLength() > 0 && this.renderAppropriateSlot(oWLProperty, document, element2)) {
                element2.appendChild(element);
                node.appendChild(element2);
            }
        } else {
            RDFSDatatype rDFSDatatype = oWLProperty.getRangeDatatype();
            DIGDataTypes dIGDataTypes = DIGDataTypes.getInstance(oWLProperty.getOWLModel());
            if (dIGDataTypes.isSupported(rDFSDatatype)) {
                Element element = document.createElement(dIGDataTypes.getPropertyRangeTagName(rDFSDatatype));
                boolean bl = this.renderAppropriateSlot(oWLProperty, document, element);
                if (bl) {
                    node.appendChild(element);
                }
            } else {
                this.logErrorOrWarning(oWLProperty, "DIG 1.1 (The language used to communicate with the reasoner)\ndoes not support the range specified for the datatype property\n" + oWLProperty.getBrowserText() + ".", "Ignoring this range on this property.");
            }
        }
    }

    protected void renderInverseSlot(OWLProperty oWLProperty, Document document, Node node) throws DIGReasonerException {
        Element element;
        Element element2;
        boolean bl;
        OWLProperty oWLProperty2 = (OWLProperty)oWLProperty.getInverseProperty();
        if (oWLProperty2 != null && (bl = this.renderAppropriateSlot(oWLProperty2, document, element2 = document.createElement("inverse"))) && (bl = this.renderAppropriateSlot(oWLProperty, document, element = document.createElement("equalr")))) {
            element.appendChild(element2);
            node.appendChild(element);
        }
    }

    protected void renderInverseFunctionalSlot(OWLProperty oWLProperty, Document document, Node node) throws DIGReasonerException {
        OWLProperty oWLProperty2 = (OWLProperty)oWLProperty.getInverseProperty();
        if (((OWLObjectProperty)oWLProperty).isTransitive()) {
            this.logErrorOrWarning(oWLProperty, "The ontology is in OWL-Full.\nThis has been caused by the property " + oWLProperty.getBrowserText() + "\n" + "being transitive and inverse functional.", "Ignoring inverse functional characteristic on this property\nand attempting to continue.");
        } else if (oWLProperty2 == null) {
            Element element = document.createElement("defrole");
            String string = "*Inverse_of_" + oWLProperty.getName();
            element.setAttribute("name", string);
            node.appendChild(element);
            Element element2 = document.createElement("ratom");
            element2.setAttribute("name", string);
            Element element3 = document.createElement("equalr");
            this.renderAppropriateSlot(oWLProperty, document, element3);
            Element element4 = document.createElement("inverse");
            element4.appendChild(element2);
            element3.appendChild(element4);
            node.appendChild(element3);
            Element element5 = document.createElement("functional");
            Element element6 = document.createElement("ratom");
            element6.setAttribute("name", string);
            element5.appendChild(element6);
            document.getDocumentElement().appendChild(element5);
        } else {
            this.renderFunctionalSlot(oWLProperty2, document, node);
        }
    }

    protected void renderTransitiveSlot(OWLProperty oWLProperty, Document document, Node node) throws DIGReasonerException {
        Element element;
        boolean bl;
        if (((OWLObjectProperty)oWLProperty).isTransitive() && (bl = this.renderAppropriateSlot(oWLProperty, document, element = document.createElement("transitive")))) {
            node.appendChild(element);
        }
    }

    protected void renderSymmetricSlot(OWLProperty oWLProperty, Document document, Node node) throws DIGReasonerException {
        Element element = document.createElement("equalr");
        boolean bl = this.renderAppropriateSlot(oWLProperty, document, element);
        if (bl) {
            Element element2 = document.createElement("inverse");
            this.renderAppropriateSlot(oWLProperty, document, element2);
            element.appendChild(element2);
            node.appendChild(element);
        }
    }

    protected void renderFunctionalSlot(OWLProperty oWLProperty, Document document, Node node) throws DIGReasonerException {
        if (oWLProperty.isObjectProperty() && ((OWLObjectProperty)oWLProperty).isTransitive()) {
            this.logErrorOrWarning(oWLProperty, "The ontology is in OWL-Full.\nThis is because the property " + oWLProperty.getBrowserText() + " is both\n" + "transitive and functional.", "Ignoring the functional characteristic of this property and\nattempting to continue.");
            return;
        }
        Element element = document.createElement("functional");
        boolean bl = this.renderAppropriateSlot(oWLProperty, document, element);
        if (bl) {
            node.appendChild(element);
        }
    }

    private void renderFakeSameAs(Collection collection, Document document, Node node) throws DIGReasonerException {
        Object[] objectArray = collection.toArray();
        for (int i = 0; i < objectArray.length; ++i) {
            for (int j = 0; j < objectArray.length; ++j) {
                if (i == j) continue;
                RDFIndividual rDFIndividual = (RDFIndividual)objectArray[i];
                Element element = document.createElement("iset");
                this.render(rDFIndividual, document, (Node)element);
                RDFIndividual rDFIndividual2 = (RDFIndividual)objectArray[j];
                Element element2 = document.createElement("iset");
                this.render(rDFIndividual2, document, (Node)element2);
                Element element3 = document.createElement("equalc");
                element3.appendChild(element);
                element3.appendChild(element2);
                node.appendChild(element3);
            }
        }
    }

    public void renderAxioms(RDFIndividual rDFIndividual, Document document, Node node) throws DIGReasonerException {
        Object object;
        Object object2;
        Object object3;
        Object object4;
        this.renderTypes(rDFIndividual, document, node);
        Collection collection = rDFIndividual.getSameAs();
        if (!collection.isEmpty()) {
            if (this.isSupportedTellElement("sameas")) {
                object4 = collection.iterator();
                while (object4.hasNext()) {
                    object3 = (RDFIndividual)object4.next();
                    object2 = document.createElement("sameas");
                    if (!this.render(rDFIndividual, document, (Node)object2) || !this.render((RDFIndividual)object3, document, (Node)object2)) continue;
                    node.appendChild((Node)object2);
                }
            } else {
                this.logErrorOrWarning(rDFIndividual, "SameAs construct for individuals is not supported\nby this reasoner.", "Ignoring this assertion.");
            }
        }
        if (!(object3 = rDFIndividual.getPropertyValues((RDFProperty)(object4 = rDFIndividual.getOWLModel().getRDFProperty(OWLNames.Slot.DIFFERENT_FROM)), true)).isEmpty()) {
            Object object5;
            if (this.isSupportedTellElement("differentfrom")) {
                object2 = object3.iterator();
                while (object2.hasNext()) {
                    object5 = (RDFIndividual)object2.next();
                    object = document.createElement("differentfrom");
                    if (!this.render(rDFIndividual, document, (Node)object) || !this.render((RDFIndividual)object5, document, (Node)object)) continue;
                    node.appendChild((Node)object);
                }
            } else {
                object2 = object3.iterator();
                object5 = new ArrayList();
                ((ArrayList)object5).add(rDFIndividual);
                while (object2.hasNext()) {
                    ((ArrayList)object5).add(object2.next());
                }
                this.renderFakedDifferentFrom((Collection)object5, document, node);
            }
        }
        for (Object object5 : rDFIndividual.getOWLModel().getRDFProperties()) {
            boolean bl;
            Object object6;
            if (object5.isAnnotationProperty() || !(object5 instanceof OWLProperty)) continue;
            if (((OWLProperty)object5).isObjectProperty()) {
                for (Object object7 : rDFIndividual.getPropertyValues((RDFProperty)object5)) {
                    if (object7 instanceof OWLIndividual) {
                        object6 = document.createElement("related");
                        bl = this.render(rDFIndividual, document, (Node)object6);
                        if (!bl || !(bl = this.renderAppropriateSlot((Slot)object5, document, (Node)object6)) || !(bl = this.render((OWLIndividual)object7, document, (Node)object6))) continue;
                        node.appendChild((Node)object6);
                        continue;
                    }
                    this.logErrorOrWarning(rDFIndividual, "The ontology is in OWL-Full.\nThe filler for an object property relationship is not\nan individual.", "Ignoring this relationship and attempting to continue.");
                }
                continue;
            }
            object = rDFIndividual.getPropertyValueLiterals((RDFProperty)object5).iterator();
            while (object.hasNext()) {
                Object e;
                RDFSLiteral rDFSLiteral;
                Object object7;
                object7 = object5.getOWLModel();
                object6 = DIGDataTypes.getInstance(object7);
                if (((DIGDataTypes)object6).isSupported(rDFSLiteral = object7.asRDFSLiteral(e = object.next()))) {
                    Element element = document.createElement("value");
                    bl = this.render(rDFIndividual, document, (Node)element);
                    if (!bl || !(bl = this.renderAppropriateSlot((Slot)object5, document, element))) continue;
                    String string = ((DIGDataTypes)object6).getIndividualAxiomValueTagName(rDFSLiteral);
                    Element element2 = document.createElement(string);
                    element.appendChild(element2);
                    Text text = document.createTextNode(((DIGDataTypes)object6).getDataTypeRendering(rDFSLiteral));
                    element2.appendChild(text);
                    node.appendChild(element);
                    continue;
                }
                this.logErrorOrWarning(rDFIndividual, "The current version of DIG (the language used to communicate)\nwith the reasoner) does not support the datatype used in the\n" + object5.getBrowserText() + " relationship.", "Ignoring this relationship and attempting to continue.");
            }
        }
    }

    protected void renderTypes(RDFIndividual rDFIndividual, Document document, Node node) throws DIGReasonerException {
        Collection collection = rDFIndividual.getRDFTypes();
        for (Object e : collection) {
            Element element;
            boolean bl;
            if (!(e instanceof OWLClass) || e instanceof OWLEnumeratedClass || !(bl = this.render(rDFIndividual, document, (Node)(element = document.createElement("instanceof")))) || !(bl = this.renderAppropriateCls((OWLClass)e, document, element))) continue;
            node.appendChild(element);
        }
    }

    protected boolean isSupportedTellElement(String string) {
        boolean bl = true;
        if (this.reasonerIdentity != null) {
            bl = this.reasonerIdentity.supportsTellElemement(string);
        }
        return bl;
    }

    protected boolean isSupportedAskElement(String string) {
        boolean bl = true;
        if (this.reasonerIdentity != null) {
            bl = this.reasonerIdentity.supportsAskElement(string);
        }
        return bl;
    }

    protected boolean isSupportedLanguageElement(String string) {
        boolean bl = true;
        if (this.reasonerIdentity != null) {
            bl = this.reasonerIdentity.supportsLanguageElement(string);
        }
        return bl;
    }

    protected void logErrorOrWarning(RDFResource rDFResource, String string, String string2) throws DIGReasonerException {
        if (ReasonerPreferences.getInstance().isWarningAsErrors()) {
            throw new DIGReasonerException(string);
        }
        String string3 = string + "\n" + string2;
        ReasonerLogRecordFactory reasonerLogRecordFactory = ReasonerLogRecordFactory.getInstance();
        ReasonerLogRecord reasonerLogRecord = reasonerLogRecordFactory.createWarningMessageLogRecord(rDFResource, string3, null);
        ReasonerLogger.getInstance().postLogRecord(reasonerLogRecord);
    }

    private void updateIgnoredCollections(OWLModel oWLModel) {
        if (!this.isSWRLModel(oWLModel)) {
            return;
        }
        this.swrlFactory = new SWRLFactory(oWLModel);
        this.clsesToIgnore.addAll(this.swrlFactory.getSWRLClasses());
        this.slotsToIgnore.addAll(this.swrlFactory.getSWRLProperties());
        this.slotsToIgnore.addAll(this.swrlFactory.getSWRLBProperties());
    }

    private boolean isSWRLModel(OWLModel oWLModel) {
        return oWLModel.getOWLJavaFactory() instanceof SWRLJavaFactory;
    }

    private boolean isSWRLResource(RDFResource rDFResource) {
        return this.swrlFactory == null ? false : SWRLFactory.isSWRLResource(rDFResource);
    }
}

