/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.inference.dig.reasoner;

import edu.stanford.smi.protegex.owl.inference.dig.reasoner.ReasonerIdentity;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class DIGReasonerIdentity
implements ReasonerIdentity {
    private String reasonerName;
    private String reasonerMessage;
    private String reasonerVersion;
    private HashSet supportedLanguageElements = new HashSet();
    private HashSet supportedTellElements = new HashSet();
    private HashSet supportedAskElements = new HashSet();

    protected void clear() {
        this.supportedLanguageElements = new HashSet();
        this.supportedTellElements = new HashSet();
        this.supportedAskElements = new HashSet();
        this.reasonerName = "";
        this.reasonerMessage = "";
        this.reasonerVersion = "";
    }

    public void parseIdentityDescrtiption(Document document) {
        this.clear();
        this.processDocument(document);
    }

    protected void processDocument(Document document) {
        Element element = document.getDocumentElement();
        this.reasonerName = element.getAttribute("name");
        this.reasonerMessage = element.getAttribute("message");
        this.reasonerVersion = element.getAttribute("version");
        if (this.reasonerName.equals("Racer")) {
            this.supportedLanguageElements.add("iset");
            this.supportedLanguageElements.add("individual");
        }
        Element element2 = (Element)element.getElementsByTagName("supports").item(0);
        Node node = element2.getElementsByTagName("language").item(0);
        this.fillSet(node, this.supportedLanguageElements);
        node = element2.getElementsByTagName("tell").item(0);
        this.fillSet(node, this.supportedTellElements);
        node = element2.getElementsByTagName("ask").item(0);
        this.fillSet(node, this.supportedAskElements);
    }

    public String getName() {
        return this.reasonerName;
    }

    public String getVersion() {
        return this.reasonerVersion;
    }

    public String getMessage() {
        return this.reasonerMessage;
    }

    public Collection getSupportedLanguageElements() {
        return Collections.unmodifiableCollection(this.supportedLanguageElements);
    }

    public Collection getSupportedTellElements() {
        return Collections.unmodifiableCollection(this.supportedTellElements);
    }

    public Collection getSupportedAskElements() {
        return Collections.unmodifiableCollection(this.supportedAskElements);
    }

    public boolean supportsLanguageElement(String string) {
        return this.supportedLanguageElements.contains(string);
    }

    public boolean supportsTellElemement(String string) {
        return this.supportedTellElements.contains(string);
    }

    public boolean supportsAskElement(String string) {
        return this.supportedAskElements.contains(string);
    }

    private void fillSet(Node node, Set set) {
        NodeList nodeList = node.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            if (!(nodeList.item(i) instanceof Element)) continue;
            String string = nodeList.item(i).getNodeName();
            set.add(string);
        }
    }
}

