/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.inference.dig;

import edu.stanford.smi.protege.event.ProjectAdapter;
import edu.stanford.smi.protege.event.ProjectEvent;
import edu.stanford.smi.protege.event.ProjectListener;
import edu.stanford.smi.protege.util.Log;
import edu.stanford.smi.protegex.owl.inference.dig.exception.DIGError;
import edu.stanford.smi.protegex.owl.inference.dig.exception.DIGReasonerException;
import edu.stanford.smi.protegex.owl.inference.dig.reasoner.DIGReasoner;
import edu.stanford.smi.protegex.owl.inference.dig.reasoner.DIGReasonerIdentity;
import edu.stanford.smi.protegex.owl.inference.dig.reasoner.DefaultDIGReasoner;
import edu.stanford.smi.protegex.owl.inference.dig.reasoner.logger.DIGLogger;
import edu.stanford.smi.protegex.owl.inference.dig.reasoner.logger.DIGLoggerListener;
import edu.stanford.smi.protegex.owl.inference.protegeowl.ProtegeOWLReasoner;
import edu.stanford.smi.protegex.owl.inference.protegeowl.log.ErrorMessageLogRecord;
import edu.stanford.smi.protegex.owl.inference.protegeowl.log.ReasonerLogRecordFactory;
import edu.stanford.smi.protegex.owl.inference.protegeowl.log.ReasonerLogger;
import edu.stanford.smi.protegex.owl.inference.protegeowl.task.ReasonerTask;
import edu.stanford.smi.protegex.owl.inference.protegeowl.task.ReasonerTaskAdapter;
import edu.stanford.smi.protegex.owl.inference.protegeowl.task.ReasonerTaskEvent;
import edu.stanford.smi.protegex.owl.inference.protegeowl.task.ReasonerTaskListener;
import edu.stanford.smi.protegex.owl.inference.protegeowl.task.digreasoner.ClassifyTaxonomyTask;
import edu.stanford.smi.protegex.owl.inference.protegeowl.task.digreasoner.GetAncestorConceptsTask;
import edu.stanford.smi.protegex.owl.inference.protegeowl.task.digreasoner.GetConceptIntersectionSuperclassesTask;
import edu.stanford.smi.protegex.owl.inference.protegeowl.task.digreasoner.GetConceptSatisfiableTask;
import edu.stanford.smi.protegex.owl.inference.protegeowl.task.digreasoner.GetDescendantConceptsTask;
import edu.stanford.smi.protegex.owl.inference.protegeowl.task.digreasoner.GetEquivalentConceptsTask;
import edu.stanford.smi.protegex.owl.inference.protegeowl.task.digreasoner.GetIndividualInferredTypesTask;
import edu.stanford.smi.protegex.owl.inference.protegeowl.task.digreasoner.GetIndividualsBelongingToConceptTask;
import edu.stanford.smi.protegex.owl.inference.protegeowl.task.digreasoner.GetSubConceptsTask;
import edu.stanford.smi.protegex.owl.inference.protegeowl.task.digreasoner.GetSubsumptionRelationshipTask;
import edu.stanford.smi.protegex.owl.inference.protegeowl.task.digreasoner.GetSuperConceptsTask;
import edu.stanford.smi.protegex.owl.inference.protegeowl.task.digreasoner.IsConceptIntersectionSatisfiableTask;
import edu.stanford.smi.protegex.owl.inference.protegeowl.task.digreasoner.IsDisjointToTask;
import edu.stanford.smi.protegex.owl.inference.protegeowl.task.digreasoner.IsSubsumedByTask;
import edu.stanford.smi.protegex.owl.inference.protegeowl.task.digreasoner.SynchronizeReasonerTask;
import edu.stanford.smi.protegex.owl.inference.protegeowl.task.digreasoner.UpdateEquivalentClassesTask;
import edu.stanford.smi.protegex.owl.inference.protegeowl.task.digreasoner.UpdateInconsistentClassesTask;
import edu.stanford.smi.protegex.owl.inference.protegeowl.task.digreasoner.UpdateInferredHierarchyTask;
import edu.stanford.smi.protegex.owl.inference.protegeowl.task.digreasoner.UpdateInferredTypesTask;
import edu.stanford.smi.protegex.owl.inference.reasoner.AbstractProtegeReasoner;
import edu.stanford.smi.protegex.owl.inference.reasoner.ProtegeReasoner;
import edu.stanford.smi.protegex.owl.inference.reasoner.exception.ProtegeReasonerException;
import edu.stanford.smi.protegex.owl.inference.util.ReasonerPreferences;
import edu.stanford.smi.protegex.owl.inference.util.TimeDifference;
import edu.stanford.smi.protegex.owl.model.OWLClass;
import edu.stanford.smi.protegex.owl.model.OWLIndividual;
import edu.stanford.smi.protegex.owl.model.OWLModel;
import edu.stanford.smi.protegex.owl.model.OWLNamedClass;
import java.util.Collection;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultProtegeDIGReasoner
extends AbstractProtegeReasoner
implements ProtegeOWLReasoner,
ProtegeReasoner {
    private static transient Logger log = Log.getLogger(DefaultProtegeDIGReasoner.class);
    private DIGReasoner reasoner;
    private String kbURI;
    private DIGLoggerListener digLoggerListener = new DIGLoggerListener(){

        public void errorLogged(DIGError dIGError) {
            OWLNamedClass oWLNamedClass = DefaultProtegeDIGReasoner.this.owlModel.getOWLNamedClass(dIGError.getID());
            ReasonerLogger.getInstance().postLogRecord(new ErrorMessageLogRecord(oWLNamedClass, dIGError.getMessage(), null));
        }
    };

    public DefaultProtegeDIGReasoner() {
        this.reasoner = new DefaultDIGReasoner();
        DIGLogger.getInstance(this.reasoner).addListener(this.digLoggerListener);
        this.setURL(ReasonerPreferences.getInstance().getReasonerURL());
    }

    @Override
    public DIGReasoner getDIGReasoner() {
        return this.reasoner;
    }

    @Override
    public void setURL(String string) {
        try {
            if (!this.reasoner.getReasonerURL().equals(string)) {
                if (this.kbURI != null) {
                    this.reasoner.releaseKnowledgeBase(this.kbURI);
                    this.kbURI = null;
                    this.forceReasonerReSynchronization();
                }
                this.reasoner.setReasonerURL(string);
            }
        }
        catch (DIGReasonerException dIGReasonerException) {
            Log.getLogger().log(Level.SEVERE, "Exception caught", dIGReasonerException);
        }
    }

    @Override
    public String getURL() {
        return this.reasoner.getReasonerURL();
    }

    @Override
    public boolean isConnected() {
        try {
            this.reasoner.getIdentity();
            return true;
        }
        catch (DIGReasonerException dIGReasonerException) {
            return false;
        }
    }

    @Override
    public void reset() {
        try {
            this.getDIGReasoner().clearKnowledgeBase(this.getReasonerKnowledgeBaseURI());
        }
        catch (DIGReasonerException dIGReasonerException) {
            Log.getLogger().log(Level.WARNING, "Error at resetting model", dIGReasonerException);
        }
    }

    @Override
    public String getReasonerKnowledgeBaseURI() {
        return this.kbURI;
    }

    @Override
    protected void synchronizeReasoner(ReasonerTaskListener reasonerTaskListener) throws DIGReasonerException {
        if (this.synchronizeReasoner || this.kbURI == null) {
            SynchronizeReasonerTask synchronizeReasonerTask = new SynchronizeReasonerTask(this);
            if (reasonerTaskListener != null) {
                synchronizeReasonerTask.addTaskListener(reasonerTaskListener);
            }
            if (this.kbURI == null) {
                this.kbURI = this.reasoner.createKnowledgeBase();
            }
            synchronizeReasonerTask.run();
            if (reasonerTaskListener != null) {
                synchronizeReasonerTask.removeTaskListener(reasonerTaskListener);
            }
            this.synchronizeReasoner = false;
        }
    }

    @Override
    public DIGReasonerIdentity getIdentity() {
        DIGReasonerIdentity dIGReasonerIdentity;
        block2: {
            dIGReasonerIdentity = null;
            try {
                dIGReasonerIdentity = this.reasoner.getIdentity();
            }
            catch (DIGReasonerException dIGReasonerException) {
                Log.getLogger().severe(dIGReasonerException.getMessage());
                if (!log.isLoggable(Level.FINE)) break block2;
                log.log(Level.FINE, "Exception caught", dIGReasonerException);
            }
        }
        return dIGReasonerIdentity;
    }

    public static String getReasonerName() {
        return "DIG Reasoner";
    }

    @Override
    public OWLModel getKnowledgeBase() {
        return this.getOWLModel();
    }

    @Override
    public void classifyTaxonomy(ReasonerTaskListener reasonerTaskListener) throws DIGReasonerException {
        ClassifyTaxonomyTask classifyTaxonomyTask = new ClassifyTaxonomyTask(this);
        this.performTask(classifyTaxonomyTask, reasonerTaskListener);
    }

    @Override
    public void classifyTaxonomy() throws ProtegeReasonerException {
        ClassifyTaxonomyTask classifyTaxonomyTask = new ClassifyTaxonomyTask(this);
        this.performTask(classifyTaxonomyTask);
    }

    @Override
    public void computeInferredHierarchy(ReasonerTaskListener reasonerTaskListener) throws DIGReasonerException {
        UpdateInferredHierarchyTask updateInferredHierarchyTask = new UpdateInferredHierarchyTask(this);
        this.performTask(updateInferredHierarchyTask, reasonerTaskListener);
    }

    @Override
    public void computeInferredHierarchy() throws ProtegeReasonerException {
        UpdateInferredHierarchyTask updateInferredHierarchyTask = new UpdateInferredHierarchyTask(this);
        this.performTask(updateInferredHierarchyTask);
    }

    @Override
    public void computeEquivalentConcepts(ReasonerTaskListener reasonerTaskListener) throws DIGReasonerException {
        UpdateEquivalentClassesTask updateEquivalentClassesTask = new UpdateEquivalentClassesTask(this);
        this.performTask(updateEquivalentClassesTask, reasonerTaskListener);
    }

    @Override
    public void computeEquivalentConcepts() throws ProtegeReasonerException {
        UpdateEquivalentClassesTask updateEquivalentClassesTask = new UpdateEquivalentClassesTask(this);
        this.performTask(updateEquivalentClassesTask);
    }

    @Override
    public void computeInconsistentConcepts(ReasonerTaskListener reasonerTaskListener) throws DIGReasonerException {
        UpdateInconsistentClassesTask updateInconsistentClassesTask = new UpdateInconsistentClassesTask(this);
        this.performTask(updateInconsistentClassesTask, reasonerTaskListener);
    }

    @Override
    public void computeInconsistentConcepts() throws ProtegeReasonerException {
        UpdateInconsistentClassesTask updateInconsistentClassesTask = new UpdateInconsistentClassesTask(this);
        this.performTask(updateInconsistentClassesTask);
    }

    @Override
    public void computeInferredIndividualTypes(ReasonerTaskListener reasonerTaskListener) throws DIGReasonerException {
        UpdateInferredTypesTask updateInferredTypesTask = new UpdateInferredTypesTask(this);
        this.performTask(updateInferredTypesTask, reasonerTaskListener);
    }

    @Override
    public void computeInferredIndividualTypes() throws ProtegeReasonerException {
        UpdateInferredTypesTask updateInferredTypesTask = new UpdateInferredTypesTask(this);
        this.performTask(updateInferredTypesTask);
    }

    @Override
    public boolean isSatisfiable(OWLClass oWLClass, ReasonerTaskListener reasonerTaskListener) throws DIGReasonerException {
        GetConceptSatisfiableTask getConceptSatisfiableTask = new GetConceptSatisfiableTask(oWLClass, this);
        this.performTask(getConceptSatisfiableTask, reasonerTaskListener);
        return getConceptSatisfiableTask.getResult();
    }

    @Override
    public boolean isSatisfiable(OWLClass oWLClass) throws ProtegeReasonerException {
        GetConceptSatisfiableTask getConceptSatisfiableTask = new GetConceptSatisfiableTask(oWLClass, this);
        this.performTask(getConceptSatisfiableTask);
        return getConceptSatisfiableTask.getResult();
    }

    @Override
    public boolean isIntersectionSatisfiable(OWLClass[] oWLClassArray, ReasonerTaskListener reasonerTaskListener) throws DIGReasonerException {
        IsConceptIntersectionSatisfiableTask isConceptIntersectionSatisfiableTask = new IsConceptIntersectionSatisfiableTask(oWLClassArray, this);
        this.performTask(isConceptIntersectionSatisfiableTask, reasonerTaskListener);
        return isConceptIntersectionSatisfiableTask.getResult();
    }

    @Override
    public boolean isIntersectionSatisfiable(OWLClass[] oWLClassArray) throws ProtegeReasonerException {
        IsConceptIntersectionSatisfiableTask isConceptIntersectionSatisfiableTask = new IsConceptIntersectionSatisfiableTask(oWLClassArray, this);
        this.performTask(isConceptIntersectionSatisfiableTask);
        return isConceptIntersectionSatisfiableTask.getResult();
    }

    @Override
    public boolean isSubsumedBy(OWLClass oWLClass, OWLClass oWLClass2, ReasonerTaskListener reasonerTaskListener) throws DIGReasonerException {
        IsSubsumedByTask isSubsumedByTask = new IsSubsumedByTask(this, oWLClass, oWLClass2);
        this.performTask(isSubsumedByTask, reasonerTaskListener);
        return isSubsumedByTask.getResult();
    }

    @Override
    public boolean isSubsumedBy(OWLClass oWLClass, OWLClass oWLClass2) throws ProtegeReasonerException {
        IsSubsumedByTask isSubsumedByTask = new IsSubsumedByTask(this, oWLClass, oWLClass2);
        this.performTask(isSubsumedByTask);
        return isSubsumedByTask.getResult();
    }

    @Override
    public boolean isDisjointTo(OWLClass oWLClass, OWLClass oWLClass2, ReasonerTaskListener reasonerTaskListener) throws DIGReasonerException {
        IsDisjointToTask isDisjointToTask = new IsDisjointToTask(this, oWLClass, oWLClass2);
        this.performTask(isDisjointToTask, reasonerTaskListener);
        return isDisjointToTask.getResult();
    }

    @Override
    public boolean isDisjointTo(OWLClass oWLClass, OWLClass oWLClass2) throws ProtegeReasonerException {
        IsDisjointToTask isDisjointToTask = new IsDisjointToTask(this, oWLClass, oWLClass2);
        this.performTask(isDisjointToTask);
        return isDisjointToTask.getResult();
    }

    @Override
    public int getSubsumptionRelationship(OWLClass oWLClass, OWLClass oWLClass2, ReasonerTaskListener reasonerTaskListener) throws DIGReasonerException {
        GetSubsumptionRelationshipTask getSubsumptionRelationshipTask = new GetSubsumptionRelationshipTask(this, oWLClass, oWLClass2);
        this.performTask(getSubsumptionRelationshipTask, reasonerTaskListener);
        return getSubsumptionRelationshipTask.getResult();
    }

    @Override
    public int getSubsumptionRelationship(OWLClass oWLClass, OWLClass oWLClass2) throws ProtegeReasonerException {
        GetSubsumptionRelationshipTask getSubsumptionRelationshipTask = new GetSubsumptionRelationshipTask(this, oWLClass, oWLClass2);
        this.performTask(getSubsumptionRelationshipTask);
        return getSubsumptionRelationshipTask.getResult();
    }

    @Override
    public Collection getSuperclasses(OWLClass oWLClass, ReasonerTaskListener reasonerTaskListener) throws DIGReasonerException {
        GetSuperConceptsTask getSuperConceptsTask = new GetSuperConceptsTask(oWLClass, this);
        this.performTask(getSuperConceptsTask, reasonerTaskListener);
        return getSuperConceptsTask.getResult();
    }

    @Override
    public Collection<OWLClass> getSuperclasses(OWLClass oWLClass) throws ProtegeReasonerException {
        GetSuperConceptsTask getSuperConceptsTask = new GetSuperConceptsTask(oWLClass, this);
        this.performTask(getSuperConceptsTask);
        return getSuperConceptsTask.getResult();
    }

    @Override
    public Collection getSuperclassesOfIntersection(OWLClass[] oWLClassArray, ReasonerTaskListener reasonerTaskListener) throws DIGReasonerException {
        GetConceptIntersectionSuperclassesTask getConceptIntersectionSuperclassesTask = new GetConceptIntersectionSuperclassesTask(oWLClassArray, this);
        this.performTask(getConceptIntersectionSuperclassesTask, reasonerTaskListener);
        return getConceptIntersectionSuperclassesTask.getResult();
    }

    @Override
    public Collection<OWLClass> getSuperclassesOfIntersection(OWLClass[] oWLClassArray) throws ProtegeReasonerException {
        GetConceptIntersectionSuperclassesTask getConceptIntersectionSuperclassesTask = new GetConceptIntersectionSuperclassesTask(oWLClassArray, this);
        this.performTask(getConceptIntersectionSuperclassesTask);
        return getConceptIntersectionSuperclassesTask.getResult();
    }

    @Override
    public Collection getSubclasses(OWLClass oWLClass, ReasonerTaskListener reasonerTaskListener) throws DIGReasonerException {
        GetSubConceptsTask getSubConceptsTask = new GetSubConceptsTask(oWLClass, this);
        this.performTask(getSubConceptsTask, reasonerTaskListener);
        return getSubConceptsTask.getResult();
    }

    @Override
    public Collection<OWLClass> getSubclasses(OWLClass oWLClass) throws ProtegeReasonerException {
        GetSubConceptsTask getSubConceptsTask = new GetSubConceptsTask(oWLClass, this);
        this.performTask(getSubConceptsTask);
        return getSubConceptsTask.getResult();
    }

    @Override
    public Collection getAncestorClasses(OWLClass oWLClass, ReasonerTaskListener reasonerTaskListener) throws DIGReasonerException {
        GetAncestorConceptsTask getAncestorConceptsTask = new GetAncestorConceptsTask(oWLClass, this);
        this.performTask(getAncestorConceptsTask, reasonerTaskListener);
        return getAncestorConceptsTask.getResult();
    }

    @Override
    public Collection<OWLClass> getAncestorClasses(OWLClass oWLClass) throws ProtegeReasonerException {
        GetAncestorConceptsTask getAncestorConceptsTask = new GetAncestorConceptsTask(oWLClass, this);
        this.performTask(getAncestorConceptsTask);
        return getAncestorConceptsTask.getResult();
    }

    @Override
    public Collection getDescendantClasses(OWLClass oWLClass, ReasonerTaskListener reasonerTaskListener) throws DIGReasonerException {
        GetDescendantConceptsTask getDescendantConceptsTask = new GetDescendantConceptsTask(oWLClass, this);
        this.performTask(getDescendantConceptsTask, reasonerTaskListener);
        return getDescendantConceptsTask.getResult();
    }

    @Override
    public Collection<OWLClass> getDescendantClasses(OWLClass oWLClass) throws ProtegeReasonerException {
        GetDescendantConceptsTask getDescendantConceptsTask = new GetDescendantConceptsTask(oWLClass, this);
        this.performTask(getDescendantConceptsTask);
        return getDescendantConceptsTask.getResult();
    }

    @Override
    public Collection getEquivalentClasses(OWLClass oWLClass, ReasonerTaskListener reasonerTaskListener) throws DIGReasonerException {
        GetEquivalentConceptsTask getEquivalentConceptsTask = new GetEquivalentConceptsTask(oWLClass, this);
        this.performTask(getEquivalentConceptsTask, reasonerTaskListener);
        return getEquivalentConceptsTask.getResult();
    }

    @Override
    public Collection<OWLClass> getEquivalentClasses(OWLClass oWLClass) throws ProtegeReasonerException {
        GetEquivalentConceptsTask getEquivalentConceptsTask = new GetEquivalentConceptsTask(oWLClass, this);
        this.performTask(getEquivalentConceptsTask);
        return getEquivalentConceptsTask.getResult();
    }

    @Override
    public Collection getIndividualsBelongingToClass(OWLClass oWLClass, ReasonerTaskListener reasonerTaskListener) throws DIGReasonerException {
        GetIndividualsBelongingToConceptTask getIndividualsBelongingToConceptTask = new GetIndividualsBelongingToConceptTask(oWLClass, this);
        this.performTask(getIndividualsBelongingToConceptTask, reasonerTaskListener);
        return getIndividualsBelongingToConceptTask.getResult();
    }

    @Override
    public Collection<OWLIndividual> getIndividualsBelongingToClass(OWLClass oWLClass) throws ProtegeReasonerException {
        GetIndividualsBelongingToConceptTask getIndividualsBelongingToConceptTask = new GetIndividualsBelongingToConceptTask(oWLClass, this);
        this.performTask(getIndividualsBelongingToConceptTask);
        return getIndividualsBelongingToConceptTask.getResult();
    }

    @Override
    public Collection getIndividualTypes(OWLIndividual oWLIndividual, ReasonerTaskListener reasonerTaskListener) throws DIGReasonerException {
        GetIndividualInferredTypesTask getIndividualInferredTypesTask = new GetIndividualInferredTypesTask(oWLIndividual, this);
        this.performTask(getIndividualInferredTypesTask, reasonerTaskListener);
        return getIndividualInferredTypesTask.getResult();
    }

    @Override
    public Collection<OWLClass> getIndividualTypes(OWLIndividual oWLIndividual) throws ProtegeReasonerException {
        GetIndividualInferredTypesTask getIndividualInferredTypesTask = new GetIndividualInferredTypesTask(oWLIndividual, this);
        this.performTask(getIndividualInferredTypesTask);
        return getIndividualInferredTypesTask.getResult();
    }

    @Override
    protected ProjectListener getProjectListener() {
        this.projectListener = new ProjectAdapter(){

            public void projectClosed(ProjectEvent projectEvent) {
                if (DefaultProtegeDIGReasoner.this.kbURI != null) {
                    try {
                        DefaultProtegeDIGReasoner.this.reasoner.releaseKnowledgeBase(DefaultProtegeDIGReasoner.this.kbURI);
                        DefaultProtegeDIGReasoner.this.kbURI = null;
                        DefaultProtegeDIGReasoner.this.removeListeners();
                        DefaultProtegeDIGReasoner.this.owlModel = null;
                    }
                    catch (DIGReasonerException dIGReasonerException) {
                        Log.getLogger().log(Level.SEVERE, "Exception caught", dIGReasonerException);
                    }
                }
            }
        };
        return this.projectListener;
    }

    @Override
    public void performTask(ReasonerTask reasonerTask, ReasonerTaskListener reasonerTaskListener) throws DIGReasonerException {
        TimeDifference timeDifference = new TimeDifference();
        timeDifference.markStart();
        final ReasonerTaskListener reasonerTaskListener2 = reasonerTaskListener;
        ReasonerTaskAdapter reasonerTaskAdapter = reasonerTaskListener != null ? new ReasonerTaskAdapter(){

            public void addedToTask(ReasonerTaskEvent reasonerTaskEvent) {
                reasonerTaskListener2.addedToTask(reasonerTaskEvent);
            }

            public void progressChanged(ReasonerTaskEvent reasonerTaskEvent) {
                reasonerTaskListener2.progressChanged(reasonerTaskEvent);
            }

            public void progressIndeterminateChanged(ReasonerTaskEvent reasonerTaskEvent) {
                reasonerTaskListener2.progressIndeterminateChanged(reasonerTaskEvent);
            }

            public void descriptionChanged(ReasonerTaskEvent reasonerTaskEvent) {
                reasonerTaskListener2.descriptionChanged(reasonerTaskEvent);
            }

            public void messageChanged(ReasonerTaskEvent reasonerTaskEvent) {
                reasonerTaskListener2.messageChanged(reasonerTaskEvent);
            }

            public void taskFailed(ReasonerTaskEvent reasonerTaskEvent) {
                reasonerTaskListener2.taskFailed(reasonerTaskEvent);
            }
        } : new ReasonerTaskAdapter();
        this.synchronizeReasoner(reasonerTaskAdapter);
        if (reasonerTaskListener != null) {
            reasonerTask.addTaskListener(reasonerTaskListener);
        }
        try {
            reasonerTask.run();
        }
        catch (DIGReasonerException dIGReasonerException) {
            String string = this.kbURI;
            this.kbURI = null;
            this.reasoner.releaseKnowledgeBase(string);
            this.synchronizeReasoner = true;
            throw dIGReasonerException;
        }
        catch (ProtegeReasonerException protegeReasonerException) {
            String string = this.kbURI;
            this.kbURI = null;
            this.reasoner.releaseKnowledgeBase(string);
            this.synchronizeReasoner = true;
            throw new DIGReasonerException(protegeReasonerException.getMessage(), protegeReasonerException);
        }
        finally {
            if (reasonerTaskListener != null) {
                reasonerTask.removeTaskListener(reasonerTaskListener);
            }
        }
        timeDifference.markEnd();
        ReasonerLogger.getInstance().postLogRecord(ReasonerLogRecordFactory.getInstance().createInformationMessageLogRecord("Total time: " + timeDifference, null));
    }

    @Override
    public void dispose() {
        try {
            if (this.kbURI != null) {
                this.reasoner.releaseKnowledgeBase(this.kbURI);
                this.kbURI = null;
            }
            this.reasonerTaskListener = null;
            DIGLogger.getInstance(this.reasoner).removeListener(this.digLoggerListener);
            super.dispose();
        }
        catch (Exception exception) {
            Log.getLogger().log(Level.WARNING, "Errors at disposing DIG reasoner", exception);
        }
    }
}

