/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.emf;

import edu.stanford.smi.protege.model.Cls;
import edu.stanford.smi.protege.model.Slot;
import edu.stanford.smi.protege.model.ValueType;
import edu.stanford.smi.protegex.owl.emf.EMFGeneratorOptions;
import edu.stanford.smi.protegex.owl.model.OWLModel;
import edu.stanford.smi.protegex.owl.model.RDFProperty;
import edu.stanford.smi.protegex.owl.model.RDFSNamedClass;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;

public class EMFGenerator {
    private static final String OBJECT_JAVA_CLASS_NAME = "Object";
    private OWLModel owlModel;
    private EMFGeneratorOptions options;

    public EMFGenerator(OWLModel oWLModel, EMFGeneratorOptions eMFGeneratorOptions) {
        String string;
        this.owlModel = oWLModel;
        this.options = eMFGeneratorOptions;
        File file = eMFGeneratorOptions.getOutputFolder();
        if (file != null && !file.exists()) {
            file.mkdirs();
        }
        if ((string = eMFGeneratorOptions.getPackage()) != null) {
            string = string.replace('.', '/');
            File file2 = file == null ? new File(string) : new File(file, string);
            file2.mkdirs();
        }
    }

    public void createAllInterfaces() throws IOException {
        for (RDFSNamedClass rDFSNamedClass : this.owlModel.getUserDefinedOWLNamedClasses()) {
            this.createInterface(rDFSNamedClass);
        }
    }

    public void createInterface(RDFSNamedClass rDFSNamedClass) throws IOException {
        File file = this.getInterfaceFile(rDFSNamedClass);
        FileWriter fileWriter = new FileWriter(file);
        PrintWriter printWriter = new PrintWriter(fileWriter);
        this.createInterfaceCode(printWriter, rDFSNamedClass);
        fileWriter.close();
    }

    public void createInterfaceCode(PrintWriter printWriter, RDFSNamedClass rDFSNamedClass) {
        if (this.options.getPackage() != null) {
            printWriter.println("package " + this.options.getPackage() + ";");
            printWriter.println();
        }
        printWriter.println("/**");
        printWriter.println(" * Generated by the EMFGenerator from the Protege OWL Plugin (http://protege.stanford.edu).");
        printWriter.println(" * Source OWL Class: " + rDFSNamedClass.getURI());
        printWriter.println(" * @version generated on " + new Date());
        printWriter.println(" * @model");
        printWriter.println(" */");
        printWriter.println("public interface " + this.getInterfaceName(rDFSNamedClass) + this.getExtendsCode(rDFSNamedClass) + " {");
        for (Slot slot : rDFSNamedClass.getUnionDomainProperties()) {
            if (!(slot instanceof RDFProperty)) continue;
            this.createSlotCode(printWriter, rDFSNamedClass, (RDFProperty)slot);
        }
        printWriter.println("}");
    }

    private String getExtendsCode(RDFSNamedClass rDFSNamedClass) {
        String string = "";
        Iterator iterator = this.getBaseInterfaces(rDFSNamedClass).iterator();
        if (iterator.hasNext()) {
            string = string + " extends ";
            while (iterator.hasNext()) {
                String string2 = (String)iterator.next();
                string = string + string2;
                if (!iterator.hasNext()) continue;
                string = string + ", ";
            }
        }
        return string;
    }

    public void createSlotCode(PrintWriter printWriter, RDFSNamedClass rDFSNamedClass, RDFProperty rDFProperty) {
        String string = EMFGenerator.getValidJavaName(rDFProperty.getName());
        string = string.length() > 1 ? Character.toUpperCase(string.charAt(0)) + string.substring(1) : string.toUpperCase();
        String string2 = null;
        String string3 = null;
        if (rDFSNamedClass.getTemplateSlotAllowsMultipleValues(rDFProperty)) {
            string2 = "java.util.List";
            if (!rDFSNamedClass.getTemplateSlotAllowedClses(rDFProperty).isEmpty()) {
                RDFSNamedClass rDFSNamedClass2 = (RDFSNamedClass)rDFSNamedClass.getTemplateSlotAllowedClses(rDFProperty).iterator().next();
                string3 = " type=\"" + this.getInterfaceName(rDFSNamedClass2) + "\"";
            }
        } else {
            Object object;
            ValueType valueType = rDFSNamedClass.getTemplateSlotValueType(rDFProperty);
            if (valueType == ValueType.INSTANCE) {
                string2 = rDFProperty.hasRange(false) ? ((object = rDFProperty.getRange()) instanceof RDFSNamedClass ? this.getInterfaceName((RDFSNamedClass)object) : OBJECT_JAVA_CLASS_NAME) : OBJECT_JAVA_CLASS_NAME;
            } else {
                object = valueType.getJavaType();
                string2 = ((Class)object).toString();
            }
            int n = string2.lastIndexOf(46);
            if (n > 0) {
                string2 = string2.substring(n + 1);
            }
        }
        printWriter.println();
        printWriter.println("    /**");
        printWriter.println("     * Generated from property #" + rDFProperty.getLocalName());
        printWriter.println("     * @model " + string3);
        printWriter.println("     */");
        printWriter.println("    " + string2 + " get" + string + "();");
    }

    public Collection getBaseInterfaces(RDFSNamedClass rDFSNamedClass) {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (Cls cls : rDFSNamedClass.getSuperclasses(false)) {
            if (!(cls instanceof RDFSNamedClass) || this.owlModel.getOWLThingClass().equals(cls)) continue;
            arrayList.add(this.getInterfaceName((RDFSNamedClass)cls));
        }
        return arrayList;
    }

    public File getInterfaceFile(RDFSNamedClass rDFSNamedClass) {
        String string = this.options.getPackage();
        string = string != null ? string.replace('.', '/') + "/" : "";
        return new File(this.options.getOutputFolder(), string + this.getInterfaceName(rDFSNamedClass) + ".java");
    }

    public String getInterfaceName(RDFSNamedClass rDFSNamedClass) {
        String string = rDFSNamedClass.getName();
        return EMFGenerator.getValidJavaName(string);
    }

    public static String getValidJavaName(String string) {
        for (int i = 1; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (Character.isJavaIdentifierPart(c)) continue;
            string = string.replace(c, '_');
        }
        return string;
    }
}

