/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.database.creator;

import edu.stanford.smi.protege.exception.OntologyLoadException;
import edu.stanford.smi.protege.util.FileUtilities;
import edu.stanford.smi.protege.util.Log;
import edu.stanford.smi.protege.util.URIUtilities;
import edu.stanford.smi.protegex.owl.database.OWLDatabaseKnowledgeBaseFactory;
import edu.stanford.smi.protegex.owl.database.OWLDatabaseModel;
import edu.stanford.smi.protegex.owl.database.creator.AbstractOwlDatabaseCreator;
import edu.stanford.smi.protegex.owl.jena.parser.ProtegeOWLParser;
import edu.stanford.smi.protegex.owl.model.factory.AlreadyImportedException;
import edu.stanford.smi.protegex.owl.model.factory.FactoryUtils;
import edu.stanford.smi.protegex.owl.repository.Repository;
import edu.stanford.smi.protegex.owl.repository.util.RepositoryUtil;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OwlDatabaseFromFileCreator
extends AbstractOwlDatabaseCreator {
    private static transient Logger log = Log.getLogger(OwlDatabaseFromFileCreator.class);
    private List<Repository> repositories = new ArrayList<Repository>();
    private boolean isMergeImportMode = false;
    private String ontologySource;

    public OwlDatabaseFromFileCreator() {
        this(new OWLDatabaseKnowledgeBaseFactory());
    }

    public OwlDatabaseFromFileCreator(OWLDatabaseKnowledgeBaseFactory oWLDatabaseKnowledgeBaseFactory) {
        super(oWLDatabaseKnowledgeBaseFactory);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void create(Collection collection) throws OntologyLoadException {
        try {
            this.initializeTable(collection);
        }
        catch (IOException iOException) {
            throw new OntologyLoadException((Throwable)iOException, "Could not initialize DB tables");
        }
        super.create(collection);
        this.insertRepositoriesIntoOwlModel(this.getOwlModel());
        this.loadProjectRepositories(this.getOwlModel());
        ProtegeOWLParser protegeOWLParser = new ProtegeOWLParser(this.getOwlModel());
        boolean bl = protegeOWLParser.isMergingImportMode();
        protegeOWLParser.setMergingImportMode(this.isMergeImportMode);
        try {
            protegeOWLParser.run(URIUtilities.createURI((String)this.ontologySource));
        }
        finally {
            protegeOWLParser.setMergingImportMode(bl);
        }
        try {
            FactoryUtils.writeOntologyAndPrefixInfo(this.getOwlModel(), collection);
        }
        catch (AlreadyImportedException alreadyImportedException) {
            throw new RuntimeException("This shouldn't happen", alreadyImportedException);
        }
        FactoryUtils.adjustBrowserTextBasedOnPreferences(this.getOwlModel());
        collection.addAll(this.getOwlModel().getParserErrors());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void loadProjectRepositories(OWLDatabaseModel oWLDatabaseModel) {
        URI uRI = oWLDatabaseModel.getProject().getProjectURI();
        try {
            String string = FileUtilities.replaceExtension((String)this.ontologySource, (String)".pprj");
            oWLDatabaseModel.getProject().setProjectURI(URIUtilities.createURI((String)string));
            String string2 = FileUtilities.replaceExtension((String)this.ontologySource, (String)".repository");
            RepositoryUtil.loadProjectRepositoriesFromURI(oWLDatabaseModel, URIUtilities.createURI((String)string2), false);
        }
        catch (Exception exception) {
            Log.getLogger().log(Level.WARNING, "Error at loading project repositories", exception);
        }
        finally {
            oWLDatabaseModel.getProject().setProjectURI(uRI);
        }
    }

    public void setOntologySource(String string) {
        this.ontologySource = string;
    }

    public void addRepository(Repository repository) {
        this.repositories.add(repository);
    }

    public void clearRepositories() {
        this.repositories.clear();
    }

    public List<Repository> getRepositories() {
        return Collections.unmodifiableList(this.repositories);
    }

    public boolean isMergeImportMode() {
        return this.isMergeImportMode;
    }

    public void setMergeImportMode(boolean bl) {
        this.isMergeImportMode = bl;
    }
}

