/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.database.creator;

import edu.stanford.smi.protege.exception.OntologyLoadException;
import edu.stanford.smi.protege.model.KnowledgeBase;
import edu.stanford.smi.protege.model.KnowledgeBaseFactory;
import edu.stanford.smi.protege.model.Project;
import edu.stanford.smi.protege.model.framestore.MergingNarrowFrameStore;
import edu.stanford.smi.protege.model.framestore.NarrowFrameStore;
import edu.stanford.smi.protege.storage.database.DatabaseFrameDb;
import edu.stanford.smi.protegex.owl.database.DatabaseFactoryUtils;
import edu.stanford.smi.protegex.owl.database.OWLDatabaseKnowledgeBaseFactory;
import edu.stanford.smi.protegex.owl.database.creator.AbstractOwlDatabaseCreator;
import edu.stanford.smi.protegex.owl.model.OWLModel;
import edu.stanford.smi.protegex.owl.model.factory.AlreadyImportedException;
import edu.stanford.smi.protegex.owl.model.factory.FactoryUtils;
import edu.stanford.smi.protegex.owl.repository.Repository;
import edu.stanford.smi.protegex.owl.storage.OWLKnowledgeBaseFactory;
import java.io.IOException;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OwlDatabaseCreator
extends AbstractOwlDatabaseCreator {
    private boolean wipe;
    private List<Repository> repositories = new ArrayList<Repository>();
    private String ontologyName;
    private Class<? extends DatabaseFrameDb> databaseFrameDbClass;

    public OwlDatabaseCreator(boolean bl) {
        this(new OWLDatabaseKnowledgeBaseFactory(), bl);
    }

    public OwlDatabaseCreator(OWLDatabaseKnowledgeBaseFactory oWLDatabaseKnowledgeBaseFactory, boolean bl) {
        super(oWLDatabaseKnowledgeBaseFactory);
        this.wipe = bl;
        this.databaseFrameDbClass = oWLDatabaseKnowledgeBaseFactory.getDatabaseFrameDbClass();
    }

    @Override
    public void create(Collection collection) throws OntologyLoadException {
        if (!this.useExistingDb()) {
            this.createFromNewEmptySources(collection);
        } else {
            this.createFromExistingSources(collection);
        }
        FactoryUtils.adjustBrowserTextBasedOnPreferences(this.getOwlModel());
    }

    private void createFromNewEmptySources(Collection collection) throws OntologyLoadException {
        try {
            this.initializeTable(collection);
        }
        catch (IOException iOException) {
            throw new OntologyLoadException((Throwable)iOException, "Could not initialize DB tables");
        }
        super.create(collection);
        if (this.ontologyName == null) {
            this.ontologyName = FactoryUtils.generateOntologyURIBase();
        }
        try {
            FactoryUtils.addOntologyToTripleStore(this.getOwlModel(), this.getOwlModel().getTripleStoreModel().getActiveTripleStore(), this.ontologyName);
            FactoryUtils.writeOntologyAndPrefixInfo(this.getOwlModel(), collection);
        }
        catch (AlreadyImportedException alreadyImportedException) {
            throw new RuntimeException("This shouldn't happen", alreadyImportedException);
        }
    }

    private void createFromExistingSources(Collection collection) {
        OWLKnowledgeBaseFactory oWLKnowledgeBaseFactory = this.getFactory();
        OWLDatabaseKnowledgeBaseFactory oWLDatabaseKnowledgeBaseFactory = oWLKnowledgeBaseFactory != null && oWLKnowledgeBaseFactory instanceof OWLDatabaseKnowledgeBaseFactory ? (OWLDatabaseKnowledgeBaseFactory)oWLKnowledgeBaseFactory : new OWLDatabaseKnowledgeBaseFactory();
        this.project = Project.createBuildProject((KnowledgeBaseFactory)oWLDatabaseKnowledgeBaseFactory, (Collection)collection);
        this.initializeSources(this.project.getSources());
        this.project.createDomainKnowledgeBase((KnowledgeBaseFactory)oWLDatabaseKnowledgeBaseFactory, collection, false);
        OWLModel oWLModel = (OWLModel)this.project.getKnowledgeBase();
        this.insertRepositoriesIntoOwlModel(oWLModel);
        MergingNarrowFrameStore mergingNarrowFrameStore = MergingNarrowFrameStore.get((KnowledgeBase)oWLModel);
        oWLModel.setGenerateEventsEnabled(false);
        NarrowFrameStore narrowFrameStore = oWLDatabaseKnowledgeBaseFactory.createNarrowFrameStore("<new>");
        mergingNarrowFrameStore.addActiveFrameStore(narrowFrameStore);
        oWLDatabaseKnowledgeBaseFactory.loadKnowledgeBase(oWLModel, this.project.getSources(), collection);
        oWLModel.setGenerateEventsEnabled(true);
        oWLModel.setChanged(false);
        this.project.getInternalProjectKnowledgeBase().setChanged(false);
    }

    private boolean useExistingDb() throws OntologyLoadException {
        if (this.wipe) {
            return false;
        }
        Connection connection = null;
        try {
            Class.forName(this.getDriver());
            connection = DriverManager.getConnection(this.getUrl(), this.getUsername(), this.getPassword());
        }
        catch (ClassNotFoundException classNotFoundException) {
            this.rethrow(classNotFoundException);
        }
        catch (SQLException sQLException) {
            this.rethrow(sQLException);
        }
        try {
            return DatabaseFactoryUtils.getOntologyFromTable(this.databaseFrameDbClass, this.getDriver(), this.getUrl(), this.getUsername(), this.getPassword(), this.getTable()) != null;
        }
        catch (SQLException sQLException) {
            return true;
        }
    }

    private void rethrow(Throwable throwable) throws OntologyLoadException {
        if (throwable instanceof OntologyLoadException) {
            throw (OntologyLoadException)throwable;
        }
        throw new OntologyLoadException(throwable, throwable.getMessage());
    }

    public void setOntologyName(String string) {
        this.ontologyName = string;
    }

    public void addRepository(Repository repository) {
        this.repositories.add(repository);
    }

    public void clearRepositories() {
        this.repositories.clear();
    }

    public List<Repository> getRepositories() {
        return Collections.unmodifiableList(this.repositories);
    }
}

